/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.code.CodeDocumentPart;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.IInstructionOperand;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeInstructionItem;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IInstructionOperandSized;
import com.pnfsoftware.jeb.core.units.code.asm.render.GenericCodeFormatter;
import com.pnfsoftware.jeb.core.units.code.asm.render.NumberFormatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.math.MathUtil;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jebglobal.cns;
import com.pnfsoftware.jebglobal.cql;
import com.pnfsoftware.jebglobal.cqm;
import com.pnfsoftware.jebglobal.cqn;
import com.pnfsoftware.jebglobal.cqo;

@Ser
public class cow
extends GenericCodeFormatter<cql> {
    public String ce(cql cql2, IInstructionOperandSized iInstructionOperandSized) {
        int n2 = iInstructionOperandSized.getOperandBitsize();
        switch (n2) {
            case 0: {
                return "";
            }
            case 8: {
                return "byte ptr ";
            }
            case 16: {
                return "word ptr ";
            }
            case 32: {
                return "dword ptr ";
            }
            case 48: {
                return "fword ptr ";
            }
            case 64: {
                return "qword ptr ";
            }
            case 80: {
                return "tword ptr ";
            }
            case 128: {
                return "dqword ptr ";
            }
            case 256: {
                return "qqword ptr ";
            }
            case 512: {
                return "dqqword ptr ";
            }
        }
        if (n2 % 8 == 0) {
            return Strings.ff("m%d ptr ", n2 / 8);
        }
        return Strings.ff("%db ptr ", n2);
    }

    public String ce(cql cql2, IInstructionOperand iInstructionOperand) {
        cns cns2 = (cns)iInstructionOperand;
        long l2 = cqo.ce(cql2, cns2);
        if (l2 == 0L) {
            return "";
        }
        return this.getRegisterName(l2) + ":";
    }

    @Override
    public String getRegisterName(long l2) {
        try {
            return cqo.ok(l2);
        }
        catch (RuntimeException runtimeException) {
            return "unkreg_" + l2;
        }
    }

    protected String ce(long l2, cql cql2) {
        IInstruction iInstruction;
        INativeContinuousItem iNativeContinuousItem;
        if (cql2.ce() == 155 && (iNativeContinuousItem = this.getCodeUnit().getNativeItemAt(l2 + 1L)) instanceof INativeInstructionItem && (iInstruction = ((INativeInstructionItem)iNativeContinuousItem).getInstruction()) instanceof cql && (((cql)iInstruction).oW.fz & 0x20000L) != 0L) {
            return "fwait";
        }
        return super.generateMnemonic(l2, cql2);
    }

    public void ce(long l2, cql cql2, IInstructionOperand iInstructionOperand, int n2, int n3, CodeDocumentPart codeDocumentPart) {
        if (iInstructionOperand instanceof cns) {
            cns cns2 = (cns)iInstructionOperand;
            switch (cns2.getOperandType()) {
                case 4097: {
                    this.ce(l2, cql2, (cqn)iInstructionOperand, n2, codeDocumentPart);
                    return;
                }
                case 8: {
                    this.ce(l2, cql2, (cqm)iInstructionOperand, n2, codeDocumentPart);
                    return;
                }
            }
        }
        super.formatOperand(l2, cql2, iInstructionOperand, n2, n3, codeDocumentPart);
    }

    private void ce(long l2, cql cql2, cqn cqn2, int n2, CodeDocumentPart codeDocumentPart) {
        int n3 = cqn2.fz();
        long l3 = (long)cqn2.Rs() & 0xFFFFFFFFL;
        String string = Strings.ff("%Xh:%Xh", n3, l3);
        codeDocumentPart.append(string);
    }

    private void ce(long l2, cql cql2, cqm cqm2, int n2, CodeDocumentPart codeDocumentPart) {
        codeDocumentPart.append(this.ce(cql2, cqm2));
        codeDocumentPart.append(this.ce(cql2, (IInstructionOperand)cqm2));
        codeDocumentPart.append(this.getMemoryAccessPrefix());
        long l3 = cqm2.getMemoryBaseRegister();
        long l4 = cqm2.getMemoryIndexRegister();
        long l5 = cqm2.getMemoryDisplacement();
        if (l2 != 0L && l4 < 0L && l3 >= 0L && cqo.mm(l3) == 10) {
            long l6 = l5;
            int n3 = cqo.fz(l3);
            if (n3 == 32) {
                l6 = l6 + l2 + (long)cql2.getSize() & 0xFFFFFFFFL;
            } else if (n3 == 64) {
                l6 = l6 + l2 + (long)cql2.getSize();
            }
            this.formatAddress(l6, codeDocumentPart);
        } else {
            if (l3 >= 0L) {
                this.formatRegister(l3, codeDocumentPart);
            }
            if (l4 >= 0L) {
                int n4;
                if (l3 >= 0L) {
                    codeDocumentPart.append("+");
                }
                if ((n4 = cqm2.getMemoryScale()) >= 2) {
                    codeDocumentPart.append(n4 + "*");
                }
                this.formatRegister(l4, codeDocumentPart);
            }
            if (l5 != 0L) {
                if (l3 >= 0L || l4 >= 0L) {
                    if (l5 < 0L) {
                        l5 = -l5;
                        codeDocumentPart.append("-");
                    } else {
                        codeDocumentPart.append("+");
                    }
                } else {
                    l5 &= MathUtil.makeMask(this.getCodeUnit().getCodeAnalyzer().getProcessor().getMode());
                }
                if (this.getCodeUnit().getCodeAnalyzer().getAnalysisRanges().contains(l5) && this.getCodeUnit().getNativeItemAt(l5) != null) {
                    this.formatAddress(l5, codeDocumentPart);
                } else {
                    String string = this.getDefaultNumberFormatter().format(64, l5, NumberFormatter.NumberBase.HEXADECIMAL, false);
                    codeDocumentPart.appendAndRecord(string, ItemClassIdentifiers.IMMEDIATE);
                }
            } else if (l3 < 0L && l4 < 0L) {
                codeDocumentPart.appendAndRecord("0", ItemClassIdentifiers.IMMEDIATE);
            }
        }
        codeDocumentPart.append(this.getMemoryAccessSuffix());
    }

    @Override
    public /* synthetic */ void formatOperand(long l2, IInstruction iInstruction, IInstructionOperand iInstructionOperand, int n2, int n3, CodeDocumentPart codeDocumentPart) {
        this.ce(l2, (cql)iInstruction, iInstructionOperand, n2, n3, codeDocumentPart);
    }

    @Override
    protected /* synthetic */ String generateMnemonic(long l2, IInstruction iInstruction) {
        return this.ce(l2, (cql)iInstruction);
    }

    @Override
    public /* synthetic */ String getMemoryAccessSegmentInfo(IInstruction iInstruction, IInstructionOperand iInstructionOperand) {
        return this.ce((cql)iInstruction, iInstructionOperand);
    }

    @Override
    public /* synthetic */ String getMemoryAccessSizeInfo(IInstruction iInstruction, IInstructionOperandSized iInstructionOperandSized) {
        return this.ce((cql)iInstruction, iInstructionOperandSized);
    }
}

