/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.processor.AbstractProcessor;
import com.pnfsoftware.jeb.core.units.code.asm.processor.BytesBlock;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterBank;
import com.pnfsoftware.jeb.core.units.code.asm.processor.ProcessorException;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterDescriptionEntry;
import com.pnfsoftware.jeb.core.units.code.asm.processor.arch.RegisterUtil;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jebglobal.ckw;
import com.pnfsoftware.jebglobal.ckx;
import com.pnfsoftware.jebglobal.cky;
import com.pnfsoftware.jebglobal.cla;
import com.pnfsoftware.jebglobal.clb;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@Ser
public class ckz
extends AbstractProcessor<ckw> {
    private static final ILogger Rs = GlobalLog.getLogger(ckz.class);
    static final int ce = 0;
    static final int mm = 1;
    static final int fz = 2;
    @SerId(value=1)
    private int ok;

    public ckz(int n2) {
        super(4, n2, Endianness.LITTLE_ENDIAN, 2);
        int n3;
        switch (n2) {
            case 32: {
                n3 = 0;
                break;
            }
            case 64: {
                n3 = 1;
                break;
            }
            case 128: {
                n3 = 2;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.ce(n3);
    }

    @Override
    public Collection<Integer> getSupportedModes() {
        return Arrays.asList(32, 64);
    }

    public void ce(int n2) {
        this.ok = n2;
    }

    public int ce() {
        return this.ok;
    }

    @Override
    public ProcessorType getType() {
        switch (this.mode) {
            case 32: {
                return cky.mm;
            }
            case 64: {
                return cky.fz;
            }
        }
        throw new RuntimeException();
    }

    @Override
    public int getPCRegisterBitsize() {
        return this.getMode();
    }

    @Override
    public int getGPRegisterBitsize() {
        return this.getMode();
    }

    @Override
    public IRegisterBank getRegisterBank() {
        switch (this.getMode()) {
            case 32: {
                return cla.Rs;
            }
            case 64: {
                return cla.ok;
            }
        }
        throw new RuntimeException("Unsupported");
    }

    @Override
    public boolean isRISC() {
        return true;
    }

    boolean mm() {
        return this.mode == 32;
    }

    boolean fz() {
        return this.mode == 64;
    }

    boolean Rs() {
        return this.mode == 128;
    }

    boolean ok() {
        return this.mode == 32 || this.mode == 64;
    }

    boolean mH() {
        return this.mode == 64 || this.mode == 128;
    }

    protected ckw ce(byte[] byArray, int n2, int n3) throws ProcessorException {
        ckw ckw2;
        int n4;
        if (n2 + 2 > n3) {
            throw new ProcessorException("Not enough bytes");
        }
        int n5 = byArray[n2] & 0x7F;
        int n6 = n5 & 3;
        if (n2 + 4 > n3) {
            if (n6 == 3) {
                throw new ProcessorException("Not enough bytes");
            }
            n4 = EndianUtil.littleEndianBytesToShort(byArray, n2);
        } else {
            n4 = EndianUtil.littleEndianBytesToInt(byArray, n2);
        }
        if (n6 == 3) {
            int n7 = n5 >> 2 & 0x1F;
            switch (n7) {
                case 0: 
                case 1: {
                    ckw2 = this.mm(n4, n7);
                    break;
                }
                case 8: 
                case 9: {
                    ckw2 = this.ok(n4, n7);
                    break;
                }
                case 24: {
                    ckw2 = this.mH(n4, n7);
                    break;
                }
                case 27: {
                    ckw2 = this.tA(n4, n7);
                    break;
                }
                case 25: {
                    ckw2 = this.mm(n4, n7);
                    break;
                }
                case 5: 
                case 13: {
                    ckw2 = this.ce(n4, n7);
                    break;
                }
                case 4: 
                case 6: {
                    ckw2 = this.mm(n4, n7);
                    break;
                }
                case 12: 
                case 14: {
                    ckw2 = this.hG(n4, n7);
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    ckw2 = this.ch(n4, n7);
                    break;
                }
                case 20: {
                    ckw2 = this.lg(n4, n7);
                    break;
                }
                case 3: {
                    ckw2 = this.fz(n4, n7);
                    break;
                }
                case 28: {
                    ckw2 = this.Rs(n4, n7);
                    break;
                }
                case 11: {
                    ckw2 = this.ZQ(n4, n7);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        } else {
            ckw2 = this.fz(n4 & 0xFFFF);
        }
        Assert.a(ckw2 != null);
        return ckw2;
    }

    int mm(int n2) {
        return n2 >> 12 & 7;
    }

    ckw ce(int n2, int n3) {
        Assert.a(n3 == 13 || n3 == 5);
        int n4 = n2 >> 7 & 0x1F;
        long l2 = (long)n2 & 0xFFFFFFFFFFFFF000L;
        clb.ri ri2 = n3 == 13 ? clb.hw : clb.PE;
        return this.ce(n2, ri2, n4, l2 >>= 12, 0L, 0L);
    }

    ckw mm(int n2, int n3) {
        int n4 = n2 >> 12 & 7;
        int n5 = n2 >> 7 & 0x1F;
        int n6 = n2 >> 15 & 0x1F;
        long l2 = (long)n2 >> 20;
        clb.ri ri2 = null;
        switch (n3) {
            case 0: {
                ri2 = clb.rt[n4];
                break;
            }
            case 1: {
                if (n4 == 2) {
                    ri2 = clb.uf;
                    break;
                }
                if (n4 != 3) break;
                ri2 = clb.Ue;
                break;
            }
            case 25: {
                if (n4 != 0) break;
                ri2 = clb.tf;
                break;
            }
            case 4: {
                if (n4 == 1 || n4 == 5) {
                    if (this.mm()) {
                        if (n4 == 1 && l2 >> 5 == 0L) {
                            ri2 = clb.hu;
                        } else if (n4 == 5 && l2 >> 5 == 0L) {
                            ri2 = clb.ER;
                        } else if (n4 == 5 && l2 >> 5 == 32L) {
                            ri2 = clb.lP;
                        } else {
                            throw new RuntimeException();
                        }
                        l2 &= 0x1FL;
                        break;
                    }
                    if (!this.mH()) break;
                    if (n4 == 1 && l2 >> 6 == 0L) {
                        ri2 = clb.hu;
                    } else if (n4 == 5 && l2 >> 6 == 0L) {
                        ri2 = clb.ER;
                    } else if (n4 == 5 && l2 >> 6 == 16L) {
                        ri2 = clb.lP;
                    } else {
                        throw new RuntimeException();
                    }
                    l2 &= 0x3FL;
                    break;
                }
                ri2 = clb.Uu[n4];
                break;
            }
            case 6: {
                if (n4 == 1 || n4 == 5) {
                    if (n4 == 1 && l2 >> 5 == 0L) {
                        ri2 = clb.PD;
                    } else if (n4 == 5 && l2 >> 5 == 0L) {
                        ri2 = clb.st;
                    } else if (n4 == 5 && l2 >> 5 == 32L) {
                        ri2 = clb.Vr;
                    } else {
                        throw new RuntimeException();
                    }
                    l2 &= 0x1FL;
                    break;
                }
                ri2 = clb.ac[n4];
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return this.ce(n2, ri2, n5, n6, l2, 0L);
    }

    ckw fz(int n2, int n3) {
        Assert.a(n3 == 3);
        int n4 = n2 >> 12 & 7;
        int n5 = n2 >> 7 & 0x1F;
        int n6 = n2 >> 15 & 0x1F;
        clb.ri ri2 = null;
        int n7 = 0;
        int n8 = 0;
        if (n4 == 0) {
            if (n6 == 0 && n5 == 0) {
                n7 = n2 >> 20 & 0xF;
                n8 = n2 >> 24 & 0xF;
                int n9 = n2 >> 28 & 0xF;
                if (n9 == 0) {
                    ri2 = clb.io;
                } else if (n9 == 8) {
                    ri2 = clb.HI;
                }
            }
        } else if (n4 == 1) {
            ri2 = clb.Cy;
        }
        return this.ce(n2, ri2, n8, n7, 0L, 0L);
    }

    ckw Rs(int n2, int n3) {
        Assert.a(n3 == 28);
        int n4 = n2 >> 12 & 7;
        int n5 = n2 >> 7 & 0x1F;
        int n6 = n2 >> 15 & 0x1F;
        long l2 = n2 >>> 20;
        clb.ri ri2 = null;
        if (n4 == 0 && n6 == 0 && n5 == 0) {
            if (l2 == 0L) {
                ri2 = clb.kP;
            } else if (l2 == 1L) {
                ri2 = clb.ai;
            }
        } else if (n4 == 1 || n4 == 2 || n4 == 3) {
            if (n4 == 1) {
                ri2 = clb.eL;
            } else if (n4 == 2) {
                ri2 = clb.CT;
            } else if (n4 == 3) {
                ri2 = clb.bM;
            }
        } else if (n4 == 5 || n4 == 6 || n4 == 7) {
            if (n4 == 5) {
                ri2 = clb.pP;
            } else if (n4 == 6) {
                ri2 = clb.ta;
            } else if (n4 == 7) {
                ri2 = clb.fy;
            }
        }
        return this.ce(n2, ri2, n5, l2, n6, 0L);
    }

    ckw ok(int n2, int n3) {
        int n4 = n2 >> 12 & 7;
        int n5 = n2 >> 15 & 0x1F;
        int n6 = n2 >> 20 & 0x1F;
        long l2 = (long)n2 >> 25 << 5 | (long)(n2 >> 7) & 0x1FL;
        clb.ri ri2 = null;
        if (n3 == 8) {
            ri2 = clb.Al[n4];
        } else if (n3 == 9) {
            if (n4 == 2) {
                ri2 = clb.KQ;
            } else if (n4 == 3) {
                ri2 = clb.hA;
            }
        }
        return this.ce(n2, ri2, n6, n5, l2, 0L);
    }

    ckw mH(int n2, int n3) {
        Assert.a(n3 == 24);
        int n4 = n2 >> 12 & 7;
        int n5 = n2 >> 15 & 0x1F;
        int n6 = n2 >> 20 & 0x1F;
        long l2 = (long)n2 >> 31 << 12 | ((long)n2 >> 7 & 1L) << 11 | ((long)n2 >> 25 & 0x3FL) << 5 | ((long)n2 >> 8 & 0xFL) << 1;
        clb.ri ri2 = clb.wx[n4];
        return this.ce(n2, ri2, n5, n6, l2, 0L);
    }

    ckw tA(int n2, int n3) {
        Assert.a(n3 == 27);
        int n4 = n2 >> 7 & 0x1F;
        long l2 = (long)n2 >> 31 << 20 | ((long)n2 >> 12 & 0xFFL) << 12 | ((long)n2 >> 20 & 1L) << 11 | ((long)n2 >> 21 & 0x3FFL) << 1;
        clb.ri ri2 = clb.DO;
        return this.ce(n2, ri2, n4, l2, 0L, 0L);
    }

    ckw hG(int n2, int n3) {
        Assert.a(n3 == 12 || n3 == 14);
        int n4 = n2 >> 12 & 7;
        int n5 = n2 >> 25 & 0x7F;
        int n6 = n2 >> 7 & 0x1F;
        int n7 = n2 >> 15 & 0x1F;
        int n8 = n2 >> 20 & 0x1F;
        clb.ri ri2 = null;
        switch (n4) {
            case 0: {
                if (n5 == 0) {
                    ri2 = n3 == 12 ? clb.LW : clb.aW;
                    break;
                }
                if (n5 == 32) {
                    ri2 = n3 == 12 ? clb.PU : clb.YS;
                    break;
                }
                if (n5 != 1) break;
                ri2 = n3 == 12 ? clb.Zq : clb.dj;
                break;
            }
            case 1: {
                if (n5 == 0) {
                    ri2 = n3 == 12 ? clb.Xr : clb.mR;
                    break;
                }
                if (n5 != 1) break;
                ri2 = n3 == 12 ? clb.gA : null;
                break;
            }
            case 2: {
                if (n5 == 0) {
                    ri2 = n3 == 12 ? clb.Nx : null;
                    break;
                }
                if (n5 != 1) break;
                ri2 = n3 == 12 ? clb.eP : null;
                break;
            }
            case 3: {
                if (n5 == 0) {
                    ri2 = n3 == 12 ? clb.uM : null;
                    break;
                }
                if (n5 != 1) break;
                ri2 = n3 == 12 ? clb.xd : null;
                break;
            }
            case 4: {
                if (n5 == 0) {
                    ri2 = n3 == 12 ? clb.Qt : null;
                    break;
                }
                if (n5 != 1) break;
                ri2 = n3 == 12 ? clb.eq : clb.iI;
                break;
            }
            case 5: {
                if (n5 == 0) {
                    ri2 = n3 == 12 ? clb.dh : clb.vD;
                    break;
                }
                if (n5 == 32) {
                    ri2 = n3 == 12 ? clb.dr : clb.OG;
                    break;
                }
                if (n5 != 1) break;
                ri2 = n3 == 12 ? clb.BO : clb.Sk;
                break;
            }
            case 6: {
                if (n5 == 0) {
                    ri2 = n3 == 12 ? clb.PG : null;
                    break;
                }
                if (n5 != 1) break;
                ri2 = n3 == 12 ? clb.QM : clb.EC;
                break;
            }
            case 7: {
                if (n5 == 0) {
                    ri2 = n3 == 12 ? clb.ly : null;
                    break;
                }
                if (n5 != 1) break;
                ri2 = n3 == 12 ? clb.sl : clb.F;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return this.ce(n2, ri2, n6, n7, n8, 0L);
    }

    ckw ZQ(int n2, int n3) {
        clb.ri[] riArray;
        Assert.a(n3 == 11);
        int n4 = n2 >> 12 & 7;
        int n5 = n2 >> 27 & 0x1F;
        int n6 = n2 >> 7 & 0x1F;
        int n7 = n2 >> 15 & 0x1F;
        int n8 = n2 >> 20 & 0x1F;
        if (n4 == 2) {
            riArray = clb.Wt;
        } else if (n4 == 3) {
            riArray = clb.LM;
        } else {
            throw new RuntimeException();
        }
        clb.ri ri2 = riArray[n5];
        if (n5 == 2 && n8 != 0) {
            ri2 = null;
        }
        return this.ce(n2, ri2, n6, n7, n8, 0L);
    }

    ckw lg(int n2, int n3) {
        Assert.a(n3 == 20);
        int n4 = n2 >> 25 & 0x7F;
        int n5 = n2 >> 12 & 7;
        int n6 = n2 >> 7 & 0x1F;
        int n7 = n2 >> 15 & 0x1F;
        int n8 = n2 >> 20 & 0x1F;
        boolean bl = (n4 & 1) == 0;
        Assert.a((n4 & 2) == 0);
        int n9 = n4 >> 2;
        clb.ri ri2 = null;
        switch (n9) {
            case 0: {
                ri2 = bl ? clb.Uy : clb.dY;
                break;
            }
            case 1: {
                ri2 = bl ? clb.SU : clb.WV;
                break;
            }
            case 2: {
                ri2 = bl ? clb.Ru : clb.Hy;
                break;
            }
            case 3: {
                ri2 = bl ? clb.bb : clb.c;
                break;
            }
            case 11: {
                if (n8 != 0) break;
                ri2 = bl ? clb.Bg : clb.OB;
                break;
            }
            case 4: {
                if (n5 == 0) {
                    ri2 = bl ? clb.P : clb.su;
                    break;
                }
                if (n5 == 1) {
                    ri2 = bl ? clb.iP : clb.zx;
                    break;
                }
                if (n5 != 2) break;
                ri2 = bl ? clb.AP : clb.pc;
                break;
            }
            case 5: {
                if (n5 == 0) {
                    ri2 = bl ? clb.dB : clb.Ik;
                    break;
                }
                if (n5 != 1) break;
                ri2 = bl ? clb.Rl : clb.up;
                break;
            }
            case 24: {
                if (n8 == 0) {
                    ri2 = bl ? clb.Pv : clb.pt;
                    break;
                }
                if (n8 == 1) {
                    ri2 = bl ? clb.dz : clb.wc;
                    break;
                }
                if (n8 == 2) {
                    ri2 = bl ? clb.xM : clb.ft;
                    break;
                }
                if (n8 != 3) break;
                ri2 = bl ? clb.Cv : clb.qV;
                break;
            }
            case 28: {
                if (n8 == 0 && n5 == 0) {
                    ri2 = bl ? clb.hO : clb.Wn;
                    break;
                }
                if (n8 != 0 || n5 != 1) break;
                ri2 = bl ? clb.nb : clb.FT;
                break;
            }
            case 20: {
                if (n5 == 2) {
                    ri2 = bl ? clb.kZ : clb.rg;
                    break;
                }
                if (n5 == 1) {
                    ri2 = bl ? clb.jW : clb.TE;
                    break;
                }
                if (n5 != 0) break;
                ri2 = bl ? clb.Zp : clb.lr;
                break;
            }
            case 26: {
                if (n8 == 0) {
                    ri2 = bl ? clb.Gz : clb.lL;
                    break;
                }
                if (n8 == 1) {
                    ri2 = bl ? clb.DZ : clb.zt;
                    break;
                }
                if (n8 == 2) {
                    ri2 = bl ? clb.Aq : clb.kY;
                    break;
                }
                if (n8 != 3) break;
                ri2 = bl ? clb.xv : clb.BF;
                break;
            }
            case 30: {
                if (n8 != 0 || n5 != 0) break;
                ri2 = bl ? clb.iN : clb.mu;
                break;
            }
            case 8: {
                if (n8 == 0) {
                    ri2 = bl ? null : clb.eG;
                    break;
                }
                if (n8 != 1) break;
                ri2 = bl ? clb.YI : null;
            }
        }
        return this.ce(n2, ri2, n6, n7, n8, 0L);
    }

    ckw ch(int n2, int n3) {
        int n4 = n2 >> 25 & 3;
        int n5 = n2 >> 7 & 0x1F;
        int n6 = n2 >> 15 & 0x1F;
        int n7 = n2 >> 20 & 0x1F;
        int n8 = n2 >> 27 & 0x1F;
        clb.ri ri2 = null;
        if (n4 == 0 || n4 == 1) {
            if (n3 == 16) {
                ri2 = n4 == 0 ? clb.vw : clb.Vj;
            } else if (n3 == 17) {
                ri2 = n4 == 0 ? clb.sI : clb.LP;
            } else if (n3 == 18) {
                ri2 = n4 == 0 ? clb.RZ : clb.Gf;
            } else if (n3 == 19) {
                ri2 = n4 == 0 ? clb.AF : clb.ed;
            }
        }
        return this.ce(n2, ri2, n5, n6, n7, n8);
    }

    ckw fz(int n2) {
        ckw ckw2;
        block23: {
            int n3;
            int n4;
            block24: {
                block22: {
                    ckw2 = null;
                    n4 = n2 & 3;
                    n3 = n2 >> 13 & 7;
                    if (n4 != 0) break block22;
                    switch (n3) {
                        case 0: {
                            ckw2 = this.ok(n2, n4, n3);
                            break block23;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            ckw2 = this.mH(n2, n4, n3);
                            break block23;
                        }
                        case 4: {
                            break block23;
                        }
                        case 5: 
                        case 6: 
                        case 7: {
                            ckw2 = this.tA(n2, n4, n3);
                            break block23;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                }
                if (n4 != 1) break block24;
                switch (n3) {
                    case 0: {
                        ckw2 = this.ce(n2, n4, n3);
                        break block23;
                    }
                    case 1: {
                        if (this.mm()) {
                            ckw2 = this.fz(n2, n4, n3);
                        } else if (this.mH()) {
                            ckw2 = this.ce(n2, n4, n3);
                        }
                        break block23;
                    }
                    case 2: 
                    case 3: {
                        ckw2 = this.ce(n2, n4, n3);
                        break block23;
                    }
                    case 4: {
                        ckw2 = this.mm(n2, n4, n3);
                        break block23;
                    }
                    case 5: {
                        ckw2 = this.fz(n2, n4, n3);
                        break block23;
                    }
                    case 6: 
                    case 7: {
                        ckw2 = this.Rs(n2, n4, n3);
                        break block23;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            Assert.a(n4 == 2);
            switch (n3) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    ckw2 = this.ce(n2, n4, n3);
                    break;
                }
                case 4: {
                    ckw2 = this.hG(n2, n4, n3);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    ckw2 = this.ZQ(n2, n4, n3);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        return ckw2;
    }

    ckw ce(int n2, int n3, int n4) {
        int n5;
        int n6 = n5 = n2 >> 7 & 0x1F;
        int n7 = 0;
        clb.ri ri2 = null;
        if (n3 == 1) {
            n7 = n2 >>> 12 << 31 >> 26 | n2 >> 2 & 0x1F;
            if (n4 == 0) {
                if (n5 == 0) {
                    if (n7 == 0) {
                        ri2 = clb.lW;
                    }
                } else if (n7 != 0) {
                    ri2 = clb.WJ;
                }
            } else if (n4 == 1) {
                Assert.a(this.mH());
                if (n5 != 0) {
                    ri2 = clb.vp;
                }
            } else if (n4 == 2) {
                if (n5 != 0) {
                    ri2 = clb.Hv;
                }
            } else if (n4 == 3) {
                if (n5 == 2) {
                    n7 = n2 >>> 12 << 31 >> 22 | (n2 >> 2 & 1) << 5 | (n2 >> 3 & 3) << 7 | (n2 >> 5 & 1) << 6 | (n2 >> 6 & 1) << 4;
                    ri2 = clb.Iq;
                    return this.ce(n2, ri2, (long)n7);
                }
                if (n5 != 0 && n5 != 2) {
                    ri2 = clb.hw;
                    n7 = n2 >>> 12 << 31 >> 14 | (n2 >> 2 & 0x1F) << 12;
                }
            }
        } else if (n3 == 2) {
            if (n4 == 0) {
                if (n5 != 0) {
                    if (this.ok()) {
                        if ((n7 & 0x20) == 0) {
                            ri2 = clb.hu;
                            n7 = (n2 >> 12 & 1) << 5 | n2 >> 2 & 0x1F;
                        }
                    } else if (this.Rs()) {
                        // empty if block
                    }
                }
            } else if (n4 == 1) {
                if (this.ok()) {
                    ri2 = clb.uB;
                    n6 = 2;
                    n7 = ckz.ok(n2);
                } else if (this.Rs()) {
                    // empty if block
                }
            } else if (n4 == 2 || n4 == 3) {
                if (n4 == 2) {
                    if (n5 != 0) {
                        ri2 = clb.am;
                        n6 = 2;
                        n7 = ckz.Rs(n2);
                    }
                } else if (this.mm()) {
                    ri2 = clb.IA;
                    n6 = 2;
                    n7 = ckz.Rs(n2);
                } else if (this.mH()) {
                    ri2 = clb.IL;
                    n6 = 2;
                    n7 = ckz.ok(n2);
                }
            }
        }
        if (ri2.fz == 3) {
            return this.ce(n2, ri2, n5, n6, n7);
        }
        return this.ce(n2, ri2, n5, n7);
    }

    static final int Rs(int n2) {
        return (n2 >> 4 & 7) << 2 | (n2 >> 12 & 1) << 5 | (n2 >> 2 & 3) << 6;
    }

    static final int ok(int n2) {
        return (n2 >> 5 & 3) << 3 | (n2 >> 12 & 1) << 5 | (n2 >> 2 & 7) << 6;
    }

    ckw mm(int n2, int n3, int n4) {
        Assert.a(n3 == 1 && n4 == 4);
        int n5 = 8 | n2 >> 7 & 7;
        int n6 = n2 >> 2 & 0x1F | (n2 >> 12 & 1) << 5;
        int n7 = n2 >> 10 & 3;
        int n8 = n2 >> 12 & 1;
        clb.ri ri2 = null;
        if (n7 == 0) {
            if (this.mm() && n8 != 0) {
                return null;
            }
            if (n6 != 0) {
                ri2 = clb.ER;
            }
        } else if (n7 == 1) {
            if (this.mm() && n8 != 0) {
                return null;
            }
            if (n6 != 0) {
                ri2 = clb.lP;
            }
        } else if (n7 == 2) {
            n6 = n2 >>> 12 << 31 >> 26 | n2 >> 2 & 0x1F;
            ri2 = clb.cO;
        } else {
            Assert.a(n7 == 3);
            int n9 = 8 | n2 >> 2 & 7;
            int n10 = n2 >> 5 & 3;
            if (n8 == 0) {
                ri2 = n10 == 0 ? clb.PU : (n10 == 1 ? clb.Qt : (n10 == 2 ? clb.PG : clb.ly));
            } else if (n10 == 0) {
                ri2 = clb.YS;
            } else if (n10 == 1) {
                ri2 = clb.aW;
            }
            n6 = n9;
        }
        return this.ce(n2, ri2, n5, n5, n6, 0L);
    }

    ckw fz(int n2, int n3, int n4) {
        long l2 = n2 >>> 12 << 31 >> 20 | (n2 >> 2 & 1) << 5 | (n2 >> 3 & 7) << 1 | (n2 >> 6 & 1) << 7 | (n2 >> 7 & 1) << 6 | (n2 >> 8 & 1) << 10 | (n2 >> 9 & 3) << 8 | (n2 >> 11 & 1) << 4;
        clb.ri ri2 = null;
        if (n3 == 1 && n4 == 1) {
            ri2 = clb.DO;
        } else if (n3 == 1 && n4 == 5) {
            ri2 = clb.DM;
        }
        if (ri2 == clb.DM) {
            return this.ce(n2, ri2, l2, 0L, 0L, 0L);
        }
        return this.ce(n2, ri2, 1L, l2, 0L, 0L);
    }

    ckw Rs(int n2, int n3, int n4) {
        int n5 = 8 | n2 >> 7 & 7;
        long l2 = n2 >>> 12 << 31 >> 23 | (n2 >> 5 & 3) << 6 | (n2 >> 2 & 1) << 5 | (n2 >> 10 & 3) << 3 | (n2 >> 3 & 3) << 1;
        clb.ri ri2 = null;
        if (n3 == 1 && n4 == 6) {
            ri2 = clb.CC;
        } else if (n3 == 1 && n4 == 7) {
            ri2 = clb.gn;
        }
        return this.ce(n2, ri2, n5, l2, 0L, 0L);
    }

    ckw ok(int n2, int n3, int n4) {
        int n5 = 8 | n2 >> 2 & 7;
        long l2 = (n2 >> 6 & 1) << 2 | (n2 >> 5 & 1) << 3 | (n2 >> 11 & 3) << 4 | (n2 >> 7 & 0xF) << 6;
        clb.ri ri2 = null;
        if (n3 == 0 && n4 == 0 && l2 != 0L) {
            ri2 = clb.WJ;
        }
        return this.ce(n2, ri2, n5, 2L, l2, 0L);
    }

    ckw mH(int n2, int n3, int n4) {
        int n5 = 8 | n2 >> 2 & 7;
        int n6 = 8 | n2 >> 7 & 7;
        long l2 = (n2 >> 10 & 7) << 3 | (n2 >> 5 & 3) << 6;
        long l3 = (n2 >> 6 & 1) << 2 | (n2 >> 10 & 7) << 3 | (n2 >> 5 & 1) << 6;
        clb.ri ri2 = null;
        if (n3 == 0) {
            if (n4 == 1) {
                if (this.ok()) {
                    ri2 = clb.Ue;
                } else if (this.Rs()) {
                    // empty if block
                }
            } else if (n4 == 2) {
                l2 = l3;
                ri2 = clb.fD;
            } else if (n4 == 3) {
                if (this.mm()) {
                    l2 = l3;
                    ri2 = clb.uf;
                } else if (this.mH()) {
                    ri2 = clb.ML;
                }
            }
        }
        return this.ce(n2, ri2, n5, n6, l2, 0L);
    }

    ckw tA(int n2, int n3, int n4) {
        int n5 = 8 | n2 >> 2 & 7;
        int n6 = 8 | n2 >> 7 & 7;
        long l2 = (n2 >> 10 & 7) << 3 | (n2 >> 5 & 3) << 6;
        long l3 = (n2 >> 6 & 1) << 2 | (n2 >> 10 & 7) << 3 | (n2 >> 5 & 1) << 6;
        clb.ri ri2 = null;
        if (n3 == 0) {
            if (n4 == 5) {
                if (this.ok()) {
                    ri2 = clb.hA;
                } else if (this.Rs()) {
                    // empty if block
                }
            } else if (n4 == 6) {
                l2 = l3;
                ri2 = clb.hY;
            } else if (n4 == 7) {
                if (this.mm()) {
                    l2 = l3;
                    ri2 = clb.KQ;
                } else if (this.mH()) {
                    ri2 = clb.UN;
                }
            }
        }
        return this.ce(n2, ri2, n5, n6, l2, 0L);
    }

    ckw hG(int n2, int n3, int n4) {
        int n5 = n2 >> 12 & 1;
        int n6 = n2 >> 7 & 0x1F;
        int n7 = n2 >> 2 & 0x1F;
        clb.ri ri2 = null;
        if (n3 == 2 && n4 == 4) {
            if (n5 == 0) {
                ri2 = n7 == 0 ? clb.ig : clb.ge;
            } else if (n5 == 1) {
                if (n6 == 0 && n7 == 0) {
                    ri2 = clb.ai;
                } else {
                    if (n6 != 0 && n7 == 0) {
                        ri2 = clb.tf;
                        return this.ce(n2, ri2, 1L, n6, 0L);
                    }
                    if (n6 != 0 && n7 != 0) {
                        ri2 = clb.LW;
                        return this.ce(n2, ri2, n6, n6, n7);
                    }
                }
            }
        }
        return this.ce(n2, ri2, n6, n7);
    }

    ckw ZQ(int n2, int n3, int n4) {
        int n5 = n2 >> 2 & 0x1F;
        clb.ri ri2 = null;
        int n6 = 0;
        if (n3 == 2) {
            if (n4 == 5) {
                if (this.ok()) {
                    n6 = ckz.mH(n2);
                    ri2 = clb.Ro;
                } else if (this.Rs()) {
                    n6 = ckz.tA(n2);
                    ri2 = clb.lU;
                }
            } else if (n4 == 6) {
                n6 = ckz.hG(n2);
                ri2 = clb.Re;
            }
            if (n4 == 7) {
                if (this.mm()) {
                    n6 = ckz.hG(n2);
                    ri2 = clb.zw;
                } else if (this.mH()) {
                    n6 = ckz.mH(n2);
                    ri2 = clb.qv;
                }
            }
        }
        return this.ce(n2, ri2, n5, n6, 0L, 0L);
    }

    static final int mH(int n2) {
        return (n2 >> 10 & 7) << 3 | (n2 >> 7 & 7) << 6;
    }

    static final int tA(int n2) {
        return (n2 >> 11 & 3) << 4 | (n2 >> 7 & 0xF) << 6;
    }

    static final int hG(int n2) {
        return (n2 >> 9 & 0xF) << 2 | (n2 >> 7 & 3) << 6;
    }

    void ce(clb.ri ri2) {
        Assert.a(ri2 != null);
        Assert.a((this.ok & 0xF) >= (ri2.mm & 0xF));
    }

    ckw ce(int n2, clb.ri ri2, ckx ... ckxArray) {
        int n3 = 0;
        for (ckx ckx2 : ckxArray) {
            if (ckx2 == null) break;
            ++n3;
        }
        return new ckw((n2 & 3) == 3 ? this.ZQ(n2) : this.lg(n2), ri2, Arrays.copyOf(ckxArray, n3), this.getMode());
    }

    ckx ce(long l2, boolean bl) {
        long l3 = bl ? RegisterUtil.createPureRegisterId((int)l2, 2) : l2;
        return new ckx(0, this.getGPRegisterBitsize(), l3);
    }

    ckx ce(long l2) {
        return new ckx(0, this.getGPRegisterBitsize(), l2);
    }

    ckx mm(long l2) {
        return new ckx(1, this.getGPRegisterBitsize(), l2);
    }

    ckx fz(long l2) {
        return new ckx(9, this.getGPRegisterBitsize(), l2);
    }

    ckx Rs(long l2) {
        return new ckx(3, this.getGPRegisterBitsize(), l2);
    }

    ckw ce(int n2, clb.ri ri2) {
        return this.ce(n2, ri2, 0L, 0L, 0L, 0L);
    }

    ckw ce(int n2, clb.ri ri2, long l2) {
        return this.ce(n2, ri2, l2, 0L, 0L, 0L);
    }

    ckw ce(int n2, clb.ri ri2, long l2, long l3) {
        return this.ce(n2, ri2, l2, l3, 0L, 0L);
    }

    ckw ce(int n2, clb.ri ri2, long l2, long l3, long l4) {
        return this.ce(n2, ri2, l2, l3, l4, 0L);
    }

    ckw ce(int n2, clb.ri ri2, long l2, long l3, long l4, long l5) {
        this.ce(ri2);
        ckx ckx2 = this.ce(ri2.Rs & 0xF, l2);
        ckx ckx3 = this.ce(ri2.Rs >> 4 & 0xF, l3);
        ckx ckx4 = this.ce(ri2.Rs >> 8 & 0xF, l4);
        ckx ckx5 = this.ce(ri2.Rs >> 12 & 0xF, l5);
        return this.ce(n2, ri2, ckx2, ckx3, ckx4, ckx5);
    }

    ckx ce(int n2, long l2) {
        switch (n2) {
            case 1: {
                return this.mm(l2);
            }
            case 2: {
                return this.fz(l2);
            }
            case 3: {
                return this.Rs(l2);
            }
            case 4: {
                return this.ce(l2);
            }
            case 5: {
                return this.ce(l2, true);
            }
        }
        return null;
    }

    BytesBlock ZQ(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 24 & 0xFF)};
        return new BytesBlock(byArray, Endianness.LITTLE_ENDIAN, 2);
    }

    BytesBlock lg(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF)};
        return new BytesBlock(byArray, Endianness.LITTLE_ENDIAN, 2);
    }

    @Override
    public String getRegisterName(long l2) {
        return this.mm(l2, false);
    }

    public String mm(long l2, boolean bl) {
        IRegisterBank iRegisterBank = this.getRegisterBank();
        RegisterDescriptionEntry registerDescriptionEntry = iRegisterBank.getDescriptionEntryById(l2);
        if (registerDescriptionEntry != null) {
            List<String> list;
            if (bl && (list = registerDescriptionEntry.getNames()).size() >= 2) {
                return list.get(1);
            }
            return registerDescriptionEntry.getName();
        }
        return null;
    }

    @Override
    protected /* synthetic */ IInstruction parseAtInternal(byte[] byArray, int n2, int n3) throws ProcessorException {
        return this.ce(byArray, n2, n3);
    }
}

