/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionGroup;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.units.code.asm.AbstractNativeDisassemblerPlugin;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeAnalyzerExtension;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.VirtualMemoryUtil;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IProcessor;
import com.pnfsoftware.jeb.core.units.code.asm.processor.RegisterBankService;
import com.pnfsoftware.jeb.core.units.code.asm.render.GenericCodeFormatter;
import com.pnfsoftware.jeb.core.units.code.asm.type.CallingConventionBuilder;
import com.pnfsoftware.jeb.core.units.code.asm.type.CallingConventionService;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.StorageEntry;
import com.pnfsoftware.jeb.core.units.codeobject.ELFPluginsService;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jebglobal.ckl;
import com.pnfsoftware.jebglobal.cko;
import com.pnfsoftware.jebglobal.ckv;
import com.pnfsoftware.jebglobal.ckw;
import com.pnfsoftware.jebglobal.ckz;
import com.pnfsoftware.jebglobal.cla;
import java.util.Arrays;
import java.util.List;

public class cky
extends AbstractNativeDisassemblerPlugin<ckw> {
    public static final String ce = "riscv";
    static ProcessorType mm;
    static ProcessorType fz;
    static ICallingConvention Rs;
    static ICallingConvention ok;

    public cky() {
        super(ce, 0.0);
    }

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("RISC-V Disassembler", "RV32GC/RV64GC disassembler", "PNF Software", Version.create(0, 1));
    }

    @Override
    public boolean canProcessELF(int n2, boolean bl) {
        return n2 == 243;
    }

    @Override
    public boolean canProcessPE(int n2, boolean bl) {
        return n2 == 20530 || n2 == 20580;
    }

    @Override
    public List<ProcessorType> getProcessorTypes() {
        return Arrays.asList(mm, fz);
    }

    @Override
    public IProcessor<ckw> getProcessor(IUnitCreator iUnitCreator) {
        int n2 = 32;
        if (iUnitCreator instanceof ICodeObjectUnit) {
            n2 = ((ICodeObjectUnit)iUnitCreator).getLoaderInformation().getWordSize();
        }
        return new ckz(n2);
    }

    @Override
    public ICallingConvention getCallingConvention(IUnitCreator iUnitCreator) {
        int n2 = 32;
        if (iUnitCreator instanceof ICodeObjectUnit) {
            n2 = ((ICodeObjectUnit)iUnitCreator).getLoaderInformation().getWordSize();
        }
        if (n2 == 32) {
            return Rs;
        }
        if (n2 == 64) {
            return ok;
        }
        return null;
    }

    @Override
    public IVirtualMemory getMemory(IUnitCreator iUnitCreator) {
        int n2 = 32;
        if (iUnitCreator instanceof ICodeObjectUnit) {
            n2 = ((ICodeObjectUnit)iUnitCreator).getLoaderInformation().getWordSize();
        }
        return VirtualMemoryUtil.createMemory(n2, 12, Endianness.LITTLE_ENDIAN);
    }

    @Override
    public GenericCodeFormatter<ckw> getCodeFormatter() {
        return new ckv();
    }

    @Override
    public INativeCodeAnalyzerExtension<ckw> getAnalyzerExtension() {
        return new ckl();
    }

    @Override
    public void initialize(IPropertyDefinitionManager iPropertyDefinitionManager) {
    }

    @Override
    public void setupCustomProperties(IPropertyDefinitionManager iPropertyDefinitionManager) {
        IPropertyDefinitionGroup iPropertyDefinitionGroup = iPropertyDefinitionManager.getGroup("text");
        iPropertyDefinitionGroup.addDefinition("DisplayAbiRegisterNames", PropertyTypeBoolean.create(true), "Use abi (standard calling convention) registers instead of xN/fN", 0);
        iPropertyDefinitionGroup.addDefinition("RenderJRX1AsRet", PropertyTypeBoolean.create(false), "Render 'JR X1 / JR LR' as 'RET' pseudo-instructions", 0);
    }

    static {
        ProcessorType processorType = ProcessorType.valueOf(243);
        if (processorType == ProcessorType.UNKNOWN) {
            processorType = ProcessorType.register(243, ce, null);
        }
        mm = processorType;
        processorType = ProcessorType.valueOf(61490);
        if (processorType == ProcessorType.UNKNOWN) {
            processorType = ProcessorType.register(61490, "riscv64", null);
        }
        fz = processorType;
        RegisterBankService.getInstance().add(mm, cla.Rs);
        RegisterBankService.getInstance().add(fz, cla.ok);
        Rs = new CallingConventionBuilder("ILP32D", mm).setReturnAddressSlot(StorageEntry.createRegister(1L)).addInputSlot(StorageEntry.createRegister(10L)).addInputSlot(StorageEntry.createRegister(11L)).addInputSlot(StorageEntry.createRegister(12L)).addInputSlot(StorageEntry.createRegister(13L)).addInputSlot(StorageEntry.createRegister(14L)).addInputSlot(StorageEntry.createRegister(15L)).addInputSlot(StorageEntry.createRegister(16L)).addInputSlot(StorageEntry.createRegister(17L)).addInputRegisterPair(StorageEntry.createRegisterPair(10L, 11L)).addInputRegisterPair(StorageEntry.createRegisterPair(12L, 13L)).addInputRegisterPair(StorageEntry.createRegisterPair(14L, 15L)).addInputRegisterPair(StorageEntry.createRegisterPair(16L, 17L)).addInputSlot(StorageEntry.createStackSlot(0L)).addOutputSlot(StorageEntry.createRegister(10L)).addOutputSlot(StorageEntry.createRegister(11L)).addOutputRegisterPair(StorageEntry.createRegisterPair(10L, 11L)).build();
        ok = new CallingConventionBuilder("LP64D", fz).setReturnAddressSlot(StorageEntry.createRegister(1L)).addInputSlot(StorageEntry.createRegister(10L)).addInputSlot(StorageEntry.createRegister(11L)).addInputSlot(StorageEntry.createRegister(12L)).addInputSlot(StorageEntry.createRegister(13L)).addInputSlot(StorageEntry.createRegister(14L)).addInputSlot(StorageEntry.createRegister(15L)).addInputSlot(StorageEntry.createRegister(16L)).addInputSlot(StorageEntry.createRegister(17L)).addInputRegisterPair(StorageEntry.createRegisterPair(10L, 11L)).addInputRegisterPair(StorageEntry.createRegisterPair(12L, 13L)).addInputRegisterPair(StorageEntry.createRegisterPair(14L, 15L)).addInputRegisterPair(StorageEntry.createRegisterPair(16L, 17L)).addInputSlot(StorageEntry.createStackSlot(0L)).addOutputSlot(StorageEntry.createRegister(10L)).addOutputSlot(StorageEntry.createRegister(11L)).addOutputRegisterPair(StorageEntry.createRegisterPair(10L, 11L)).build();
        CallingConventionService.getInstance().addConvention(Rs);
        CallingConventionService.getInstance().addConvention(ok);
        ELFPluginsService.getInstance().addRelocationContext(cko.mH);
    }
}

