/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.units.code.android.ir.DFormattingContext;
import com.pnfsoftware.jeb.core.units.code.java.IJavaOperator;
import com.pnfsoftware.jeb.core.units.code.java.IJavaOperatorFactory;
import com.pnfsoftware.jeb.core.units.code.java.IJavaType;
import com.pnfsoftware.jeb.core.units.code.java.JavaOperatorType;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class cfx
implements IJavaOperator {
    private static final ILogger ce = GlobalLog.getLogger(cfx.class);
    @SerId(value=1)
    private JavaOperatorType mm;
    @SerId(value=2)
    private IJavaType fz;
    @SerId(value=3)
    private IJavaOperatorFactory Rs;

    cfx(JavaOperatorType javaOperatorType, IJavaOperatorFactory iJavaOperatorFactory) {
        this.mm = javaOperatorType;
        this.fz = null;
        this.Rs = iJavaOperatorFactory;
    }

    cfx(IJavaType iJavaType, IJavaOperatorFactory iJavaOperatorFactory) {
        this.mm = JavaOperatorType.CAST_TO_OBJECT;
        this.fz = iJavaType;
        this.Rs = iJavaOperatorFactory;
    }

    @Override
    public IJavaOperatorFactory getFactory() {
        return this.Rs;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public boolean is(JavaOperatorType javaOperatorType) {
        return this.mm == javaOperatorType;
    }

    @Override
    public boolean isAnyOf(JavaOperatorType ... javaOperatorTypeArray) {
        for (JavaOperatorType javaOperatorType : javaOperatorTypeArray) {
            if (this.mm != javaOperatorType) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNoneOf(JavaOperatorType ... javaOperatorTypeArray) {
        for (JavaOperatorType javaOperatorType : javaOperatorTypeArray) {
            if (this.mm != javaOperatorType) continue;
            return false;
        }
        return true;
    }

    @Override
    public JavaOperatorType getOperatorType() {
        switch (this.mm) {
            case ADD: {
                return JavaOperatorType.ADD;
            }
            case AND: {
                return JavaOperatorType.AND;
            }
            case CAST_TO_BOOLEAN: {
                return JavaOperatorType.CAST_TO_BOOLEAN;
            }
            case CAST_TO_BYTE: {
                return JavaOperatorType.CAST_TO_BYTE;
            }
            case CAST_TO_CHAR: {
                return JavaOperatorType.CAST_TO_CHAR;
            }
            case CAST_TO_DOUBLE: {
                return JavaOperatorType.CAST_TO_DOUBLE;
            }
            case CAST_TO_FLOAT: {
                return JavaOperatorType.CAST_TO_FLOAT;
            }
            case CAST_TO_INT: {
                return JavaOperatorType.CAST_TO_INT;
            }
            case CAST_TO_LONG: {
                return JavaOperatorType.CAST_TO_LONG;
            }
            case CAST_TO_OBJECT: {
                return JavaOperatorType.CAST_TO_OBJECT;
            }
            case CAST_TO_SHORT: {
                return JavaOperatorType.CAST_TO_SHORT;
            }
            case CONCAT: {
                return JavaOperatorType.CONCAT;
            }
            case DIV: {
                return JavaOperatorType.DIV;
            }
            case EQ: {
                return JavaOperatorType.EQ;
            }
            case GE: {
                return JavaOperatorType.GE;
            }
            case GT: {
                return JavaOperatorType.GT;
            }
            case INSTANCEOF: {
                return JavaOperatorType.INSTANCEOF;
            }
            case LE: {
                return JavaOperatorType.LE;
            }
            case LOG_AND: {
                return JavaOperatorType.LOG_AND;
            }
            case LOG_IDENT: {
                return JavaOperatorType.LOG_IDENT;
            }
            case LOG_NOT: {
                return JavaOperatorType.LOG_NOT;
            }
            case LOG_OR: {
                return JavaOperatorType.LOG_OR;
            }
            case LT: {
                return JavaOperatorType.LT;
            }
            case MUL: {
                return JavaOperatorType.MUL;
            }
            case NE: {
                return JavaOperatorType.NE;
            }
            case NEG: {
                return JavaOperatorType.NEG;
            }
            case NOT: {
                return JavaOperatorType.NOT;
            }
            case OR: {
                return JavaOperatorType.OR;
            }
            case REM: {
                return JavaOperatorType.REM;
            }
            case SHL: {
                return JavaOperatorType.SHL;
            }
            case SHR: {
                return JavaOperatorType.SHR;
            }
            case SUB: {
                return JavaOperatorType.SUB;
            }
            case USHR: {
                return JavaOperatorType.USHR;
            }
            case XOR: {
                return JavaOperatorType.XOR;
            }
            case COND_EXP: {
                return JavaOperatorType.COND_EXP;
            }
            case CAST_CONVERSION: {
                return JavaOperatorType.CAST_CONVERSION;
            }
        }
        return null;
    }

    @Override
    public IJavaType getCastType() {
        switch (this.mm) {
            case CAST_TO_BYTE: {
                return this.getFactory().getTypeFactory().getByte();
            }
            case CAST_TO_CHAR: {
                return this.getFactory().getTypeFactory().getChar();
            }
            case CAST_TO_SHORT: {
                return this.getFactory().getTypeFactory().getShort();
            }
            case CAST_TO_INT: {
                return this.getFactory().getTypeFactory().getInt();
            }
            case CAST_TO_LONG: {
                return this.getFactory().getTypeFactory().getLong();
            }
            case CAST_TO_FLOAT: {
                return this.getFactory().getTypeFactory().getFloat();
            }
            case CAST_TO_DOUBLE: {
                return this.getFactory().getTypeFactory().getDouble();
            }
            case CAST_TO_BOOLEAN: {
                return this.getFactory().getTypeFactory().getBoolean();
            }
            case CAST_TO_OBJECT: {
                return this.fz;
            }
            case CAST_CONVERSION: {
                throw new RuntimeException("Cast-conversion, resulting type is unknown");
            }
        }
        throw new RuntimeException();
    }

    @Override
    public boolean isUnary() {
        return this.mm.isUnary();
    }

    @Override
    public boolean isBinary() {
        return this.mm.isBinary();
    }

    @Override
    public boolean isArithmetic() {
        return this.mm.isArithmetic();
    }

    @Override
    public boolean isLogical() {
        return this.mm.isLogical();
    }

    @Override
    public boolean isCast() {
        return this.mm.isCast();
    }

    @Override
    public boolean isCastToPrimitive() {
        return this.mm.isCastToPrimitive();
    }

    public String toString() {
        switch (this.mm) {
            case ADD: {
                return "+";
            }
            case SUB: {
                return "-";
            }
            case MUL: {
                return "*";
            }
            case DIV: {
                return "/";
            }
            case REM: {
                return "%";
            }
            case AND: {
                return "&";
            }
            case OR: {
                return "|";
            }
            case XOR: {
                return "^";
            }
            case SHL: {
                return "<<";
            }
            case SHR: {
                return ">>";
            }
            case USHR: {
                return ">>>";
            }
            case NEG: {
                return "-";
            }
            case NOT: {
                return "~";
            }
            case LOG_IDENT: {
                return "";
            }
            case LOG_NOT: {
                return "!";
            }
            case LOG_OR: {
                return "||";
            }
            case LOG_AND: {
                return "&&";
            }
            case INSTANCEOF: {
                return " instanceof ";
            }
            case EQ: {
                return "==";
            }
            case NE: {
                return "!=";
            }
            case LT: {
                return "<";
            }
            case GE: {
                return ">=";
            }
            case GT: {
                return ">";
            }
            case LE: {
                return "<=";
            }
            case CAST_TO_BYTE: {
                return "(byte)";
            }
            case CAST_TO_CHAR: {
                return "(char)";
            }
            case CAST_TO_SHORT: {
                return "(short)";
            }
            case CAST_TO_INT: {
                return "(int)";
            }
            case CAST_TO_LONG: {
                return "(long)";
            }
            case CAST_TO_FLOAT: {
                return "(float)";
            }
            case CAST_TO_DOUBLE: {
                return "(double)";
            }
            case CAST_TO_BOOLEAN: {
                return "(boolean)";
            }
            case CAST_TO_OBJECT: {
                return Strings.ff("(%s)", this.fz);
            }
            case CONCAT: {
                return "+";
            }
            case CAST_CONVERSION: {
                return "(?conv)";
            }
            case COND_EXP: {
                return ":?";
            }
        }
        throw new RuntimeException();
    }

    @Override
    public boolean isValidForCombinedAssignment() {
        switch (this.mm) {
            case ADD: 
            case AND: 
            case DIV: 
            case MUL: 
            case OR: 
            case REM: 
            case SHL: 
            case SHR: 
            case SUB: 
            case USHR: 
            case XOR: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPrecedenceDelta(IJavaOperator iJavaOperator) throws Exception {
        int n2 = this.mm.getPrecedence();
        int n3 = iJavaOperator.getOperatorType().getPrecedence();
        if (n2 == 0 || n3 == 0) {
            throw new Exception("Cannot calculate precedence delta");
        }
        return n2 - n3;
    }

    @Override
    public int getPrecedence() {
        int n2 = this.mm.getPrecedence();
        if (n2 == 0) {
            throw new RuntimeException();
        }
        return n2;
    }

    @Override
    public JavaOperatorType.Associativity getAssociativity() {
        JavaOperatorType.Associativity associativity = this.mm.getAssociativity();
        if (associativity == null) {
            throw new RuntimeException();
        }
        return associativity;
    }

    @Override
    public boolean canCauseException() {
        return this.mm == JavaOperatorType.DIV || this.mm == JavaOperatorType.REM || this.isCast();
    }

    @Override
    public void format(DFormattingContext dFormattingContext) {
        switch (this.mm) {
            case ADD: {
                dFormattingContext.append("+");
                break;
            }
            case SUB: {
                dFormattingContext.append("-");
                break;
            }
            case MUL: {
                dFormattingContext.append("*");
                break;
            }
            case DIV: {
                dFormattingContext.append("/");
                break;
            }
            case REM: {
                dFormattingContext.append("%");
                break;
            }
            case AND: {
                dFormattingContext.append("&");
                break;
            }
            case OR: {
                dFormattingContext.append("|");
                break;
            }
            case XOR: {
                dFormattingContext.append("^");
                break;
            }
            case SHL: {
                dFormattingContext.append("<<");
                break;
            }
            case SHR: {
                dFormattingContext.append(">>");
                break;
            }
            case USHR: {
                dFormattingContext.append(">>>");
                break;
            }
            case NEG: {
                dFormattingContext.append("-");
                break;
            }
            case NOT: {
                dFormattingContext.append("~");
                break;
            }
            case LOG_IDENT: {
                break;
            }
            case LOG_NOT: {
                dFormattingContext.append("!");
                break;
            }
            case LOG_OR: {
                dFormattingContext.append("||");
                break;
            }
            case LOG_AND: {
                dFormattingContext.append("&&");
                break;
            }
            case INSTANCEOF: {
                dFormattingContext.append(" instanceof ");
                break;
            }
            case EQ: {
                dFormattingContext.append("==");
                break;
            }
            case NE: {
                dFormattingContext.append("!=");
                break;
            }
            case LT: {
                dFormattingContext.append("<");
                break;
            }
            case GE: {
                dFormattingContext.append(">=");
                break;
            }
            case GT: {
                dFormattingContext.append(">");
                break;
            }
            case LE: {
                dFormattingContext.append("<=");
                break;
            }
            case CAST_TO_BYTE: {
                dFormattingContext.append("(byte)");
                break;
            }
            case CAST_TO_CHAR: {
                dFormattingContext.append("(char)");
                break;
            }
            case CAST_TO_SHORT: {
                dFormattingContext.append("(short)");
                break;
            }
            case CAST_TO_INT: {
                dFormattingContext.append("(int)");
                break;
            }
            case CAST_TO_LONG: {
                dFormattingContext.append("(long)");
                break;
            }
            case CAST_TO_FLOAT: {
                dFormattingContext.append("(float)");
                break;
            }
            case CAST_TO_DOUBLE: {
                dFormattingContext.append("(double)");
                break;
            }
            case CAST_TO_BOOLEAN: {
                dFormattingContext.append("(boolean)");
                break;
            }
            case CAST_TO_OBJECT: {
                dFormattingContext.paren();
                this.fz.format(dFormattingContext);
                dFormattingContext.parenClose();
                break;
            }
            case CONCAT: {
                dFormattingContext.append("+");
                break;
            }
            case CAST_CONVERSION: {
                dFormattingContext.append("(?conv)");
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }
}

