/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDalvikInstructionParameter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class bgz
implements IDalvikInstructionParameter {
    @SerId(value=1)
    private int ce;
    @SerId(value=2)
    private long mm;

    public bgz(int n2, long l2) {
        this.ce = n2;
        this.mm = l2;
    }

    @Override
    public int getType() {
        return this.ce;
    }

    @Override
    public long getValue() {
        return this.mm;
    }

    @Override
    public String format(IInstruction iInstruction, long l2) {
        StringBuilder stringBuilder = new StringBuilder();
        long l3 = this.getValue();
        switch (this.getType()) {
            case 0: {
                Strings.ff(stringBuilder, "v%d", l3);
                break;
            }
            case 1: {
                Strings.ff(stringBuilder, "#%X", l3);
                break;
            }
            case 2: {
                int n2 = (int)l3;
                Strings.ff(stringBuilder, "@%d", n2);
                break;
            }
            case 3: {
                int n3 = (int)(l2 + l3 * 2L);
                Strings.ff(stringBuilder, "%X", n3);
                break;
            }
            case 4: {
                Strings.ff(stringBuilder, "v%d-v%d", l3 & 0xFFFFL, l3 >> 32 & 0xFFFFL);
                break;
            }
            case 5: {
                Strings.ff(stringBuilder, "@@%d", l3);
                break;
            }
            default: {
                throw new JebRuntimeException("Unsupported parameter type: " + this.getType());
            }
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.ce;
        n2 = 31 * n2 + (int)(this.mm ^ this.mm >>> 32);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        bgz bgz2 = (bgz)object;
        if (this.ce != bgz2.ce) {
            return false;
        }
        return this.mm == bgz2.mm;
    }

    public String toString() {
        return Strings.ff("t=%d,v=%d", this.getType(), this.getValue());
    }
}

