/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.units.code.asm.decompiler.exceptions.UntranslatedIntermediateExpressionException;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEAssign;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECompose;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECond;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEMem;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEOperation;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEReturn;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IESlice;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.collect.Lists;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jebglobal.alc;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class avl
extends alc {
    private List<IEGeneric> ce = Lists.createArrayList();
    private StringBuilder mm = new StringBuilder();

    public avl() {
    }

    public avl(avl avl2) {
        for (IEGeneric iEGeneric : avl2.ce()) {
            this.ce.add(iEGeneric);
        }
        this.mm = new StringBuilder(avl2.mm().toString());
    }

    public List<IEGeneric> ce() {
        return this.ce;
    }

    public String mm(IEGeneric iEGeneric) {
        return "v" + this.ce.indexOf(iEGeneric);
    }

    public StringBuilder mm() {
        return this.mm;
    }

    @Override
    public void ce(IECompose iECompose) {
        this.mm.append("(concat");
        ListIterator<IEGeneric> listIterator = new ArrayList<IEGeneric>(iECompose.getParts()).listIterator(iECompose.getPartsCount());
        while (listIterator.hasPrevious()) {
            IEGeneric iEGeneric = listIterator.previous();
            this.mm.append(" ");
            if (EUtil.isLogicalOperation(iEGeneric)) {
                this.fz(iEGeneric);
                continue;
            }
            this.ce(iEGeneric);
        }
        this.mm.append(")");
    }

    public void fz(IEGeneric iEGeneric) {
        this.mm.append("(ite ");
        this.ce(iEGeneric);
        this.mm.append(" #b1 #b0)");
    }

    @Override
    public void ce(IECond iECond) {
        if (!EUtil.isLogicalOperation(iECond.getCondition())) {
            iECond = EUtil.buildStrictLogicalECond(iECond);
        }
        this.mm.append("(ite ");
        this.ce(iECond.getCondition());
        this.mm.append(" ");
        this.ce(iECond.getExpressionTrue());
        this.mm.append(" ");
        this.ce(iECond.getExpressionFalse());
        this.mm.append(")");
    }

    @Override
    public void ce(IEImm iEImm) {
        this.mm.append(this.ce(iEImm.getUnsignedValue().toString(), iEImm.getBitsize()));
    }

    @Override
    public void ce(IEMem iEMem) {
        if (!this.ce.contains(iEMem)) {
            this.ce.add(iEMem);
        }
        this.mm.append(this.Rs(iEMem));
    }

    @Override
    public void ce(IEOperation iEOperation) {
        switch (iEOperation.getOperationType()) {
            case ADD: {
                this.mm.append("(bvadd ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case SUB: {
                this.mm.append("(bvsub ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case MUL: {
                this.mm.append("(bvmul ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case DIV_S: {
                this.mm.append("(bvsdiv ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case DIV_U: {
                this.mm.append("(bvudiv ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case REM_S: {
                this.mm.append("(bvsrem ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case REM_U: {
                this.mm.append("(bvurem ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case LOG_NOT: {
                if (!EUtil.isLogicalOperation(iEOperation.getOperand1())) {
                    iEOperation = EUtil.buildStrictLogicalOperation(iEOperation);
                }
                this.mm.append("(not ");
                this.ce(iEOperation.getOperand1());
                this.mm.append(")");
                break;
            }
            case LOG_EQ: {
                if (EUtil.isLogicalOperation(iEOperation.getOperand1()) && !EUtil.isLogicalOperation(iEOperation.getOperand2()) || !EUtil.isLogicalOperation(iEOperation.getOperand1()) && EUtil.isLogicalOperation(iEOperation.getOperand2())) {
                    iEOperation = EUtil.buildLogicalOperation(iEOperation);
                }
                this.mm.append("(= ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case LOG_NEQ: {
                if (EUtil.isLogicalOperation(iEOperation.getOperand1()) && !EUtil.isLogicalOperation(iEOperation.getOperand2()) || !EUtil.isLogicalOperation(iEOperation.getOperand1()) && EUtil.isLogicalOperation(iEOperation.getOperand2())) {
                    iEOperation = EUtil.buildLogicalOperation(iEOperation);
                }
                this.mm.append("(not (= ");
                this.mm(iEOperation);
                this.mm.append("))");
                break;
            }
            case LOG_OR: {
                if (!EUtil.isLogicalOperation(iEOperation.getOperand1()) || !EUtil.isLogicalOperation(iEOperation.getOperand2())) {
                    iEOperation = EUtil.buildStrictLogicalOperation(iEOperation);
                }
                this.mm.append("(or ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case LOG_AND: {
                if (!EUtil.isLogicalOperation(iEOperation.getOperand1()) || !EUtil.isLogicalOperation(iEOperation.getOperand2())) {
                    iEOperation = EUtil.buildStrictLogicalOperation(iEOperation);
                }
                this.mm.append("(and ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case LE_S: {
                this.mm.append("(bvsle ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case LT_S: {
                this.mm.append("(bvslt ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case GE_S: {
                this.mm.append("(bvsge ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case GT_S: {
                this.mm.append("(bvsgt ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case LE_U: {
                this.mm.append("(bvule ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case LT_U: {
                this.mm.append("(bvult ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case GE_U: {
                this.mm.append("(bvuge ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case GT_U: {
                this.mm.append("(bvugt ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case AND: {
                this.mm.append("(bvand ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case OR: {
                this.mm.append("(bvor ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case NOT: {
                this.mm.append("(bvnot ");
                this.ce(iEOperation.getOperand1());
                this.mm.append(")");
                break;
            }
            case XOR: {
                this.mm.append("(bvxor ");
                this.mm(iEOperation);
                this.mm.append(")");
                break;
            }
            case SHL: {
                this.mm.append("(bvshl ");
                this.fz(iEOperation);
                this.mm.append(")");
                break;
            }
            case SHR: {
                this.mm.append("(bvlshr ");
                this.fz(iEOperation);
                this.mm.append(")");
                break;
            }
            case SAR: {
                this.mm.append("(bvashr ");
                this.fz(iEOperation);
                this.mm.append(")");
                break;
            }
            default: {
                throw new UntranslatedIntermediateExpressionException("No translation available for EOperation (%s)", new Object[]{iEOperation.getOperationType()});
            }
        }
    }

    @Override
    public void ce(IEVar iEVar) {
        if (!this.ce.contains(iEVar)) {
            this.ce.add(iEVar);
        }
        this.mm.append(this.Rs(iEVar));
    }

    @Override
    public void ce(IESlice iESlice) {
        this.mm.append("((_ extract ");
        this.mm.append(iESlice.getBitEnd() - 1);
        this.mm.append(" ");
        this.mm.append(iESlice.getBitStart());
        this.mm.append(") ");
        this.ce(iESlice.getWholeExpression());
        this.mm.append(")");
    }

    @Override
    public void ce(IEStatement iEStatement) {
        if (iEStatement instanceof IEAssign) {
            IEGeneric iEGeneric = ((IEAssign)iEStatement).getDstOperand();
            IEGeneric iEGeneric2 = ((IEAssign)iEStatement).getSrcOperand();
            if (iEGeneric.getBitsize() != iEGeneric2.getBitsize()) {
                throw new UntranslatedIntermediateExpressionException("No translation available for EAssign with different sizes");
            }
            this.mm.append("(= ");
            this.ce(iEGeneric);
            this.mm.append(" ");
            this.ce(iEGeneric2);
            this.mm.append(")");
        } else if (iEStatement instanceof IEReturn) {
            if (((IEReturn)iEStatement).getValue() != null) {
                this.ce(((IEReturn)iEStatement).getValue());
            }
        } else {
            throw new UntranslatedIntermediateExpressionException("No translation available for such EStatement (%s)", iEStatement);
        }
    }

    private void mm(IEOperation iEOperation) {
        this.ce(iEOperation.getOperand1());
        this.mm.append(" ");
        this.ce(iEOperation.getOperand2());
    }

    private void fz(IEOperation iEOperation) {
        IEGeneric iEGeneric = iEOperation.getOperand1();
        IEGeneric iEGeneric2 = iEOperation.getOperand2();
        int n2 = iEOperation.getBitsize();
        Assert.a(n2 == iEGeneric.getBitsize());
        if (n2 == iEGeneric2.getBitsize()) {
            this.mm(iEOperation);
        } else if (n2 > iEGeneric2.getBitsize()) {
            this.ce(iEGeneric);
            this.mm.append(" ");
            this.ce(iEGeneric2.zeroExtend(n2));
        } else {
            this.ce(iEGeneric);
            this.mm.append(" ");
            this.ce(iEGeneric2.part(n2));
        }
    }

    private void ce(IEGeneric iEGeneric, int n2) {
        if (n2 == 0) {
            throw new IllegalArgumentException("Invalid number of bit to extend");
        }
        this.mm.append("(concat ");
        this.mm.append(this.ce("0", n2));
        this.mm.append(" ");
        this.ce(iEGeneric);
        this.mm.append(")");
    }

    private String ce(String string, int n2) {
        return Strings.ff("(_ bv%s %d)", string, n2);
    }

    private String Rs(IEGeneric iEGeneric) {
        return Strings.ff("v%d", this.ce.indexOf(iEGeneric));
    }

    public String fz() {
        StringBuilder stringBuilder = new StringBuilder();
        for (IEGeneric iEGeneric : this.ce) {
            Strings.ff(stringBuilder, "(declare-const %s (_ BitVec %d))\n", this.Rs(iEGeneric), iEGeneric.getBitsize());
        }
        stringBuilder.append("(assert ");
        stringBuilder.append("(and ");
        stringBuilder.append(this.mm.toString());
        stringBuilder.append(")");
        stringBuilder.append(")\n");
        return stringBuilder.toString();
    }
}

