/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.JebCoreService;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEJump;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IENop;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IESwitch;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import com.pnfsoftware.jebglobal.aeb;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class anz {
    private static final StructuredLogger logger = aeb.ce(anz.class);
    private IERoutineContext ctx;
    private CFG<IEStatement> cfg;
    private CFG<IEStatement> cfgN;
    private TreeMap<Integer, Integer> interToInterN = new TreeMap();
    private List<Long> adjustedEntriesForNativeAddresses = new ArrayList<Long>();
    private List<Long> missingEntriesForNativeAddresses = new ArrayList<Long>();

    public anz(IERoutineContext iERoutineContext) {
        this.ctx = iERoutineContext;
    }

    public IERoutineContext getContext() {
        return this.ctx;
    }

    public IEStatement[] processStatement(IEStatement iEStatement, int n2) {
        return new IEStatement[]{iEStatement};
    }

    public boolean process() {
        return this.process(true, true, false);
    }

    public boolean process(boolean bl, boolean bl2, boolean bl3) {
        return this.process(bl, bl2, bl3, null);
    }

    public boolean process(boolean bl, boolean bl2, boolean bl3, Boolean bl4) {
        if (this.cfgN != null) {
            throw new IllegalStateException("The graph was already processed");
        }
        this.cfg = this.ctx.getCfg();
        if (bl4 == null) {
            bl4 = (this.cfg.getFlags() & 1) != 0;
        }
        ArrayList<IEStatement> arrayList = new ArrayList<IEStatement>();
        ArrayList<IEJump> arrayList2 = new ArrayList<IEJump>();
        ArrayList<IESwitch> arrayList3 = new ArrayList<IESwitch>();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        try {
            int n2;
            int n3 = 0;
            for (BasicBlock<IEStatement> object : this.cfg) {
                n2 = (int)object.getFirstAddress();
                for (Object object2 : object) {
                    int n4 = object2.getSize();
                    Object[] objectArray = this.processStatement((IEStatement)object2, n2);
                    if (objectArray == null || objectArray.length == 0) {
                        throw new RuntimeException("processStatements() must have at least one instruction, got: " + Arrays.toString(objectArray));
                    }
                    object2 = objectArray[0];
                    if (bl) {
                        object2.adjustSize(-n4 + 1);
                    }
                    IEStatement[] iEStatementArray = (IEStatement[])Arrays.copyOfRange(objectArray, 1, objectArray.length);
                    if (bl) {
                        for (IEStatement iEStatement : iEStatementArray) {
                            if (iEStatement.getSize() == 1) continue;
                            throw new RuntimeException("Inserted statement size must be 1");
                        }
                    }
                    if (bl2) {
                        if (object2 instanceof IENop && iEStatementArray.length > 0) {
                            throw new RuntimeException("Additional statements cannot be inserted when the first one is a nop and nops should be removed");
                        }
                        for (IEStatement iEStatement : iEStatementArray) {
                            if (!(iEStatement instanceof IENop)) continue;
                            throw new RuntimeException("Inserted statement cannot be nop");
                        }
                    }
                    if (object2 instanceof IEJump) {
                        arrayList2.add((IEJump)object2);
                    } else if (object2 instanceof IESwitch) {
                        arrayList3.add((IESwitch)object2);
                    }
                    if (bl2 && object2 instanceof IENop) {
                        arrayList4.add(n2);
                    } else {
                        if (!arrayList4.isEmpty()) {
                            Iterator iterator = arrayList4.iterator();
                            while (iterator.hasNext()) {
                                int n5 = (Integer)iterator.next();
                                this.interToInterN.put(n5, n3);
                            }
                            arrayList4.clear();
                        }
                        this.interToInterN.put(n2, n3);
                        arrayList.add((IEStatement)object2);
                        n3 += object2.getSize();
                        for (IEStatement iEStatement : iEStatementArray) {
                            arrayList.add(iEStatement);
                            n3 += iEStatement.getSize();
                        }
                    }
                    n2 += n4;
                }
            }
            if (!arrayList4.isEmpty()) {
                int n6 = (Integer)arrayList4.remove(arrayList4.size() - 1);
                Iterator iterator = arrayList4.iterator();
                while (iterator.hasNext()) {
                    n2 = (Integer)iterator.next();
                    this.interToInterN.put(n2, n3);
                }
                this.interToInterN.put(n6, n3);
                arrayList.add(this.ctx.createNop());
            }
            for (IEJump iEJump : arrayList2) {
                iEJump.setBranchAddress(this.updateIROffset(iEJump.getBranchAddress()));
            }
            for (IESwitch iESwitch : arrayList3) {
                if (iESwitch.hasDefaultAddress()) {
                    iESwitch.setDefaultAddress(this.updateIROffset(iESwitch.getDefaultAddress()));
                }
                for (Couple<IEGeneric, Integer> couple : iESwitch.getCases()) {
                    couple.setSecond(this.updateIROffset(couple.getSecond()));
                }
            }
            this.cfgN = this.ctx.buildCfg(arrayList, bl4, false);
            this.cfgN.setVariableInformationProvider(this.cfg.getVariableInformationProvider());
            this.cfgN.setDFADefaultCollectionFlags(this.cfg.getDFADefaultCollectionFlags());
            if (bl3) {
                this.ctx.setCfg(this.cfgN);
            }
        }
        catch (Exception exception) {
            Object[] cfr_ignored_0 = new Object[0];
            logger.catching(exception);
            JebCoreService.notifySilentExceptionToClient(exception);
            return false;
        }
        return true;
    }

    private int updateIROffset(int n2) {
        Integer n3 = this.interToInterN.get(n2);
        if (n3 == null) {
            throw new RuntimeException(Strings.ff("Cannot convert old IR offset to normalized one: 0x%X", n2));
        }
        return n3;
    }

    public CFG<IEStatement> getCfg() {
        if (this.cfgN == null) {
            throw new IllegalStateException();
        }
        return this.cfgN;
    }

    @Deprecated
    public List<Long> getMissingEntriesForNativeAddresses() {
        return this.missingEntriesForNativeAddresses;
    }

    @Deprecated
    public List<Long> getAdjustedEntriesForNativeAddresses() {
        return this.adjustedEntriesForNativeAddresses;
    }
}

