/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.IDFA;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EDefUseInfo;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EUtil;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEAssign;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IECall;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEJump;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEMem;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IENop;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEOperation;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IESwitch;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.OperationType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.VarSrc;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IMasterOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.OptimizerEntry;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TimeFormatter;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.ams;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class amr {
    private static final ILogger ce = GlobalLog.getLogger(amr.class);

    public static String ce(IMasterOptimizer iMasterOptimizer) {
        long l2 = 0L;
        List list = iMasterOptimizer.getRegisteredOptimizers();
        for (OptimizerEntry object : list) {
            object.getStatistics().getRunCount();
            object.getStatistics().getOptimizationCount();
            l2 += object.getStatistics().getExecutionTimeMillis();
        }
        Collections.sort(list, new ams());
        StringBuilder stringBuilder = new StringBuilder();
        for (OptimizerEntry optimizerEntry : list) {
            String string = optimizerEntry.getOptimizer().getPluginInformation().getName();
            OptimizerEntry.Stat stat = optimizerEntry.getStatistics();
            int n2 = stat.getRunCount();
            int n3 = stat.getOptimizationCount();
            long l3 = stat.getExecutionTimeMillis();
            int n4 = l2 == 0L ? 0 : (int)(l3 * 100L / l2);
            Strings.ff(stringBuilder, "- \"%s\": rc=%d oc=%d t=%d(%s) (%d%%)\n", string, n2, n3, l3, TimeFormatter.formatTimestampDelta(l3), n4);
        }
        return stringBuilder.toString();
    }

    public static boolean ce(IERoutineContext iERoutineContext, BasicBlock<IEStatement> basicBlock) {
        for (BasicBlock<IEStatement> basicBlock2 : basicBlock.getAllInputs()) {
            IEStatement iEStatement = basicBlock2.getLast();
            if (!EUtil.isPCAssign(iEStatement) && !iEStatement.isJumpFar()) continue;
            return false;
        }
        return true;
    }

    public static int ce(IERoutineContext iERoutineContext, BasicBlock<IEStatement> basicBlock, int n2) {
        return amr.ce(iERoutineContext, basicBlock, n2, false);
    }

    public static int ce(IERoutineContext iERoutineContext, BasicBlock<IEStatement> basicBlock, int n2, boolean bl) {
        IEGeneric iEGeneric;
        IEStatement iEStatement;
        Object object;
        IEStatement iEStatement2;
        IEStatement iEStatement3 = basicBlock.get(n2);
        if (iEStatement3 == null) {
            throw new RuntimeException("Cannot remove null instruction");
        }
        if (basicBlock.isEmpty()) {
            throw new RuntimeException("Empty basic bloc!");
        }
        if (basicBlock.size() == 1 || n2 == 0 && !bl || n2 == 0 && !amr.ce(iERoutineContext, basicBlock)) {
            if (iEStatement3.isNop()) {
                return 0;
            }
            IENop iENop = iERoutineContext.createNop(iEStatement3);
            basicBlock.set(0, iENop);
            return -1;
        }
        int n3 = iEStatement3.getSize();
        if (n2 == 0) {
            iEStatement2 = basicBlock.get(1);
            object = iERoutineContext.getCfg().getBlockEndingAt(basicBlock.getBase());
            iEStatement = object != null ? (IEStatement)((BasicBlock)object).getLast() : null;
        } else {
            iEStatement = iEStatement2 = basicBlock.get(n2 - 1);
        }
        if (iEStatement instanceof IECall && (iEGeneric = (object = iEStatement.asCall()).getReturnLocation()) != null) {
            IEImm iEImm;
            if (!(iEGeneric instanceof IEImm)) {
                if (iEStatement3.isNop()) {
                    return 0;
                }
                IENop iENop = iERoutineContext.createNop(iEStatement3);
                basicBlock.set(n2, iENop);
                return -1;
            }
            if (n2 + 1 < basicBlock.size() && (iEImm = iEGeneric.asImm()).canReadAsAddress()) {
                IEStatement iEStatement4;
                Long l2;
                long l3 = iEImm.getValueAsAddress();
                if (iEStatement3.getLowerLevelAddresses().contains(l3) && (l2 = (iEStatement4 = basicBlock.get(n2 + 1)).getPrimaryLowerLevelAddress()) != null) {
                    IEImm iEImm2 = EUtil.imm(l2, iEGeneric.getBitsize());
                    object.setReturnLocation(iEImm2);
                }
            }
        }
        iEStatement2.adjustSize(n3);
        basicBlock.remove(n2);
        Assert.a(!basicBlock.isEmpty());
        return 1;
    }

    public static void ce(IERoutineContext iERoutineContext, IBasicBlock<IEStatement> iBasicBlock, int n2, int n3) {
        IEStatement iEStatement = iBasicBlock.get(n2 == iBasicBlock.size() ? n2 - 1 : n2);
        int n4 = (int)(iBasicBlock.getEndAddress() - iBasicBlock.getBase() - (long)iBasicBlock.size());
        int n5 = iEStatement.getSize() + n3 - n4;
        EUtil.expandStatementSize(iERoutineContext, iEStatement, n5);
    }

    public static boolean ce(IERoutineContext iERoutineContext, BasicBlock<IEStatement> basicBlock, int n2, List<IEStatement> list) throws JebException {
        int n3;
        int n4;
        IEStatement iEStatement;
        int n5;
        if (!amr.ce(basicBlock, list.size())) {
            amr.ce(iERoutineContext, basicBlock, n2, list.size());
            throw new JebException("Size adjusted, cfg was modified");
        }
        int n6 = list.size();
        List<IEStatement> list2 = basicBlock.getInstructions();
        if (n2 != 0) {
            for (n5 = n2 - 1; n5 >= 0 && n6 > 0; --n5) {
                iEStatement = list2.get(n5);
                n4 = iEStatement.getSize();
                if (n4 <= 1) continue;
                n3 = n4 - n6 >= 1 ? n6 : n4 - 1;
                n6 -= n3;
                iEStatement.adjustSize(-n3);
            }
        }
        if (n6 > 0 && n2 < list2.size()) {
            for (n5 = n2; n5 < list2.size() && n6 > 0; ++n5) {
                iEStatement = list2.get(n5);
                n4 = iEStatement.getSize();
                if (n4 <= 1) continue;
                n3 = n4 - n6 >= 1 ? n6 : n4 - 1;
                n6 -= n3;
                iEStatement.adjustSize(-n3);
            }
        }
        for (n5 = 0; n5 < list.size(); ++n5) {
            iEStatement = list.get(n5);
            iEStatement.setSize(1);
            basicBlock.add(n2 + n5, iEStatement);
        }
        return true;
    }

    public static boolean ce(IBasicBlock<IEStatement> iBasicBlock, int n2) {
        return (long)(n2 + iBasicBlock.size()) <= iBasicBlock.getEndAddress() - iBasicBlock.getBase();
    }

    public static boolean ce(IEGeneric iEGeneric, IEGeneric iEGeneric2) {
        if (iEGeneric == null) {
            return iEGeneric2 == null;
        }
        return iEGeneric.equalsEx(iEGeneric2, false);
    }

    public static boolean ce(IDFA<IEStatement> iDFA, int n2) {
        for (IBasicBlock<IEStatement> iBasicBlock : iDFA.getCfg().getExitBlocks()) {
            if (!iDFA.getOutputMap(iBasicBlock).containsKey(n2)) continue;
            return true;
        }
        return false;
    }

    public static boolean ce(IDFA<IEStatement> iDFA, long l2, int n2) {
        return amr.mm(iDFA, l2, n2) >= 0;
    }

    public static int mm(IDFA<IEStatement> iDFA, long l2, int n2) {
        for (IBasicBlock<IEStatement> iBasicBlock : iDFA.getCfg().getExitBlocks()) {
            Collection<Long> collection = iDFA.getOutputMap(iBasicBlock, n2);
            if (collection == null) continue;
            if (collection.contains(l2)) {
                return 1;
            }
            for (Long l3 : collection) {
                IEStatement iEStatement = iDFA.getCfg().getInstruction(l3);
                if (!(iEStatement instanceof IEAssign) || ((IEAssign)iEStatement).isRoutineCall() || ((IEAssign)iEStatement).isBreakingFlow()) continue;
                EDefUseInfo eDefUseInfo = new EDefUseInfo();
                ((IEAssign)iEStatement).getLeftOperand().getDefinedOrUsedAsDestination(eDefUseInfo);
                if (!eDefUseInfo.getDef().containsVarFull(n2)) {
                    return 0;
                }
                Collection<Long> collection2 = iDFA.getUseDefs(l3, n2);
                if (collection2 == null || !collection2.contains(n2)) continue;
                return 0;
            }
        }
        return -1;
    }

    public static boolean ce(IERoutineContext iERoutineContext, IDFA<IEStatement> iDFA, long l2, int n2) {
        for (IBasicBlock<IEStatement> iBasicBlock : iDFA.getCfg().getExitBlocks()) {
            Collection<Long> collection = iDFA.getOutputMap(iBasicBlock, n2);
            if (collection == null || !collection.contains(l2)) continue;
            VarSrc varSrc = iERoutineContext.getSourceForVariable(n2);
            if (varSrc == null) {
                return true;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            varSrc.collectSourceIds(arrayList);
            if (arrayList.size() != 1) {
                return true;
            }
            IEVar iEVar = iERoutineContext.getVariableById((Integer)arrayList.get(0));
            IEGeneric iEGeneric = iERoutineContext.getOutputVariableForRegister(iDFA, iBasicBlock.getLastAddress(), iEVar);
            if (iEGeneric == null) {
                return true;
            }
            return iEGeneric instanceof IEVar && ((IEVar)iEGeneric).getId() == n2;
        }
        return false;
    }

    public static boolean ce(CFG<IEStatement> cFG, BasicBlock<IEStatement> basicBlock) {
        if (basicBlock.size() != 1 || !EUtil.isJump(basicBlock.get(0))) {
            return false;
        }
        if (basicBlock.allinsize() != 0) {
            return false;
        }
        BasicBlock<IEStatement> basicBlock2 = null;
        long l2 = basicBlock.getFirstAddress();
        for (BasicBlock<IEStatement> basicBlock3 : cFG) {
            if (basicBlock3 == basicBlock || basicBlock3.size() < 1 || basicBlock3.getEndAddress() != l2) continue;
            basicBlock2 = basicBlock3;
            break;
        }
        if (basicBlock2 == null) {
            return false;
        }
        int n2 = basicBlock.get(0).getSize();
        cFG.removeBlock(basicBlock);
        ((IEStatement)basicBlock2.getLast()).adjustSize(n2);
        return true;
    }

    public static int ce(CFG<IEStatement> cFG, boolean bl, boolean bl2) {
        int n2 = 0;
        for (int i = 0; i < cFG.size() - 1; ++i) {
            IEStatement iEStatement;
            IBasicBlock iBasicBlock = cFG.get(i);
            if (!((IEStatement)((BasicBlock)iBasicBlock).getLast()).isJump()) continue;
            IEJump iEJump = ((IEStatement)((BasicBlock)iBasicBlock).getLast()).asJump();
            IEGeneric iEGeneric = iEJump.getCondition();
            if (bl && iEGeneric == null) continue;
            IBasicBlock iBasicBlock2 = cFG.get(i + 1);
            if ((long)iEJump.getBranchAddress() != ((BasicBlock)iBasicBlock2).getBase()) continue;
            IERoutineContext iERoutineContext = iEJump.getContext();
            if (!bl2 && (iEGeneric == null || EUtil.hasNoSideEffect(iEGeneric))) {
                iEStatement = iERoutineContext.createNop(iEJump);
            } else {
                IEVar iEVar = iERoutineContext.getGlobalContext().createVirtualRegister("oldJumpCondition" + iEGeneric.getBitsize(), iEGeneric.getBitsize());
                iEStatement = iERoutineContext.createAssign(iEVar, iEGeneric);
                iEStatement.copyProperties(iEJump);
            }
            ((BasicBlock)iBasicBlock).set(((BasicBlock)iBasicBlock).size() - 1, iEStatement);
            cFG.deleteOutEdges((BasicBlock<IEStatement>)iBasicBlock);
            cFG.addEdge((BasicBlock<IEStatement>)iBasicBlock, (BasicBlock<IEStatement>)iBasicBlock2);
            ++n2;
        }
        return n2;
    }

    public static int mm(CFG<IEStatement> cFG, boolean bl, boolean bl2) {
        int n2 = 0;
        if (bl) {
            n2 += cFG.removeUnreachableBlocks();
        }
        if (bl2) {
            n2 += amr.ce(cFG, true, false);
        }
        return n2;
    }

    public static int ce(CFG<IEStatement> cFG) {
        return amr.mm(cFG, true, true);
    }

    public static IEMem ce(IERoutineContext iERoutineContext, IEMem iEMem, IEMem iEMem2) {
        IEGeneric iEGeneric;
        IEGeneric iEGeneric2 = iEMem.getReference();
        IEGeneric iEGeneric3 = iEMem2.getReference();
        IEGeneric iEGeneric4 = iEGeneric2;
        IEGeneric iEGeneric5 = iEGeneric3;
        BigInteger bigInteger = BigInteger.ZERO;
        BigInteger bigInteger2 = BigInteger.ZERO;
        int n2 = iEMem.getBitsize() >>> 3;
        if (EUtil.isOperation(iEGeneric3, OperationType.ADD, OperationType.SUB)) {
            iEGeneric = ((IEOperation)iEGeneric3).getOperand2();
            if (iEGeneric instanceof IEImm) {
                iEGeneric5 = ((IEOperation)iEGeneric3).getOperand1();
                BigInteger bigInteger3 = bigInteger2 = ((IEOperation)iEGeneric3).getOperationType() == OperationType.ADD ? ((IEImm)iEGeneric).getValue() : ((IEImm)iEGeneric).getValue().negate();
            }
            if (bigInteger2.equals(BigInteger.valueOf(n2)) && iEGeneric2.equals(iEGeneric5)) {
                return iERoutineContext.createMem(iEGeneric2, iEMem.getBitsize() + iEMem2.getBitsize());
            }
        }
        if (EUtil.isOperation(iEGeneric2, OperationType.ADD, OperationType.SUB) && (iEGeneric = ((IEOperation)iEGeneric2).getOperand2()) instanceof IEImm) {
            iEGeneric4 = ((IEOperation)iEGeneric2).getOperand1();
            BigInteger bigInteger4 = bigInteger = ((IEOperation)iEGeneric2).getOperationType() == OperationType.ADD ? ((IEImm)iEGeneric).getValue() : ((IEImm)iEGeneric).getValue().negate();
        }
        if (bigInteger2.subtract(bigInteger).equals(BigInteger.valueOf(n2)) && iEGeneric4.equals(iEGeneric5)) {
            return iERoutineContext.createMem(iEGeneric2, iEMem.getBitsize() + iEMem2.getBitsize());
        }
        return null;
    }

    public static boolean ce(IESwitch iESwitch, CFG<IEStatement> cFG, BasicBlock<IEStatement> basicBlock, BasicBlock<IEStatement> basicBlock2, BasicBlock<IEStatement> basicBlock3) {
        boolean bl = false;
        int n2 = (int)basicBlock2.getBase();
        int n3 = (int)basicBlock3.getBase();
        if (iESwitch.getDefaultAddress() == n2) {
            iESwitch.setDefaultAddress(n3);
            bl = true;
        }
        if (iESwitch.isPossibleTarget(n2)) {
            ArrayList<IEGeneric> arrayList = new ArrayList<IEGeneric>();
            for (Couple<IEGeneric, Integer> couple : iESwitch.getCases()) {
                if (couple.getSecond() != n2) continue;
                arrayList.add(couple.getFirst());
            }
            for (IEGeneric iEGeneric : arrayList) {
                iESwitch.removeCase(iEGeneric);
                iESwitch.addCase(iEGeneric, n3);
                bl = true;
            }
        }
        if (!basicBlock.getOutputOffsets().contains(n3)) {
            if (cFG.reconnectEdge(basicBlock, basicBlock2, basicBlock3) != 1) {
                throw new RuntimeException("Edge reconnect failed");
            }
        } else {
            cFG.deleteEdge(basicBlock, basicBlock2);
        }
        return bl;
    }
}

