/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.google.common.collect.MapMaker;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICConstant;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICConstantFactory;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICConstantString;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICElement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICExpression;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.exceptions.EvaluationException;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEImm;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IWildcardType;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.math.MathUtil;
import com.pnfsoftware.jeb.util.primitives.LargeIntHandler;
import com.pnfsoftware.jeb.util.primitives.Longs;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jebglobal.alp;
import com.pnfsoftware.jebglobal.alq;
import com.pnfsoftware.jebglobal.alr;
import com.pnfsoftware.jebglobal.als;
import com.pnfsoftware.jebglobal.amy;
import java.math.BigInteger;
import java.util.Map;

@Ser
public class alu
extends alp {
    private static Map<Couple<Long, Integer>, alu> ok = new MapMaker().weakValues().makeMap();
    @SerId(value=1)
    protected long Rs;

    public static alu mm(long l2, int n2) {
        if (n2 > 64) {
            throw new IllegalArgumentException("Illegal bitsize, greater than 64: " + n2);
        }
        long l3 = MathUtil.signExtend(l2, n2);
        Couple<Long, Integer> couple = new Couple<Long, Integer>(l3, n2);
        alu alu2 = ok.get(couple);
        if (alu2 == null) {
            alu2 = new alu(l3, n2);
            ok.put(couple, alu2);
        }
        return alu2;
    }

    private alu(long l2, int n2) {
        super(n2);
        this.Rs = l2;
    }

    @Override
    public IWildcardType.Group getGroup() {
        return IWildcardType.Group.INTEGER;
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 31 * n2 + (int)(this.Rs ^ this.Rs >>> 32);
        return n2;
    }

    @Override
    public boolean equalsEx(Object object, boolean bl) {
        if (this == object) {
            return true;
        }
        if (!super.equalsEx(object, bl)) {
            return false;
        }
        if (object instanceof alu) {
            alu alu2 = (alu)object;
            return this.Rs == alu2.Rs;
        }
        if (object instanceof alq) {
            alq alq2 = (alq)object;
            return this.Rs == alq2.Rs.longValue();
        }
        return false;
    }

    public alp ZQ() {
        alu alu2 = new alu(this.Rs, this.ce);
        return super.ce(alu2);
    }

    public Long lg() {
        return this.Rs;
    }

    @Override
    public boolean canReadAsLong() {
        return true;
    }

    @Override
    public long getValueAsLong() {
        return this.Rs;
    }

    @Override
    public boolean canReadAsUnsignedLong() {
        return this.ce <= 63 || this._signum() >= 0;
    }

    @Override
    public long getValueAsUnsignedLong() {
        if (!this.canReadAsUnsignedLong()) {
            throw new EvaluationException("Cannot return value as a 64-bit unsigned long");
        }
        return MathUtil.zeroExtend(this.Rs, this.ce);
    }

    @Override
    public BigInteger getValue() {
        return BigInteger.valueOf(this.Rs);
    }

    @Override
    public BigInteger getUnsignedValue() {
        return new BigInteger(Long.toHexString(MathUtil.zeroExtend(this.Rs, this.ce)), 16);
    }

    @Override
    public boolean isStringLiteral() {
        return this.fz instanceof ICConstantString;
    }

    @Override
    public String getStringLiteral() {
        if (this.fz instanceof ICConstantString) {
            return (String)((ICConstantString)this.fz).getValue();
        }
        return null;
    }

    public alp mm(int n2) {
        if (n2 > 64) {
            return alq.ce(this.Rs, n2);
        }
        return alu.mm(this.Rs, n2);
    }

    public alp fz(int n2) {
        if (n2 > 64) {
            String string = Longs.toUnsignedString(MathUtil.zeroExtend(this.Rs, this.ce));
            return alq.mm(string, n2);
        }
        return alu.mm(MathUtil.zeroExtend(this.Rs, this.ce), n2);
    }

    @Override
    public void ce(amy amy2) {
        if (this.fz != null && this.fz instanceof ICConstant) {
            ItemClassIdentifiers itemClassIdentifiers = ItemClassIdentifiers.IMMEDIATE;
            if (this.fz instanceof ICConstantString) {
                itemClassIdentifiers = ItemClassIdentifiers.STRING;
            }
            amy2.append(this.fz.format(), itemClassIdentifiers);
            return;
        }
        Object object = "";
        if (amy2.ce()) {
            object = (String)object + "i" + this.ce + ":";
        }
        switch (this.ce) {
            case 1: {
                object = (String)object + Long.toString(this.Rs & 1L);
                break;
            }
            case 2: {
                object = (String)object + Long.toString(this.Rs & 3L);
                break;
            }
            case 8: {
                object = (String)object + Strings.ff("%02Xh", this.Rs & 0xFFL);
                break;
            }
            case 16: {
                object = (String)object + Strings.ff("%04Xh", this.Rs & 0xFFFFL);
                break;
            }
            case 32: {
                object = (String)object + Strings.ff("%08Xh", this.Rs & 0xFFFFFFFFL);
                break;
            }
            case 64: {
                object = (String)object + Strings.ff("%016Xh", this.Rs);
                break;
            }
            default: {
                object = (String)object + Strings.ff("%Xh", MathUtil.zeroExtend(this.Rs, this.ce));
            }
        }
        amy2.append((String)object, ItemClassIdentifiers.IMMEDIATE);
        if (this.mm) {
            amy2.mm(this);
        }
    }

    @Override
    public int _signum() {
        return this.Rs > 0L ? 1 : (this.Rs < 0L ? -1 : 0);
    }

    public alp ch() {
        if (this.Rs == 0L) {
            return this;
        }
        return alu.mm(-this.Rs, this.ce);
    }

    private alu ch(IEImm iEImm) {
        alu alu2;
        if (iEImm.getBitsize() != this.ce) {
            throw new RuntimeException("Mismatched bit sizes between " + this + " and " + iEImm);
        }
        if (iEImm instanceof alu) {
            alu2 = (alu)iEImm;
        } else if (iEImm instanceof alq) {
            alu2 = alu.mm(iEImm.getValueAsLong(), iEImm.getBitsize());
            if (this.isMutable()) {
                alu2 = (alu)alu2.ce(iEImm.getType());
            }
        } else if (iEImm instanceof alr) {
            alu2 = ((alr)iEImm).lg();
        } else if (iEImm instanceof als) {
            alu2 = ((als)iEImm).lg();
        } else {
            throw new RuntimeException();
        }
        return alu2;
    }

    public alp ce(IEImm iEImm) {
        alu alu2 = this.ch(iEImm);
        return alu.mm(this.Rs + alu2.Rs, this.ce);
    }

    public alp mm(IEImm iEImm) {
        alu alu2 = this.ch(iEImm);
        return alu.mm(this.Rs - alu2.Rs, this.ce);
    }

    public alp fz(IEImm iEImm) {
        alu alu2 = this.ch(iEImm);
        return alu.mm(this.Rs * alu2.Rs, this.ce);
    }

    public alp Rs(IEImm iEImm) {
        alu alu2 = this.ch(iEImm);
        return alu.mm(this.Rs / alu2.Rs, this.ce);
    }

    public alp ok(IEImm iEImm) {
        long l2;
        alu alu2 = this.ch(iEImm);
        if (this.ce == 64 && (this.Rs < 0L || alu2.Rs < 0L)) {
            LargeIntHandler largeIntHandler = LargeIntHandler.create(this.ce);
            l2 = largeIntHandler.divU(BigInteger.valueOf(this.Rs), BigInteger.valueOf(alu2.Rs)).longValue();
        } else {
            long l3 = MathUtil.zeroExtend(this.Rs, this.ce);
            long l4 = MathUtil.zeroExtend(alu2.Rs, this.ce);
            l2 = l3 / l4;
        }
        return alu.mm(l2, this.ce);
    }

    public alp mH(IEImm iEImm) {
        alu alu2 = this.ch(iEImm);
        return alu.mm(this.Rs % alu2.Rs, this.ce);
    }

    public alp tA(IEImm iEImm) {
        alu alu2 = this.ch(iEImm);
        long l2 = this.ce == 64 ? this.Rs : MathUtil.zeroExtend(this.Rs, this.ce);
        long l3 = alu2.ce == 64 ? alu2.Rs : MathUtil.zeroExtend(alu2.Rs, this.ce);
        return alu.mm(l2 % l3, this.ce);
    }

    public alp UE() {
        return alu.mm(this.Rs ^ 0xFFFFFFFFFFFFFFFFL, this.ce);
    }

    public alp hG(IEImm iEImm) {
        alu alu2 = this.ch(iEImm);
        return alu.mm(this.Rs & alu2.Rs, this.ce);
    }

    public alp ZQ(IEImm iEImm) {
        alu alu2 = this.ch(iEImm);
        return alu.mm(this.Rs | alu2.Rs, this.ce);
    }

    public alp lg(IEImm iEImm) {
        alu alu2 = this.ch(iEImm);
        return alu.mm(this.Rs ^ alu2.Rs, this.ce);
    }

    @Override
    public boolean _testbit(int n2) {
        if (n2 < 0 || n2 >= this.ce) {
            throw new ArithmeticException("Invalid bit position");
        }
        return (this.Rs & 1L << n2) != 0L;
    }

    public alp Rs(int n2) {
        if (n2 < 0 || n2 >= this.ce) {
            throw new ArithmeticException("Invalid bit position");
        }
        return alu.mm(this.Rs | 1L << n2, this.ce);
    }

    public alp ok(int n2) {
        if (n2 < 0 || n2 >= this.ce) {
            throw new ArithmeticException("Invalid bit position");
        }
        return alu.mm(this.Rs & (1L << n2 ^ 0xFFFFFFFFFFFFFFFFL), this.ce);
    }

    private int UE(int n2) {
        if (this.ce == 64) {
            n2 &= 0x3F;
        } else if (this.ce == 32) {
            n2 &= 0x1F;
        } else if (this.ce == 8) {
            n2 &= 7;
        } else if ((n2 %= this.ce) < 0) {
            n2 += this.ce;
        }
        return n2;
    }

    public alp mH(int n2) {
        n2 = this.UE(n2);
        return alu.mm(this.Rs << n2, this.ce);
    }

    public alp tA(int n2) {
        n2 = this.UE(n2);
        long l2 = MathUtil.makeMask(this.ce);
        return alu.mm((this.Rs & l2) >>> n2, this.ce);
    }

    public alp hG(int n2) {
        n2 = this.UE(n2);
        return alu.mm(this.Rs >> n2, this.ce);
    }

    public alp ZQ(int n2) {
        if (n2 < 0) {
            return this.lg(-n2);
        }
        n2 = this.UE(n2);
        long l2 = (1L << n2) - 1L;
        long l3 = this.Rs << n2 | this.Rs >>> this.ce - n2 & l2;
        return alu.mm(l3, this.ce);
    }

    public alp lg(int n2) {
        if (n2 < 0) {
            return this.ZQ(-n2);
        }
        n2 = this.UE(n2);
        long l2 = (1L << n2) - 1L;
        long l3 = MathUtil.makeMask(this.ce);
        long l4 = (this.Rs & l3) >>> n2 | (this.Rs & l2) << this.ce - n2;
        return alu.mm(l4, this.ce);
    }

    @Override
    public int _cmp(IEImm iEImm) {
        alu alu2 = this.ch(iEImm);
        return Long.compare(this.Rs, alu2.Rs);
    }

    @Override
    public int _cmpU(IEImm iEImm) {
        alu alu2 = this.ch(iEImm);
        return Longs.compareUnsigned(this.Rs, alu2.Rs);
    }

    public alp ch(int n2) {
        if (n2 < 0) {
            throw new ArithmeticException("Invalid exponent");
        }
        long l2 = 1L;
        while (n2 > 0) {
            l2 *= this.Rs;
            --n2;
        }
        return alp.ce(l2, this.ce);
    }

    @Override
    public ICElement generateC(IERoutineContext iERoutineContext, ICMethod iCMethod) {
        ICExpression iCExpression;
        if (this.fz != null) {
            return this.fz;
        }
        ICConstantFactory iCConstantFactory = iCMethod.getConstantFactory();
        ICType iCType = null;
        if (this.getType() != null && this.getType().isPointer()) {
            if (this._signum() == 0) {
                return iCConstantFactory.getNull();
            }
            iCType = iCMethod.getTypeFactory().create(this.getType());
        }
        long l2 = MathUtil.zeroExtend(this.Rs, this.ce);
        int n2 = this.ce;
        boolean bl = false;
        if (this.getType() != null) {
            n2 = this.getType().getBitsize();
            if (n2 > 64) {
                n2 = 64;
            }
            if (this.getType().isSigned()) {
                bl = true;
            }
        }
        l2 = bl ? MathUtil.signExtend(l2, n2) : MathUtil.zeroExtend(l2, n2);
        if (iCType != null) {
            iCExpression = iCConstantFactory.createPointer(l2);
            iCExpression = iCMethod.getElementFactory().createCast(iCType, iCExpression);
        } else {
            iCExpression = n2 <= 32 ? (this.getType() != null && this.getType().toString().equals("char") ? iCConstantFactory.createChar((char)l2) : (this.getType() != null && this.getType().isUnsigned() ? iCConstantFactory.createUnsignedInt32((int)l2) : iCConstantFactory.createInt32((int)l2))) : (this.getType() != null && this.getType().isUnsigned() ? iCConstantFactory.createUnsignedInt64(l2) : iCConstantFactory.createInt64(l2));
        }
        return iCExpression;
    }

    @Override
    public String toHexString() {
        return Long.toHexString(MathUtil.zeroExtend(this.Rs, this.ce));
    }

    @Override
    public boolean ok() {
        return this.ce == 32 || this.ce == 64;
    }

    @Override
    public alp mH() {
        alp alp2;
        int n2 = this.ce;
        if (this.getType() != null && this.getType().isFloat()) {
            n2 = this.getType().getBitsize();
        }
        if (n2 == 32) {
            alp2 = alr.mm(Float.intBitsToFloat((int)this.Rs));
        } else if (n2 == 64) {
            alp2 = als.fz(Double.longBitsToDouble(this.Rs));
        } else {
            throw new RuntimeException("Cannot generate a float immediate");
        }
        if (this.isMutable()) {
            alp2 = alp2.ce((IWildcardType)null);
        }
        return alp2;
    }

    @Override
    public alp hG() {
        return this;
    }

    @Override
    public IEImm _fadd(IEImm iEImm) {
        return this.mH()._fadd(iEImm);
    }

    @Override
    public IEImm _fsub(IEImm iEImm) {
        return this.mH()._fsub(iEImm);
    }

    @Override
    public IEImm _fmul(IEImm iEImm) {
        return this.mH()._fmul(iEImm);
    }

    @Override
    public IEImm _fdiv(IEImm iEImm) {
        return this.mH()._fdiv(iEImm);
    }

    @Override
    public Integer _fcmp(IEImm iEImm) {
        return this.mH()._fcmp(iEImm);
    }

    @Override
    public boolean canReadAsSingleFloat() {
        return this.ce == 32;
    }

    @Override
    public float getValueAsSingleFloat() {
        if (!this.canReadAsSingleFloat()) {
            throw new IllegalStateException("Cannot return value as a 32-bit single-precision float");
        }
        return Float.intBitsToFloat((int)this.Rs);
    }

    @Override
    public boolean canReadAsDoubleFloat() {
        return this.ce == 64;
    }

    @Override
    public double getValueAsDoubleFloat() {
        if (!this.canReadAsDoubleFloat()) {
            throw new IllegalStateException("Cannot return value as a 64-bit double-precision float");
        }
        return Double.longBitsToDouble(this.Rs);
    }

    @Override
    public /* synthetic */ Object Rs() {
        return this.lg();
    }

    @Override
    public /* synthetic */ IEImm _pow(int n2) {
        return this.ch(n2);
    }

    @Override
    public /* synthetic */ IEImm _ror(int n2) {
        return this.lg(n2);
    }

    @Override
    public /* synthetic */ IEImm _rol(int n2) {
        return this.ZQ(n2);
    }

    @Override
    public /* synthetic */ IEImm _sar(int n2) {
        return this.hG(n2);
    }

    @Override
    public /* synthetic */ IEImm _shr(int n2) {
        return this.tA(n2);
    }

    @Override
    public /* synthetic */ IEImm _shl(int n2) {
        return this.mH(n2);
    }

    @Override
    public /* synthetic */ IEImm _clearbit(int n2) {
        return this.ok(n2);
    }

    @Override
    public /* synthetic */ IEImm _setbit(int n2) {
        return this.Rs(n2);
    }

    @Override
    public /* synthetic */ IEImm _xor(IEImm iEImm) {
        return this.lg(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _or(IEImm iEImm) {
        return this.ZQ(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _and(IEImm iEImm) {
        return this.hG(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _not() {
        return this.UE();
    }

    @Override
    public /* synthetic */ IEImm _remU(IEImm iEImm) {
        return this.tA(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _rem(IEImm iEImm) {
        return this.mH(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _divU(IEImm iEImm) {
        return this.ok(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _div(IEImm iEImm) {
        return this.Rs(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _mul(IEImm iEImm) {
        return this.fz(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _sub(IEImm iEImm) {
        return this.mm(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _add(IEImm iEImm) {
        return this.ce(iEImm);
    }

    @Override
    public /* synthetic */ IEImm _neg() {
        return this.ch();
    }

    @Override
    public /* synthetic */ IEImm expand(int n2) {
        return this.fz(n2);
    }

    @Override
    public /* synthetic */ IEImm truncate(int n2) {
        return this.mm(n2);
    }

    @Override
    public /* synthetic */ IEImm duplicateToMutable() {
        return this.ZQ();
    }
}

