/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.CoordinatesConversionPrecision;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.text.IAnchor;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.impl.AbstractTextDocument;
import com.pnfsoftware.jeb.core.output.text.impl.Anchor;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.output.text.impl.Line;
import com.pnfsoftware.jeb.core.output.text.impl.TextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.impl.TextItem;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerTargetInformation;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.primitives.Characters;
import com.pnfsoftware.jeb.util.serialization.annotations.SerDisabled;
import java.util.ArrayList;

@SerDisabled
public class YH
extends AbstractTextDocument {
    private static final ILogger tA = GlobalLog.getLogger(YH.class);
    IDebuggerUnit ce;
    long mm;
    int fz;
    int Rs;
    int ok;
    int mH = 16;

    public YH(IDebuggerUnit iDebuggerUnit) throws JebException {
        ProcessorType processorType;
        this.ce = iDebuggerUnit;
        IDebuggerTargetInformation iDebuggerTargetInformation = iDebuggerUnit.getTargetInformation();
        if (iDebuggerTargetInformation != null && (processorType = iDebuggerTargetInformation.getProcessorType()) != null) {
            if (processorType == ProcessorType.ARM || processorType == ProcessorType.X86 || processorType == ProcessorType.MIPS) {
                this.fz = 4096;
                this.mm = 0x100000000L;
            } else if (processorType == ProcessorType.ARM64 || processorType == ProcessorType.X86_64 || processorType == ProcessorType.MIPS64) {
                this.fz = 4096;
                this.mm = Long.MAX_VALUE;
            }
        }
        if (this.fz == 0 || this.mm == 0L) {
            throw new JebException("Cannot render memory view for target: " + iDebuggerTargetInformation);
        }
        this.Rs = 0;
        this.ok = 16;
    }

    @Override
    public IUnit getUnit() {
        return this.ce;
    }

    @Override
    public long getAnchorCount() {
        return this.mm;
    }

    @Override
    public ITextDocumentPart getDocumentPart(long l2, int n2, int n3) {
        if (this.Rs != 0) {
            throw new RuntimeException();
        }
        ArrayList<ILine> arrayList = new ArrayList<ILine>();
        ArrayList<IAnchor> arrayList2 = new ArrayList<IAnchor>();
        int n4 = n3 * this.mH;
        long l3 = l2 - (long)n4;
        if (l3 < 0L) {
            l3 = 0L;
        }
        int n5 = n2 * this.mH;
        long l4 = l2 + (long)n5;
        byte[] byArray = new byte[this.fz];
        while (l3 < l4) {
            String string;
            int n6;
            int n7;
            StringBuilder stringBuilder;
            ArrayList<TextItem> arrayList3;
            int n8;
            int n9;
            long l5 = l3 + (long)this.fz & (long)(~(this.fz - 1));
            int n10 = (int)(l5 - l3);
            if (l5 > l4) {
                n10 = (int)(l4 - l3);
            }
            int n11 = this.ce.readMemory(l3, n10, byArray, 0);
            if (n11 <= 0) {
                n11 = n10;
                for (n8 = 0; n8 < n11; n8 += n9) {
                    n9 = this.mH;
                    arrayList3 = new ArrayList();
                    stringBuilder = new StringBuilder();
                    arrayList3.add(new TextItem(stringBuilder.length(), this.ok, ItemClassIdentifiers.ADDRESS));
                    if (this.ok == 8) {
                        Strings.ff(stringBuilder, "%08X  ", l3 + (long)n8);
                    } else if (this.ok == 16) {
                        Strings.ff(stringBuilder, "%016X  ", l3 + (long)n8);
                    } else {
                        throw new RuntimeException();
                    }
                    for (n7 = 0; n7 < n9; ++n7) {
                        stringBuilder.append("?? ");
                    }
                    n6 = n7;
                    while (n7 < 16) {
                        stringBuilder.append("   ");
                        ++n7;
                    }
                    stringBuilder.append(" ");
                    for (n7 = 0; n7 < n6; ++n7) {
                        stringBuilder.append(".");
                    }
                    string = stringBuilder.toString();
                    arrayList2.add(new Anchor(l3 + (long)n8, arrayList.size()));
                    arrayList.add(new Line(string, arrayList3));
                }
            } else {
                while (n8 < n11) {
                    n9 = this.mH;
                    arrayList3 = new ArrayList<TextItem>();
                    stringBuilder = new StringBuilder();
                    arrayList3.add(new TextItem(stringBuilder.length(), this.ok, ItemClassIdentifiers.ADDRESS));
                    if (this.ok == 8) {
                        Strings.ff(stringBuilder, "%08X  ", l3 + (long)n8);
                    } else if (this.ok == 16) {
                        Strings.ff(stringBuilder, "%016X  ", l3 + (long)n8);
                    } else {
                        throw new RuntimeException();
                    }
                    for (n7 = 0; n7 < n9; ++n7) {
                        arrayList3.add(new TextItem(stringBuilder.length(), 2, ItemClassIdentifiers.TYPE_BYTE));
                        Strings.ff(stringBuilder, "%02X ", byArray[n8 + n7]);
                    }
                    n6 = n7;
                    while (n7 < 16) {
                        stringBuilder.append("   ");
                        ++n7;
                    }
                    stringBuilder.append(" ");
                    for (n7 = 0; n7 < n6; ++n7) {
                        arrayList3.add(new TextItem(stringBuilder.length(), 1, ItemClassIdentifiers.TYPE_BYTE));
                        byte by = byArray[n8 + n7];
                        if (Characters.isAsciiChar(by)) {
                            stringBuilder.append((char)by);
                            continue;
                        }
                        stringBuilder.append(".");
                    }
                    string = stringBuilder.toString();
                    arrayList2.add(new Anchor(l3 + (long)n8, arrayList.size()));
                    arrayList.add(new Line(string, arrayList3));
                    n8 += n9;
                }
            }
            l3 += (long)n11;
        }
        return new TextDocumentPart(arrayList, arrayList2);
    }

    @Override
    public String coordinatesToAddress(ICoordinates iCoordinates, AddressConversionPrecision addressConversionPrecision) {
        if (iCoordinates == null) {
            return null;
        }
        long l2 = iCoordinates.getAnchorId();
        l2 += (long)(iCoordinates.getLineDelta() * this.mH);
        return Strings.ff("%Xh", l2 += (long)((iCoordinates.getColumnOffset() - 18) / 3));
    }

    @Override
    public ICoordinates addressToCoordinates(String string, CoordinatesConversionPrecision coordinatesConversionPrecision) {
        if (string == null) {
            return null;
        }
        long l2 = Conversion.stringToLong(string, -1L);
        if (l2 != -1L) {
            long l3 = l2 / 16L * 16L;
            int n2 = 18 + 3 * (int)(l2 % 16L);
            return new Coordinates(l3, 0, n2);
        }
        return null;
    }
}

