/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.units.codeobject.ELF;
import com.pnfsoftware.jeb.util.encoding.IntegerLEB128;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

@Ser
public class Xr {
    @SerId(value=1)
    private List<String> ce = new ArrayList<String>();
    @SerId(value=2)
    private List<String> mm = new ArrayList<String>();
    private static final String[] fz = new String[]{"Pre-v4", "v4", "v4T", "v5T", "v5TE", "v5TEJ", "v6", "v6KZ", "v6T2", "v6K", "v7", "v6-M", "v6S-M", "v7E-M", "v8", "v8-R", "v8-M.baseline", "v8-M.mainline"};
    private static final String[] Rs = new String[]{"Not permitted", "Permitted"};
    private static final String[] ok = new String[]{"Not permitted", "Thumb", "Thumb-2"};
    private static final String[] mH = new String[]{"Not Permitted", "VFPv1", "VFPv2", "VFPv3", "VFPv3-D16", "VFPv4", "VFPv4-D16", "ARMv8-a FP", "ARMv8-a FP-D16"};
    private static final String[] tA = new String[]{"Not Permitted", "WMMXv1", "WMMXv2"};
    private static final String[] hG = new String[]{"Not Permitted", "NEONv1", "NEONv2+FMA", "ARMv8-a NEON", "ARMv8.1-a NEON"};
    private static final String[] ZQ = new String[]{"None", "Bare Platform", "Linux Application", "Linux DSO", "Palm OS 2004", "Reserved (Palm OS)", "Symbian OS 2004", "Reserved (Symbian OS)"};
    private static final String[] lg = new String[]{"v6", "Static Base", "TLS", "Unused"};
    private static final String[] ch = new String[]{"Absolute", "PC-relative", "SB-relative", "Not Permitted"};
    private static final String[] UE = new String[]{"Absolute", "PC-relative", "Not Permitted"};
    private static final String[] lj = new String[]{"Not Permitted", "Direct", "GOT-Indirect"};
    private static final String[] Wz = new String[]{"Not Permitted", "Unknown", "2-byte", "Unknown", "4-byte"};
    private static final String[] LS = new String[]{"IEEE-754", "Runtime"};
    private static final String[] oW = new String[]{"Unsupported", "IEEE-754", "Sign Only"};
    private static final String[] zO = new String[]{"Not Permitted", "IEEE-754"};
    private static final String[] oT = new String[]{"Not Permitted", "IEEE-754"};
    private static final String[] Px = new String[]{"Not Permitted", "Finite Only", "RTABI", "IEEE-754"};
    private static final String[] dT = new String[]{"Not Permitted", "8-byte alignment", "4-byte alignment", "Reserved"};
    private static final String[] GR = new String[]{"Not Required", "8-byte data alignment", "8-byte data and code alignment", "Reserved"};
    private static final String[] Im = new String[]{"Not Permitted", "Packed", "Int32", "External Int32"};
    private static final String[] GH = new String[]{"Tag_FP_arch", "Single-Precision", "Reserved", "Tag_FP_arch (deprecated)"};
    private static final String[] mq = new String[]{"AAPCS", "AAPCS VFP", "Custom", "Not Permitted"};
    private static final String[] Ae = new String[]{"AAPCS", "iWMMX", "Custom"};
    private static final String[] To = new String[]{"None", "Speed", "Aggressive Speed", "Size", "Aggressive Size", "Debugging", "Best Debugging"};
    private static final String[] sb = new String[]{"None", "Speed", "Aggressive Speed", "Size", "Aggressive Size", "Accuracy", "Best Accuracy"};
    private static final String[] XB = new String[]{"Not Permitted", "v6-style"};
    private static final String[] jR = new String[]{"If Available", "Permitted"};
    private static final String[] CQ = new String[]{"Not Permitted", "IEEE-754", "VFPv3"};
    private static final String[] bB = new String[]{"Not Permitted", "Permitted"};
    private static final String[] ij = new String[]{"If Available", "Not Permitted", "Permitted"};
    private static final String[] JX = new String[]{"Not Permitted", "Permitted"};
    private static final String[] sK = new String[]{"Not Permitted", "Permitted"};
    private static final String[] ex = new String[]{"Not Permitted", "TrustZone", "Virtualization Extensions", "TrustZone + Virtualization Extensions"};

    public static Xr ce(ByteBuffer byteBuffer, boolean bl, long l2) {
        Xr xr = new Xr();
        try {
            byte by = byteBuffer.get();
            if (by != 65) {
                xr.mm.add(Strings.ff("uncommon version number (%x) => parsing stopped", by));
                return xr;
            }
            long l3 = 1L;
            while (l3 < l2) {
                int n2 = byteBuffer.getInt();
                String string = Xr.ce(byteBuffer);
                if (string.equals("aeabi")) {
                    byte by2 = byteBuffer.get();
                    if (by2 == 1) {
                        int n3 = byteBuffer.getInt() - 1 - 4;
                        if (!Xr.ce(xr, byteBuffer, n3)) {
                            xr.mm.add("public file attributes parsing failed");
                        }
                    } else if (by2 == 2) {
                        xr.mm.add("public attributes targeting a section => not parsed");
                    } else if (by2 == 3) {
                        xr.mm.add("public attributes targeting a symbol => not parsed");
                    } else {
                        xr.mm.add("public attributes with unknown granularity => not parsed");
                    }
                } else {
                    xr.mm.add(Strings.ff("private vendor attributes for %s => not parsed", string));
                }
                if ((l3 += (long)n2) <= 10000L) continue;
                return null;
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return null;
        }
        return xr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean ce(Xr xr, ByteBuffer byteBuffer, int n2) {
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            int n3 = 0;
            while (n3 < n2) {
                IntegerLEB128.DecodedInt decodedInt = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                String string = ELF.getArmAttributeTagString(decodedInt.value);
                if (string == null) {
                    xr.mm.add("unknown attribute => parsing stopped");
                    boolean bl = false;
                    return bl;
                }
                n3 += decodedInt.encodedSize;
                String string2 = null;
                int n4 = 0;
                switch (decodedInt.value) {
                    case 4: 
                    case 5: {
                        string2 = Xr.ce(byteArrayInputStream);
                        n4 = string2.length() + 1;
                        break;
                    }
                    case 6: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(fz, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 7: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        switch (decodedInt2.value) {
                            case 65: {
                                string2 = "Application";
                                break;
                            }
                            case 82: {
                                string2 = "Real-time";
                                break;
                            }
                            case 77: {
                                string2 = "Microcontroller";
                                break;
                            }
                            case 83: {
                                string2 = "Classic";
                                break;
                            }
                            case 0: {
                                string2 = "None";
                                break;
                            }
                            default: {
                                string2 = "Unknown";
                            }
                        }
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 8: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(Rs, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 9: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(ok, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 10: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(mH, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 11: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(tA, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 12: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(hG, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 13: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(ZQ, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 14: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(lg, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 15: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(ch, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 16: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(UE, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 17: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(lj, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 18: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(Wz, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 19: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(LS, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 20: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(oW, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 21: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(zO, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 22: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(oT, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 23: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(Px, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 24: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(dT, decodedInt2.value);
                        if (string2 == null) {
                            string2 = decodedInt2.value <= 12 ? Strings.ff("8-byte alignment, %d-byte extended alignment", decodedInt2.value) : "invalid";
                        }
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 25: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(GR, decodedInt2.value);
                        if (string2 == null) {
                            string2 = decodedInt2.value <= 12 ? Strings.ff("8-byte alignment, %d-byte data alignment", decodedInt2.value) : "invalid";
                        }
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 26: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(Im, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 27: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(GH, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 28: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(mq, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 29: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(Ae, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 30: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(To, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 31: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(sb, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 32: {
                        break;
                    }
                    case 34: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(XB, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 36: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(jR, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 38: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(CQ, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 42: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(bB, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 44: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(ij, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 46: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(JX, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 65: {
                        break;
                    }
                    case 67: {
                        break;
                    }
                    case 68: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(ex, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                    case 64: {
                        break;
                    }
                    case 66: {
                        IntegerLEB128.DecodedInt decodedInt2 = IntegerLEB128.decodeULEB128(byteArrayInputStream);
                        string2 = Xr.ce(sK, decodedInt2.value);
                        n4 = decodedInt2.encodedSize;
                        break;
                    }
                }
                if (n4 == 0) {
                    xr.mm.add(Strings.ff("cannot parse tag %s value => parsing stopped", string));
                    boolean bl = true;
                    return bl;
                }
                xr.ce.add(Strings.ff("%s: %s", string, string2));
                n3 += n4;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static String ce(String[] stringArray, int n2) {
        if (n2 < 0 || n2 >= stringArray.length) {
            return null;
        }
        return stringArray[n2];
    }

    private static String ce(ByteBuffer byteBuffer) {
        StringBuilder stringBuilder = new StringBuilder();
        byte by = byteBuffer.get();
        while (by != 0) {
            char c2 = (char)(by & 0xFF);
            stringBuilder.append(c2);
            by = byteBuffer.get();
        }
        return stringBuilder.toString();
    }

    private static String ce(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = inputStream.read();
        while (n2 != 0 && n2 != -1) {
            stringBuilder.append((char)n2);
            n2 = inputStream.read();
        }
        return stringBuilder.toString();
    }

    public List<String> ce() {
        return this.ce;
    }

    public List<String> mm() {
        return this.mm;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.ce != null && this.ce.size() != 0) {
            stringBuilder.append("+ Vendor 'aeabi' (public attributes):\n");
            for (String string : this.ce) {
                stringBuilder.append("    ");
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
        }
        if (this.mm != null && this.mm.size() != 0) {
            stringBuilder.append("\n  + Notes on ARM attributes parsing:\n");
            for (String string : this.mm) {
                stringBuilder.append("    ");
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
        }
        return stringBuilder.toString();
    }
}

