/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.exceptions.InterruptionException;
import com.pnfsoftware.jeb.core.units.code.DecompilationContext;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeAdvancedAnalyzer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IDecompiledMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.NativeDecompilationStage;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.exceptions.UnsupportedConversionException;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.util.concurrent.ACLock;
import com.pnfsoftware.jeb.util.format.TimeFormatter;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.pnfsoftware.jebglobal.aac;
import com.pnfsoftware.jebglobal.aal;
import com.pnfsoftware.jebglobal.abb;
import com.pnfsoftware.jebglobal.axj;
import com.pnfsoftware.jebglobal.axk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

@Ser
public class P<InsnType extends IInstruction>
implements INativeCodeAdvancedAnalyzer<InsnType> {
    private static final ILogger Rs = GlobalLog.getLogger(P.class);
    private static final boolean ok = false;
    @SerId(value=1)
    abb<InsnType> ce;
    @SerTransient
    volatile INativeDecompilerUnit<InsnType> mm;
    @SerTransient
    volatile boolean fz;

    public P(abb<InsnType> abb2) {
        this.ce = abb2;
    }

    @Override
    public void perform() {
        List<axk> list = this.ce.getInternalMethods();
        this.analyzeRoutines(list);
    }

    @Override
    public void analyzeRoutines(Collection<? extends INativeMethodItem> collection) {
        ArrayList<axj> arrayList = new ArrayList<axj>();
        for (INativeMethodItem iNativeMethodItem : collection) {
            if (iNativeMethodItem.getData() == null) continue;
            arrayList.add((axj)iNativeMethodItem.getData());
        }
        this.analyzeInternalRoutines(arrayList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void analyzeInternalRoutines(Collection<? extends INativeMethodDataItem> collection) {
        this.mm = (INativeDecompilerUnit)DecompilerHelper.getDecompiler(this.ce, true);
        if (this.mm == null) {
            return;
        }
        try (ACLock aCLock = this.ce.ce().a();){
            long l2 = System.currentTimeMillis();
            int n2 = 0;
            Iterator<INativeMethodDataItem> iterator = this.ce(collection);
            while (iterator.hasNext()) {
                if (this.fz) {
                    Rs.status("Advanced analysis paused", new Object[0]);
                    return;
                }
                axj axj2 = (axj)iterator.next();
                if (axj2.isDisposed()) {
                    ++n2;
                    continue;
                }
                if (!this.ce(axj2.fz(), n2, collection.size())) {
                    Rs.status("Advanced analysis interrupted on routine %Xh", axj2.getMemoryAddress());
                    return;
                }
                ++n2;
            }
            Rs.status("Advanced analysis completed (%s)", TimeFormatter.formatTimestampDelta(System.currentTimeMillis() - l2));
            return;
        }
        finally {
            this.fz = false;
            this.mm.runGarbageCollection();
        }
    }

    private boolean ce(axk axk2, int n2, int n3) {
        if (axk2 == null || axk2.mH() == null) {
            return false;
        }
        Integer n4 = axk2.mH().getAttribute("analysisStatus", Integer.class);
        if (n4 != null) {
            return true;
        }
        if (n2 >= 0 && n3 > 0) {
            int n5 = n2 * 100 / n3;
            Rs.status("Advanced analysis of routine %d/%d: \"%s\"... (%d%%)", n2 + 1, n3, axk2.getName(true), n5);
        }
        try {
            axk2.mH().setAttribute("analysisStatus", 0);
            this.ce(axk2);
        }
        catch (Exception exception) {
            if (axk2.mH() != null && !axk2.mH().isDisposed()) {
                axk2.mH().setAttribute("analysisStatus", -1);
            }
            Rs.debug("Advanced analysis failed on method %s", axk2);
            Throwable throwable = exception.getCause();
            if (throwable instanceof UnsupportedConversionException) {
                Rs.debug("Cannot convert instruction: %s", throwable.getMessage());
            } else {
                Rs.catchingSilent(exception);
            }
            if (exception instanceof InterruptionException) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        if (axk2.mH() != null && !axk2.mH().isDisposed()) {
            axk2.mH().setAttribute("analysisStatus", 1);
            axk2.ce((Boolean)true);
        }
        return true;
    }

    private IDecompiledMethod ce(axk axk2) {
        NativeDecompilationStage nativeDecompilationStage = this.ce.getCodeAnalyzerExtensionsManager().getPreferredAdvancedAnalysisStage(axk2).getResult();
        DecompilationContext decompilationContext = new DecompilationContext(0, 5000L, null);
        if (nativeDecompilationStage == null) {
            nativeDecompilationStage = NativeDecompilationStage.SIMULATION;
        }
        return this.mm.decompileMethodEx(axk2, decompilationContext, nativeDecompilationStage);
    }

    private Iterator<INativeMethodDataItem> ce(Collection<? extends INativeMethodDataItem> collection) {
        return new aal((aac)this.ce.getCodeModel(), collection);
    }
}

