/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.units.code.asm.ChainedOperationResult;
import com.pnfsoftware.jeb.core.units.code.asm.INativeContext;
import com.pnfsoftware.jeb.core.units.code.asm.LinuxSyscallResolver;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.AbstractNativeDecompilerExtension;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.DecompilationStatus;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IDecompiledMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.NativeDecompilationStage;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.EState;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEGeneric;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IESimulationResults;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEUntranslatedInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEVar;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.IEMasterOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeInstructionItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.util.collect.Sets;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jebglobal.OV;
import com.pnfsoftware.jebglobal.fU;
import com.pnfsoftware.jebglobal.lp;
import com.pnfsoftware.jebglobal.yK;
import com.pnfsoftware.jebglobal.zP;

public class EL
extends AbstractNativeDecompilerExtension {
    @Override
    public ChainedOperationResult<DecompilationStatus> executePostPipelineStage(NativeDecompilationStage nativeDecompilationStage, IDecompiledMethod iDecompiledMethod) {
        if (nativeDecompilationStage == NativeDecompilationStage.IR_CONVERSION) {
            IERoutineContext iERoutineContext = iDecompiledMethod.getIRContext();
            this.ce(iERoutineContext);
        }
        return super.executePostPipelineStage(nativeDecompilationStage, iDecompiledMethod);
    }

    int ce(IERoutineContext iERoutineContext) {
        IEVar iEVar = iERoutineContext.getVariableByName("TPIDR_EL0");
        if (iEVar == null || iEVar.getBitsize() != 64) {
            return 0;
        }
        int n2 = 0;
        for (BasicBlock<IEStatement> basicBlock : iERoutineContext.getCfg()) {
            for (int i = 0; i < basicBlock.size(); ++i) {
                IEStatement iEStatement = basicBlock.get(i);
                if (!iEStatement.isAssign() || iEStatement.asAssign().getRightOperand() != iEVar) continue;
                IEGeneric iEGeneric = iEStatement.asAssign().getLeftOperand();
                long l2 = iEStatement.getPrimaryLowerLevelAddress();
                IEUntranslatedInstruction iEUntranslatedInstruction = iERoutineContext.createUntranslatedInstruction(l2, "read_TPIDR_EL0", new IEGeneric[0]);
                iEUntranslatedInstruction.setReturnExpression(iEGeneric);
                iEUntranslatedInstruction.copyProperties(iEStatement);
                basicBlock.set(i, iEUntranslatedInstruction);
                ++n2;
            }
        }
        if (n2 > 0) {
            iERoutineContext.getCfg().invalidateDataFlowAnalysis();
        }
        return n2;
    }

    @Override
    public ChainedOperationResult<Boolean> customizeIntermediateOptimizer(INativeDecompilerContext iNativeDecompilerContext, IEMasterOptimizer iEMasterOptimizer) {
        if (iNativeDecompilerContext.getNativeContext().getProcessor().getType().is64Bit()) {
            iEMasterOptimizer.registerOptimizer(new lp());
        } else {
            iEMasterOptimizer.registerOptimizer(new yK());
            iEMasterOptimizer.registerOptimizer(new OV());
            iEMasterOptimizer.registerOptimizer(new fU());
        }
        iEMasterOptimizer.addDisregardedOutputBits(Sets.createNonNulls(543, 540, 542, 541, 528, 536, 512, 539, 520, 519, 518, 517));
        return ChainedOperationResult.TRUE_CONTINUE;
    }

    @Override
    public ChainedOperationResult<Boolean> augmentSimulationContext(INativeDecompilerContext iNativeDecompilerContext, IERoutineContext iERoutineContext, IESimulationResults iESimulationResults, long l2, IEStatement iEStatement, EState eState) {
        Long l3;
        ProcessorType processorType;
        Object object;
        INativeContext iNativeContext = iNativeDecompilerContext.getNativeContext();
        if (!(iEStatement instanceof IEUntranslatedInstruction) || !Strings.equalsIgnoreCase(((IEUntranslatedInstruction)iEStatement).getNativeMnemonic(), "svc")) {
            return ChainedOperationResult.FALSE_CONTINUE;
        }
        int n2 = 0;
        if (eState != null && eState.hasValue(517)) {
            n2 = iNativeDecompilerContext.getConverter().getStateProcessorMode(eState);
        } else {
            object = iEStatement.getPrimaryLowerLevelAddress();
            if (object != null && iNativeContext.getNativeItemAt((Long)object) instanceof INativeInstructionItem) {
                INativeInstructionItem iNativeInstructionItem = (INativeInstructionItem)iNativeContext.getNativeItemAt((Long)object);
                n2 = iNativeInstructionItem.getInstruction().getProcessorMode();
            }
        }
        if (n2 == 0) {
            n2 = iNativeContext.getProcessor().getMode();
        }
        if (n2 == 16 || n2 == 32) {
            processorType = ProcessorType.ARM;
            l3 = eState.getValueAsLongSafe(zP.mm(7));
        } else if (n2 == 64) {
            processorType = ProcessorType.ARM64;
            l3 = eState.getValueAsLongSafe(zP.fz(8));
        } else {
            return ChainedOperationResult.FALSE_CONTINUE;
        }
        if (l3 == null) {
            return ChainedOperationResult.FALSE_CONTINUE;
        }
        object = LinuxSyscallResolver.getInstance(processorType);
        if (object == null) {
            return ChainedOperationResult.FALSE_CONTINUE;
        }
        int n3 = l3.intValue();
        String string = ((LinuxSyscallResolver)object).getName(n3);
        if (string == null) {
            return ChainedOperationResult.FALSE_CONTINUE;
        }
        iESimulationResults.recordComment(l2, "syscall:" + string);
        IPrototypeItem iPrototypeItem = ((LinuxSyscallResolver)object).getPrototype(n3, iNativeContext.getTypeManager());
        if (iPrototypeItem == null) {
            return ChainedOperationResult.FALSE_CONTINUE;
        }
        String string2 = "sys_" + string;
        INativeMethodItem iNativeMethodItem = iNativeContext.getRoutineByName(string2);
        if (iNativeMethodItem == null) {
            iNativeContext.createMethodReference(string2, iPrototypeItem, null);
        }
        INativeMethodItem iNativeMethodItem2 = iNativeContext.getRoutineByName(string2);
        iESimulationResults.recordSupportRoutineCall(l2, iNativeMethodItem2);
        return ChainedOperationResult.TRUE_STOP;
    }
}

