/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.serialization.objects;

import com.pnfsoftware.jeb.util.serialization.SerializerHelper;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerConstructor;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomWrite;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

@Ser
public class SerEnumSet<E extends Enum<E>>
implements Set<E> {
    @SerTransient
    private EnumSet<E> set;
    @SerId(value=1)
    private Class<E> c;
    @SerId(value=2)
    private Set<E> setForStorage;

    public static <E extends Enum<E>> SerEnumSet<E> wrap(Class<E> clazz, EnumSet<E> enumSet) {
        if (clazz == null || enumSet == null) {
            throw new IllegalArgumentException();
        }
        SerEnumSet<E> serEnumSet = new SerEnumSet<E>();
        serEnumSet.c = clazz;
        serEnumSet.set = enumSet;
        return serEnumSet;
    }

    @SerConstructor
    public SerEnumSet() {
    }

    @SerCustomWrite
    private void save(SerializerHelper serializerHelper) throws IOException {
        this.setForStorage = new HashSet(this.set.size());
        for (Enum enum_ : this.set) {
            this.setForStorage.add(enum_);
        }
        serializerHelper.saveStandard();
        this.setForStorage = null;
    }

    @SerCustomInitPostGraph
    private void postInit() {
        this.set = EnumSet.allOf(this.c);
        this.set.retainAll(this.setForStorage);
        this.setForStorage = null;
    }

    public EnumSet<E> wrapped() {
        return this.set;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.set.contains(object);
    }

    @Override
    public Iterator<E> iterator() {
        return this.set.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.set.toArray(TArray);
    }

    @Override
    public boolean add(E e) {
        return this.set.add(e);
    }

    @Override
    public boolean remove(Object object) {
        return this.set.remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.set.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.set.addAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.set.retainAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.set.removeAll(collection);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return this.set.equals(object);
    }

    public String toString() {
        return this.set.toString();
    }
}

