/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.serialization.objects;

import com.pnfsoftware.jeb.util.serialization.SerializerHelper;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerConstructor;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomWrite;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Ser
public class SerEnumMap<K extends Enum<K>, V>
implements Map<K, V> {
    @SerTransient
    private EnumMap<K, V> map;
    @SerId(value=1)
    private Class<K> c;
    @SerId(value=2)
    private Map<K, V> mapForStorage;

    public static <K extends Enum<K>, V> SerEnumMap<K, V> wrap(Class<K> clazz, EnumMap<K, V> enumMap) {
        if (clazz == null || enumMap == null) {
            throw new IllegalArgumentException();
        }
        SerEnumMap<K, V> serEnumMap = new SerEnumMap<K, V>();
        serEnumMap.c = clazz;
        serEnumMap.map = enumMap;
        return serEnumMap;
    }

    @SerConstructor
    public SerEnumMap() {
    }

    @SerCustomWrite
    private void save(SerializerHelper serializerHelper) throws IOException {
        this.mapForStorage = new HashMap(this.map.size());
        for (Map.Entry<K, V> entry : this.map.entrySet()) {
            this.mapForStorage.put((Enum)entry.getKey(), entry.getValue());
        }
        serializerHelper.saveStandard();
        this.mapForStorage = null;
    }

    @SerCustomInitPostGraph
    private void postInit() {
        this.map = new EnumMap(this.c);
        for (Map.Entry<K, V> entry : this.mapForStorage.entrySet()) {
            this.put((K)((Enum)entry.getKey()), entry.getValue());
        }
        this.mapForStorage = null;
    }

    public EnumMap<K, V> wrapped() {
        return this.map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.map.get(object);
    }

    @Override
    public V put(K k, V v2) {
        return this.map.put(k, v2);
    }

    @Override
    public V remove(Object object) {
        return this.map.remove(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.map.putAll(map);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    public String toString() {
        return this.map.toString();
    }
}

