/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.serialization;

import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.IProgressCallback;
import com.pnfsoftware.jeb.util.collect.IntList;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.LEDataOutputStream;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.reflect.ReflectionHelper;
import com.pnfsoftware.jeb.util.serialization.IInternalSerializer;
import com.pnfsoftware.jeb.util.serialization.ITypeIdProvider;
import com.pnfsoftware.jeb.util.serialization.LEDataOutputStreamFake;
import com.pnfsoftware.jeb.util.serialization.NativeTypeIdProvider;
import com.pnfsoftware.jeb.util.serialization.SerializationException;
import com.pnfsoftware.jeb.util.serialization.SerializerHelper;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomWrite;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import com.pnfsoftware.jeb.util.serialization.annotations.SerVersion;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Serializer
implements IInternalSerializer {
    private static final ILogger logger = GlobalLog.getLogger(Serializer.class);
    private static final int VERSION = 5;
    private boolean simumode = false;
    private final LEDataOutputStream out0;
    private LEDataOutputStream out;
    private ITypeIdProvider nativeTypeIdProvider;
    private ITypeIdProvider customTypeIdProvider;
    private IdentityHashMap<Object, Integer> objmap = new IdentityHashMap();
    private int leafStack = 0;
    private Deque<Object> objQueue = new ArrayDeque<Object>();
    private IntList dumpOffsets;
    private int writtenObjectCount;
    private LinkedHashMap<String, Integer> stringpool;
    private Map<String, Integer> t2omap = new HashMap<String, Integer>();
    private int currentObjectId = 1;
    private int rootCount;
    private boolean cancelled;
    private long lastWrittenSize;
    private static Map<Class<?>, List<Field>> fieldCache = new HashMap();
    private static Map<Field, Integer> fieldIdCache = new HashMap<Field, Integer>();
    private Set<Field> impTransientFields = new HashSet<Field>();
    private static Map<Class<?>, Method> customWriters = new HashMap();
    private static Map<Class<?>, Integer> versionFields = new HashMap();
    private int expectedObjectCount;
    private List<IProgressCallback> progressCallbacks = new ArrayList<IProgressCallback>();
    private Map<Class<?>, Integer> customSerializationClassFlags = new HashMap();

    public Serializer(ITypeIdProvider iTypeIdProvider, OutputStream outputStream, boolean bl) {
        this.out = this.out0 = new LEDataOutputStream(new BufferedOutputStream(outputStream));
        this.dumpOffsets = new IntList(256, 0x100000);
        this.dumpOffsets.add(-1);
        this.stringpool = bl ? new LinkedHashMap() : null;
        this.nativeTypeIdProvider = NativeTypeIdProvider.getInstance();
        this.customTypeIdProvider = iTypeIdProvider;
    }

    public void setup(boolean bl) {
        if (this.cancelled) {
            throw new IllegalStateException("The object was cancelled");
        }
        if (bl) {
            if (this.currentObjectId != 1) {
                throw new IllegalStateException("Simulation mode cannot be enabled when previous (real) serializations were performed by this object");
            }
            this.simumode = true;
            this.out = new LEDataOutputStreamFake();
        } else {
            this.simumode = false;
            this.out = this.out0;
        }
        this.init();
    }

    private void init() {
        this.objmap.clear();
        this.leafStack = 0;
        this.objQueue.clear();
        this.dumpOffsets.clear();
        this.dumpOffsets.add(-1);
        this.writtenObjectCount = 0;
        this.t2omap.clear();
        this.currentObjectId = 1;
        this.rootCount = 0;
    }

    void writeHeader() throws IOException {
        int n2 = 0;
        if (this.stringpool != null) {
            n2 |= 1;
        }
        this.out.write("PNF-ORPD".getBytes("UTF-8"));
        this.out.writeByte(5);
        this.out.writeByte(n2);
        this.out.writeByte(0);
        this.out.writeByte(0);
        this.out.writeInt(0);
    }

    @Override
    public OutputStream getStream() {
        return new OutputStream(){

            @Override
            public void write(int n2) throws IOException {
                Serializer.this.out.write(n2);
            }

            @Override
            public void write(byte[] byArray) throws IOException {
                Serializer.this.out.write(byArray);
            }

            @Override
            public void write(byte[] byArray, int n2, int n3) throws IOException {
                Serializer.this.out.write(byArray, n2, n3);
            }
        };
    }

    public int getRootCount() {
        return this.rootCount;
    }

    public int getObjectCount() {
        return this.objmap.size();
    }

    public int getWrittenObjectCount() {
        return this.writtenObjectCount;
    }

    public long getLastWrittenSize() {
        return this.lastWrittenSize;
    }

    public List<String> getStringPool() {
        if (this.stringpool == null) {
            throw new IllegalStateException("This serializer was not configured to generate a string pool");
        }
        return new ArrayList<String>(this.stringpool.keySet());
    }

    public void serialize(Object object) throws IOException {
        if (this.rootCount == 0) {
            this.writeHeader();
        }
        this.out.flush();
        long l2 = this.out.size();
        Assert.a(this.leafStack == 0);
        Assert.a(this.objQueue.isEmpty());
        this.objQueue.push(object);
        int n2 = 0;
        while (!this.objQueue.isEmpty()) {
            Object object2 = this.objQueue.pop();
            this.write(object2);
            ++n2;
        }
        if (!this.simumode) {
            this.rootCount += n2;
        }
        if (this.cancelled) {
            throw new SerializationException(Strings.ff("The serialization of object \"%s\" was cancelled", object));
        }
        Assert.a(this.leafStack == 0);
        Assert.a(this.objQueue.isEmpty());
        this.out.flush();
        this.lastWrittenSize = (long)this.out.size() - l2;
        this.notifyProgressCallbacks();
    }

    public void close() throws IOException {
        Assert.a(this.getObjectCount() == this.currentObjectId - 1);
        this.out.flush();
        this.out.close();
        this.out = null;
    }

    @Override
    public void write(Object object) throws IOException {
        this.write(object, null);
    }

    private void write(Object object, Class<?> clazz) throws IOException {
        boolean bl;
        if (this.cancelled) {
            return;
        }
        if (Thread.interrupted()) {
            this.cancelled = true;
            return;
        }
        boolean bl2 = bl = clazz == null;
        if (object == null) {
            if (!bl) {
                throw new SerializationException("A null object must be a leaf object", clazz);
            }
            this.out.writeIntULEB128(1);
            return;
        }
        if (bl) {
            ++this.leafStack;
        }
        try {
            this.writeI(object, clazz);
        }
        finally {
            if (bl) {
                --this.leafStack;
            }
        }
    }

    private void writeI(Object object, Class<?> clazz) throws IOException {
    }

    @Override
    public void writeFields(Object object, Class<?> clazz) throws IOException {
        List<Field> list = fieldCache.get(clazz);
        if (list == null) {
            list = new ArrayList<Field>();
            fieldCache.put(clazz, list);
            HashSet hashSet = new HashSet();
            for (Field field : clazz.getDeclaredFields()) {
                int n2 = field.getModifiers();
                if ((n2 & 8) != 0) continue;
                SerId serId = field.getAnnotation(SerId.class);
                if (serId == null) {
                    if (field.getAnnotation(SerTransient.class) != null || this.impTransientFields.contains(field)) continue;
                    this.impTransientFields.add(field);
                    String string = Strings.ff("Field %s is implicitly transient", field);
                    logger.debug(string, new Object[0]);
                    continue;
                }
                int n3 = serId.value();
                if (n3 == 0) {
                    String string = Strings.ff("Invalid field serialization id (0) for field: %s", field);
                    logger.warn(string, new Object[0]);
                    continue;
                }
                if (serId.deprecated()) continue;
                list.add(field);
                fieldIdCache.put(field, n3);
                if (hashSet.add(n3)) continue;
                throw new SerializationException("Duplicate field id: " + n3, clazz);
            }
        }
        for (Field field : list) {
            int n4 = fieldIdCache.get(field);
            this.writeField(object, field, n4);
        }
        this.out.writeIntULEB128(0);
    }

    private void writeField(Object object, Field field, int n2) throws IOException {
        Object object2;
        boolean bl = field.canAccess(object);
        if (!bl) {
            field.setAccessible(true);
        }
        try {
            object2 = field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SerializationException(illegalAccessException);
        }
        this.out.writeIntULEB128(n2);
        this.write(object2);
        if (!bl) {
            field.setAccessible(false);
        }
    }

    private boolean attemptCustomWrite(Object object, Class<?> clazz) throws SerializationException {
        Class<?> clazz2 = clazz == null ? object.getClass() : clazz;
        try {
            Method method;
            if (customWriters.containsKey(clazz2)) {
                method = customWriters.get(clazz2);
            } else {
                method = null;
                for (Method method2 : clazz2.getDeclaredMethods()) {
                    SerCustomWrite serCustomWrite = method2.getAnnotation(SerCustomWrite.class);
                    if (serCustomWrite == null) continue;
                    if (!this.isValidSerializerHelper(method2)) {
                        throw new SerializationException("Invalid prototype for serialization helper method: " + method2, clazz2);
                    }
                    method = method2;
                    break;
                }
                customWriters.put(clazz2, method);
            }
            if (method == null) {
                return false;
            }
            Integer n2 = this.customSerializationClassFlags.get(clazz2);
            ReflectionHelper.invoke2(method, object, new SerializerHelper(this, object, clazz2, n2 == null ? 0 : n2));
            return true;
        }
        catch (Exception exception) {
            throw new SerializationException("Custom write failed", exception, clazz2);
        }
    }

    private boolean isValidSerializerHelper(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1 || classArray[0] != SerializerHelper.class) {
            return false;
        }
        Class<?> clazz = method.getReturnType();
        if (clazz != Void.TYPE) {
            return false;
        }
        return (method.getModifiers() & 2) != 0;
    }

    private int getVersionField(Object object, Class<?> clazz) throws SerializationException {
        try {
            Class<?> clazz2 = clazz == null ? object.getClass() : clazz;
            Integer n2 = versionFields.get(clazz2);
            if (n2 == null) {
                SerVersion serVersion = clazz2.getAnnotation(SerVersion.class);
                n2 = serVersion != null ? Integer.valueOf(serVersion.value()) : Integer.valueOf(0);
                versionFields.put(clazz2, n2);
            }
            return n2;
        }
        catch (SecurityException securityException) {
            throw new SerializationException(securityException);
        }
    }

    private void writeNativeObject(Object object, Class<?> clazz) throws IOException {
        if (clazz != Object.class) {
            if (clazz == Class.class) {
                String string = null;
                int n2 = this.nativeTypeIdProvider.getId((Class)object);
                if (n2 == 0 && (n2 = this.customTypeIdProvider.getId((Class)object)) == 0) {
                    string = ((Class)object).getName();
                }
                this.out.writeInt(n2);
                if (string != null) {
                    this.out.writeUTF(string);
                }
            } else if (clazz == Boolean.class) {
                this.out.writeByte((Boolean)object != false ? 1 : 0);
            } else if (clazz == boolean[].class) {
                boolean[] blArray = (boolean[])object;
                this.out.writeIntULEB128(blArray.length);
                for (boolean bl : blArray) {
                    this.out.writeByte(bl ? 1 : 0);
                }
            } else if (clazz == Byte.class) {
                this.out.writeByte(((Byte)object).byteValue());
            } else if (clazz == byte[].class) {
                byte[] byArray = (byte[])object;
                this.out.writeIntULEB128(byArray.length);
                this.out.write(byArray);
            } else if (clazz == Short.class) {
                this.out.writeShort(((Short)object).shortValue());
            } else if (clazz == short[].class) {
                short[] sArray = (short[])object;
                this.out.writeIntULEB128(sArray.length);
                for (short s2 : sArray) {
                    this.out.writeShort(s2);
                }
            } else if (clazz == Character.class) {
                this.out.writeChar(((Character)object).charValue());
            } else if (clazz == char[].class) {
                char[] cArray = (char[])object;
                this.out.writeIntULEB128(cArray.length);
                for (char c2 : cArray) {
                    this.out.writeChar(c2);
                }
            } else if (clazz == Integer.class) {
                this.out.writeIntULEB128((Integer)object);
            } else if (clazz == int[].class) {
                int[] nArray = (int[])object;
                this.out.writeIntULEB128(nArray.length);
                for (int n3 : nArray) {
                    this.out.writeIntULEB128(n3);
                }
            } else if (clazz == Long.class) {
                this.out.writeLongULEB128((Long)object);
            } else if (clazz == long[].class) {
                long[] lArray = (long[])object;
                this.out.writeIntULEB128(lArray.length);
                for (long l2 : lArray) {
                    this.out.writeLongULEB128(l2);
                }
            } else if (clazz == Float.class) {
                this.out.writeFloat(((Float)object).floatValue());
            } else if (clazz == float[].class) {
                float[] fArray = (float[])object;
                this.out.writeIntULEB128(fArray.length);
                for (float f : fArray) {
                    this.out.writeFloat(f);
                }
            } else if (clazz == Double.class) {
                this.out.writeDouble((Double)object);
            } else if (clazz == double[].class) {
                double[] dArray = (double[])object;
                this.out.writeIntULEB128(dArray.length);
                for (double d : dArray) {
                    this.out.writeDouble(d);
                }
            } else if (clazz == String.class || clazz == StringBuilder.class) {
                String string = clazz == StringBuilder.class ? object.toString() : (String)object;
                if (this.stringpool != null) {
                    Integer n4 = this.stringpool.get(string);
                    if (n4 == null) {
                        n4 = this.stringpool.size();
                        this.stringpool.put(string, n4);
                    }
                    this.out.writeIntULEB128(n4);
                } else {
                    byte[] byArray = Strings.encodeUTF8(string);
                    int n5 = byArray.length;
                    this.out.writeIntULEB128(n5);
                    this.out.write(byArray);
                }
            } else if (clazz == BigInteger.class) {
                BigInteger bigInteger = (BigInteger)object;
                byte[] byArray = bigInteger.toByteArray();
                this.out.writeIntULEB128(byArray.length);
                this.out.write(byArray);
            } else if (clazz == BigDecimal.class) {
                BigDecimal bigDecimal = (BigDecimal)object;
                byte[] byArray = Strings.encodeUTF8(bigDecimal.toString());
                this.out.writeIntULEB128(byArray.length);
                this.out.write(byArray);
            } else if (clazz == AtomicBoolean.class) {
                this.out.writeByte(((AtomicBoolean)object).get() ? 1 : 0);
            } else if (clazz == AtomicInteger.class) {
                this.out.writeIntULEB128(((AtomicInteger)object).get());
            } else if (clazz == AtomicLong.class) {
                this.out.writeLongULEB128(((AtomicLong)object).get());
            } else if (clazz == SoftReference.class) {
                this.write(((SoftReference)object).get());
            } else if (clazz == WeakReference.class) {
                this.write(((WeakReference)object).get());
            } else if (Collection.class.isAssignableFrom(clazz)) {
                if (clazz == ArrayList.class || clazz == LinkedList.class || clazz == ArrayDeque.class || clazz == HashSet.class || clazz == TreeSet.class || clazz == LinkedHashSet.class || clazz == CopyOnWriteArrayList.class || clazz == CopyOnWriteArraySet.class || clazz == ConcurrentSkipListSet.class || clazz == ConcurrentLinkedQueue.class) {
                    Collection collection = (Collection)object;
                    int n6 = collection.size();
                    this.out.writeIntULEB128(n6);
                    for (Object e : collection) {
                        this.write(e);
                    }
                } else if (clazz == AbstractList.class) {
                    // empty if block
                }
            } else if (Map.class.isAssignableFrom(clazz) && (clazz == HashMap.class || clazz == TreeMap.class || clazz == LinkedHashMap.class || clazz == IdentityHashMap.class || clazz == ConcurrentHashMap.class || clazz == ConcurrentSkipListMap.class)) {
                Map map = (Map)object;
                this.out.writeIntULEB128(map.size());
                for (Object k : map.keySet()) {
                    Object v2 = map.get(k);
                    this.write(k);
                    this.write(v2);
                }
            } else {
                throw new SerializationException("Native object cannot be serialized", clazz);
            }
        }
    }

    static boolean isBoxedPrimitiveType(Class<?> clazz) {
        return clazz == Boolean.class || clazz == Byte.class || clazz == Short.class || clazz == Character.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class;
    }

    public void setExpectedObjectCount(int n2) {
        this.expectedObjectCount = n2;
    }

    public void addProgressCallback(IProgressCallback iProgressCallback) {
        this.progressCallbacks.add(iProgressCallback);
    }

    public void removeProgressCallback(IProgressCallback iProgressCallback) {
        this.progressCallbacks.remove(iProgressCallback);
    }

    private void notifyProgressCallbacks() {
        for (IProgressCallback iProgressCallback : this.progressCallbacks) {
            if (this.expectedObjectCount != 0 && !iProgressCallback.isInitialized()) {
                iProgressCallback.setTotal(this.expectedObjectCount);
            }
            iProgressCallback.setCurrent(this.getWrittenObjectCount());
        }
    }

    public void setCustomSerializationClassFlags(Class<?> clazz, int n2) {
        this.customSerializationClassFlags.put(clazz, n2);
    }
}

