/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.serialization;

import com.pnfsoftware.jeb.util.serialization.Deserializer;
import com.pnfsoftware.jeb.util.serialization.ITypeIdProvider;
import com.pnfsoftware.jeb.util.serialization.Serializer;
import com.pnfsoftware.jeb.util.serialization.Serializer_v4;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class SerializationManager {
    public static final String MAGIC = "PNF-ORPD";
    public static final int FLAG_HAS_STRINGPOOL = 1;
    private ITypeIdProvider typeIdProvider;
    private List<ClassLoader> classloaders = new ArrayList<ClassLoader>();

    public SerializationManager(ITypeIdProvider iTypeIdProvider) {
        this.typeIdProvider = iTypeIdProvider;
    }

    public void addClassloader(ClassLoader classLoader) {
        if (classLoader == null || this.classloaders.contains(classLoader)) {
            return;
        }
        this.classloaders.add(classLoader);
    }

    public ITypeIdProvider getTypeIdProvider() {
        return this.typeIdProvider;
    }

    public Serializer getSerializer(OutputStream outputStream) {
        return this.getSerializer(outputStream, false);
    }

    public Serializer getSerializer(OutputStream outputStream, boolean bl) {
        return new Serializer(this.typeIdProvider, outputStream, bl);
    }

    public Serializer_v4 getSerializer_v4(OutputStream outputStream) {
        return new Serializer_v4(this.typeIdProvider, outputStream, false);
    }

    public Deserializer getDeserializer(InputStream inputStream) {
        return new Deserializer(this.typeIdProvider, this.classloaders, inputStream);
    }
}

