/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.serialization;

import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.IProgressCallback;
import com.pnfsoftware.jeb.util.collect.MultiMap;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.LEDataInputStream;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.reflect.ReflectionHelper;
import com.pnfsoftware.jeb.util.serialization.DeserializerHelper;
import com.pnfsoftware.jeb.util.serialization.IDeserializationEventHandler;
import com.pnfsoftware.jeb.util.serialization.IInternalDeserializer;
import com.pnfsoftware.jeb.util.serialization.IPreObject;
import com.pnfsoftware.jeb.util.serialization.ITypeIdProvider;
import com.pnfsoftware.jeb.util.serialization.NativeTypeIdProvider;
import com.pnfsoftware.jeb.util.serialization.PreArray;
import com.pnfsoftware.jeb.util.serialization.PreCollection;
import com.pnfsoftware.jeb.util.serialization.PreMap;
import com.pnfsoftware.jeb.util.serialization.SerializationCancelledException;
import com.pnfsoftware.jeb.util.serialization.SerializationException;
import com.pnfsoftware.jeb.util.serialization.annotations.SerConstructor;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInit;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomInitPostGraph;
import com.pnfsoftware.jeb.util.serialization.annotations.SerCustomRead;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.objenesis.ObjenesisStd;

class Deserializer_v5
implements IInternalDeserializer {
    private static final ILogger logger = GlobalLog.getLogger(Deserializer_v5.class);
    protected LEDataInputStream in;
    protected ITypeIdProvider nativeTypeIdProvider;
    protected ITypeIdProvider customTypeIdProvider;
    protected List<ClassLoader> classloaders;
    protected ObjenesisStd objenesis;
    protected Map<Class<?>, Object> constructorMap = new HashMap();
    protected Object mootObject = new Object();
    protected ArrayList<Object> objlist = new ArrayList();
    protected int objcnt = 0;
    protected List<IPreObject> deferredObjects = new ArrayList<IPreObject>();
    private Map<Integer, Object> objmap = new ObjlistAsMap();
    private static Map<Class<?>, Map<Integer, Field>> fieldCache = new HashMap();
    List<DeferredFieldValue> deferredFieldValues = new ArrayList<DeferredFieldValue>();
    protected static Map<Class<?>, CustomMethods> customMethods = new HashMap();
    protected int expectedObjectCount;
    protected List<IProgressCallback> progressCallbacks = new ArrayList<IProgressCallback>();
    protected MultiMap<Class<?>, IDeserializationEventHandler> objectCreatedHookMap = new MultiMap();
    private List<String> stringpool;
    private Set<Integer> requestedObjectIds = new LinkedHashSet<Integer>();

    protected Deserializer_v5(ITypeIdProvider iTypeIdProvider, List<ClassLoader> list, LEDataInputStream lEDataInputStream) {
        this.in = lEDataInputStream;
        this.nativeTypeIdProvider = NativeTypeIdProvider.getInstance();
        this.customTypeIdProvider = iTypeIdProvider;
        this.classloaders = list;
        this.objenesis = new ObjenesisStd();
        this.objlist.add(null);
    }

    @Override
    public int getObjectCount() {
        return this.objcnt;
    }

    @Override
    public Collection<Object> getObjects() {
        if (this.objlist.isEmpty()) {
            return this.objlist;
        }
        return this.objlist.subList(1, this.objlist.size());
    }

    private Object objPut(int n2, Object object) {
        Assert.a(n2 >= 1);
        if (n2 >= this.objlist.size()) {
            this.objlist.ensureCapacity(n2 + 1);
            for (int i = this.objlist.size(); i < n2; ++i) {
                this.objlist.add(null);
            }
            this.objlist.add(object);
            ++this.objcnt;
            return null;
        }
        Object object2 = this.objlist.set(n2, object);
        if (object2 == null) {
            ++this.objcnt;
        }
        return object2;
    }

    private Object objGet(int n2) {
        Assert.a(n2 >= 1);
        if (n2 >= this.objlist.size()) {
            return null;
        }
        return this.objlist.get(n2);
    }

    @Override
    public InputStream getStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return Deserializer_v5.this.in.readByte();
            }

            @Override
            public int read(byte[] byArray) throws IOException {
                return Deserializer_v5.this.in.read(byArray);
            }

            @Override
            public int read(byte[] byArray, int n2, int n3) throws IOException {
                return Deserializer_v5.this.in.read(byArray, n2, n3);
            }
        };
    }

    @Override
    public Object deserializeInternal() throws IOException {
        Assert.a(this.requestedObjectIds.isEmpty());
        Object object = this.read();
        while (!this.requestedObjectIds.isEmpty()) {
            this.read();
        }
        for (DeferredFieldValue deferredFieldValue : this.deferredFieldValues) {
            Object object2;
            this.verifyNonInterrupted();
            Object object3 = this.objGet(deferredFieldValue.fieldObjectId);
            if (object3 == null) {
                throw new RuntimeException(Strings.ff("Unexpected null object (id=%d): %s", deferredFieldValue.fieldObjectId, deferredFieldValue.f));
            }
            if (object3 instanceof TemporaryReference && (object2 = ((TemporaryReference)object3).build(this.objmap)) != object3) {
                this.objPut(deferredFieldValue.fieldObjectId, object2);
                object3 = object2;
            }
            deferredFieldValue.f.setAccessible(true);
            try {
                deferredFieldValue.f.set(deferredFieldValue.o, object3);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SerializationException(illegalAccessException);
            }
        }
        this.resolveDeferredObjects();
        HashSet hashSet = new HashSet();
        int n2 = 1;
        for (Object object2 : this.getObjects()) {
            this.verifyNonInterrupted();
            if (object2 != null && hashSet.add(n2)) {
                Class<?> clazz = object2.getClass();
                do {
                    CustomMethods customMethods = this.getCustomMethods(object2, clazz);
                    if (customMethods.mCustomInitPostGraph == null) continue;
                    try {
                        ReflectionHelper.invoke2(customMethods.mCustomInitPostGraph, object2, new Object[0]);
                    }
                    catch (Exception exception) {
                        throw new SerializationException("Post-graph initializer failed", exception, null);
                    }
                } while ((clazz = clazz.getSuperclass()) != null);
            }
            ++n2;
        }
        this.notifyProgressCallbacks();
        return object;
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
    }

    @Override
    public Object read() throws IOException {
        return this.read(null, null, null);
    }

    private void verifyNonInterrupted() throws SerializationCancelledException {
        if (Thread.interrupted()) {
            throw new SerializationCancelledException("The deserialization process was cancelled");
        }
    }

    public Object read(Object object, Class<?> clazz, int[] nArray) throws IOException {
        this.verifyNonInterrupted();
        return this.readInternal(object, clazz, nArray);
    }

    protected void registerObject(boolean bl, int n2, Object object) {
        int n3;
        Object object2;
        if (bl && (object2 = this.objPut(n2, object)) != object && (n3 = this.objcnt) % 200000 == 0) {
            logger.debug("Deserializing... status: %d unique objects", n3);
            this.notifyProgressCallbacks();
        }
    }

    protected Class<?> loadClass(String string) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.classloaders) {
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return ClassLoader.getSystemClassLoader().loadClass(string);
    }

    protected void restoreFieldValue(Object object, Class<?> clazz, int n2, Object object2, int n3) throws SerializationException {
        Field[] fieldArray;
        Class<?> clazz2 = clazz == null ? object.getClass() : clazz;
        Map<Integer, Field> map = fieldCache.get(clazz2);
        if (map == null) {
            map = new HashMap<Integer, Field>();
            fieldCache.put(clazz2, map);
            fieldArray = clazz2.getDeclaredFields();
            int n4 = fieldArray.length;
            for (int i = 0; i < n4; ++i) {
                Field field = fieldArray[i];
                SerId serId = field.getAnnotation(SerId.class);
                if (serId == null) continue;
                map.put(serId.value(), field);
            }
        }
        if ((fieldArray = map.get(n2)) != null) {
            if (object2 == null && n3 > 0) {
                this.deferredFieldValues.add(new DeferredFieldValue((Field)fieldArray, object, n3));
            } else if (object2 instanceof TemporaryReference) {
                this.deferredFieldValues.add(new DeferredFieldValue((Field)fieldArray, object, n3));
            }
            fieldArray.setAccessible(true);
            try {
                fieldArray.set(object, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SerializationException(illegalAccessException, clazz2);
            }
        }
    }

    protected CustomMethods getCustomMethods(Object object, Class<?> clazz) throws SerializationException {
        Class<?> clazz2 = clazz == null ? object.getClass() : clazz;
        CustomMethods customMethods = Deserializer_v5.customMethods.get(clazz2);
        if (customMethods == null) {
            customMethods = new CustomMethods();
            int n2 = 0;
            for (Method method : clazz2.getDeclaredMethods()) {
                for (Annotation annotation : method.getAnnotations()) {
                    Class<? extends Annotation> clazz3 = annotation.annotationType();
                    if ((n2 & 1) == 0 && clazz3 == SerCustomRead.class) {
                        if (!this.isValidMethodCustomRead(method)) {
                            throw new SerializationException("Invalid prototype for custom reader method: " + method);
                        }
                        customMethods.mCustomRead = method;
                        n2 |= 1;
                        break;
                    }
                    if ((n2 & 2) == 0 && clazz3 == SerCustomInit.class) {
                        if (!this.isValidMethodCustomInit(method)) {
                            throw new SerializationException("Invalid prototype for custom initializer method: " + method);
                        }
                        customMethods.mCustomInit = method;
                        n2 |= 2;
                        break;
                    }
                    if ((n2 & 4) != 0 || clazz3 != SerCustomInitPostGraph.class) continue;
                    if (!this.isValidMethodCustomInit(method)) {
                        throw new SerializationException("Invalid prototype for custom post-graph initializer method: " + method);
                    }
                    customMethods.mCustomInitPostGraph = method;
                    n2 |= 4;
                    break;
                }
                if (n2 == 7) break;
            }
            Deserializer_v5.customMethods.put(clazz2, customMethods);
        }
        return customMethods;
    }

    private boolean isValidMethodCustomRead(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1 || classArray[0] != DeserializerHelper.class) {
            return false;
        }
        Class<?> clazz = method.getReturnType();
        if (clazz != Void.TYPE) {
            return false;
        }
        return (method.getModifiers() & 2) != 0;
    }

    private boolean isValidMethodCustomInit(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 0) {
            return false;
        }
        Class<?> clazz = method.getReturnType();
        if (clazz != Void.TYPE) {
            return false;
        }
        return (method.getModifiers() & 2) != 0;
    }

    protected void resolveDeferredObjects() {
        for (IPreObject iPreObject : this.deferredObjects) {
            iPreObject.build(this.objmap);
        }
        this.deferredObjects.clear();
    }

    @Override
    public void setExpectedObjectCount(int n2) {
        this.expectedObjectCount = n2;
    }

    @Override
    public void addProgressCallback(IProgressCallback iProgressCallback) {
        this.progressCallbacks.add(iProgressCallback);
    }

    @Override
    public void removeProgressCallback(IProgressCallback iProgressCallback) {
        this.progressCallbacks.remove(iProgressCallback);
    }

    protected void notifyProgressCallbacks() {
        for (IProgressCallback iProgressCallback : this.progressCallbacks) {
            if (!iProgressCallback.isInitialized()) {
                iProgressCallback.setTotal(this.expectedObjectCount);
            }
            iProgressCallback.setCurrent(this.getObjectCount());
        }
    }

    @Override
    public void addObjectCreatedHook(Class<?> clazz, IDeserializationEventHandler iDeserializationEventHandler) {
        if (clazz.isInterface() || clazz.isArray() || clazz.isPrimitive()) {
            throw new IllegalArgumentException(Strings.ff("Illegal object type to be monitored: %s (must be a pure object: no interface, no array, no primitive)", clazz.getSimpleName()));
        }
        this.objectCreatedHookMap.put(clazz, iDeserializationEventHandler);
    }

    @Override
    public void removeObjectCreatedHook(Class<?> clazz, IDeserializationEventHandler iDeserializationEventHandler) {
        this.objectCreatedHookMap.removeValue(clazz, iDeserializationEventHandler);
    }

    protected void notifyDeserializationEvent(int n2, Class<?> clazz, Object object) {
        if (n2 == 1) {
            for (IDeserializationEventHandler iDeserializationEventHandler : this.objectCreatedHookMap.getSafe(clazz)) {
                iDeserializationEventHandler.notifyObjectCreated(clazz, object);
            }
        }
    }

    public void setStringPool(List<String> list) {
        this.stringpool = list;
    }

    public List<String> getStringPool() {
        return this.stringpool;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object readInternal(Object object, Class<?> clazz, int[] nArray) throws IOException {
        int n2;
        int n3;
        boolean bl;
        boolean bl2 = bl = clazz == null;
        if (bl && object != null) {
            throw new SerializationException("Object should not be provided, a leaf is being deserialized", clazz);
        }
        Object object2 = object;
        int n4 = this.in.readIntULEB128();
        int n5 = 0;
        String string = null;
        int n6 = 0;
        if (bl) {
            Class<?> clazz2;
            int n7;
            if (n4 == 1) {
                return null;
            }
            if ((n4 & 0x40) != 0) {
                int n8 = n4 & 0x3F;
                switch (n8) {
                    case 0: {
                        return Boolean.FALSE;
                    }
                    case 1: {
                        return Boolean.TRUE;
                    }
                    case 2: {
                        return this.in.readIntULEB128();
                    }
                    case 3: {
                        return this.in.readLongULEB128();
                    }
                    case 4: {
                        return "";
                    }
                    case 5: {
                        return 0;
                    }
                    case 6: {
                        return 1;
                    }
                    case 7: {
                        return -1;
                    }
                    case 8: {
                        return 0L;
                    }
                    case 9: {
                        return 1L;
                    }
                    case 10: {
                        return -1L;
                    }
                    case 12: {
                        return (byte)0;
                    }
                    case 13: {
                        return (byte)1;
                    }
                    case 14: {
                        return (byte)-1;
                    }
                    case 11: {
                        return this.in.readByte();
                    }
                    case 16: {
                        return (short)0;
                    }
                    case 17: {
                        return (short)1;
                    }
                    case 18: {
                        return (short)-1;
                    }
                    case 15: {
                        return this.in.readShort();
                    }
                    case 20: {
                        return Character.valueOf('\u0000');
                    }
                    case 19: {
                        return Character.valueOf(this.in.readChar());
                    }
                    case 21: {
                        return Float.valueOf(this.in.readFloat());
                    }
                    case 22: {
                        return this.in.readDouble();
                    }
                }
                throw new SerializationException("Unknown special object index: " + n8);
            }
            if ((n4 & 0x10) != 0) {
                n6 = this.in.readByte() & 0xFF;
            }
            n5 = this.in.readIntULEB128();
            if ((n4 & 4) != 0) {
                Object object3 = this.objGet(n5);
                if (object3 != null) return object3;
                throw new SerializationException(Strings.ff("Expected an already-deserialized object for id: %d", n5), clazz);
            }
            if ((n4 & 8) != 0) {
                Object object4 = this.objGet(n5);
                if (object4 != null) return object4;
                this.requestedObjectIds.add(n5);
                if (nArray == null) return object4;
                nArray[0] = n5;
                return object4;
            }
            this.requestedObjectIds.remove(n5);
            n3 = this.in.readIntULEB128() - 128;
            if ((n4 & 0x100) != 0) {
                n7 = this.in.readIntULEB128();
                byte[] byArray = new byte[n7];
                this.in.readFully(byArray);
                string = Strings.decodeUTF8(byArray);
            } else if ((n4 & 0x200) != 0) {
                n7 = this.in.readIntULEB128();
                Class<?> clazz3 = this.objGet(n7).getClass();
                string = ReflectionHelper.reduceDimensions(clazz3).getName();
            }
            try {
                clazz2 = n3 > 0 ? this.customTypeIdProvider.getType(n3) : (n3 < 0 ? this.nativeTypeIdProvider.getType(n3) : this.loadClass(string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SerializationException(Strings.ff("Class not found for type id: %d", n3), classNotFoundException, clazz);
            }
            if (clazz != null && clazz != clazz2) {
                throw new SerializationException(Strings.ff("Unexpected class was found for type id %d: %s", n3, clazz2), clazz);
            }
            clazz = clazz2;
            if (clazz2 == null) {
                throw new SerializationException(Strings.ff("Type was expected for id %d, got null", n3), clazz);
            }
        } else {
            n3 = this.nativeTypeIdProvider.getId(clazz);
            if (n3 == 0) {
                n3 = this.customTypeIdProvider.getId(clazz);
            }
        }
        if ((n4 & 2) != 0) {
            int n9 = this.in.readIntULEB128();
            object2 = clazz.getEnumConstants()[n9];
            this.registerObject(true, n5, object2);
            return object2;
        }
        if ((n4 & 0x80) != 0) {
            int n10 = this.in.readIntULEB128();
            try {
                object2 = clazz.getDeclaredMethod("valueOf", Integer.TYPE).invoke(null, n10);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new SerializationException(reflectiveOperationException);
            }
            this.registerObject(true, n5, object2);
            return object2;
        }
        int n11 = n2 = (n4 & 0x20) != 0 ? this.in.readIntULEB128() : 0;
        if (n3 >= 0 && n6 == 0) {
            Class<?> clazz4;
            if (bl) {
                Object object5 = this.constructorMap.get(clazz);
                if (object5 == null) {
                    void var12_27;
                    Object object6 = this.mootObject;
                    try {
                        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                        if (constructor.getAnnotation(SerConstructor.class) != null) {
                            Constructor<?> constructor2 = constructor;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (Exception exception) {
                        throw new SerializationException(exception, clazz);
                    }
                    this.constructorMap.put(clazz, var12_27);
                }
                try {
                    void var12_28;
                    object2 = var12_28 instanceof Constructor ? ReflectionHelper.newInstance2((Constructor)var12_28) : this.objenesis.getInstantiatorOf(clazz).newInstance();
                }
                catch (Exception exception) {
                    throw new SerializationException(exception, clazz);
                }
                this.registerObject(bl, n5, object2);
            }
            if ((clazz4 = clazz.getSuperclass()) != null) {
                this.read(object2, clazz4, null);
            }
            CustomMethods customMethods = this.getCustomMethods(object2, clazz);
            if (customMethods.mCustomRead != null) {
                try {
                    ReflectionHelper.invoke2(customMethods.mCustomRead, object2, new DeserializerHelper(this, object2, clazz, n2));
                }
                catch (Exception exception) {
                    throw new SerializationException("Custom read failed", exception, clazz);
                }
            } else {
                this.restoreFields(object2, clazz);
            }
            if (customMethods.mCustomInit != null) {
                try {
                    ReflectionHelper.invoke2(customMethods.mCustomInit, object2, new Object[0]);
                }
                catch (Exception exception) {
                    throw new SerializationException("Initializer failed", exception, clazz);
                }
            }
            this.notifyDeserializationEvent(1, clazz, object2);
        } else if (n6 > 0) {
            int n12;
            int[] nArray2 = new int[n6];
            nArray2[0] = n12 = this.in.readIntULEB128();
            Object object7 = Array.newInstance(clazz, nArray2);
            this.registerObject(bl, n5, object7);
            PreArray preArray = new PreArray(object7, n12);
            int[] nArray3 = new int[1];
            for (int i = 0; i < n12; ++i) {
                Object object8 = this.read(null, null, nArray3);
                if (nArray3[0] == 0) {
                    preArray.record(object8);
                    continue;
                }
                preArray.recordId(nArray3[0]);
                nArray3[0] = 0;
            }
            this.deferredObjects.add(preArray);
            object2 = object7;
        } else if (clazz == Object.class) {
            if (object == null) {
                object = new Object();
            }
            object2 = object;
        } else if (clazz == Class.class) {
            void var12_34;
            Object var12_32 = null;
            int n13 = this.in.readInt();
            if (n13 == 0) {
                String string2 = this.in.readUTF();
            }
            object2 = this.retrieveClassFromIdOrName(n13, (String)var12_34);
        } else if (clazz == Boolean.class) {
            object2 = this.in.readByte() == 0 ? Boolean.FALSE : Boolean.TRUE;
        } else if (clazz == boolean[].class) {
            void var14_85;
            int n14 = this.in.readIntULEB128();
            boolean[] blArray = new boolean[n14];
            boolean bl3 = false;
            while (var14_85 < n14) {
                blArray[var14_85] = this.in.readByte() != 0;
                ++var14_85;
            }
            object2 = blArray;
        } else if (clazz == Byte.class) {
            object2 = this.in.readByte();
        } else if (clazz == byte[].class) {
            void var14_87;
            int n15 = this.in.readIntULEB128();
            byte[] byArray = new byte[n15];
            boolean bl4 = false;
            while (var14_87 < n15) {
                byArray[var14_87] = this.in.readByte();
                ++var14_87;
            }
            object2 = byArray;
        } else if (clazz == Character.class) {
            object2 = Character.valueOf(this.in.readChar());
        } else if (clazz == char[].class) {
            void var14_89;
            int n16 = this.in.readIntULEB128();
            char[] cArray = new char[n16];
            boolean bl5 = false;
            while (var14_89 < n16) {
                cArray[var14_89] = this.in.readChar();
                ++var14_89;
            }
            object2 = cArray;
        } else if (clazz == Short.class) {
            object2 = this.in.readShort();
        } else if (clazz == short[].class) {
            void var14_91;
            int n17 = this.in.readIntULEB128();
            short[] sArray = new short[n17];
            boolean bl6 = false;
            while (var14_91 < n17) {
                sArray[var14_91] = this.in.readShort();
                ++var14_91;
            }
            object2 = sArray;
        } else if (clazz == Integer.class) {
            object2 = this.in.readIntULEB128();
        } else if (clazz == int[].class) {
            void var14_93;
            int n18 = this.in.readIntULEB128();
            int[] nArray4 = new int[n18];
            boolean bl7 = false;
            while (var14_93 < n18) {
                nArray4[var14_93] = this.in.readIntULEB128();
                ++var14_93;
            }
            object2 = nArray4;
        } else if (clazz == Long.class) {
            object2 = this.in.readLongULEB128();
        } else if (clazz == long[].class) {
            void var14_95;
            int n19 = this.in.readIntULEB128();
            long[] lArray = new long[n19];
            boolean bl8 = false;
            while (var14_95 < n19) {
                lArray[var14_95] = this.in.readLongULEB128();
                ++var14_95;
            }
            object2 = lArray;
        } else if (clazz == Float.class) {
            object2 = Float.valueOf(this.in.readFloat());
        } else if (clazz == float[].class) {
            void var14_97;
            int n20 = this.in.readIntULEB128();
            float[] fArray = new float[n20];
            boolean bl9 = false;
            while (var14_97 < n20) {
                fArray[var14_97] = this.in.readFloat();
                ++var14_97;
            }
            object2 = fArray;
        } else if (clazz == Double.class) {
            object2 = this.in.readDouble();
        } else if (clazz == double[].class) {
            void var14_99;
            int n21 = this.in.readIntULEB128();
            double[] dArray = new double[n21];
            boolean bl10 = false;
            while (var14_99 < n21) {
                dArray[var14_99] = this.in.readDouble();
                ++var14_99;
            }
            object2 = dArray;
        } else if (clazz == String.class || clazz == StringBuilder.class) {
            if (this.stringpool != null) {
                int n22 = this.in.readIntULEB128();
                object2 = this.stringpool.get(n22);
            } else {
                int n23 = this.in.readIntULEB128();
                byte[] byArray = new byte[n23];
                this.in.readFully(byArray);
                object2 = Strings.decodeUTF8(byArray);
            }
            if (clazz == StringBuilder.class) {
                object2 = new StringBuilder((String)object2);
            }
        } else if (clazz == BigInteger.class) {
            int n24 = this.in.readIntULEB128();
            byte[] byArray = new byte[n24];
            this.in.readFully(byArray);
            object2 = new BigInteger(byArray);
        } else if (clazz == BigDecimal.class) {
            int n25 = this.in.readIntULEB128();
            byte[] byArray = new byte[n25];
            this.in.readFully(byArray);
            object2 = new BigDecimal(Strings.decodeUTF8(byArray));
        } else if (clazz == AtomicBoolean.class) {
            object2 = new AtomicBoolean(this.in.readByte() != 0);
        } else if (clazz == AtomicInteger.class) {
            object2 = new AtomicInteger(this.in.readIntULEB128());
        } else if (clazz == AtomicLong.class) {
            object2 = new AtomicLong(this.in.readLongULEB128());
        } else if (clazz == SoftReference.class || clazz == WeakReference.class) {
            if (!bl) {
                throw new RuntimeException("Unexpected non-leaf SoftReference object");
            }
            int[] nArray5 = new int[1];
            Object object9 = this.read(null, null, nArray5);
            if (nArray5[0] == 0) {
                object2 = clazz == SoftReference.class ? new SoftReference<Object>(object9) : new WeakReference<Object>(object9);
            } else {
                object2 = new TemporaryReference(clazz, nArray5[0]);
                nArray5[0] = 0;
            }
        } else if (Collection.class.isAssignableFrom(clazz)) {
            if (clazz == ArrayList.class || clazz == LinkedList.class || clazz == ArrayDeque.class || clazz == HashSet.class || clazz == TreeSet.class || clazz == LinkedHashSet.class || clazz == CopyOnWriteArrayList.class || clazz == CopyOnWriteArraySet.class || clazz == ConcurrentSkipListSet.class || clazz == ConcurrentLinkedQueue.class) {
                void var12_50;
                void var14_111;
                int n26;
                int n27 = this.in.readIntULEB128();
                if (n27 < 0) {
                    n26 = -n27;
                    boolean bl11 = false;
                } else {
                    boolean bl12 = true;
                }
                if (bl) {
                    if (clazz == ArrayList.class) {
                        ArrayList arrayList = new ArrayList(n26);
                    } else if (clazz == LinkedList.class) {
                        LinkedList linkedList = new LinkedList();
                    } else if (clazz == ArrayDeque.class) {
                        ArrayDeque arrayDeque = new ArrayDeque(n26);
                    } else if (clazz == HashSet.class) {
                        HashSet hashSet = new HashSet(n26);
                    } else if (clazz == TreeSet.class) {
                        TreeSet treeSet = new TreeSet();
                    } else if (clazz == LinkedHashSet.class) {
                        LinkedHashSet linkedHashSet = new LinkedHashSet();
                    } else if (clazz == CopyOnWriteArrayList.class) {
                        CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList();
                    } else if (clazz == CopyOnWriteArraySet.class) {
                        CopyOnWriteArraySet copyOnWriteArraySet = new CopyOnWriteArraySet();
                    } else if (clazz == ConcurrentSkipListSet.class) {
                        ConcurrentSkipListSet concurrentSkipListSet = new ConcurrentSkipListSet();
                    } else {
                        if (clazz != ConcurrentLinkedQueue.class) throw new SerializationException("Unsupported collection type", clazz);
                        ConcurrentLinkedQueue concurrentLinkedQueue = new ConcurrentLinkedQueue();
                    }
                } else {
                    Collection collection = (Collection)object2;
                }
                this.registerObject(bl, n5, var14_111);
                if (var12_50 == false) throw new RuntimeException();
                PreCollection preCollection = new PreCollection((Collection<Object>)var14_111, n26);
                int[] nArray6 = new int[1];
                for (int i = 0; i < n26; ++i) {
                    Object object10 = this.read(null, null, nArray6);
                    if (nArray6[0] == 0) {
                        preCollection.record(object10);
                        continue;
                    }
                    preCollection.recordId(nArray6[0]);
                    nArray6[0] = 0;
                }
                this.deferredObjects.add(preCollection);
                object2 = var14_111;
            } else if (clazz == AbstractList.class) {
                if (bl) {
                    throw new RuntimeException();
                }
                Collection collection = (Collection)object2;
                object2 = collection;
            }
        } else {
            void var13_80;
            if (!Map.class.isAssignableFrom(clazz) || clazz != HashMap.class && clazz != TreeMap.class && clazz != LinkedHashMap.class && clazz != IdentityHashMap.class && clazz != ConcurrentHashMap.class && clazz != ConcurrentSkipListMap.class) throw new SerializationException("Unsupported type", clazz);
            int n28 = this.in.readIntULEB128();
            if (bl) {
                if (clazz == HashMap.class) {
                    HashMap hashMap = new HashMap(n28);
                } else if (clazz == TreeMap.class) {
                    TreeMap treeMap = new TreeMap();
                } else if (clazz == LinkedHashMap.class) {
                    LinkedHashMap linkedHashMap = new LinkedHashMap(n28);
                } else if (clazz == IdentityHashMap.class) {
                    IdentityHashMap identityHashMap = new IdentityHashMap(n28);
                } else if (clazz == ConcurrentHashMap.class) {
                    ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(n28);
                } else {
                    if (clazz != ConcurrentSkipListMap.class) throw new SerializationException("Unsupported map type", clazz);
                    ConcurrentSkipListMap concurrentSkipListMap = new ConcurrentSkipListMap();
                }
            } else {
                Map map = (Map)object2;
            }
            this.registerObject(bl, n5, var13_80);
            PreMap preMap = new PreMap((Map<Object, Object>)var13_80, n28);
            int[] nArray7 = new int[1];
            for (int i = 0; i < n28; ++i) {
                Object object11 = this.read(null, null, nArray7);
                if (nArray7[0] == 0) {
                    preMap.record(object11);
                } else {
                    preMap.recordId(nArray7[0]);
                    nArray7[0] = 0;
                }
                Object object12 = this.read(null, null, nArray7);
                if (nArray7[0] == 0) {
                    preMap.record(object12);
                    continue;
                }
                preMap.recordId(nArray7[0]);
                nArray7[0] = 0;
            }
            this.deferredObjects.add(preMap);
            object2 = var13_80;
        }
        this.registerObject(bl, n5, object2);
        return object2;
    }

    @Override
    public void restoreFields(Object object, Class<?> clazz) throws IOException {
        int n2;
        int[] nArray = new int[1];
        while ((n2 = this.in.readIntULEB128()) != 0) {
            Object object2 = this.read(null, null, nArray);
            this.restoreFieldValue(object, clazz, n2, object2, nArray[0]);
            nArray[0] = 0;
        }
    }

    private Class<?> retrieveClassFromIdOrName(int n2, String string) throws SerializationException {
        try {
            Class<?> clazz = n2 > 0 ? this.customTypeIdProvider.getType(n2) : (n2 < 0 ? this.nativeTypeIdProvider.getType(n2) : this.loadClass(string));
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SerializationException(Strings.ff("Class not found for type id: %d / %s", n2, string), classNotFoundException);
        }
    }

    static class CustomMethods {
        Method mCustomRead;
        Method mCustomInit;
        Method mCustomInitPostGraph;

        CustomMethods() {
        }
    }

    static class TemporaryReference
    implements IPreObject {
        Class<?> refClazz;
        int refObjectId;

        TemporaryReference(Class<?> clazz, int n2) {
            this.refClazz = clazz;
            this.refObjectId = n2;
        }

        @Override
        public Object build(Map<Integer, Object> map) {
            Object object = map.get(this.refObjectId);
            if (this.refClazz == SoftReference.class) {
                return new SoftReference<Object>(object);
            }
            if (this.refClazz == WeakReference.class) {
                return new WeakReference<Object>(object);
            }
            throw new RuntimeException();
        }
    }

    static class DeferredFieldValue {
        Field f;
        Object o;
        int fieldObjectId;

        DeferredFieldValue(Field field, Object object, int n2) {
            this.f = field;
            this.o = object;
            this.fieldObjectId = n2;
        }

        public String toString() {
            return this.f + " (field id: " + this.fieldObjectId + ")";
        }
    }

    class ObjlistAsMap
    implements Map<Integer, Object> {
        ObjlistAsMap() {
        }

        @Override
        public int size() {
            return Deserializer_v5.this.objcnt;
        }

        @Override
        public boolean isEmpty() {
            return Deserializer_v5.this.objcnt == 0;
        }

        @Override
        public boolean containsKey(Object object) {
            throw new RuntimeException("Do not use");
        }

        @Override
        public boolean containsValue(Object object) {
            throw new RuntimeException("Do not use");
        }

        @Override
        public Object get(Object object) {
            int n2 = (Integer)object;
            if (n2 < 0 || n2 >= Deserializer_v5.this.objlist.size()) {
                return null;
            }
            return Deserializer_v5.this.objlist.get((Integer)object);
        }

        @Override
        public Object put(Integer n2, Object object) {
            throw new RuntimeException("Do not use");
        }

        @Override
        public Object remove(Object object) {
            throw new RuntimeException("Do not use");
        }

        @Override
        public void putAll(Map<? extends Integer, ? extends Object> map) {
            throw new RuntimeException("Do not use");
        }

        @Override
        public void clear() {
            throw new RuntimeException("Do not use");
        }

        @Override
        public Set<Integer> keySet() {
            throw new RuntimeException("Do not use");
        }

        @Override
        public Collection<Object> values() {
            throw new RuntimeException("Do not use");
        }

        @Override
        public Set<Map.Entry<Integer, Object>> entrySet() {
            throw new RuntimeException("Do not use");
        }
    }
}

