/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.serialization;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.LEDataInputStream;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.reflect.ReflectionHelper;
import com.pnfsoftware.jeb.util.serialization.AbstractInternalDeserializer;
import com.pnfsoftware.jeb.util.serialization.DeserializerHelper;
import com.pnfsoftware.jeb.util.serialization.ITypeIdProvider;
import com.pnfsoftware.jeb.util.serialization.PreCollection;
import com.pnfsoftware.jeb.util.serialization.PreMap;
import com.pnfsoftware.jeb.util.serialization.SerializationException;
import com.pnfsoftware.jeb.util.serialization.annotations.SerConstructor;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

class Deserializer_v4
extends AbstractInternalDeserializer {
    private static final ILogger logger = GlobalLog.getLogger(Deserializer_v4.class);
    private List<String> stringpool;

    public Deserializer_v4(ITypeIdProvider iTypeIdProvider, List<ClassLoader> list, LEDataInputStream lEDataInputStream) {
        super(iTypeIdProvider, list, lEDataInputStream);
    }

    public void setStringPool(List<String> list) {
        this.stringpool = list;
    }

    public List<String> getStringPool() {
        return this.stringpool;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object readInternal(Object object, Class<?> clazz) throws IOException {
        int n2;
        int n3;
        boolean bl;
        boolean bl2 = bl = clazz == null;
        if (bl && object != null) {
            throw new SerializationException("Object should not be provided, a leaf is being deserialized", clazz);
        }
        Object object2 = object;
        int n4 = this.in.readIntULEB128();
        int n5 = 0;
        String string = null;
        int n6 = 0;
        if (bl) {
            Class<?> clazz2;
            int n7;
            if ((n4 & 0x10) != 0) {
                n6 = this.in.readByte() & 0xFF;
            }
            if (n4 == 1) {
                return null;
            }
            if ((n4 & 0x40) != 0) {
                int n8 = n4 & 0x3F;
                switch (n8) {
                    case 0: {
                        return Boolean.FALSE;
                    }
                    case 1: {
                        return Boolean.TRUE;
                    }
                    case 2: {
                        return this.in.readIntULEB128();
                    }
                    case 3: {
                        return this.in.readLongULEB128();
                    }
                    case 4: {
                        return "";
                    }
                    case 5: {
                        return 0;
                    }
                    case 6: {
                        return 1;
                    }
                    case 7: {
                        return -1;
                    }
                    case 8: {
                        return 0L;
                    }
                    case 9: {
                        return 1L;
                    }
                    case 10: {
                        return -1L;
                    }
                }
                throw new SerializationException("Unknown special object index: " + n8);
            }
            n5 = this.in.readIntULEB128();
            if ((n4 & 4) != 0) {
                Object v2 = this.objmap.get(n5);
                if (v2 != null) return v2;
                throw new SerializationException(Strings.ff("Expected an already-deserialized object for id: %d", n5), clazz);
            }
            n3 = this.in.readIntULEB128() - 128;
            if ((n4 & 0x100) != 0) {
                n7 = this.in.readIntULEB128();
                byte[] byArray = new byte[n7];
                this.in.readFully(byArray);
                string = Strings.decodeUTF8(byArray);
            } else if ((n4 & 0x200) != 0) {
                n7 = this.in.readIntULEB128();
                Class<?> clazz3 = this.objmap.get(n7).getClass();
                string = ReflectionHelper.reduceDimensions(clazz3).getName();
            }
            try {
                clazz2 = n3 > 0 ? this.customTypeIdProvider.getType(n3) : (n3 < 0 ? this.nativeTypeIdProvider.getType(n3) : this.loadClass(string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SerializationException(Strings.ff("Class not found for type id: %d", n3), classNotFoundException, clazz);
            }
            if (clazz != null && clazz != clazz2) {
                throw new SerializationException(Strings.ff("Unexpected class was found for type id %d: %s", n3, clazz2), clazz);
            }
            clazz = clazz2;
            if (clazz2 == null) {
                throw new SerializationException(Strings.ff("Type was expected for id %d, got null", n3), clazz);
            }
        } else {
            n3 = this.nativeTypeIdProvider.getId(clazz);
            if (n3 == 0) {
                n3 = this.customTypeIdProvider.getId(clazz);
            }
        }
        if ((n4 & 2) != 0) {
            int n9 = this.in.readIntULEB128();
            object2 = clazz.getEnumConstants()[n9];
            this.registerObject(true, n5, object2);
            return object2;
        }
        if ((n4 & 0x80) != 0) {
            int n10 = this.in.readIntULEB128();
            try {
                object2 = clazz.getDeclaredMethod("valueOf", Integer.TYPE).invoke(null, n10);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new SerializationException(reflectiveOperationException);
            }
            this.registerObject(true, n5, object2);
            return object2;
        }
        int n11 = n2 = (n4 & 0x20) != 0 ? this.in.readIntULEB128() : 0;
        if (n3 >= 0 && n6 == 0) {
            Class<?> clazz4;
            if (bl) {
                Object v3 = this.constructorMap.get(clazz);
                if (v3 == null) {
                    void var11_25;
                    Object object3 = this.mootObject;
                    try {
                        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                        if (constructor.getAnnotation(SerConstructor.class) != null) {
                            Constructor<?> constructor2 = constructor;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (Exception exception) {
                        throw new SerializationException(exception, clazz);
                    }
                    this.constructorMap.put(clazz, var11_25);
                }
                try {
                    void var11_26;
                    object2 = var11_26 instanceof Constructor ? ReflectionHelper.newInstance2((Constructor)var11_26) : this.objenesis.getInstantiatorOf(clazz).newInstance();
                }
                catch (Exception exception) {
                    throw new SerializationException(exception, clazz);
                }
                this.registerObject(bl, n5, object2);
            }
            if ((clazz4 = clazz.getSuperclass()) != null) {
                this.read(object2, clazz4);
            }
            AbstractInternalDeserializer.CustomMethods customMethods = this.getCustomMethods(object2, clazz);
            if (customMethods.mCustomRead != null) {
                try {
                    ReflectionHelper.invoke2(customMethods.mCustomRead, object2, new DeserializerHelper(this, object2, clazz, n2));
                }
                catch (Exception exception) {
                    throw new SerializationException("Custom read failed", exception, clazz);
                }
            } else {
                this.restoreFields(object2, clazz);
            }
            if (customMethods.mCustomInit != null) {
                try {
                    ReflectionHelper.invoke2(customMethods.mCustomInit, object2, new Object[0]);
                }
                catch (Exception exception) {
                    throw new SerializationException("Initializer failed", exception, clazz);
                }
            }
            this.notifyDeserializationEvent(1, clazz, object2);
        } else if (n6 > 0) {
            int n12;
            int[] nArray = new int[n6];
            nArray[0] = n12 = this.in.readIntULEB128();
            Object object4 = Array.newInstance(clazz, nArray);
            this.registerObject(bl, n5, object4);
            for (int i = 0; i < n12; ++i) {
                Array.set(object4, i, this.read());
            }
            object2 = object4;
        } else if (clazz == Object.class) {
            if (object == null) {
                object = new Object();
            }
            object2 = object;
        } else if (clazz == Class.class) {
            void var11_32;
            Object var11_30 = null;
            int n13 = this.in.readInt();
            if (n13 == 0) {
                String string2 = this.in.readUTF();
            }
            object2 = this.retrieveClassFromIdOrName(n13, (String)var11_32);
        } else if (clazz == Boolean.class) {
            object2 = this.in.readByte() == 0 ? Boolean.FALSE : Boolean.TRUE;
        } else if (clazz == boolean[].class) {
            int n14 = this.in.readIntULEB128();
            boolean[] blArray = new boolean[n14];
            for (int i = 0; i < n14; ++i) {
                blArray[i] = this.in.readByte() != 0;
            }
            object2 = blArray;
        } else if (clazz == Byte.class) {
            object2 = this.in.readByte();
        } else if (clazz == byte[].class) {
            int n15 = this.in.readIntULEB128();
            byte[] byArray = new byte[n15];
            for (int i = 0; i < n15; ++i) {
                byArray[i] = this.in.readByte();
            }
            object2 = byArray;
        } else if (clazz == Character.class) {
            object2 = Character.valueOf(this.in.readChar());
        } else if (clazz == char[].class) {
            int n16 = this.in.readIntULEB128();
            char[] cArray = new char[n16];
            for (int i = 0; i < n16; ++i) {
                cArray[i] = this.in.readChar();
            }
            object2 = cArray;
        } else if (clazz == Short.class) {
            object2 = this.in.readShort();
        } else if (clazz == short[].class) {
            int n17 = this.in.readIntULEB128();
            short[] sArray = new short[n17];
            for (int i = 0; i < n17; ++i) {
                sArray[i] = this.in.readShort();
            }
            object2 = sArray;
        } else if (clazz == Integer.class) {
            object2 = this.in.readIntULEB128();
        } else if (clazz == int[].class) {
            int n18 = this.in.readIntULEB128();
            int[] nArray = new int[n18];
            for (int i = 0; i < n18; ++i) {
                nArray[i] = this.in.readIntULEB128();
            }
            object2 = nArray;
        } else if (clazz == Long.class) {
            object2 = this.in.readLongULEB128();
        } else if (clazz == long[].class) {
            int n19 = this.in.readIntULEB128();
            long[] lArray = new long[n19];
            for (int i = 0; i < n19; ++i) {
                lArray[i] = this.in.readLongULEB128();
            }
            object2 = lArray;
        } else if (clazz == Float.class) {
            object2 = Float.valueOf(this.in.readFloat());
        } else if (clazz == float[].class) {
            int n20 = this.in.readIntULEB128();
            float[] fArray = new float[n20];
            for (int i = 0; i < n20; ++i) {
                fArray[i] = this.in.readFloat();
            }
            object2 = fArray;
        } else if (clazz == Double.class) {
            object2 = this.in.readDouble();
        } else if (clazz == double[].class) {
            int n21 = this.in.readIntULEB128();
            double[] dArray = new double[n21];
            for (int i = 0; i < n21; ++i) {
                dArray[i] = this.in.readDouble();
            }
            object2 = dArray;
        } else if (clazz == String.class) {
            if (this.stringpool != null) {
                int n22 = this.in.readIntULEB128();
                object2 = this.stringpool.get(n22);
            } else {
                int n23 = this.in.readIntULEB128();
                byte[] byArray = new byte[n23];
                this.in.readFully(byArray);
                object2 = Strings.decodeUTF8(byArray);
            }
        } else if (clazz == BigInteger.class) {
            int n24 = this.in.readIntULEB128();
            byte[] byArray = new byte[n24];
            this.in.readFully(byArray);
            object2 = new BigInteger(byArray);
        } else if (clazz == BigDecimal.class) {
            int n25 = this.in.readIntULEB128();
            byte[] byArray = new byte[n25];
            this.in.readFully(byArray);
            object2 = new BigDecimal(Strings.decodeUTF8(byArray));
        } else if (clazz == AtomicBoolean.class) {
            object2 = new AtomicBoolean(this.in.readByte() != 0);
        } else if (clazz == AtomicInteger.class) {
            object2 = new AtomicInteger(this.in.readIntULEB128());
        } else if (clazz == AtomicLong.class) {
            object2 = new AtomicLong(this.in.readLongULEB128());
        } else if (clazz == SoftReference.class) {
            if (!bl) {
                throw new RuntimeException("Unexpected non-lead SoftReference object");
            }
            object2 = new SoftReference<Object>(this.read());
        } else if (clazz == WeakReference.class) {
            if (!bl) {
                throw new RuntimeException("Unexpected non-lead WeakReference object");
            }
            object2 = new WeakReference<Object>(this.read());
        } else if (Collection.class.isAssignableFrom(clazz)) {
            if (clazz == ArrayList.class || clazz == LinkedList.class || clazz == ArrayDeque.class || clazz == HashSet.class || clazz == TreeSet.class || clazz == LinkedHashSet.class || clazz == CopyOnWriteArrayList.class || clazz == CopyOnWriteArraySet.class || clazz == ConcurrentSkipListSet.class || clazz == ConcurrentLinkedQueue.class) {
                void var12_76;
                int n26 = this.in.readIntULEB128();
                if (bl) {
                    if (clazz == ArrayList.class) {
                        ArrayList arrayList = new ArrayList(n26);
                    } else if (clazz == LinkedList.class) {
                        LinkedList linkedList = new LinkedList();
                    } else if (clazz == ArrayDeque.class) {
                        ArrayDeque arrayDeque = new ArrayDeque(n26);
                    } else if (clazz == HashSet.class) {
                        HashSet hashSet = new HashSet(n26);
                    } else if (clazz == TreeSet.class) {
                        TreeSet treeSet = new TreeSet();
                    } else if (clazz == LinkedHashSet.class) {
                        LinkedHashSet linkedHashSet = new LinkedHashSet();
                    } else if (clazz == CopyOnWriteArrayList.class) {
                        CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList();
                    } else if (clazz == CopyOnWriteArraySet.class) {
                        CopyOnWriteArraySet copyOnWriteArraySet = new CopyOnWriteArraySet();
                    } else if (clazz == ConcurrentSkipListSet.class) {
                        ConcurrentSkipListSet concurrentSkipListSet = new ConcurrentSkipListSet();
                    } else {
                        if (clazz != ConcurrentLinkedQueue.class) throw new SerializationException("Unsupported collection type", clazz);
                        ConcurrentLinkedQueue concurrentLinkedQueue = new ConcurrentLinkedQueue();
                    }
                } else {
                    Collection collection = (Collection)object2;
                }
                this.registerObject(bl, n5, var12_76);
                PreCollection preCollection = new PreCollection((Collection<Object>)var12_76, n26);
                for (int i = 0; i < n26; ++i) {
                    Object object5 = this.read();
                    preCollection.record(object5);
                }
                this.deferredObjects.add(preCollection);
                object2 = var12_76;
            } else if (clazz == AbstractList.class) {
                if (bl) {
                    throw new RuntimeException();
                }
                Collection collection = (Collection)object2;
                object2 = collection;
            }
        } else {
            void var12_84;
            if (!Map.class.isAssignableFrom(clazz) || clazz != HashMap.class && clazz != TreeMap.class && clazz != LinkedHashMap.class && clazz != IdentityHashMap.class && clazz != ConcurrentHashMap.class && clazz != ConcurrentSkipListMap.class) throw new SerializationException("Unsupported type", clazz);
            int n27 = this.in.readIntULEB128();
            if (bl) {
                if (clazz == HashMap.class) {
                    HashMap hashMap = new HashMap(n27);
                } else if (clazz == TreeMap.class) {
                    TreeMap treeMap = new TreeMap();
                } else if (clazz == LinkedHashMap.class) {
                    LinkedHashMap linkedHashMap = new LinkedHashMap(n27);
                } else if (clazz == IdentityHashMap.class) {
                    IdentityHashMap identityHashMap = new IdentityHashMap(n27);
                } else if (clazz == ConcurrentHashMap.class) {
                    ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(n27);
                } else {
                    if (clazz != ConcurrentSkipListMap.class) throw new SerializationException("Unsupported map type", clazz);
                    ConcurrentSkipListMap concurrentSkipListMap = new ConcurrentSkipListMap();
                }
            } else {
                Map map = (Map)object2;
            }
            this.registerObject(bl, n5, var12_84);
            PreMap preMap = new PreMap((Map<Object, Object>)var12_84, n27);
            for (int i = 0; i < n27; ++i) {
                Object object6 = this.read();
                preMap.record(object6);
                Object object7 = this.read();
                preMap.record(object7);
            }
            this.deferredObjects.add(preMap);
            object2 = var12_84;
        }
        this.registerObject(bl, n5, object2);
        return object2;
    }

    @Override
    public void restoreFields(Object object, Class<?> clazz) throws IOException {
        int n2;
        while ((n2 = this.in.readIntULEB128()) != 0) {
            Object object2 = this.read();
            this.restoreFieldValue(object, clazz, n2, object2);
        }
    }

    private Class<?> retrieveClassFromIdOrName(int n2, String string) throws SerializationException {
        try {
            Class<?> clazz = n2 > 0 ? this.customTypeIdProvider.getType(n2) : (n2 < 0 ? this.nativeTypeIdProvider.getType(n2) : this.loadClass(string));
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SerializationException(Strings.ff("Class not found for type id: %d / %s", n2, string), classNotFoundException);
        }
    }
}

