/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.serialization;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.LEDataInputStream;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.reflect.ReflectionHelper;
import com.pnfsoftware.jeb.util.serialization.AbstractInternalDeserializer;
import com.pnfsoftware.jeb.util.serialization.DeserializerHelper;
import com.pnfsoftware.jeb.util.serialization.ITypeIdProvider;
import com.pnfsoftware.jeb.util.serialization.PreCollection;
import com.pnfsoftware.jeb.util.serialization.PreMap;
import com.pnfsoftware.jeb.util.serialization.SerializationException;
import com.pnfsoftware.jeb.util.serialization.annotations.SerConstructor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

class Deserializer_v1_and_v2
extends AbstractInternalDeserializer {
    private static final ILogger logger = GlobalLog.getLogger(Deserializer_v1_and_v2.class);
    private int flagMask;

    public Deserializer_v1_and_v2(boolean bl, ITypeIdProvider iTypeIdProvider, List<ClassLoader> list, LEDataInputStream lEDataInputStream) {
        super(iTypeIdProvider, list, lEDataInputStream);
        this.flagMask = bl ? -65408 : -65344;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object readInternal(Object object, Class<?> clazz) throws IOException {
        int n2;
        boolean bl;
        int n3 = 0;
        int n4 = 0;
        String string = null;
        boolean bl2 = bl = clazz == null;
        if (bl && object != null) {
            throw new SerializationException("Object should not be provided, a leaf is being deserialized", clazz);
        }
        Object object2 = object;
        int n5 = 0;
        if (bl) {
            Class<?> clazz2;
            int n6;
            n3 = this.in.readInt();
            if ((n3 & this.flagMask) != 0) {
                throw new SerializationException(Strings.ff("Unsupported flag in serialized object: 0x%X", n3), clazz);
            }
            if (n3 == 1) {
                return null;
            }
            n4 = this.in.readInt();
            if ((n3 & 4) != 0) {
                Object v2 = this.objmap.get(n4);
                if (v2 == null) {
                    throw new SerializationException(Strings.ff("Expected an already-deserialized object for id: %d", n4), clazz);
                }
                if (object == null) return v2;
                throw new SerializationException("An empty object was provided, but an already-deserialized object was found", clazz);
            }
            n5 = n3 >> 8 & 0xFF;
            n2 = this.in.readInt();
            if ((n3 & 0x10) != 0) {
                n6 = this.in.readInt();
                byte[] byArray = new byte[n6];
                this.in.readFully(byArray);
                string = Strings.decodeUTF8(byArray);
            } else if ((n3 & 0x40) != 0) {
                n6 = this.in.readInt();
                Class<?> clazz3 = this.objmap.get(n6).getClass();
                string = ReflectionHelper.reduceDimensions(clazz3).getName();
            }
            try {
                clazz2 = n2 > 0 ? this.customTypeIdProvider.getType(n2) : (n2 < 0 ? this.nativeTypeIdProvider.getType(n2) : this.loadClass(string));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SerializationException(Strings.ff("Class not found for type id: %d", n2), classNotFoundException, clazz);
            }
            if (clazz != null && clazz != clazz2) {
                throw new SerializationException(Strings.ff("Unexpected class was found for type id %d: %s", n2, clazz2), clazz);
            }
            clazz = clazz2;
            if (clazz2 == null) {
                throw new SerializationException(Strings.ff("Type was expected for id %d, got null", n2), clazz);
            }
        } else {
            n2 = this.nativeTypeIdProvider.getId(clazz);
            if (n2 == 0) {
                n2 = this.customTypeIdProvider.getId(clazz);
            }
        }
        if ((n3 & 0x20) != 0) {
            int n7 = this.in.readInt();
            object2 = clazz.getEnumConstants()[n7];
            this.objmap.put(n4, object2);
            return object2;
        }
        int n8 = this.in.readInt();
        if (n2 >= 0 && n5 == 0) {
            Class<?> clazz4;
            if (bl) {
                Object v3 = this.constructorMap.get(clazz);
                if (v3 == null) {
                    void var11_22;
                    Object object3 = this.mootObject;
                    try {
                        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                        if (constructor.getAnnotation(SerConstructor.class) != null) {
                            Constructor<?> constructor2 = constructor;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (Exception exception) {
                        throw new SerializationException(exception, clazz);
                    }
                    this.constructorMap.put(clazz, var11_22);
                }
                try {
                    void var11_23;
                    object2 = var11_23 instanceof Constructor ? ReflectionHelper.newInstance2((Constructor)var11_23) : this.objenesis.getInstantiatorOf(clazz).newInstance();
                }
                catch (Exception exception) {
                    throw new SerializationException(exception, clazz);
                }
                this.registerObject(bl, n4, object2);
            }
            if ((clazz4 = clazz.getSuperclass()) != null) {
                this.read(object2, clazz4);
            }
            AbstractInternalDeserializer.CustomMethods customMethods = this.getCustomMethods(object2, clazz);
            if (customMethods.mCustomRead != null) {
                try {
                    ReflectionHelper.invoke2(customMethods.mCustomRead, object2, new DeserializerHelper(this, object2, clazz, n8));
                }
                catch (Exception exception) {
                    throw new SerializationException("Custom read failed", exception, clazz);
                }
            } else {
                this.restoreFields(object2, clazz);
            }
            if (customMethods.mCustomInit != null) {
                try {
                    ReflectionHelper.invoke2(customMethods.mCustomInit, object2, new Object[0]);
                }
                catch (Exception exception) {
                    throw new SerializationException("Initializer failed", exception, clazz);
                }
            }
            this.notifyDeserializationEvent(1, clazz, object2);
        } else if (n5 > 0) {
            int n9;
            int[] nArray = new int[n5];
            nArray[0] = n9 = this.in.readInt();
            Object object4 = Array.newInstance(clazz, nArray);
            this.registerObject(bl, n4, object4);
            for (int i = 0; i < n9; ++i) {
                Array.set(object4, i, this.read());
            }
            object2 = object4;
        } else if (clazz == Object.class) {
            if (object == null) {
                throw new SerializationException("Unexpected null object", clazz);
            }
            object2 = object;
        } else if (clazz == Boolean.class) {
            object2 = this.in.readByte() == 0 ? Boolean.FALSE : Boolean.TRUE;
        } else if (clazz == boolean[].class) {
            int n10 = this.in.readInt();
            boolean[] blArray = new boolean[n10];
            for (int i = 0; i < n10; ++i) {
                blArray[i] = this.in.readByte() != 0;
            }
            object2 = blArray;
        } else if (clazz == Byte.class) {
            object2 = this.in.readByte();
        } else if (clazz == byte[].class) {
            int n11 = this.in.readInt();
            byte[] byArray = new byte[n11];
            for (int i = 0; i < n11; ++i) {
                byArray[i] = this.in.readByte();
            }
            object2 = byArray;
        } else if (clazz == Character.class) {
            object2 = Character.valueOf(this.in.readChar());
        } else if (clazz == char[].class) {
            int n12 = this.in.readInt();
            char[] cArray = new char[n12];
            for (int i = 0; i < n12; ++i) {
                cArray[i] = this.in.readChar();
            }
            object2 = cArray;
        } else if (clazz == Short.class) {
            object2 = this.in.readShort();
        } else if (clazz == short[].class) {
            int n13 = this.in.readInt();
            short[] sArray = new short[n13];
            for (int i = 0; i < n13; ++i) {
                sArray[i] = this.in.readShort();
            }
            object2 = sArray;
        } else if (clazz == Integer.class) {
            object2 = this.in.readInt();
        } else if (clazz == int[].class) {
            int n14 = this.in.readInt();
            int[] nArray = new int[n14];
            for (int i = 0; i < n14; ++i) {
                nArray[i] = this.in.readInt();
            }
            object2 = nArray;
        } else if (clazz == Long.class) {
            object2 = this.in.readLong();
        } else if (clazz == long[].class) {
            int n15 = this.in.readInt();
            long[] lArray = new long[n15];
            for (int i = 0; i < n15; ++i) {
                lArray[i] = this.in.readLong();
            }
            object2 = lArray;
        } else if (clazz == Float.class) {
            object2 = Float.valueOf(this.in.readFloat());
        } else if (clazz == float[].class) {
            int n16 = this.in.readInt();
            float[] fArray = new float[n16];
            for (int i = 0; i < n16; ++i) {
                fArray[i] = this.in.readFloat();
            }
            object2 = fArray;
        } else if (clazz == Double.class) {
            object2 = this.in.readDouble();
        } else if (clazz == double[].class) {
            int n17 = this.in.readInt();
            double[] dArray = new double[n17];
            for (int i = 0; i < n17; ++i) {
                dArray[i] = this.in.readDouble();
            }
            object2 = dArray;
        } else if (clazz == String.class) {
            int n18 = this.in.readInt();
            this.in.readInt();
            byte[] byArray = new byte[n18];
            this.in.readFully(byArray);
            object2 = Strings.decodeUTF8(byArray);
        } else if (clazz == BigInteger.class) {
            int n19 = this.in.readInt();
            byte[] byArray = new byte[n19];
            this.in.readFully(byArray);
            object2 = new BigInteger(byArray);
        } else if (clazz == BigDecimal.class) {
            int n20 = this.in.readInt();
            byte[] byArray = new byte[n20];
            this.in.readFully(byArray);
            object2 = new BigDecimal(Strings.decodeUTF8(byArray));
        } else if (clazz == ArrayList.class || clazz == LinkedList.class || clazz == ArrayDeque.class || clazz == HashSet.class || clazz == TreeSet.class || clazz == LinkedHashSet.class) {
            void var12_63;
            int n21 = this.in.readInt();
            if (bl) {
                if (clazz == ArrayList.class) {
                    ArrayList arrayList = new ArrayList(n21);
                } else if (clazz == LinkedList.class) {
                    LinkedList linkedList = new LinkedList();
                } else if (clazz == ArrayDeque.class) {
                    ArrayDeque arrayDeque = new ArrayDeque(n21);
                } else if (clazz == HashSet.class) {
                    HashSet hashSet = new HashSet(n21);
                } else if (clazz == TreeSet.class) {
                    TreeSet treeSet = new TreeSet();
                } else {
                    if (clazz != LinkedHashSet.class) throw new SerializationException("Unsupported collection type", clazz);
                    LinkedHashSet linkedHashSet = new LinkedHashSet();
                }
            } else {
                Collection collection = (Collection)object2;
            }
            this.registerObject(bl, n4, var12_63);
            PreCollection preCollection = new PreCollection((Collection<Object>)var12_63, n21);
            for (int i = 0; i < n21; ++i) {
                Object object5 = this.read();
                preCollection.record(object5);
            }
            this.deferredObjects.add(preCollection);
            object2 = var12_63;
        } else {
            void var12_69;
            if (clazz != HashMap.class && clazz != TreeMap.class && clazz != LinkedHashMap.class && clazz != IdentityHashMap.class) throw new SerializationException("Unsupported type", clazz);
            int n22 = this.in.readInt();
            if (bl) {
                if (clazz == HashMap.class) {
                    HashMap hashMap = new HashMap(n22);
                } else if (clazz == TreeMap.class) {
                    TreeMap treeMap = new TreeMap();
                } else if (clazz == LinkedHashMap.class) {
                    LinkedHashMap linkedHashMap = new LinkedHashMap(n22);
                } else {
                    if (clazz != IdentityHashMap.class) throw new SerializationException("Unsupported map type", clazz);
                    IdentityHashMap identityHashMap = new IdentityHashMap(n22);
                }
            } else {
                Map map = (Map)object2;
            }
            this.registerObject(bl, n4, var12_69);
            PreMap preMap = new PreMap((Map<Object, Object>)var12_69, n22);
            for (int i = 0; i < n22; ++i) {
                Object object6 = this.read();
                preMap.record(object6);
                Object object7 = this.read();
                preMap.record(object7);
            }
            this.deferredObjects.add(preMap);
            object2 = var12_69;
        }
        this.registerObject(bl, n4, object2);
        return object2;
    }

    @Override
    public void restoreFields(Object object, Class<?> clazz) throws IOException {
        int n2;
        while ((n2 = this.in.readInt()) != 0) {
            Object object2 = this.read();
            this.restoreFieldValue(object, clazz, n2, object2);
        }
    }
}

