/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.serialization;

import com.pnfsoftware.jeb.core.exceptions.DemoLimitationException;
import com.pnfsoftware.jeb.util.base.IProgressCallback;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.LEDataInputStream;
import com.pnfsoftware.jeb.util.serialization.Deserializer_v1_and_v2;
import com.pnfsoftware.jeb.util.serialization.Deserializer_v3;
import com.pnfsoftware.jeb.util.serialization.Deserializer_v4;
import com.pnfsoftware.jeb.util.serialization.Deserializer_v5;
import com.pnfsoftware.jeb.util.serialization.IDeserializationEventHandler;
import com.pnfsoftware.jeb.util.serialization.IInternalDeserializer;
import com.pnfsoftware.jeb.util.serialization.ITypeIdProvider;
import com.pnfsoftware.jeb.util.serialization.SerializationException;
import com.pnfsoftware.jebglobal.csv;
import com.pnfsoftware.jebglobal.qp;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Deserializer {
    private int version;
    private int flags;
    private LEDataInputStream in;
    private ITypeIdProvider customTypeIdProvider;
    private List<ClassLoader> classloaders;
    private IInternalDeserializer d;
    private boolean initialized;
    private int rootCount;

    public Deserializer(ITypeIdProvider iTypeIdProvider, InputStream inputStream) {
        this(iTypeIdProvider, new ArrayList<ClassLoader>(), inputStream);
    }

    public Deserializer(ITypeIdProvider iTypeIdProvider, List<ClassLoader> list, InputStream inputStream) {
        this.in = new LEDataInputStream(new BufferedInputStream(inputStream));
        this.customTypeIdProvider = iTypeIdProvider;
        this.classloaders = list;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() throws IOException {
        this.readHeader();
    }

    public int getObjectCount() {
        this.verifyInitialized();
        return this.d.getObjectCount();
    }

    public Collection<Object> getObjects() {
        this.verifyInitialized();
        return this.d.getObjects();
    }

    public void setExpectedObjectCount(int n2) {
        this.verifyInitialized();
        this.d.setExpectedObjectCount(n2);
    }

    public void addProgressCallback(IProgressCallback iProgressCallback) {
        this.verifyInitialized();
        this.d.addProgressCallback(iProgressCallback);
    }

    public void removeProgressCallback(IProgressCallback iProgressCallback) {
        this.verifyInitialized();
        this.d.removeProgressCallback(iProgressCallback);
    }

    public Object deserialize() throws IOException {
        Object object = this.deserialize(Object.class);
        String string = csv.ce(new byte[]{23, 7, 25, 10, 82, 13, 2, 5, 27, 0, 71, 5, 9, 106, 116, 123, 25, 80, 77, 78, 92, 95, 70, 20, 64, 79, 46, 22, 65, 16, 13, 19, 69, 5, 78, 46, 107, 45, 64, 0, 25, 6, 28, 74, 4, 5, 18, 26}, 2, 51);
        if (object instanceof qp) {
            throw new DemoLimitationException(string);
        }
        return object;
    }

    public <T> T deserialize(Class<T> clazz) throws IOException {
        if (!this.initialized) {
            this.readHeader();
        }
        Object object = this.d.deserializeInternal();
        ++this.rootCount;
        return (T)object;
    }

    private void readHeader() throws IOException {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        this.initialized = true;
        byte[] byArray = new byte[8];
        this.in.readFully(byArray);
        if (!"PNF-ORPD".equals(Strings.decodeASCII(byArray))) {
            throw new SerializationException("Invalid header for persisted data");
        }
        this.version = this.in.readByte() & 0xFF;
        this.flags = this.in.readByte() & 0xFF;
        this.in.readByte();
        this.in.readByte();
        switch (this.version) {
            case 1: {
                this.d = new Deserializer_v1_and_v2(false, this.customTypeIdProvider, this.classloaders, this.in);
                break;
            }
            case 2: {
                this.d = new Deserializer_v1_and_v2(true, this.customTypeIdProvider, this.classloaders, this.in);
                break;
            }
            case 3: {
                this.d = new Deserializer_v3(this.customTypeIdProvider, this.classloaders, this.in);
                break;
            }
            case 4: {
                this.d = new Deserializer_v4(this.customTypeIdProvider, this.classloaders, this.in);
                break;
            }
            case 5: {
                this.d = new Deserializer_v5(this.customTypeIdProvider, this.classloaders, this.in);
                break;
            }
            default: {
                throw new SerializationException("Unsupported persisted stream version number: " + this.version);
            }
        }
        this.in.readInt();
    }

    public int getVersion() {
        this.verifyInitialized();
        return this.version;
    }

    public int getFlags() {
        this.verifyInitialized();
        return this.flags;
    }

    public boolean needsStringPool() {
        this.verifyInitialized();
        return this.version >= 4 && (this.flags & 1) != 0;
    }

    public void setStringPool(List<String> list) {
        this.verifyInitialized();
        if (this.d instanceof Deserializer_v4) {
            ((Deserializer_v4)this.d).setStringPool(list);
        } else if (this.d instanceof Deserializer_v5) {
            ((Deserializer_v5)this.d).setStringPool(list);
        } else {
            throw new RuntimeException();
        }
    }

    public void addObjectCreatedHook(Class<?> clazz, IDeserializationEventHandler iDeserializationEventHandler) {
        this.verifyInitialized();
        this.d.addObjectCreatedHook(clazz, iDeserializationEventHandler);
    }

    public void removeObjectCreatedHook(Class<?> clazz, IDeserializationEventHandler iDeserializationEventHandler) {
        this.verifyInitialized();
        this.d.removeObjectCreatedHook(clazz, iDeserializationEventHandler);
    }

    private void verifyInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Deserializer must be initialized");
        }
    }
}

