/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.reflect;

import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class ReflectionHelper {
    private static final ILogger logger = GlobalLog.getLogger(ReflectionHelper.class);

    public static boolean hasNoArgConstructor(Class<?> clazz) {
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            return constructor != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static Object newInstance2(Constructor<?> constructor) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean bl = constructor.canAccess(null);
        if (!bl) {
            constructor.setAccessible(true);
        }
        try {
            Object obj = constructor.newInstance(new Object[0]);
            return obj;
        }
        finally {
            if (!bl) {
                constructor.setAccessible(false);
            }
        }
    }

    public static Object invoke2(Method method, Object object, Object ... objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean bl = method.canAccess(object);
        if (!bl) {
            method.setAccessible(true);
        }
        try {
            Object object2 = method.invoke(object, objectArray);
            return object2;
        }
        finally {
            if (!bl) {
                method.setAccessible(false);
            }
        }
    }

    public static void set2(Field field, Object object, Object object2) throws IllegalAccessException, IllegalArgumentException {
        boolean bl = field.canAccess(object);
        if (!bl) {
            field.setAccessible(true);
        }
        try {
            field.set(object, object2);
        }
        finally {
            if (!bl) {
                field.setAccessible(false);
            }
        }
    }

    public static Object get2(Field field, Object object) throws IllegalAccessException, IllegalArgumentException {
        boolean bl = field.canAccess(object);
        if (!bl) {
            field.setAccessible(true);
        }
        try {
            Object object2 = field.get(object);
            return object2;
        }
        finally {
            if (!bl) {
                field.setAccessible(false);
            }
        }
    }

    public static Class<?> removeDimensions(Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public static Class<?> reduceDimensions(Class<?> clazz) {
        Class<?> clazz2;
        while (clazz.isArray() && !(clazz2 = clazz.getComponentType()).isPrimitive()) {
            clazz = clazz2;
        }
        return clazz;
    }

    public static <T> T instantiateSafe(Class<? extends T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            logger.catching(reflectiveOperationException);
            return null;
        }
    }

    public static <T> boolean isInstance(Object object, Collection<Class<? extends T>> collection) {
        if (object == null) {
            return false;
        }
        for (Class<T> clazz : collection) {
            if (!clazz.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstance(Object object, Class<?> ... classArray) {
        if (object == null) {
            return false;
        }
        for (Class<?> clazz : classArray) {
            if (!clazz.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean subtypeOf(Class<?> clazz, Class<?> clazz2) {
        if (clazz == null || clazz2 == null) {
            return false;
        }
        if (clazz == clazz2 || clazz.getSuperclass() == clazz2) {
            return true;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(clazz);
        HashSet<Class> hashSet = new HashSet<Class>();
        while (!arrayList.isEmpty()) {
            clazz = (Class)arrayList.remove(0);
            if (!hashSet.add(clazz)) continue;
            if (clazz == clazz2) {
                return true;
            }
            for (Class<?> clazz3 : clazz.getInterfaces()) {
                arrayList.add(clazz3);
            }
            if (clazz.getSuperclass() == null) continue;
            arrayList.add(clazz.getSuperclass());
        }
        return false;
    }
}

