/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.reflect;

import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class ClasspathCollector {
    private static final ILogger logger = GlobalLog.getLogger(ClasspathCollector.class);
    private List<URL> urls = new ArrayList<URL>();

    public ClasspathCollector() {
        logger.trace("Initializing ClassloaderCollector...", new Object[0]);
    }

    public List<URL> getUrls() {
        return Collections.unmodifiableList(this.urls);
    }

    public void addSmart(File file, String string) {
        for (String string2 : string.split(",", -1)) {
            File[] fileArray;
            File file2 = new File(string2.trim());
            String string3 = file2.getName();
            File file3 = file2.isAbsolute() ? file2.getParentFile() : (file2.getParent() != null ? new File(file, file2.getParent()) : file);
            WildcardFileFilter wildcardFileFilter = WildcardFileFilter.builder().setWildcards(new String[]{string3}).get();
            for (File file4 : fileArray = file3.listFiles((FileFilter)wildcardFileFilter)) {
                if (file4.getName().endsWith(".jar")) {
                    this.addFromJar(file4);
                    continue;
                }
                this.add(file4.getAbsolutePath());
            }
        }
    }

    public boolean add(String string) {
        boolean bl = true;
        for (String string2 : string.trim().split(File.pathSeparator, -1)) {
            URL uRL;
            try {
                uRL = new File(string2).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                logger.catching(malformedURLException);
                bl = false;
                continue;
            }
            this.addURL(uRL);
        }
        return bl;
    }

    public boolean addFromJar(File file) {
        Attributes attributes;
        Object object;
        URL uRL;
        boolean bl = true;
        try {
            uRL = file.toURI().toURL();
            object = new URL("jar", "", uRL + "!/");
            String[] stringArray = (String[])((URL)object).openConnection();
            attributes = stringArray.getMainAttributes();
        }
        catch (IOException iOException) {
            logger.catching(iOException);
            return false;
        }
        this.addURL(uRL);
        if (attributes != null && (object = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
            for (String string : ((String)object).split("\\s+", -1)) {
                try {
                    uRL = new File(file.getParentFile(), string).toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    logger.catching(malformedURLException);
                    bl = false;
                    continue;
                }
                this.addURL(uRL);
            }
        }
        return bl;
    }

    private void addURL(URL uRL) {
        logger.trace("Adding to ClasspathCollector: %s", uRL);
        this.urls.add(uRL);
    }

    public URLClassLoader createClassloader() {
        return this.getClassloader(null);
    }

    public URLClassLoader getClassloader(ClassLoader classLoader) {
        URLClassLoader uRLClassLoader;
        List<URL> list;
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        } else if (classLoader instanceof URLClassLoader && (list = Arrays.asList((uRLClassLoader = (URLClassLoader)classLoader).getURLs())).containsAll(this.urls)) {
            return uRLClassLoader;
        }
        logger.trace("Creating Classloader with: %s", this.urls);
        return new URLClassLoader(this.urls.toArray(new URL[this.urls.size()]), classLoader);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (URL uRL : this.urls) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparatorChar);
            }
            try {
                String string = Paths.get(uRL.toURI()).toFile().getAbsolutePath();
                stringBuilder.append(string);
            }
            catch (Exception exception) {}
        }
        return stringBuilder.toString();
    }
}

