/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.primitives;

import com.pnfsoftware.jeb.util.base.Assert;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;

public class Longs {
    private static BigInteger _2p64 = BigInteger.ONE.shiftLeft(64);

    public static long fromInts(int n2, int n3) {
        return (long)n3 << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    public static int[] toInts(long l2) {
        return new int[]{(int)l2, (int)(l2 >> 32)};
    }

    public static String toUnsignedString(long l2) {
        long l3 = (l2 >>> 1) / 5L;
        long l4 = l2 - l3 * 10L;
        return l3 != 0L ? Long.toString(l3) + l4 : Long.toString(l4);
    }

    public static BigInteger toUnsignedBigInteger(long l2) {
        BigInteger bigInteger = BigInteger.valueOf(l2);
        if (l2 < 0L) {
            bigInteger = bigInteger.add(_2p64);
        }
        return bigInteger;
    }

    public static int compareUnsigned(long l2, long l3) {
        return Long.compare(l2 + Long.MIN_VALUE, l3 + Long.MIN_VALUE);
    }

    public static long maxUnsigned(long l2, long l3) {
        return Longs.compareUnsigned(l2, l3) >= 0 ? l2 : l3;
    }

    public static long minUnsigned(long l2, long l3) {
        return Longs.compareUnsigned(l2, l3) <= 0 ? l2 : l3;
    }

    public static long divUnsigned(long l2, long l3) {
        long l4;
        if (l3 < 0L) {
            if (Longs.compareUnsigned(l2, l3) < 0) {
                return 0L;
            }
            return 1L;
        }
        if (l2 >= 0L) {
            return l2 / l3;
        }
        long l5 = l2 - (l4 = (l2 >>> 1) / l3 << 1) * l3;
        return l4 + (long)(Longs.compareUnsigned(l5, l3) >= 0 ? 1 : 0);
    }

    public static long remUnsigned(long l2, long l3) {
        long l4;
        if (l3 < 0L) {
            if (Longs.compareUnsigned(l2, l3) < 0) {
                return l2;
            }
            return l2 - l3;
        }
        if (l2 >= 0L) {
            return l2 % l3;
        }
        long l5 = (l2 >>> 1) / l3 << 1;
        return l4 - (Longs.compareUnsigned(l4 = l2 - l5 * l3, l3) >= 0 ? l3 : 0L);
    }

    public static String formatHexCollection(Collection<Long> collection) {
        return Longs.formatLongCollection(collection, 16, "0x", null, null);
    }

    public static String formatLongCollection(Collection<Long> collection, Integer n2, String string, String string2, String string3) {
        if (n2 == null) {
            n2 = 10;
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = ", ";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (Long l2 : collection) {
            if (n3 > 0) {
                stringBuilder.append(string3);
            }
            stringBuilder.append(string).append(Long.toString(l2, n2).toUpperCase()).append(string2);
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static boolean equals(Long l2, Long l3) {
        if (l2 == null) {
            return l3 == null;
        }
        if (l3 == null) {
            return l2 == null;
        }
        return l2.longValue() == l3.longValue();
    }

    public static boolean equals(Long l2, long l3) {
        if (l2 == null) {
            return false;
        }
        return l2 == l3;
    }

    public static boolean equals(long l2, Long l3) {
        if (l3 == null) {
            return false;
        }
        return l2 == l3;
    }

    public static Iterable<Long> range(final long l2, final long l3, final long l4) {
        return new Iterable<Long>(){

            @Override
            public Iterator<Long> iterator() {
                return new It(l2, l3, l4);
            }
        };
    }

    public static Iterable<Long> range(long l2, long l3) {
        return Longs.range(l2, l3, 1L);
    }

    public static Iterable<Long> range(long l2) {
        return Longs.range(0L, l2);
    }

    private static class It
    implements Iterator<Long> {
        long i;
        long end;
        long step;

        It(long l2, long l3, long l4) {
            Assert.a(l4 != 0L);
            this.i = l2;
            this.end = l3;
            this.step = l4;
        }

        @Override
        public boolean hasNext() {
            return this.step > 0L ? this.i < this.end : this.i > this.end;
        }

        @Override
        public Long next() {
            return this.i += this.step;
        }
    }
}

