/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.primitives;

import com.pnfsoftware.jeb.util.format.Strings;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class LargeIntHandler {
    private static Map<Integer, LargeIntHandler> map = new HashMap<Integer, LargeIntHandler>();
    private int bitsize;
    private BigInteger max;
    private BigInteger mask;

    public static LargeIntHandler create(int n2) {
        LargeIntHandler largeIntHandler = map.get(n2);
        if (largeIntHandler == null) {
            largeIntHandler = new LargeIntHandler(n2);
            map.put(n2, largeIntHandler);
        }
        return largeIntHandler;
    }

    private LargeIntHandler(int n2) {
        this.bitsize = n2;
        this.max = BigInteger.ONE.shiftLeft(n2);
        this.mask = this.max.subtract(BigInteger.ONE);
    }

    public int getBitsize() {
        return this.bitsize;
    }

    private void verifyBitlength(BigInteger bigInteger) {
        int n2 = bigInteger.bitLength() + 1;
        if (n2 > this.bitsize) {
            throw new RuntimeException(Strings.ff("Value %s does not fit properly on %d bits", bigInteger.toString(16), this.bitsize));
        }
    }

    private void verifyBitlength(BigInteger bigInteger, BigInteger bigInteger2) {
        this.verifyBitlength(bigInteger);
        this.verifyBitlength(bigInteger2);
    }

    public BigInteger create(String string) {
        BigInteger bigInteger = this.convert(string);
        this.verifyBitlength(bigInteger);
        return bigInteger;
    }

    public BigInteger truncate(String string) {
        return this.truncate(this.convert(string));
    }

    public BigInteger truncate(BigInteger bigInteger) {
        int n2 = bigInteger.bitLength() + 1;
        if (n2 > this.bitsize) {
            bigInteger = bigInteger.and(this.mask);
        }
        if ((n2 = bigInteger.bitLength() + 1) > this.bitsize && bigInteger.signum() == 1) {
            bigInteger = bigInteger.subtract(this.max);
        }
        this.verifyBitlength(bigInteger);
        return bigInteger;
    }

    private BigInteger convert(String string) {
        int n2 = 10;
        if ((string = string.trim()).startsWith("0x")) {
            n2 = 16;
            string = string.substring(2);
        } else if (string.endsWith("h")) {
            n2 = 16;
            string = string.substring(0, string.length() - 1);
        } else if (string.length() >= 2 && string.startsWith("0")) {
            n2 = 8;
            string = string.substring(1);
        }
        return new BigInteger(string, n2);
    }

    public BigInteger toUnsigned(BigInteger bigInteger) {
        this.verifyBitlength(bigInteger);
        if (bigInteger.signum() == -1) {
            bigInteger = bigInteger.add(this.max);
        }
        return bigInteger;
    }

    public BigInteger neg(BigInteger bigInteger) {
        this.verifyBitlength(bigInteger);
        BigInteger bigInteger2 = bigInteger.negate();
        return this.truncate(bigInteger2);
    }

    public BigInteger add(BigInteger bigInteger, BigInteger bigInteger2) {
        this.verifyBitlength(bigInteger, bigInteger2);
        BigInteger bigInteger3 = bigInteger.add(bigInteger2);
        return this.truncate(bigInteger3);
    }

    public BigInteger sub(BigInteger bigInteger, BigInteger bigInteger2) {
        this.verifyBitlength(bigInteger, bigInteger2);
        BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
        return this.truncate(bigInteger3);
    }

    public BigInteger mulS(BigInteger bigInteger, BigInteger bigInteger2) {
        this.verifyBitlength(bigInteger, bigInteger2);
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        return this.truncate(bigInteger3);
    }

    public BigInteger mulU(BigInteger bigInteger, BigInteger bigInteger2) {
        bigInteger = this.toUnsigned(bigInteger);
        bigInteger2 = this.toUnsigned(bigInteger2);
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        return this.truncate(bigInteger3);
    }

    public BigInteger mul2S(BigInteger bigInteger, BigInteger bigInteger2) {
        this.verifyBitlength(bigInteger, bigInteger2);
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        return LargeIntHandler.create(2 * this.bitsize).truncate(bigInteger3);
    }

    public BigInteger mul2U(BigInteger bigInteger, BigInteger bigInteger2) {
        bigInteger = this.toUnsigned(bigInteger);
        bigInteger2 = this.toUnsigned(bigInteger2);
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        return LargeIntHandler.create(2 * this.bitsize).truncate(bigInteger3);
    }

    public BigInteger divS(BigInteger bigInteger, BigInteger bigInteger2) {
        this.verifyBitlength(bigInteger, bigInteger2);
        BigInteger bigInteger3 = bigInteger.divide(bigInteger2);
        return this.truncate(bigInteger3);
    }

    public BigInteger divU(BigInteger bigInteger, BigInteger bigInteger2) {
        bigInteger = this.toUnsigned(bigInteger);
        bigInteger2 = this.toUnsigned(bigInteger2);
        BigInteger bigInteger3 = bigInteger.divide(bigInteger2);
        return this.truncate(bigInteger3);
    }

    public BigInteger remS(BigInteger bigInteger, BigInteger bigInteger2) {
        this.verifyBitlength(bigInteger, bigInteger2);
        BigInteger bigInteger3 = bigInteger.remainder(bigInteger2);
        return this.truncate(bigInteger3);
    }

    public BigInteger remU(BigInteger bigInteger, BigInteger bigInteger2) {
        bigInteger = this.toUnsigned(bigInteger);
        bigInteger2 = this.toUnsigned(bigInteger2);
        BigInteger bigInteger3 = bigInteger.remainder(bigInteger2);
        return this.truncate(bigInteger3);
    }

    public BigInteger[] div2S(BigInteger bigInteger, BigInteger bigInteger2) {
        LargeIntHandler.create(2 * this.bitsize).verifyBitlength(bigInteger);
        this.verifyBitlength(bigInteger2);
        BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger2);
        bigIntegerArray[0] = this.truncate(bigIntegerArray[0]);
        bigIntegerArray[1] = this.truncate(bigIntegerArray[1]);
        return bigIntegerArray;
    }

    public BigInteger[] div2U(BigInteger bigInteger, BigInteger bigInteger2) {
        bigInteger = LargeIntHandler.create(2 * this.bitsize).toUnsigned(bigInteger);
        bigInteger2 = this.toUnsigned(bigInteger2);
        BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger2);
        bigIntegerArray[0] = this.truncate(bigIntegerArray[0]);
        bigIntegerArray[1] = this.truncate(bigIntegerArray[1]);
        return bigIntegerArray;
    }

    public BigInteger and(BigInteger bigInteger, BigInteger bigInteger2) {
        this.verifyBitlength(bigInteger, bigInteger2);
        BigInteger bigInteger3 = bigInteger.and(bigInteger2);
        return this.truncate(bigInteger3);
    }

    public BigInteger or(BigInteger bigInteger, BigInteger bigInteger2) {
        this.verifyBitlength(bigInteger, bigInteger2);
        BigInteger bigInteger3 = bigInteger.or(bigInteger2);
        return this.truncate(bigInteger3);
    }

    public BigInteger not(BigInteger bigInteger) {
        this.verifyBitlength(bigInteger);
        BigInteger bigInteger2 = bigInteger.not();
        return this.truncate(bigInteger2);
    }

    public BigInteger xor(BigInteger bigInteger, BigInteger bigInteger2) {
        this.verifyBitlength(bigInteger, bigInteger2);
        BigInteger bigInteger3 = bigInteger.xor(bigInteger2);
        return this.truncate(bigInteger3);
    }

    public boolean testbit(BigInteger bigInteger, int n2) {
        this.verifyBitlength(bigInteger);
        return bigInteger.testBit(n2);
    }

    public BigInteger setbit(BigInteger bigInteger, int n2) {
        this.verifyBitlength(bigInteger);
        BigInteger bigInteger2 = bigInteger.setBit(n2);
        return this.truncate(bigInteger2);
    }

    public BigInteger clearbit(BigInteger bigInteger, int n2) {
        this.verifyBitlength(bigInteger);
        BigInteger bigInteger2 = bigInteger.clearBit(n2);
        return this.truncate(bigInteger2);
    }

    private int modBitsize(int n2) {
        if ((n2 %= this.bitsize) < 0) {
            n2 += this.bitsize;
        }
        return n2;
    }

    public BigInteger shl(BigInteger bigInteger, int n2) {
        this.verifyBitlength(bigInteger);
        n2 = this.modBitsize(n2);
        BigInteger bigInteger2 = bigInteger.shiftLeft(n2);
        return this.truncate(bigInteger2);
    }

    public BigInteger shr(BigInteger bigInteger, int n2) {
        bigInteger = this.toUnsigned(bigInteger);
        n2 = this.modBitsize(n2);
        BigInteger bigInteger2 = bigInteger.shiftRight(n2);
        return this.truncate(bigInteger2);
    }

    public BigInteger sar(BigInteger bigInteger, int n2) {
        this.verifyBitlength(bigInteger);
        n2 = this.modBitsize(n2);
        BigInteger bigInteger2 = bigInteger.shiftRight(n2);
        return this.truncate(bigInteger2);
    }

    public BigInteger ror(BigInteger bigInteger, int n2) {
        bigInteger = this.toUnsigned(bigInteger);
        n2 = this.modBitsize(n2);
        BigInteger bigInteger2 = bigInteger.shiftRight(n2).or(bigInteger.shiftLeft(this.bitsize - n2));
        return this.truncate(bigInteger2);
    }

    public BigInteger rol(BigInteger bigInteger, int n2) {
        bigInteger = this.toUnsigned(bigInteger);
        n2 = this.modBitsize(n2);
        BigInteger bigInteger2 = bigInteger.shiftLeft(n2).or(bigInteger.shiftRight(this.bitsize - n2));
        return this.truncate(bigInteger2);
    }

    public int compare(BigInteger bigInteger, BigInteger bigInteger2) {
        this.verifyBitlength(bigInteger, bigInteger2);
        return bigInteger.compareTo(bigInteger2);
    }

    public int compareU(BigInteger bigInteger, BigInteger bigInteger2) {
        bigInteger = this.toUnsigned(bigInteger);
        bigInteger2 = this.toUnsigned(bigInteger2);
        return bigInteger.compareTo(bigInteger2);
    }

    public String toUnsignedHexString(BigInteger bigInteger) {
        return this.toUnsigned(bigInteger).toString(16).toUpperCase();
    }
}

