/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.primitives;

import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.primitives.Longs;
import java.util.Collection;
import java.util.Iterator;

public class Integers {
    public static String toUnsignedString(int n2) {
        return Longs.toUnsignedString((long)n2 & 0xFFFFFFFFL);
    }

    public static int safeInt(Integer n2) {
        return Integers.safeInt(n2, 0);
    }

    public static Integer safeInt(Integer n2, int n3) {
        return n2 == null ? n3 : n2;
    }

    public static Integer min(Collection<Integer> collection) {
        Integer n2 = null;
        for (Integer n3 : collection) {
            if (n2 != null && n3.compareTo(n2) >= 0) continue;
            n2 = n3;
        }
        return n2;
    }

    public static Integer max(Collection<Integer> collection) {
        Integer n2 = null;
        for (Integer n3 : collection) {
            if (n2 != null && n3.compareTo(n2) <= 0) continue;
            n2 = n3;
        }
        return n2;
    }

    public static String formatIntegerCollection(Collection<Integer> collection, Integer n2, String string, String string2) {
        return Integers.formatIntegerCollection(collection, n2, string, string2, null);
    }

    public static String formatHexIntegerCollection(Collection<Integer> collection) {
        return Integers.formatIntegerCollection(collection, 16, "0x", null);
    }

    public static String formatIntegerCollection(Collection<Integer> collection, Integer n2, String string, String string2, String string3) {
        if (n2 == null) {
            n2 = 10;
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = ", ";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (int n4 : collection) {
            if (n3 > 0) {
                stringBuilder.append(string3);
            }
            stringBuilder.append(string).append(Integer.toString(n4, n2).toUpperCase()).append(string2);
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static Iterable<Integer> range(final int n2, final int n3, final int n4) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new It(n2, n3, n4);
            }
        };
    }

    public static Iterable<Integer> range(int n2, int n3) {
        return Integers.range(n2, n3, 1);
    }

    public static Iterable<Integer> range(int n2) {
        return Integers.range(0, n2);
    }

    private static class It
    implements Iterator<Integer> {
        int i;
        int end;
        int step;

        It(int n2, int n3, int n4) {
            Assert.a(n4 != 0);
            this.i = n2;
            this.end = n3;
            this.step = n4;
        }

        @Override
        public boolean hasNext() {
            return this.step > 0 ? this.i < this.end : this.i > this.end;
        }

        @Override
        public Integer next() {
            return this.i++;
        }
    }
}

