/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.net;

import com.pnfsoftware.jeb.util.base.IProgressCallback;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.net.FormFileEntry;
import com.pnfsoftware.jeb.util.net.INet;
import com.pnfsoftware.jeb.util.net.NetProxyInfo;
import com.pnfsoftware.jeb.util.net.ProgressResponseBody;
import com.pnfsoftware.jeb.util.net.SecureSocketInfo;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.NetworkInterface;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class Net
implements INet {
    private static final ILogger logger = GlobalLog.getLogger(Net.class);
    private static NetProxyInfo proxyinfoStandard;
    private String userAgent;
    private int timeoutConnect;
    private int timeoutRead;
    private int timeoutWrite;
    private SecureSocketInfo ssinfo;

    public static void setGlobalProxyInformation(NetProxyInfo netProxyInfo) {
        if (netProxyInfo != null && !netProxyInfo.isProxy()) {
            netProxyInfo = null;
        }
        proxyinfoStandard = netProxyInfo;
        logger.debug("Proxy settings: %s", netProxyInfo == null || !netProxyInfo.isProxy() ? "(none)" : netProxyInfo);
        if (netProxyInfo != null && netProxyInfo.hasCredentials()) {
            final String string = netProxyInfo.getUser();
            final String string2 = netProxyInfo.getPassword();
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    String string3 = this.getRequestingProtocol().toLowerCase();
                    Object[] objectArray = new Object[]{string3, string, string2};
                    return new PasswordAuthentication(string, string2.toCharArray());
                }
            });
        } else {
            Authenticator.setDefault(null);
        }
    }

    public static NetProxyInfo getGlobalProxyInformation() {
        return proxyinfoStandard;
    }

    public Net() {
        this.setUserAgent("PNF Software UP");
        this.setConnectTimeout(60000);
        this.setReadTimeout(30000);
        this.setWriteTimeout(120000);
    }

    public Net(Net net) {
        this.setUserAgent(net.getUserAgent());
        this.setConnectTimeout(net.getConnectTimeout());
        this.setReadTimeout(net.getReadTimeout());
        this.setWriteTimeout(net.getWriteTimeout());
        this.setSecureSocketInfo(net.getSecureSocketInfo());
    }

    @Override
    public INet duplicate() {
        return new Net(this);
    }

    public NetProxyInfo getProxyInformation() {
        return Net.getGlobalProxyInformation();
    }

    @Override
    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public void setConnectTimeout(int n2) {
        this.timeoutConnect = n2;
    }

    @Override
    public int getConnectTimeout() {
        return this.timeoutConnect;
    }

    @Override
    public void setReadTimeout(int n2) {
        this.timeoutRead = n2;
    }

    @Override
    public int getReadTimeout() {
        return this.timeoutRead;
    }

    @Override
    public void setWriteTimeout(int n2) {
        this.timeoutWrite = n2;
    }

    @Override
    public int getWriteTimeout() {
        return this.timeoutWrite;
    }

    @Override
    public SecureSocketInfo getSecureSocketInfo() {
        return this.ssinfo;
    }

    @Override
    public void setSecureSocketInfo(SecureSocketInfo secureSocketInfo) {
        this.ssinfo = secureSocketInfo;
    }

    OkHttpClient buildClient(String string) {
        return this.buildClient(string, null);
    }

    OkHttpClient buildClient(String string, final IProgressCallback iProgressCallback) {
        SSLContext sSLContext;
        NetProxyInfo netProxyInfo;
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout((long)this.timeoutConnect, TimeUnit.MILLISECONDS).readTimeout((long)this.timeoutRead, TimeUnit.MILLISECONDS).writeTimeout((long)this.timeoutWrite, TimeUnit.MILLISECONDS);
        if (iProgressCallback != null) {
            builder.addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), iProgressCallback)).build();
                }
            });
        }
        if ((netProxyInfo = this.getProxyInformation()) != null && !netProxyInfo.isWhitelisted(string)) {
            builder.proxy(netProxyInfo.getProxy());
            sSLContext = netProxyInfo.getAuthenticator();
            if (sSLContext != null) {
                builder.proxyAuthenticator((okhttp3.Authenticator)sSLContext);
            }
        }
        if (this.ssinfo != null) {
            sSLContext = this.ssinfo.getSslContext();
            if (this.ssinfo.getTrustManager() != null) {
                builder.sslSocketFactory(sSLContext.getSocketFactory(), this.ssinfo.getTrustManager());
            } else {
                builder.sslSocketFactory(sSLContext.getSocketFactory());
            }
            if (this.ssinfo.getHostnameVerifier() != null) {
                builder.hostnameVerifier(this.ssinfo.getHostnameVerifier());
            }
        }
        return builder.build();
    }

    Request buildRequest(String string, RequestBody requestBody) {
        Request.Builder builder = new Request.Builder().url(string).addHeader("User-Agent", this.userAgent);
        if (requestBody != null) {
            builder.post(requestBody);
        }
        return builder.build();
    }

    String sendSyncRequest(OkHttpClient okHttpClient, Request request, Map<String, String> map) throws IOException {
        try (Response response = okHttpClient.newCall(request).execute();){
            if (map != null) {
                for (String string : new HashSet<String>(map.keySet())) {
                    map.put(string, response.header(string));
                }
            }
            if (!response.isSuccessful()) {
                throw new IOException("Query failed with response code " + response.code());
            }
            String string = response.body().string();
            return string;
        }
    }

    @Override
    public String post(String string, Map<String, String> map, Map<String, String> map2, Map<String, String> map3) throws IOException {
        OkHttpClient okHttpClient = this.buildClient(string);
        try {
            String string22;
            FormBody.Builder builder = new FormBody.Builder();
            if (map2 != null) {
                for (String string22 : map2.keySet()) {
                    builder.add(string22, map2.get(string22));
                }
            }
            FormBody formBody = builder.build();
            (new Object[1])[0] = string;
            string22 = this.buildRequest(string, (RequestBody)formBody);
            String string3 = this.sendSyncRequest(okHttpClient, (Request)string22, map3);
            return string3;
        }
        finally {
            okHttpClient.connectionPool().evictAll();
        }
    }

    @Override
    public String post(String string, Map<String, String> map, Map<String, String> map2) throws IOException {
        return this.post(string, map, map2, null);
    }

    @Override
    public String postMultipart(String string, Map<String, String> map, Map<String, FormFileEntry> map2, Map<String, String> map3) throws IOException {
        OkHttpClient okHttpClient = this.buildClient(string);
        try {
            Object object;
            String string22;
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            if (map != null) {
                for (String string22 : map.keySet()) {
                    object = map.get(string22);
                    builder.addFormDataPart(string22, (String)object);
                }
            }
            if (map2 != null) {
                for (String string22 : map2.keySet()) {
                    object = map2.get(string22);
                    builder.addFormDataPart(string22, ((FormFileEntry)object).getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])IO.readFile(((FormFileEntry)object).getFile())));
                }
            }
            MultipartBody multipartBody = builder.build();
            (new Object[1])[0] = string;
            string22 = this.buildRequest(string, (RequestBody)multipartBody);
            object = this.sendSyncRequest(okHttpClient, (Request)string22, map3);
            return object;
        }
        finally {
            okHttpClient.connectionPool().evictAll();
        }
    }

    @Override
    public String postMultipart(String string, Map<String, String> map, Map<String, FormFileEntry> map2) throws IOException {
        return this.postMultipart(string, map, map2, null);
    }

    @Override
    public String query(String string, Map<String, String> map, Map<String, String> map2) throws IOException {
        OkHttpClient okHttpClient = this.buildClient(string);
        try {
            HttpUrl.Builder builder;
            if (map != null) {
                builder = HttpUrl.parse((String)string).newBuilder();
                for (String string2 : map.keySet()) {
                    builder.addQueryParameter(string2, map.get(string2));
                }
                string = builder.build().toString();
            }
            (new Object[1])[0] = string;
            builder = this.buildRequest(string, null);
            String string3 = this.sendSyncRequest(okHttpClient, (Request)builder, map2);
            return string3;
        }
        finally {
            okHttpClient.connectionPool().evictAll();
        }
    }

    @Override
    public String query(String string, Map<String, String> map) throws IOException {
        return this.query(string, map, null);
    }

    @Override
    public String query(String string) throws IOException {
        return this.query(string, null, null);
    }

    @Override
    public byte[] queryBinary(String string, Map<String, String> map, Map<String, String> map2, IProgressCallback iProgressCallback) throws IOException {
        HttpUrl.Builder builder;
        OkHttpClient okHttpClient = this.buildClient(string, iProgressCallback);
        if (map != null) {
            builder = HttpUrl.parse((String)string).newBuilder();
            for (String object : map.keySet()) {
                builder.addQueryParameter(object, map.get(object));
            }
            string = builder.build().toString();
        }
        (new Object[1])[0] = string;
        builder = this.buildRequest(string, null);
        try {
            byte[] byArray;
            block14: {
                Response response = okHttpClient.newCall((Request)builder).execute();
                try {
                    if (map2 != null) {
                        for (String string2 : new HashSet<String>(map2.keySet())) {
                            map2.put(string2, response.header(string2));
                        }
                    }
                    if (!response.isSuccessful()) {
                        throw new IOException("Query failed with response code " + response.code());
                    }
                    byArray = response.body().bytes();
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return byArray;
        }
        finally {
            okHttpClient.connectionPool().evictAll();
        }
    }

    @Override
    public byte[] queryBinary(String string, Map<String, String> map, Map<String, String> map2) throws IOException {
        return this.queryBinary(string, map, map2, null);
    }

    @Override
    public byte[] queryBinary(String string, Map<String, String> map) throws IOException {
        return this.queryBinary(string, map, null);
    }

    @Override
    public byte[] queryBinary(String string) throws IOException {
        return this.queryBinary(string, null, null);
    }

    /*
     * Exception decompiling
     */
    @Override
    public long downloadBinary(File var1_1, String var2_2, Map<String, String> var3_3, Map<String, String> var4_4, IProgressCallback var5_5) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static long convertHttpDateToEpoch(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        try {
            Date date = simpleDateFormat.parse(string);
            return date.getTime();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static boolean isConnectedToNetwork() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isConnectedToInternet() {
        boolean bl;
        Socket socket = null;
        try {
            Proxy proxy;
            String string = "8.8.8.8";
            int n2 = 53;
            NetProxyInfo netProxyInfo = Net.getGlobalProxyInformation();
            if (netProxyInfo != null && (proxy = netProxyInfo.getProxy()) != Proxy.NO_PROXY) {
                string = netProxyInfo.getHostname();
                n2 = netProxyInfo.getPort();
            }
            socket = new Socket(string, n2);
            bl = true;
            if (socket == null) return bl;
        }
        catch (Exception exception) {
            boolean bl2 = false;
            if (socket == null) return bl2;
            try {
                socket.close();
                return bl2;
            }
            catch (IOException iOException) {}
            return bl2;
        }
        catch (Throwable throwable) {
            if (socket == null) throw throwable;
            try {
                socket.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            socket.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
    }
}

