/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.math;

import java.util.Collection;

public class MathUtil {
    public static boolean almostEquals(double d, double d2) {
        return Math.abs(d - d2) <= 1.0E-7;
    }

    public static boolean almostEquals(double d, double d2, double d3) {
        return Math.abs(d - d2) <= d3;
    }

    public static long makeMask(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Bitsize must be >= 0: " + n2);
        }
        if (n2 > 64) {
            throw new IllegalArgumentException("Bitsize must be <= 64: " + n2);
        }
        return n2 == 64 ? -1L : (1L << n2) - 1L;
    }

    public static long makeInverseMask(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Bitsize must be >= 0: " + n2);
        }
        if (n2 > 64) {
            throw new IllegalArgumentException("Bitsize must be <= 64: " + n2);
        }
        return n2 == 64 ? 0L : (1L << n2) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long makeOverflow(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Bitsize must be >= 0: " + n2);
        }
        if (n2 > 64) {
            throw new IllegalArgumentException("Bitsize must be <= 64: " + n2);
        }
        return n2 == 64 ? 0L : 1L << n2;
    }

    public static boolean betweenExclusive(long l2, long l3, long l4) {
        return l2 > l3 && l2 < l4;
    }

    public static boolean betweenInclusive(long l2, long l3, long l4) {
        return l2 >= l3 && l2 <= l4;
    }

    public static int minPositive(int ... nArray) {
        int n2 = nArray[0];
        for (int n3 : nArray) {
            if (n2 < 0) {
                n2 = Math.max(n3, n2);
                continue;
            }
            if (n3 <= 0) continue;
            n2 = Math.min(n3, n2);
        }
        return n2;
    }

    private static long signExtend(long l2, int n2, int n3) {
        if (n3 != 32 && n3 != 64) {
            throw new IllegalArgumentException("unsupported size for sign extension: " + n3);
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("bitsize must be <= " + n3 + " (was " + n2 + ")");
        }
        if (n2 < n3) {
            long l3 = (1L << n2) - 1L;
            l2 = (l2 & 1L << n2 - 1) != 0L ? (l2 |= l3 ^ 0xFFFFFFFFFFFFFFFFL) : (l2 &= l3);
        }
        return l2;
    }

    public static long signExtend32(long l2, int n2) {
        return MathUtil.signExtend(l2, n2, 32);
    }

    public static int signExtend32(int n2, int n3) {
        return (int)MathUtil.signExtend(n2, n3, 32);
    }

    public static long signExtend(long l2, int n2) {
        return MathUtil.signExtend(l2, n2, 64);
    }

    private static long zeroExtend(long l2, int n2, int n3) {
        if (n3 != 32 && n3 != 64) {
            throw new IllegalArgumentException("unsupported size for zero extension: " + n3);
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("bitsize must be <= " + n3 + " (was " + n2 + ")");
        }
        if (n2 < n3) {
            l2 &= (1L << n2) - 1L;
        }
        return l2;
    }

    public static long zeroExtend32(long l2, int n2) {
        return MathUtil.zeroExtend(l2, n2, 32);
    }

    public static long zeroExtend(long l2, int n2) {
        return MathUtil.zeroExtend(l2, n2, 64);
    }

    public static int msb(long l2, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Bitsize must be >= 0: " + n2);
        }
        if (n2 > 64) {
            throw new IllegalArgumentException("Bitsize must be <= 64: " + n2);
        }
        return (int)(l2 >>> n2 - 1 & 1L);
    }

    public static int pow(int n2, int n3) {
        if (n3 == 0) {
            return 1;
        }
        if (n3 == 1) {
            return n2;
        }
        if (n3 < 0) {
            if (n2 == 0) {
                throw new IllegalArgumentException("Can not compute 0 pow " + n3);
            }
            if (n2 == 1) {
                return 1;
            }
            return 0;
        }
        int n4 = n2;
        for (int i = 1; i < n3; ++i) {
            n4 *= n2;
        }
        return n4;
    }

    public static long pow(long l2, long l3) {
        if (l3 == 0L) {
            return 1L;
        }
        if (l3 == 1L) {
            return l2;
        }
        if (l3 < 0L) {
            if (l2 == 0L) {
                throw new IllegalArgumentException("Can not compute 0 pow " + l3);
            }
            if (l2 == 1L) {
                return 1L;
            }
            return 0L;
        }
        long l4 = l2;
        for (long i = 1L; i < l3; ++i) {
            l4 *= l2;
        }
        return l4;
    }

    public static long unmaskedShiftLeft(long l2, int n2) {
        if (n2 >= 64) {
            return 0L;
        }
        return l2 << n2;
    }

    public static long unmaskedShiftRight(long l2, int n2) {
        if (n2 >= 64) {
            return 0L;
        }
        return l2 >>> n2;
    }

    public static long unmaskedArithShiftRight(long l2, int n2) {
        if (n2 >= 64) {
            return l2 < 0L ? -1L : 0L;
        }
        return l2 >> n2;
    }

    public static int moduloPositive(int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("The divisor must be positive");
        }
        int n4 = n2 % n3;
        if (n4 < 0) {
            n4 += n3;
        }
        return n4;
    }

    public static double avg(Collection<? extends Number> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException();
        }
        double d = 0.0;
        int n2 = 1;
        for (Number number : collection) {
            d += (number.doubleValue() - d) / (double)n2;
            ++n2;
        }
        return d;
    }

    public static double avg(byte[] byArray) {
        if (byArray.length == 0) {
            throw new IllegalArgumentException();
        }
        double d = 0.0;
        for (int i = 0; i < byArray.length; ++i) {
            d += ((double)byArray[i] - d) / (double)(i + 1);
        }
        return d;
    }

    public static double avg(char[] cArray) {
        if (cArray.length == 0) {
            throw new IllegalArgumentException();
        }
        double d = 0.0;
        for (int i = 0; i < cArray.length; ++i) {
            d += ((double)cArray[i] - d) / (double)(i + 1);
        }
        return d;
    }

    public static double avg(short[] sArray) {
        if (sArray.length == 0) {
            throw new IllegalArgumentException();
        }
        double d = 0.0;
        for (int i = 0; i < sArray.length; ++i) {
            d += ((double)sArray[i] - d) / (double)(i + 1);
        }
        return d;
    }

    public static double avg(int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += ((double)nArray[i] - d) / (double)(i + 1);
        }
        return d;
    }

    public static double avg(long[] lArray) {
        if (lArray.length == 0) {
            throw new IllegalArgumentException();
        }
        double d = 0.0;
        for (int i = 0; i < lArray.length; ++i) {
            d += ((double)lArray[i] - d) / (double)(i + 1);
        }
        return d;
    }

    public static double avg(float[] fArray) {
        if (fArray.length == 0) {
            throw new IllegalArgumentException();
        }
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            d += ((double)fArray[i] - d) / (double)(i + 1);
        }
        return d;
    }

    public static double avg(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException();
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += (dArray[i] - d) / (double)(i + 1);
        }
        return d;
    }

    public static boolean isPowerOfTwo(int n2) {
        return n2 > 0 && (n2 & n2 - 1) == 0;
    }

    public static boolean isPowerOfTwo(long l2) {
        return l2 > 0L && (l2 & l2 - 1L) == 0L;
    }

    public static int log2(int n2) {
        if ((long)n2 <= 0L) {
            throw new IllegalArgumentException();
        }
        int n3 = 0;
        while (n2 > 1) {
            n2 >>>= 1;
            ++n3;
        }
        return n3;
    }

    public static int log2(long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        while (l2 > 1L) {
            l2 >>>= 1;
            ++n2;
        }
        return n2;
    }

    public static int bitcount(int n2) {
        int n3 = 0;
        while (n2 != 0) {
            if ((n2 & 1) != 0) {
                ++n3;
            }
            n2 >>>= 1;
        }
        return n3;
    }

    public static int bitcount(long l2) {
        int n2 = 0;
        while (l2 != 0L) {
            if ((l2 & 1L) != 0L) {
                ++n2;
            }
            l2 >>>= 1;
        }
        return n2;
    }
}

