/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.logging;

import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TimeFormatter;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.StructuredLogger;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

class StructuredLoggerHtmlGenerator {
    private static final String stylesheet;
    StructuredLogger log;
    boolean genTimestampInfo;
    boolean genCallerInfo;

    StructuredLoggerHtmlGenerator(StructuredLogger structuredLogger, boolean bl, boolean bl2) {
        this.log = structuredLogger;
        this.genTimestampInfo = bl;
        this.genCallerInfo = bl2;
    }

    public String generate(FileOutputStream fileOutputStream, Charset charset) {
        StringBuilder stringBuilder = new StringBuilder(Strings.ff("<!DOCTYPE html>\n<html>\n<head>\n<title>JEB Debug Log</title>\n<style>\n%s\n</style>\n</head>\n<body>\n", stylesheet));
        Strings.ff(stringBuilder, "<h1>%s</h1>\n", this.log.rootEntry.text);
        this.gen(this.log.rootEntry, stringBuilder, 0, fileOutputStream, charset);
        stringBuilder.append("</body>\n</html>");
        if (fileOutputStream != null) {
            this.write(stringBuilder, fileOutputStream, charset);
        }
        return stringBuilder.toString();
    }

    private void write(StringBuilder stringBuilder, FileOutputStream fileOutputStream, Charset charset) {
        byte[] byArray = stringBuilder.toString().getBytes(charset);
        try {
            fileOutputStream.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Can not write buffer", iOException);
        }
        stringBuilder.delete(0, stringBuilder.length());
    }

    public String generate() {
        return this.generate(null, null);
    }

    private void gen(StructuredLogger.Entry entry, StringBuilder stringBuilder, int n2, FileOutputStream fileOutputStream, Charset charset) {
        if (entry.sub == null) {
            String string;
            StringBuilder stringBuilder2 = new StringBuilder();
            StringBuilder stringBuilder3 = new StringBuilder();
            if (entry.importance != 10) {
                if (this.genTimestampInfo) {
                    stringBuilder2.append("<span class='timestamp'>(").append(TimeFormatter.formatTimestampDelta(entry.timestamp - this.log.ts0)).append(")</span> ");
                }
                if (this.genCallerInfo) {
                    if (entry.caller == null) {
                        stringBuilder3.append("?");
                    } else {
                        stringBuilder3.append("<span class='caller'>[").append(this.escape(entry.caller)).append("]</span> ");
                    }
                }
            }
            Object object = "";
            String string2 = this.importanceToClass(entry.importance);
            if (!string2.isEmpty()) {
                object = (String)object + string2;
            }
            if (!(string = this.levelToClass(entry.level)).isEmpty()) {
                object = (String)object + " " + string;
            }
            StringBuilder stringBuilder4 = new StringBuilder();
            stringBuilder4.append("<span class='").append((String)object).append("'>");
            stringBuilder4.append((CharSequence)stringBuilder2).append((CharSequence)stringBuilder3).append(this.escape(entry.text)).append("</span><br>");
            this.appendLine(stringBuilder, n2, stringBuilder4);
            if (fileOutputStream != null) {
                this.write(stringBuilder, fileOutputStream, charset);
            }
            return;
        }
        for (StructuredLogger.Entry entry2 : entry.sub) {
            if (stringBuilder.length() > 0x10000000) {
                this.appendLine(stringBuilder, n2 + 1, "[...]");
                return;
            }
            if (entry2.sub == null) {
                this.gen(entry2, stringBuilder, n2 + 1, fileOutputStream, charset);
                continue;
            }
            String string = entry2.open ? " open" : "";
            this.appendLine(stringBuilder, n2 + 1, "<details%s><summary>%s</summary>", string, this.escape(entry2.text));
            this.appendLine(stringBuilder, n2 + 1, "<div class='logsection'>");
            this.gen(entry2, stringBuilder, n2 + 1, fileOutputStream, charset);
            this.appendLine(stringBuilder, n2 + 1, "</div>");
            this.appendLine(stringBuilder, n2 + 1, "</details>");
        }
    }

    private String importanceToClass(int n2) {
        switch (n2) {
            case -1: {
                return "logimp-small";
            }
            case 0: {
                return "logimp-normal";
            }
            case 1: {
                return "logimp-highlight";
            }
            case 2: {
                return "logimp-section";
            }
            case 3: {
                return "logimp-subtitle";
            }
            case 4: {
                return "logimp-title";
            }
            case 5: {
                return "logimp-chapter";
            }
        }
        return "";
    }

    private String levelToClass(int n2) {
        switch (n2) {
            case 60: {
                return "loglevel-critical";
            }
            case 50: {
                return "loglevel-error";
            }
            case 40: {
                return "loglevel-warn";
            }
            case 30: {
                return "loglevel-info";
            }
            case 20: {
                return "loglevel-debug";
            }
            case 10: {
                return "loglevel-trace";
            }
        }
        return "";
    }

    private void appendLine(StringBuilder stringBuilder, int n2, String string, Object ... objectArray) {
        this.appendLine(stringBuilder, n2, objectArray == null || objectArray.length == 0 ? string : Strings.ff(string, objectArray));
    }

    private void appendLine(StringBuilder stringBuilder, int n2, CharSequence charSequence) {
        stringBuilder.append(Strings.generate(' ', n2 * 2));
        stringBuilder.append(charSequence);
        stringBuilder.append('\n');
    }

    private String escape(String string) {
        string = Formatter.htmlEscape(string);
        string = string.replace("\t", "    ");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == ' ' && i + 1 < string.length() && string.charAt(i + 1) == ' ') {
                stringBuilder.append("&nbsp;");
                continue;
            }
            stringBuilder.append(c2);
        }
        string = stringBuilder.toString();
        string = string.replaceAll("(\r\n|\r|\n)", "<br>");
        return string;
    }

    static {
        try {
            stylesheet = Strings.decodeUTF8(IO.readInputStream(StructuredLogger.class.getResourceAsStream("slstyles.css")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot retrieve html style sheet for the structured logger", iOException);
        }
    }
}

