/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.logging;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.logging.StructuredLoggerHtmlGenerator;
import java.io.FileOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class StructuredLogger
implements ILogger {
    private static final String thisClassName = StructuredLogger.class.getName();
    private boolean slEnabled;
    private boolean rlEnabled;
    long ts0 = System.currentTimeMillis();
    Entry rootEntry;
    Entry currentEntry;
    int entryCount;

    public StructuredLogger(String string) {
        this(string, true, true);
    }

    public StructuredLogger(String string, boolean bl, boolean bl2) {
        this.currentEntry = this.rootEntry = Entry.createSection(null, string, true);
        this.slEnabled = bl;
        this.rlEnabled = bl2;
    }

    public boolean isStructuredLoggingEnabled() {
        return this.slEnabled;
    }

    public boolean isRegularLoggingEnabled() {
        return this.rlEnabled;
    }

    public boolean hasStructuredContents() {
        return this.entryCount > 0;
    }

    public void beginSection(String string, boolean bl) {
        if (!this.slEnabled) {
            return;
        }
        Entry entry = Entry.createSection(this.currentEntry, string, bl);
        this.currentEntry.sub.add(entry);
        this.currentEntry = entry;
        ++this.entryCount;
    }

    public void beginSection(String string) {
        this.beginSection(string, false);
    }

    public void closeSection() {
        if (!this.slEnabled) {
            return;
        }
        if (this.currentEntry.parent == null) {
            throw new IllegalStateException("The root entry cannot be closed");
        }
        this.currentEntry = this.currentEntry.parent;
    }

    public String generateHtml() {
        return new StructuredLoggerHtmlGenerator(this, true, true).generate();
    }

    public void generateHtml(FileOutputStream fileOutputStream, Charset charset) {
        new StructuredLoggerHtmlGenerator(this, true, true).generate(fileOutputStream, charset);
    }

    @Override
    public String getName() {
        return this.rootEntry.text;
    }

    public void setName(String string) {
        this.rootEntry.text = string;
    }

    @Override
    public void setEnabledLevel(int n2) {
    }

    @Override
    public int getEnabledLevel() {
        return 0;
    }

    @Override
    public void log(int n2, boolean bl, String string, Object ... objectArray) {
        this.log(0, n2, bl, string, objectArray);
    }

    public void log(int n2, int n3, boolean bl, String string, Object ... objectArray) {
        String string2;
        if (!this.slEnabled && !this.rlEnabled) {
            return;
        }
        String string3 = string2 = objectArray.length == 0 ? string : Strings.ff(string, objectArray);
        if (this.slEnabled) {
            Object object;
            int n4;
            long l2 = System.currentTimeMillis();
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            boolean bl2 = false;
            for (n4 = 1; n4 < stackTraceElementArray.length; ++n4) {
                boolean bl3 = Strings.equals(stackTraceElementArray[n4].getClassName(), thisClassName);
                if (bl3 && !bl2) {
                    bl2 = true;
                }
                if (!bl3 && bl2 && !stackTraceElementArray[n4].getClassName().toLowerCase().endsWith("log")) break;
            }
            String string4 = null;
            if (n4 < stackTraceElementArray.length) {
                object = stackTraceElementArray[n4].getClassName();
                int n5 = ((String)object).lastIndexOf(46);
                Object object2 = n5 < 0 ? object : ((String)object).substring(n5 + 1);
                int n6 = stackTraceElementArray[n4].getLineNumber();
                string4 = Strings.ff("%s:%d", object2, n6);
            }
            object = Entry.createLine(n2, n3, string2, string4, l2);
            this.currentEntry.sub.add((Entry)object);
        }
        if (this.rlEnabled) {
            GlobalLog.getLogger().log(n3, bl, string, objectArray);
        }
    }

    @Override
    public void i(String string, Object ... objectArray) {
    }

    public void iH(String string, Object ... objectArray) {
    }

    public void iHH(String string, Object ... objectArray) {
    }

    public void iHHH(String string, Object ... objectArray) {
    }

    public void iHHHH(String string, Object ... objectArray) {
    }

    public void iHHHHH(String string, Object ... objectArray) {
    }

    public void iL(String string, Object ... objectArray) {
    }

    public void i(int n2, String string, Object ... objectArray) {
    }

    public void iBreak() {
    }

    public void iBreak(int n2) {
    }

    public void iSeparator() {
    }

    @Override
    public void trace(String string, Object ... objectArray) {
        this.log(10, false, string, objectArray);
    }

    @Override
    public void fine(String string, Object ... objectArray) {
        this.trace(string, objectArray);
    }

    @Override
    public void debug(String string, Object ... objectArray) {
        this.log(20, false, string, objectArray);
    }

    @Override
    public void info(String string, Object ... objectArray) {
        this.log(30, false, string, objectArray);
    }

    @Override
    public void warn(String string, Object ... objectArray) {
        this.log(40, false, string, objectArray);
    }

    @Override
    public void warning(String string, Object ... objectArray) {
        this.warn(string, objectArray);
    }

    @Override
    public void error(String string, Object ... objectArray) {
        this.log(50, false, string, objectArray);
    }

    @Override
    public void severe(String string, Object ... objectArray) {
        this.error(string, objectArray);
    }

    @Override
    public void catching(Throwable throwable) {
        GlobalLog.catching(this, throwable);
    }

    @Override
    public void catching(Throwable throwable, String string) {
        GlobalLog.catching(this, throwable, string);
    }

    @Override
    public void catching(Throwable throwable, String string, Object ... objectArray) {
        GlobalLog.catching(this, throwable, Strings.ff(string, objectArray));
    }

    @Override
    public void catchingSilent(Throwable throwable) {
        GlobalLog.catchingDebug(this, throwable);
    }

    @Override
    public void status(String string, Object ... objectArray) {
        GlobalLog.status(string, objectArray);
    }

    static class Entry {
        int importance;
        int level;
        String text;
        String caller;
        long timestamp;
        Entry parent;
        List<Entry> sub;
        boolean open;

        Entry() {
        }

        public static Entry createLine(int n2, int n3, String string, String string2, long l2) {
            Entry entry = new Entry();
            entry.importance = n2;
            entry.level = n3;
            entry.text = string;
            entry.caller = string2;
            entry.timestamp = l2;
            return entry;
        }

        public static Entry createSection(Entry entry, String string, boolean bl) {
            Entry entry2 = new Entry();
            entry2.parent = entry;
            entry2.text = string;
            entry2.sub = new ArrayList<Entry>();
            entry2.open = bl;
            return entry2;
        }
    }
}

