/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.logging;

import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class StatusLogDrip {
    ILogger logger;
    long period;
    long lastSendTs;

    public StatusLogDrip(long l2, ILogger iLogger) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException();
        }
        this.period = l2;
        if (iLogger == null) {
            iLogger = GlobalLog.getLogger();
        }
        this.logger = iLogger;
    }

    public boolean canSend() {
        long l2 = System.currentTimeMillis();
        return this.lastSendTs == 0L || l2 - this.lastSendTs >= this.period;
    }

    public boolean log(String string, Object ... objectArray) {
        long l2 = System.currentTimeMillis();
        if (this.lastSendTs == 0L || l2 - this.lastSendTs >= this.period) {
            GlobalLog.status(string, objectArray);
            this.lastSendTs = l2;
            return true;
        }
        return false;
    }

    public void forceLog(String string, Object ... objectArray) {
        long l2 = System.currentTimeMillis();
        GlobalLog.status(string, objectArray);
        this.lastSendTs = l2;
    }
}

