/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.logging;

import com.pnfsoftware.jeb.util.format.CharSequences;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.BufferSink;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.logging.LogStatusSink;
import com.pnfsoftware.jeb.util.logging.Sink;
import com.pnfsoftware.jeb.util.logging.StreamSink;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

class SimpleLogger
implements ILogger {
    private String name;
    private int cutoffLevel;

    public SimpleLogger(String string, int n2) {
        this.name = string;
        this.cutoffLevel = n2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setEnabledLevel(int n2) {
        this.cutoffLevel = n2;
    }

    @Override
    public int getEnabledLevel() {
        return this.cutoffLevel;
    }

    @Override
    public void log(int n2, boolean bl, String string, Object ... objectArray) {
        StringBuilder stringBuilder;
        Object object;
        Iterator<BufferSink> iterator;
        if (n2 == Integer.MAX_VALUE) {
            return;
        }
        if (n2 < 60 && (n2 < this.cutoffLevel || n2 < GlobalLog.getCutoffLevel() || GlobalLog.isGloballyDisabled(this))) {
            return;
        }
        if (n2 == 100 ? GlobalLog.outStatusSinks.isEmpty() : GlobalLog.outStreams.isEmpty() && GlobalLog.outBuffers.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        if (objectArray.length == 0) {
            stringBuilder2.append(string);
        } else {
            try {
                Strings.ff(Locale.US, stringBuilder2, string, objectArray);
            }
            catch (NullPointerException | IllegalFormatException runtimeException) {
                stringBuilder2 = new StringBuilder(runtimeException.getMessage());
            }
        }
        if (n2 == 100) {
            for (LogStatusSink logStatusSink : GlobalLog.outStatusSinks) {
                logStatusSink.update(stringBuilder2);
            }
            return;
        }
        if (!bl) {
            char c2;
            if (GlobalLog.prefixWithLevel && (c2 = GlobalLog.getPrefixLetterForLevel(n2)) != '\u0000') {
                iterator = "[" + c2 + "] ";
                int n3 = stringBuilder2.length();
                while ((n3 = stringBuilder2.lastIndexOf("\n", n3)) >= 0) {
                    stringBuilder2.insert(n3 + 1, (String)((Object)iterator));
                    --n3;
                }
                stringBuilder2.insert(0, (String)((Object)iterator));
            }
            stringBuilder2.append("\n");
        }
        StringBuilder stringBuilder3 = null;
        if (this.needTimestamp()) {
            iterator = Calendar.getInstance();
            String string2 = Strings.ff("%04d-%02d-%02d %02d:%02d:%02d.%03d %s", ((Calendar)((Object)iterator)).get(1), 1 + ((Calendar)((Object)iterator)).get(2), ((Calendar)((Object)iterator)).get(5), ((Calendar)((Object)iterator)).get(11), 1 + ((Calendar)((Object)iterator)).get(12), ((Calendar)((Object)iterator)).get(13), ((Calendar)((Object)iterator)).get(14), ((Calendar)((Object)iterator)).getTimeZone().getDisplayName(false, 0));
            stringBuilder3 = new StringBuilder("[").append(string2).append("] ").append((CharSequence)stringBuilder2);
        }
        for (StreamSink streamSink : GlobalLog.outStreams) {
            if (n2 < 60 && n2 < streamSink.getLogLevel()) continue;
            object = (OutputStream)streamSink.getOutput();
            stringBuilder = streamSink.isPrefixWithTimestamp() ? stringBuilder3 : stringBuilder2;
            try {
                char[] cArray = new char[stringBuilder.length()];
                stringBuilder.getChars(0, stringBuilder.length(), cArray, 0);
                if (object instanceof PrintStream) {
                    int n4 = 10000;
                    if (cArray.length > n4) {
                        for (int i = 0; i < cArray.length; i += n4) {
                            int n5 = Math.min(n4, cArray.length - i);
                            char[] cArray2 = new char[n5];
                            System.arraycopy(cArray, i, cArray2, 0, n5);
                            if (i + n5 < cArray.length) {
                                ((PrintStream)object).println(cArray2);
                                continue;
                            }
                            ((PrintStream)object).print(cArray2);
                        }
                        continue;
                    }
                    ((PrintStream)object).print(cArray);
                    continue;
                }
                byte[] byArray = CharSequences.toByteArray(cArray);
                ((OutputStream)object).write(byArray);
            }
            catch (IOException iOException) {}
        }
        for (BufferSink bufferSink : GlobalLog.outBuffers) {
            if (n2 < 60 && n2 < bufferSink.getLogLevel()) continue;
            object = (List)bufferSink.getOutput();
            stringBuilder = bufferSink.isPrefixWithTimestamp() ? stringBuilder3 : stringBuilder2;
            object.add(stringBuilder);
        }
    }

    private boolean needTimestamp() {
        for (Sink<?> sink : GlobalLog.getRegularSinks()) {
            if (!sink.isPrefixWithTimestamp()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void i(String string, Object ... objectArray) {
    }

    @Override
    public void trace(String string, Object ... objectArray) {
        this.log(10, false, string, objectArray);
    }

    @Override
    public void fine(String string, Object ... objectArray) {
        this.trace(string, objectArray);
    }

    @Override
    public void debug(String string, Object ... objectArray) {
        this.log(20, false, string, objectArray);
    }

    @Override
    public void info(String string, Object ... objectArray) {
        this.log(30, false, string, objectArray);
    }

    @Override
    public void warn(String string, Object ... objectArray) {
        this.log(40, false, string, objectArray);
    }

    @Override
    public void warning(String string, Object ... objectArray) {
        this.warn(string, objectArray);
    }

    @Override
    public void error(String string, Object ... objectArray) {
        this.log(50, false, string, objectArray);
    }

    @Override
    public void severe(String string, Object ... objectArray) {
        this.error(string, objectArray);
    }

    @Override
    public void catching(Throwable throwable) {
        GlobalLog.catching(this, throwable);
    }

    @Override
    public void catching(Throwable throwable, String string) {
        GlobalLog.catching(this, throwable, string);
    }

    @Override
    public void catching(Throwable throwable, String string, Object ... objectArray) {
        GlobalLog.catching(this, throwable, Strings.ff(string, objectArray));
    }

    @Override
    public void catchingSilent(Throwable throwable) {
        GlobalLog.catchingDebug(this, throwable);
    }

    @Override
    public void status(String string, Object ... objectArray) {
        this.log(100, true, string, objectArray);
    }
}

