/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.logging;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.util.base.Throwables;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.BufferSink;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.logging.InternalLogger;
import com.pnfsoftware.jeb.util.logging.LogStatusSink;
import com.pnfsoftware.jeb.util.logging.SimpleLogger;
import com.pnfsoftware.jeb.util.logging.Sink;
import com.pnfsoftware.jeb.util.logging.StreamSink;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class GlobalLog {
    public static final List<String> LEVEL_NAMES = Collections.unmodifiableList(Arrays.asList("ALL", "TRACE", "DEBUG", "INFO", "WARN", "ERROR", "CATCHING"));
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_DISABLED = Integer.MAX_VALUE;
    public static final int LEVEL_ALWAYS_ON = 60;
    public static final int LEVEL_TRACE = 10;
    public static final int LEVEL_DEBUG = 20;
    public static final int LEVEL_INFO = 30;
    public static final int LEVEL_WARN = 40;
    public static final int LEVEL_ERROR = 50;
    public static final int LEVEL_INTERNAL = 19;
    public static final int LEVEL_CATCHING = 60;
    public static final int LEVEL_STATUS = 100;
    static List<StreamSink> outStreams = new CopyOnWriteArrayList<StreamSink>();
    static List<BufferSink> outBuffers = new CopyOnWriteArrayList<BufferSink>();
    static List<LogStatusSink> outStatusSinks = new CopyOnWriteArrayList<LogStatusSink>();
    private static Map<String, ILogger> map = new HashMap<String, ILogger>();
    public static final int STANDARD_CUTOFF_LEVEL;
    private static volatile int cutoffLevel;
    private static volatile int levelForNewLoggers;
    public static boolean prefixWithLevel;
    private static Map<String, Integer> filtermap;

    public static synchronized StreamSink addDestinationStream(OutputStream outputStream) {
        StreamSink streamSink = new StreamSink(outputStream);
        int n2 = outStreams.indexOf(streamSink);
        if (n2 >= 0) {
            return outStreams.get(n2);
        }
        outStreams.add(streamSink);
        return streamSink;
    }

    public static synchronized StreamSink removeDestinationStream(OutputStream outputStream) {
        StreamSink streamSink = new StreamSink(outputStream);
        int n2 = outStreams.indexOf(streamSink);
        return n2 < 0 ? null : outStreams.remove(n2);
    }

    public static synchronized List<StreamSink> getDestinationStreams() {
        return outStreams;
    }

    public static synchronized BufferSink addDestinationBuffer(List<CharSequence> list) {
        BufferSink bufferSink = new BufferSink(list);
        int n2 = outBuffers.indexOf(bufferSink);
        if (n2 >= 0) {
            return outBuffers.get(n2);
        }
        outBuffers.add(bufferSink);
        return bufferSink;
    }

    public static synchronized BufferSink removeDestinationBuffer(List<CharSequence> list) {
        BufferSink bufferSink = new BufferSink(list);
        int n2 = outBuffers.indexOf(bufferSink);
        return n2 < 0 ? null : outBuffers.remove(n2);
    }

    public static synchronized List<BufferSink> getDestinationBuffers() {
        return outBuffers;
    }

    public static synchronized List<Sink<?>> getRegularSinks() {
        ArrayList arrayList = new ArrayList(outBuffers);
        arrayList.addAll(outStreams);
        return arrayList;
    }

    public static synchronized void addStatusSink(LogStatusSink logStatusSink) {
        if (!outStatusSinks.contains(logStatusSink)) {
            outStatusSinks.add(logStatusSink);
        }
    }

    public static synchronized void removeStatusSink(LogStatusSink logStatusSink) {
        outStatusSinks.remove(logStatusSink);
    }

    public static synchronized List<LogStatusSink> getStatusSinks() {
        return outStatusSinks;
    }

    public static synchronized int setCutoffLevel(int n2) {
        int n3 = cutoffLevel;
        cutoffLevel = n2;
        return n3;
    }

    public static int getCutoffLevel() {
        return cutoffLevel;
    }

    public static int setLevelForNewLoggers(int n2) {
        return GlobalLog.setLevelForNewLoggers(n2, false);
    }

    public static synchronized int setLevelForNewLoggers(int n2, boolean bl) {
        int n3 = levelForNewLoggers;
        levelForNewLoggers = n2;
        if (bl) {
            for (ILogger iLogger : map.values()) {
                iLogger.setEnabledLevel(n2);
            }
        }
        return n3;
    }

    public static synchronized void setGlobalFilter(boolean bl) {
        if (bl) {
            GlobalLog.addGlobalFilter("", Integer.MAX_VALUE);
        } else {
            GlobalLog.removeGlobalFilter("");
        }
    }

    public static synchronized void addGlobalFilter(String string, int n2) {
        filtermap.put(string, n2);
    }

    public static synchronized void removeGlobalFilter(String string) {
        filtermap.remove(string);
    }

    public static synchronized void clearGlobalFilters() {
        filtermap.clear();
    }

    public static synchronized boolean isGloballyDisabled(ILogger iLogger) {
        String string = Strings.safe(iLogger.getName());
        if (string != null) {
            for (String string2 : filtermap.keySet()) {
                String string3 = string2 + ".";
                if (!string2.isEmpty() && !string.equals(string2) && !string.startsWith(string3)) continue;
                int n2 = filtermap.get(string2);
                if (iLogger.getEnabledLevel() >= n2) continue;
                return true;
            }
        }
        return false;
    }

    public static synchronized int getEnabledLevel() {
        return levelForNewLoggers;
    }

    public static synchronized ILogger getLogger() {
        return GlobalLog.getLogger((String)null, levelForNewLoggers);
    }

    public static synchronized void status(String string, Object ... objectArray) {
        GlobalLog.getLogger().status(string, objectArray);
    }

    public static synchronized ILogger getLogger(Class<?> clazz) {
        return GlobalLog.getLogger(clazz, levelForNewLoggers);
    }

    public static synchronized ILogger getLogger(Class<?> clazz, int n2) {
        return GlobalLog.getLogger(clazz.getName(), n2);
    }

    public static synchronized ILogger getLogger(String string, int n2) {
        ILogger iLogger = map.get(string);
        if (iLogger == null) {
            iLogger = new SimpleLogger(string, n2);
            map.put(string, iLogger);
        }
        return iLogger;
    }

    public static synchronized ILogger getInternalLogger(Class<?> clazz) {
        String string = clazz.getName();
        ILogger iLogger = map.get(string);
        if (iLogger == null) {
            iLogger = new InternalLogger(string);
            map.put(string, iLogger);
        }
        return iLogger;
    }

    public static void catching(ILogger iLogger, Throwable throwable) {
        GlobalLog.catching(iLogger, throwable, null);
    }

    public static void catching(ILogger iLogger, Throwable throwable, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string).append("\n");
        }
        GlobalLog.sanitizeTrace(throwable, stringBuilder);
        iLogger.log(60, false, stringBuilder.toString(), new Object[0]);
    }

    public static void catchingDebug(ILogger iLogger, Throwable throwable) {
        GlobalLog.catchingDebug(iLogger, throwable, null);
    }

    public static void catchingDebug(ILogger iLogger, Throwable throwable, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string).append("\n");
        }
        GlobalLog.sanitizeTrace(throwable, stringBuilder);
        iLogger.log(20, false, stringBuilder.toString(), new Object[0]);
    }

    private static void sanitizeTrace(Throwable throwable, StringBuilder stringBuilder) {
        String string = Throwables.formatStacktrace(throwable);
        if (Licensing.isDebugBuild()) {
            stringBuilder.append(string);
        } else {
            int n2 = 0;
            for (String string2 : Strings.splitLines(string)) {
                if (n2 > 0) {
                    if (string2.contains("com.pnfsoftware.jebglobal.")) break;
                    stringBuilder.append("\n");
                }
                stringBuilder.append(string2);
                ++n2;
            }
        }
    }

    public static int parseLevel(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            switch (string.trim().toUpperCase()) {
                case "ALL": {
                    return 0;
                }
                case "INTERNAL": {
                    return 19;
                }
                case "TRACE": {
                    return 10;
                }
                case "DEBUG": {
                    return 20;
                }
                case "INFO": {
                    return 30;
                }
                case "WARN": {
                    return 40;
                }
                case "ERROR": {
                    return 50;
                }
                case "CATCHING": {
                    return 60;
                }
                case "STATUS": {
                    return 100;
                }
                case "DISABLED": {
                    return Integer.MAX_VALUE;
                }
            }
            return -1;
        }
    }

    public static String levelToString(int n2) {
        switch (n2) {
            case 0: {
                return "ALL";
            }
            case 19: {
                return "INTERNAL";
            }
            case 10: {
                return "TRACE";
            }
            case 20: {
                return "DEBUG";
            }
            case 30: {
                return "INFO";
            }
            case 40: {
                return "WARN";
            }
            case 50: {
                return "ERROR";
            }
            case 60: {
                return "CATCHING";
            }
            case 0x7FFFFFFF: {
                return "DISABLED";
            }
        }
        return "LEVEL_" + n2;
    }

    public static char getPrefixLetterForLevel(int n2) {
        switch (n2) {
            case 19: {
                return 'i';
            }
            case 10: {
                return 'T';
            }
            case 20: {
                return 'D';
            }
            case 30: {
                return 'I';
            }
            case 40: {
                return 'W';
            }
            case 50: {
                return 'E';
            }
            case 60: {
                return 'C';
            }
        }
        return '\u0000';
    }

    public static int getLevelFromPrefixLetter(char c2) {
        switch (c2) {
            case 'i': {
                return 19;
            }
            case 'T': {
                return 10;
            }
            case 'D': {
                return 20;
            }
            case 'I': {
                return 30;
            }
            case 'W': {
                return 40;
            }
            case 'E': {
                return 50;
            }
            case 'C': {
                return 60;
            }
        }
        return -1;
    }

    static {
        cutoffLevel = STANDARD_CUTOFF_LEVEL = Licensing.isDebugBuild() ? 0 : 30;
        levelForNewLoggers = 0;
        prefixWithLevel = true;
        filtermap = new HashMap<String, Integer>();
    }
}

