/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class SubSeekableByteChannel
implements SeekableByteChannel {
    private SeekableByteChannel channel;
    private long base;
    private long maxsize;
    private long end;

    public SubSeekableByteChannel(SeekableByteChannel seekableByteChannel, long l2, long l3) throws IOException {
        if (l2 < 0L || l3 < 0L || l2 + l3 > seekableByteChannel.size()) {
            throw new IllegalArgumentException();
        }
        this.channel = seekableByteChannel;
        this.base = l2;
        this.maxsize = l3;
        this.end = l2 + l3;
        seekableByteChannel.position(l2);
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        long l2;
        int n2;
        long l3 = this.channel.position();
        if (l3 < this.base || l3 >= this.end) {
            return -1;
        }
        int n3 = byteBuffer.limit();
        long l4 = (long)n3 - (long)(n2 = byteBuffer.position());
        if (l4 > (l2 = this.end - l3)) {
            byteBuffer.limit((int)((long)n2 + l2));
        }
        int n4 = this.channel.read(byteBuffer);
        byteBuffer.limit(n3);
        return n4;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        throw new IOException("Unsupported operation");
    }

    @Override
    public long position() throws IOException {
        return this.channel.position() - this.base;
    }

    @Override
    public SeekableByteChannel position(long l2) throws IOException {
        this.channel.position(this.base + l2);
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.maxsize;
    }

    @Override
    public SeekableByteChannel truncate(long l2) throws IOException {
        throw new IOException("Unsupported operation");
    }
}

