/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RotatingFileOutputStream
extends OutputStream {
    private File folder;
    private String basename;
    private int rotFileCount;
    private long rotFileSize;
    private boolean buffered;
    private long rotationCount;
    private File sink;
    private long sinksize;
    private OutputStream filestream;

    public RotatingFileOutputStream(File file, String string, int n2, long l2) throws IOException {
        this(file, string, n2, l2, true, true);
    }

    public RotatingFileOutputStream(File file, String string, int n2, long l2, boolean bl, boolean bl2) throws IOException {
        if (file == null) {
            file = new File(System.getProperty("user.dir"));
        }
        if (file == null || !file.isDirectory()) {
            throw new IllegalArgumentException("Need a folder directory, got: " + file);
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Need a base filename, got: " + string);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Need a positive rotating file count, got: " + n2);
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Need a stricly positive rotating file count, got: " + n2);
        }
        this.folder = file;
        this.basename = string;
        this.rotFileCount = n2;
        this.rotFileSize = l2;
        this.buffered = bl;
        this.sink = this.gen(0);
        if (!bl2) {
            this.sink.delete();
        }
        this.sinksize = this.sink.length();
        this.open();
    }

    public int getRotatingFileCount() {
        return this.rotFileCount;
    }

    public long getRotatingFileSize() {
        return this.rotFileSize;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public long getRotationCount() {
        return this.rotationCount;
    }

    public File getOutputFile() {
        return this.sink;
    }

    public File getAdditionalOutputFile(int n2) throws IOException {
        if (n2 <= 0 || n2 > this.rotFileCount) {
            throw new IOException("Illegal rotating file, index must be in [1," + this.rotFileCount + "]");
        }
        return this.gen(n2);
    }

    private void open() throws IOException {
        this.filestream = new FileOutputStream(this.sink, true);
        if (this.buffered) {
            this.filestream = new BufferedOutputStream(this.filestream);
        }
    }

    private File gen(int n2) throws IOException {
        return this.gen(n2, true);
    }

    private File gen(int n2, boolean bl) throws IOException {
        if (n2 == 0 && bl) {
            return new File(this.folder, this.basename);
        }
        return new File(this.folder, this.basename + this.generateFileSuffix(n2));
    }

    protected String generateFileSuffix(int n2) {
        return "." + n2;
    }

    public void rotate() throws IOException {
        int n2;
        if (this.rotationCount == 0L) {
            for (n2 = 1; n2 <= this.rotFileCount; ++n2) {
                this.gen(n2).createNewFile();
            }
            ++this.rotationCount;
        }
        this.filestream.close();
        n2 = 1 + this.rotFileCount;
        for (int i = this.rotFileCount; i >= 0; --i) {
            this.gen(i).renameTo(this.gen((i + 1) % n2, false));
        }
        this.gen(0, false).delete();
        this.sink.createNewFile();
        this.sinksize = 0L;
        this.open();
    }

    private void checkRotate(long l2) throws IOException {
        this.sinksize += l2;
        if (this.sinksize >= this.rotFileSize) {
            this.rotate();
        }
    }

    @Override
    public void write(int n2) throws IOException {
        this.checkRotate(1L);
        this.filestream.write(n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.checkRotate(n3);
        this.filestream.write(byArray, n2, n3);
    }

    @Override
    public void flush() throws IOException {
        this.filestream.flush();
    }

    @Override
    public void close() throws IOException {
        this.filestream.close();
        this.filestream = null;
    }
}

