/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import com.pnfsoftware.jeb.util.encoding.IntegerLEB128;
import com.pnfsoftware.jeb.util.encoding.LongLEB128;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LEDataOutputStream
extends FilterOutputStream
implements DataOutput {
    public LEDataOutputStream(OutputStream outputStream) {
        super(new DataOutputStream(outputStream));
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public int size() {
        return ((DataOutputStream)this.out).size();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.out.write(byArray, n2, n3);
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        ((DataOutputStream)this.out).writeBoolean(bl);
    }

    @Override
    public void writeByte(int n2) throws IOException {
        ((DataOutputStream)this.out).writeByte(n2);
    }

    @Override
    @Deprecated
    public void writeBytes(String string) throws IOException {
        ((DataOutputStream)this.out).writeBytes(string);
    }

    @Override
    public void writeUTF(String string) throws IOException {
        ((DataOutputStream)this.out).writeUTF(string);
    }

    @Override
    public void writeChar(int n2) throws IOException {
        this.writeShort(n2);
    }

    @Override
    public void writeChars(String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    @Override
    public void writeInt(int n2) throws IOException {
        this.out.write(0xFF & n2);
        this.out.write(0xFF & n2 >> 8);
        this.out.write(0xFF & n2 >> 16);
        this.out.write(0xFF & n2 >> 24);
    }

    @Override
    public void writeShort(int n2) throws IOException {
        this.out.write(0xFF & n2);
        this.out.write(0xFF & n2 >> 8);
    }

    @Override
    public void writeLong(long l2) throws IOException {
        this.out.write(0xFF & (int)l2);
        this.out.write(0xFF & (int)(l2 >> 8));
        this.out.write(0xFF & (int)(l2 >> 16));
        this.out.write(0xFF & (int)(l2 >> 24));
        this.out.write(0xFF & (int)(l2 >> 32));
        this.out.write(0xFF & (int)(l2 >> 40));
        this.out.write(0xFF & (int)(l2 >> 48));
        this.out.write(0xFF & (int)(l2 >> 56));
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeIntULEB128(int n2) throws IOException {
        IntegerLEB128.writeULEB128(this.out, n2);
    }

    public void writeLongULEB128(long l2) throws IOException {
        LongLEB128.writeULEB128(this.out, l2);
    }
}

