/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.LEDataInputStream;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class IO {
    private static final ILogger logger = GlobalLog.getLogger(IO.class);
    private static OSType OSTYPE = OSType.determine();
    private static boolean IS_WINDOWS = OSTYPE.isWindows();
    public static final int MAX_FILENAME_SIZE = 255;
    public static final int MAX_PATH_SIZE = 248;
    private static final String endName = "~1";
    private static String cwd0;
    private static File tempFolder;
    private static File safeTempFolder;
    private static Set<String> windowsIllegalFileNames;
    private static boolean disablingMkdirsReplacement;

    public static String setCwd(String string) {
        String string2 = IO.getCwd();
        if (cwd0 == null) {
            cwd0 = string2;
        }
        System.setProperty("user.dir", string);
        return string2;
    }

    public static String getCwd() {
        return Strings.safe(System.getProperty("user.dir"));
    }

    public static String getOriginalCwd() {
        if (cwd0 == null) {
            cwd0 = IO.getCwd();
        }
        return cwd0;
    }

    public static boolean isFile(String string) {
        File file = new File(string);
        return file.exists() && file.isFile();
    }

    public static File createFolder(String string) throws IOException {
        File file = new File(string);
        if (file.isDirectory()) {
            return file;
        }
        IO.mkdirs2(file);
        return file;
    }

    public static boolean createDirectory(String string) {
        return IO.createDirectory(new File(string));
    }

    public static boolean createDirectory(File file) {
        try {
            return file.mkdirs();
        }
        catch (Exception exception) {
            logger.catchingSilent(exception);
            return false;
        }
    }

    public static boolean deleteDirectory(String string) {
        return IO.deleteDirectory(new File(string));
    }

    public static boolean deleteDirectory(File file) {
        int[] nArray = new int[1];
        IO.deleteDirectory(file, nArray);
        return nArray[0] == 0;
    }

    private static void deleteDirectory(File file, int[] nArray) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    IO.deleteDirectory(file2, nArray);
                    continue;
                }
                if (file2.delete()) continue;
                nArray[0] = nArray[0] + 1;
                return;
            }
        }
        if (!file.delete()) {
            nArray[0] = nArray[0] + 1;
        }
    }

    public static boolean deleteDirectoryContents(File file) {
        int[] nArray = new int[1];
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    IO.deleteDirectory(file2, nArray);
                    continue;
                }
                if (file2.delete()) continue;
                nArray[0] = nArray[0] + 1;
            }
        }
        return nArray[0] == 0;
    }

    public static boolean deleteFile(File file) {
        file.setWritable(true);
        return file.delete();
    }

    public static boolean renameFile(File file, File file2, int n2) {
        boolean bl = file.renameTo(file2);
        if (bl) {
            return true;
        }
        if (n2 == 0 || !file.exists() || !file2.exists()) {
            return false;
        }
        if (n2 == 1) {
            return IO.deleteFile(file2) && file.renameTo(file2);
        }
        if (n2 == 2) {
            return IO.deleteFile(file);
        }
        throw new IllegalArgumentException();
    }

    public static List<File> listFiles(String string) {
        return IO.listFiles(new File(string));
    }

    public static List<File> listFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        IO.listFilesRecurse(file, arrayList);
        return arrayList;
    }

    private static void listFilesRecurse(File file, List<File> list) {
        if (file.isDirectory()) {
            for (String string : IO.safeList(file)) {
                IO.listFilesRecurse(new File(file, string), list);
            }
        } else if (file.isFile()) {
            list.add(file);
        }
    }

    public static String[] safeList(File file) {
        String[] stringArray = file.list();
        return stringArray == null ? new String[]{} : stringArray;
    }

    public static String[] safeList(File file, FilenameFilter filenameFilter) {
        String[] stringArray = file.list(filenameFilter);
        return stringArray == null ? new String[]{} : stringArray;
    }

    public static File[] safeListFiles(File file) {
        File[] fileArray = file.listFiles();
        return fileArray == null ? new File[]{} : fileArray;
    }

    public static File[] safeListFiles(File file, FileFilter fileFilter) {
        File[] fileArray = file.listFiles(fileFilter);
        return fileArray == null ? new File[]{} : fileArray;
    }

    public static boolean inFolder(File file, File file2) {
        String string = IO.abs(file);
        String string2 = IO.abs(file2);
        return string.startsWith(string2 + File.separator);
    }

    public static File getHomeFolder() {
        return new File(System.getProperty("user.home"));
    }

    public static File getTempFolder() {
        return tempFolder;
    }

    @Deprecated
    public static File getSafeTempFolder() {
        return IO.getSessionTemporaryFolder();
    }

    public static File getSessionTemporaryFolder() {
        return safeTempFolder;
    }

    public static File createTempFolder(String object) throws IOException {
        if (object == null) {
            object = "tmp-" + System.nanoTime();
        }
        File file = new File(tempFolder, (String)object);
        IO.mkdirWarn(file);
        return file;
    }

    public static File createTempFile() throws IOException {
        return File.createTempFile("file-" + System.nanoTime(), null);
    }

    public static File createSafeTempFile() throws IOException {
        File file = new File(IO.getSafeTempFolder(), "file-" + System.nanoTime() + ".tmp");
        if (!file.createNewFile()) {
            throw new IOException("Error creating safe temp file!");
        }
        return file;
    }

    public static File createTempFile(String object, String string) throws IOException {
        if (object == null) {
            object = "file-" + System.nanoTime();
        }
        return File.createTempFile((String)object, string);
    }

    public static File createTempFile(String string) {
        return new File(IO.getTempFolder(), string);
    }

    public static File createTempFileNumbered(String string) throws IOException {
        File file = IO.getTempFolder();
        int n2 = 0;
        File file2 = new File(file, string);
        while (file2.exists() && n2 < 10000) {
            file2 = new File(IO.getTempFolder(), string + "." + ++n2);
        }
        if (n2 >= 10000 && file2.exists()) {
            throw new IOException("Cannot create new temp file with wanted name " + string);
        }
        return file2;
    }

    public static boolean createFile(File file, boolean bl) throws IOException {
        if (bl) {
            IO.createFoldersForFile(file);
        }
        return file.createNewFile();
    }

    public static void createFoldersForFile(File file) throws IOException {
        File file2 = file.getAbsoluteFile().getParentFile();
        if (file2 != null) {
            if (file2.isDirectory()) {
                return;
            }
            IO.mkdirs2(file2);
        }
    }

    public static void deleteDirectoryOnExit(File file) {
        file.deleteOnExit();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    IO.deleteDirectoryOnExit(file2);
                    continue;
                }
                file2.deleteOnExit();
            }
        }
    }

    public static void copyFile(File file, File file2, boolean bl) throws IOException {
        if (!file.isFile()) {
            throw new FileNotFoundException("Source file not found: " + file);
        }
        if (file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        if (file2.exists() && !bl) {
            throw new FileAlreadyExistsException("Copy would overwrite an existing file: " + file2);
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));){
            IO.copyStream(bufferedInputStream, bufferedOutputStream, new byte[4096]);
        }
    }

    public static long copyStream(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n2;
        long l2 = 0L;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static long copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IO.copyStream(inputStream, outputStream, new byte[4096]);
    }

    public static void writeFile(File file, byte[] byArray, int n2, int n3, boolean bl) throws IOException {
        Object object;
        if (bl && (object = file.getAbsoluteFile().getParentFile()) != null) {
            IO.mkdirs2Ex((File)object);
        }
        object = new DataOutputStream(new FileOutputStream(file));
        try {
            ((DataOutputStream)object).write(byArray, n2, n3);
        }
        finally {
            ((FilterOutputStream)object).close();
        }
    }

    public static void writeFile(File file, byte[] byArray, boolean bl) throws IOException {
        IO.writeFile(file, byArray, 0, byArray.length, bl);
    }

    public static void writeFile(File file, byte[] byArray, int n2, int n3) throws IOException {
        IO.writeFile(file, byArray, n2, n3, false);
    }

    public static void writeFile(File file, byte[] byArray) throws IOException {
        IO.writeFile(file, byArray, 0, byArray.length, false);
    }

    public static void writeFile(File file, String string) throws IOException {
        IO.writeFile(file, string.getBytes(Charset.defaultCharset()));
    }

    public static void writeFile(File file, String string, String string2) throws IOException {
        IO.writeFile(file, string.getBytes(string2));
    }

    public static byte[] readFile(File file, long l2) throws IOException {
        long l3 = file.length();
        if (l2 >= 0L && l3 > l2 || l3 > Integer.MAX_VALUE) {
            throw new IOException(Strings.ff("File is too large (%d bytes)", l3));
        }
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));){
            byte[] byArray = new byte[(int)l3];
            dataInputStream.readFully(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    public static byte[] readFile(File file) throws IOException {
        return IO.readFile(file, -1L);
    }

    public static byte[] readFile(String string) throws IOException {
        return IO.readFile(new File(string), -1L);
    }

    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        int n2;
        if (inputStream instanceof FileInputStream) {
            long l2 = ((FileInputStream)inputStream).getChannel().size();
            if (l2 > Integer.MAX_VALUE) {
                throw new IOException(Strings.ff("This method cannot read files larger than 2Gb: size=%d", l2));
            }
            byte[] byArray = new byte[(int)l2];
            int n3 = inputStream.read(byArray);
            if ((long)n3 != l2) {
                throw new IOException(Strings.ff("Unexpected amount of bytes read from file: %d != %d", n3, l2));
            }
            return byArray;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[16384];
        while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static List<String> readLines(InputStream inputStream, Charset charset) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));){
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public static List<String> readLines(InputStream inputStream) throws IOException {
        return IO.readLines(inputStream, Charset.forName("UTF-8"));
    }

    public static List<String> readLines(File file, Charset charset) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            List<String> list = IO.readLines(fileInputStream, charset);
            return list;
        }
    }

    public static List<String> readLines(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            List<String> list = IO.readLines(fileInputStream, Charset.forName("UTF-8"));
            return list;
        }
    }

    public static List<String> readLinesSafe(File file, Charset charset) {
        try {
            return IO.readLines(file, charset);
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            return null;
        }
    }

    public static List<String> readLinesSafe(File file) {
        return IO.readLinesSafe(file, Charset.forName("UTF-8"));
    }

    public static void writeLines(OutputStream outputStream, List<? extends CharSequence> list, Charset charset) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, charset));){
            for (CharSequence charSequence : list) {
                bufferedWriter.write(charSequence.toString());
                bufferedWriter.newLine();
            }
        }
    }

    public static void writeLines(OutputStream outputStream, List<? extends CharSequence> list) throws IOException {
        IO.writeLines(outputStream, list, Charset.forName("UTF-8"));
    }

    public static void writeLines(File file, List<? extends CharSequence> list, Charset charset) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            IO.writeLines(fileOutputStream, list, charset);
        }
    }

    public static void writeLines(File file, List<? extends CharSequence> list) throws IOException {
        IO.writeLines(file, list, Charset.forName("UTF-8"));
    }

    public static boolean writeLinesSafe(OutputStream outputStream, List<? extends CharSequence> list, Charset charset) {
        try {
            IO.writeLines(outputStream, list, charset);
            return true;
        }
        catch (IOException iOException) {
            logger.catching(iOException);
            return false;
        }
    }

    public static boolean writeLinesSafe(OutputStream outputStream, List<? extends CharSequence> list) {
        return IO.writeLinesSafe(outputStream, list, Charset.forName("UTF-8"));
    }

    public static boolean writeLinesSafe(File file, List<? extends CharSequence> list, Charset charset) {
        try {
            IO.writeLines(file, list, charset);
            return true;
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            return false;
        }
    }

    public static boolean writeLinesSafe(File file, List<? extends CharSequence> list) {
        return IO.writeLinesSafe(file, list, Charset.forName("UTF-8"));
    }

    public static int getFirstIntLE(String string) {
        int n2;
        File file = new File(string);
        LEDataInputStream lEDataInputStream = new LEDataInputStream(new FileInputStream(file));
        try {
            n2 = lEDataInputStream.readInt();
        }
        catch (Throwable throwable) {
            try {
                try {
                    lEDataInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return 0;
            }
        }
        lEDataInputStream.close();
        return n2;
    }

    public static short getFirstShortLE(String string) {
        short s2;
        File file = new File(string);
        LEDataInputStream lEDataInputStream = new LEDataInputStream(new FileInputStream(file));
        try {
            s2 = lEDataInputStream.readShort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    lEDataInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                logger.catchingSilent(iOException);
                return 0;
            }
        }
        lEDataInputStream.close();
        return s2;
    }

    public static byte getFirstByte(String string) {
        byte by;
        File file = new File(string);
        LEDataInputStream lEDataInputStream = new LEDataInputStream(new FileInputStream(file));
        try {
            by = lEDataInputStream.readByte();
        }
        catch (Throwable throwable) {
            try {
                try {
                    lEDataInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                logger.catchingSilent(iOException);
                return 0;
            }
        }
        lEDataInputStream.close();
        return by;
    }

    public static boolean compressFolder(String string, String string2) {
        boolean bl;
        File file = new File(string);
        if (!file.isDirectory()) {
            return false;
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(new File(string2)));
        try {
            IO.compressFolderRecurse(zipOutputStream, file, "/");
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                logger.catchingSilent(iOException);
                return false;
            }
        }
        zipOutputStream.close();
        return bl;
    }

    private static void compressFolderRecurse(ZipOutputStream zipOutputStream, File file, String string) throws IOException {
        File file2 = new File(file, string);
        if (file2.isFile()) {
            ZipEntry zipEntry = new ZipEntry(string);
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = IO.readFile(file2.getAbsolutePath());
            zipOutputStream.write(byArray);
            zipOutputStream.closeEntry();
        } else if (file2.isDirectory()) {
            for (String string2 : IO.safeList(file2)) {
                IO.compressFolderRecurse(zipOutputStream, file, new File(string, string2).getPath());
            }
        }
    }

    public static void extractToFolder(File file, File file2) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                try {
                    byte[] byArray = IO.readInputStream(inputStream);
                    File file3 = new File(file2, zipEntry.getName());
                    IO.writeFile(file3, byArray, true);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
    }

    public static void addFileToZip(ZipOutputStream zipOutputStream, File file, String string) throws IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setTime(file.lastModified());
            zipOutputStream.putNextEntry(zipEntry);
            IO.copyStream(bufferedInputStream, zipOutputStream);
            zipOutputStream.closeEntry();
        }
    }

    public static void addFileToJar(JarOutputStream jarOutputStream, File file, String string) throws IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            JarEntry jarEntry = new JarEntry(string);
            jarEntry.setTime(file.lastModified());
            jarOutputStream.putNextEntry(jarEntry);
            IO.copyStream(bufferedInputStream, jarOutputStream);
            jarOutputStream.closeEntry();
        }
    }

    public static byte[] readFileSafe(File file) {
        byte[] byArray;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        try {
            long l2 = file.length();
            if (l2 > Integer.MAX_VALUE) {
                throw new IOException(Strings.ff("This method cannot read files larger than 2Gb: size=%d", l2));
            }
            byte[] byArray2 = new byte[(int)l2];
            dataInputStream.readFully(byArray2);
            byArray = byArray2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                logger.catchingSilent(iOException);
                return new byte[0];
            }
        }
        dataInputStream.close();
        return byArray;
    }

    public static boolean writeFileSafe(File file, byte[] byArray, int n2, int n3, boolean bl) {
        try {
            IO.writeFile(file, byArray, n2, n3, bl);
            return true;
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            return false;
        }
    }

    public static boolean writeFileSafe(File file, byte[] byArray, boolean bl) {
        try {
            IO.writeFile(file, byArray, 0, byArray.length, bl);
            return true;
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            return false;
        }
    }

    public static String readInputLineSafe() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        try {
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            logger.catchingSilent(iOException);
            return null;
        }
    }

    public static String readInputLine() throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        return bufferedReader.readLine();
    }

    public static File getParentFile2(File file) {
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = file.getAbsoluteFile().getParentFile();
        }
        return file2;
    }

    public static String expandPath(String string) {
        String string2 = System.getProperty("user.home");
        if (string2 == null) {
            return string;
        }
        return string.replaceFirst("^~", Matcher.quoteReplacement(string2));
    }

    public static Thread copyAsync(final InputStream inputStream, final OutputStream outputStream) {
        return ThreadUtil.start("Async-Stream-Copy", new Runnable(){

            @Override
            public void run() {
                long l2 = 0L;
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                     BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
                    byte[] byArray;
                    int n2;
                    while ((n2 = bufferedInputStream.read(byArray = new byte[4096])) != -1) {
                        bufferedOutputStream.write(byArray, 0, n2);
                        bufferedOutputStream.flush();
                        l2 += (long)n2;
                    }
                    bufferedOutputStream.flush();
                    logger.trace("Background stream copy completed: %d bytes copied", l2);
                }
                catch (IOException iOException) {
                    logger.trace("Background stream copy stopped: %d bytes copied (error: %s)", l2, iOException);
                }
            }
        });
    }

    public static String dirname(String string) {
        char c2;
        int n2 = Strings.lastIndexOf2(string, '/', '\\');
        if (n2 < 0) {
            return "";
        }
        --n2;
        while (n2 >= 0 && ((c2 = string.charAt(n2)) == '/' || c2 == '\\')) {
            --n2;
        }
        if (n2 < 0) {
            return "";
        }
        return string.substring(0, n2 + 1);
    }

    public static String basename(String string) {
        int n2 = Strings.lastIndexOf2(string, '/', '\\');
        if (n2 < 0) {
            return string;
        }
        return string.substring(n2 + 1);
    }

    public static List<String> parsePathElements(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : string.split("(/|\\\\)")) {
            if (string2.isEmpty()) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static String escapeFileName(String string) {
        return IO.escapeFileName(string, '_');
    }

    public static String escapeFileName(String string, char c2) {
        return string.replaceAll("[:\\\\/*\"?|<>]", "" + c2);
    }

    public static String escapeFileNameStrict(String string) {
        return IO.escapeFileNameStrict(string, '_');
    }

    public static String escapeFileNameStrict(String string, char c2) {
        return string.replaceAll("[^a-zA-Z0-9-_\\.']", "" + c2);
    }

    public static String sanitizePathUnsafe(String string) {
        return IO.sanitizePath(string, false, false);
    }

    public static String sanitizePath(String object, boolean bl, boolean bl2) {
        int n2;
        int n3;
        if (IS_WINDOWS) {
            StringBuilder stringBuilder = new StringBuilder();
            int n4 = -1;
            for (n3 = 0; n3 < ((String)object).length(); ++n3) {
                n2 = ((String)object).charAt(n3);
                if (n2 == 47 || n2 == 92) {
                    if (n4 != -1) {
                        stringBuilder.append(IO.sanitizeReservedWindowsFileName(((String)object).substring(n4, n3)));
                        n4 = -1;
                    }
                    stringBuilder.append((char)n2);
                    continue;
                }
                if (n4 != -1) continue;
                n4 = n3;
            }
            if (n4 != -1) {
                stringBuilder.append(IO.sanitizeReservedWindowsFileName(((String)object).substring(n4, ((String)object).length())));
            }
            object = stringBuilder.toString();
        }
        int n5 = -1;
        while (true) {
            try {
                Paths.get((String)object, new String[0]);
                StringBuilder stringBuilder = new StringBuilder();
                n3 = 0;
                for (n2 = 0; n2 < ((String)object).length(); ++n2) {
                    char c2 = ((String)object).charAt(n2);
                    if (!bl) {
                        boolean bl3;
                        boolean bl4 = bl3 = c2 == '/' || c2 == '\\' || c2 == ':';
                        if (stringBuilder.length() - n3 > 248 && bl3) {
                            stringBuilder.delete(n3 + 248 - endName.length(), stringBuilder.length());
                            stringBuilder.append(endName);
                        }
                        if (bl3) {
                            n3 = stringBuilder.length() + 1;
                        }
                    }
                    if (c2 == '?' || c2 == '%' || c2 == '*' || c2 == '|' || c2 == '<' || c2 == '>' || c2 == '\"' || bl && (c2 == '/' || c2 == '\\' || c2 == ':') || bl2 && Character.isWhitespace(c2)) {
                        Strings.ff(stringBuilder, "_x%04x", c2 & 0xFFFF);
                        continue;
                    }
                    stringBuilder.append(c2);
                }
                if (stringBuilder.length() - n3 > 255) {
                    n2 = stringBuilder.lastIndexOf(".");
                    if (n2 < 0 || n2 + 50 < stringBuilder.length()) {
                        stringBuilder.delete(n3 + 255 - endName.length(), stringBuilder.length());
                        stringBuilder.append(endName);
                    } else {
                        CharSequence charSequence = stringBuilder.subSequence(n2, stringBuilder.length());
                        stringBuilder.delete(n3 + 255 - endName.length() - charSequence.length(), stringBuilder.length());
                        stringBuilder.append(endName);
                        stringBuilder.append(charSequence);
                    }
                }
                object = stringBuilder.toString();
                return object;
            }
            catch (InvalidPathException invalidPathException) {
                n3 = invalidPathException.getIndex();
                if (n3 > n5) {
                    n5 = n3;
                    object = invalidPathException.getInput();
                    n2 = ((String)object).charAt(n3);
                    object = ((String)object).substring(0, n3) + Strings.ff("_x%04x", n2 & 0xFFFF) + ((String)object).substring(n3 + 1);
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (n3 = 0; n3 < ((String)object).length(); ++n3) {
                    n2 = ((String)object).charAt(n3);
                    if (n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90 || n2 >= 48 && n2 <= 57 || n2 == 45 || n2 == 95 || n2 == 46) {
                        stringBuilder.append((char)n2);
                        continue;
                    }
                    Strings.ff(stringBuilder, "_x%04x", n2 & 0xFFFF);
                }
                object = stringBuilder.toString();
                Paths.get((String)object, new String[0]);
                return object;
            }
            break;
        }
    }

    private static String sanitizeReservedWindowsFileName(String object) {
        String string = ((String)object).toLowerCase();
        int n2 = string.indexOf(46);
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        if (windowsIllegalFileNames.contains(string)) {
            object = n2 < 0 ? (String)object + "\u00a0" : ((String)object).substring(0, n2) + "\u00a0" + ((String)object).substring(n2);
        }
        return object;
    }

    public static String getRelativePath(File file, File file2) {
        String string;
        String string2 = IO.abs(file.getPath());
        if (!string2.startsWith(string = IO.abs(file2.getPath()))) {
            return null;
        }
        String string3 = string2.substring(string.length());
        string3 = Strings.ltrim(string3, '/');
        string3 = Strings.ltrim(string3, '\\');
        return string3;
    }

    public static boolean compareFiles(File file, File file2) throws IOException {
        if (!file.isFile()) {
            throw new FileNotFoundException("File not found: " + file);
        }
        if (!file2.isFile()) {
            throw new FileNotFoundException("File not found: " + file2);
        }
        if (file.length() != file2.length()) {
            return false;
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            boolean bl;
            try (BufferedInputStream bufferedInputStream2 = new BufferedInputStream(new FileInputStream(file2));){
                bl = IO.compareStreams(bufferedInputStream, bufferedInputStream2);
            }
            return bl;
        }
    }

    private static boolean compareStreams(InputStream inputStream, InputStream inputStream2) throws IOException {
        int n2;
        int n3;
        do {
            n3 = inputStream.read();
            n2 = inputStream2.read();
            if (n3 != -1 || n2 != -1) continue;
            return true;
        } while (n3 == n2);
        return false;
    }

    public static String[] splitPath(String string) {
        int n2 = Strings.lastIndexOf2(string, '/', '\\');
        if (n2 < 0) {
            return new String[]{"", string};
        }
        return new String[]{string.substring(0, n2 + 1), string.substring(n2 + 1)};
    }

    public static String[] splitExtension(String string) {
        int n2 = Strings.lastIndexOf2(string, '/', '\\');
        int n3 = string.lastIndexOf(46);
        if (n3 <= n2) {
            return new String[]{string, ""};
        }
        return new String[]{string.substring(0, n3), string.substring(n3)};
    }

    public static String getExtension(String string) {
        int n2 = Strings.lastIndexOf2(string, '/', '\\');
        int n3 = string.lastIndexOf(46);
        if (n3 <= n2) {
            return "";
        }
        return string.substring(n3);
    }

    public static String getExtension(File file) {
        return IO.getExtension(file.getAbsolutePath());
    }

    public static String noExtension(String string) {
        int n2 = Strings.lastIndexOf2(string, '/', '\\');
        int n3 = string.lastIndexOf(46);
        if (n3 <= n2) {
            return string;
        }
        return string.substring(0, n3);
    }

    public static File noExtension(File file) {
        return new File(IO.noExtension(file.getAbsolutePath()));
    }

    public static File replaceExtension(File file, String string) {
        return new File(IO.noExtension(file.getAbsolutePath()) + string);
    }

    public static boolean isUrl(String string) {
        try {
            URI uRI = URI.create(string);
            return uRI.getScheme() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String abs(File file) {
        return IO.abs(file.getPath());
    }

    public static String abs(String string) {
        return IO.simplifyPath(new File(string).getAbsolutePath());
    }

    public static String simplifyPath(String string) {
        if (File.separatorChar == '/') {
            return IO.simplifyPathUnix(string);
        }
        if (File.separatorChar == '\\') {
            return IO.simplifyPathWindows(string);
        }
        return string;
    }

    public static String simplifyPathUnix(String string) {
        Object object;
        if (string.isEmpty()) {
            return ".";
        }
        char c2 = string.charAt(0);
        boolean bl = false;
        if (c2 == '/') {
            bl = true;
        }
        String[] stringArray = string.split("/");
        ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (((String)object).isEmpty() || ((String)object).equals(".")) continue;
            if (((String)object).equals("..")) {
                if (arrayList.isEmpty()) continue;
                arrayList.remove(arrayList.size() - 1);
                continue;
            }
            arrayList.add(object);
        }
        if (arrayList.isEmpty()) {
            if (bl) {
                return "/";
            }
            return ".";
        }
        object = Strings.join("/", arrayList);
        if (bl) {
            object = "/" + (String)object;
        }
        return object;
    }

    public static String simplifyPathWindows(String string) {
        Object object;
        if (string.isEmpty()) {
            return ".";
        }
        string = string.replace('/', '\\');
        char c2 = string.charAt(0);
        int n2 = 0;
        if (c2 == '\\') {
            if (string.length() >= 2 && string.charAt(1) == '\\') {
                if (string.length() >= 3 && string.charAt(2) == '\\') {
                    return string;
                }
                n2 = 2;
            } else {
                n2 = 1;
            }
        }
        String[] stringArray = string.split("\\\\");
        ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (((String)object).isEmpty() || ((String)object).equals(".")) continue;
            if (((String)object).equals("..")) {
                if (arrayList.isEmpty()) continue;
                arrayList.remove(arrayList.size() - 1);
                continue;
            }
            arrayList.add(object);
        }
        if (arrayList.isEmpty()) {
            if (n2 == 1) {
                return "\\";
            }
            if (n2 == 2) {
                return "\\\\";
            }
            return ".";
        }
        object = Strings.join("\\", arrayList);
        if (n2 == 1) {
            object = "\\" + (String)object;
        } else if (n2 == 2) {
            object = "\\\\" + (String)object;
        }
        return object;
    }

    public static boolean checkFileFreshness(File file, long l2, boolean bl) {
        if (!file.exists()) {
            return false;
        }
        if (System.currentTimeMillis() - file.lastModified() <= l2) {
            return true;
        }
        if (bl) {
            file.delete();
        }
        return false;
    }

    static boolean mkdirs2Ex(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        if (file.isDirectory()) {
            return false;
        }
        IO.mkdirs2(file);
        return true;
    }

    static void mkdirs2(File file) throws IOException {
        File file2;
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        if (disablingMkdirsReplacement) {
            file.mkdirs();
            return;
        }
        if (IO.mkdirs(file)) {
            return;
        }
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException(Strings.ff("Failed to create %s: directory exists", file));
            }
            throw new IOException(Strings.ff("Failed to create %s: entry exists and is not a directory", file));
        }
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new IOException(Strings.ff("Failed to create %s: cannot canonicalize path", file), iOException);
        }
        try {
            IO.mkdirsExSafeRec(file2);
        }
        catch (IOException iOException) {
            throw new IOException(Strings.ff("Failed to create %s (canon: %s): an exception occurred", file, file2), iOException);
        }
    }

    private static void mkdirsExSafeRec(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 == null) {
            throw new IOException("No more parents");
        }
        if (!file2.exists()) {
            IO.mkdirsExSafeRec(file2);
        }
        if (!IO.mkdirWarn(file)) {
            throw new IOException("Cannot create intermediate folder: " + file);
        }
    }

    private static boolean mkdirs(File file) {
        File file2;
        if (file.exists()) {
            return false;
        }
        if (IO.mkdirWarn(file)) {
            return true;
        }
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            logger.catching(iOException);
            return false;
        }
        File file3 = file2.getParentFile();
        return file3 != null && (IO.mkdirs(file3) || file3.exists()) && IO.mkdirWarn(file2);
    }

    private static boolean mkdirWarn(File file) {
        if (file.getPath().endsWith(" ")) {
            logger.warn("Warning: Folder name ends with space, it may not be created as expected: '%s'", file);
        }
        return file.mkdir();
    }

    static {
        tempFolder = null;
        safeTempFolder = null;
        File file = null;
        try {
            file = File.createTempFile("jebgettemp", null);
            tempFolder = file.getParentFile();
            safeTempFolder = new File(tempFolder, "jebtmp-" + System.currentTimeMillis());
            IO.mkdirWarn(safeTempFolder);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public synchronized void start() {
                    IO.deleteDirectory(safeTempFolder);
                }
            });
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        windowsIllegalFileNames = new HashSet<String>();
        windowsIllegalFileNames.add("con");
        windowsIllegalFileNames.add("prn");
        windowsIllegalFileNames.add("aux");
        windowsIllegalFileNames.add("nul");
        for (int i = 1; i <= 9; ++i) {
            windowsIllegalFileNames.add("com" + i);
            windowsIllegalFileNames.add("lpt" + i);
        }
        disablingMkdirsReplacement = true;
    }
}

