/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.collect.Maps;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class FileMonitor {
    public static final long TOUCH_MS = 1000L;
    public static final long CHECK_MS = 3000L;
    private static Map<String, FileMonitor> map;
    private File folder;
    private String filename;
    private boolean singlefile;
    private boolean cleanStaleFiles = true;
    private Thread toucherThread;

    public static FileMonitor get(File file) throws IOException {
        return FileMonitor.get(file.getParentFile(), file.getName(), true);
    }

    public static FileMonitor get(File file, String string, boolean bl) throws IOException {
        return FileMonitor.retrieve(file, string, bl, false);
    }

    public static FileMonitor create(File file) throws IOException {
        return FileMonitor.create(file.getParentFile(), file.getName(), true);
    }

    public static FileMonitor create(File file, String string, boolean bl) throws IOException {
        return FileMonitor.retrieve(file, string, bl, true);
    }

    private static FileMonitor retrieve(File file, String string, boolean bl, boolean bl2) throws IOException {
        String string2 = file.getCanonicalPath() + ";" + string + ";" + bl;
        FileMonitor fileMonitor = map.get(string2);
        if (fileMonitor == null && bl2) {
            fileMonitor = new FileMonitor(file, string, bl);
            map.put(string2, fileMonitor);
        }
        return fileMonitor;
    }

    private FileMonitor(File file, String string, boolean bl) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Folder does not exist: " + file);
        }
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Filename or prefix name cannot be null or empty");
        }
        this.folder = file;
        this.filename = string;
        this.singlefile = bl;
    }

    public boolean isLocked() {
        if (this.singlefile) {
            File file = new File(this.folder, this.filename);
            if (!file.exists()) {
                return false;
            }
            if (System.currentTimeMillis() - file.lastModified() <= 3000L) {
                return true;
            }
            if (this.cleanStaleFiles) {
                file.delete();
            }
            return false;
        }
        boolean bl = false;
        for (String string : this.folder.list()) {
            if (!string.startsWith(this.filename)) continue;
            File file = new File(this.folder, string);
            if (System.currentTimeMillis() - file.lastModified() <= 3000L) {
                bl = true;
                if (this.cleanStaleFiles) continue;
                break;
            }
            if (!this.cleanStaleFiles) continue;
            file.delete();
        }
        return bl;
    }

    public void lock() {
        if (this.toucherThread != null) {
            return;
        }
        this.toucherThread = ThreadUtil.start(new Runnable(){

            @Override
            public void run() {
                File file;
                if (FileMonitor.this.singlefile) {
                    file = new File(FileMonitor.this.folder, FileMonitor.this.filename);
                } else {
                    String string = FileMonitor.this.folder.getPath() + File.separatorChar + FileMonitor.this.filename;
                    int n2 = 0;
                    String string2 = string;
                    while ((file = new File(string2)).exists() && n2 < 100000) {
                        string2 = string + "_" + ++n2;
                    }
                }
                try {
                    file.createNewFile();
                    file.deleteOnExit();
                }
                catch (IOException iOException) {
                    return;
                }
                while (true) {
                    file.setLastModified(System.currentTimeMillis());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        file.delete();
                        return;
                    }
                }
            }
        });
    }

    public void unlock(boolean bl) throws InterruptedException {
        if (this.toucherThread == null) {
            return;
        }
        this.toucherThread.interrupt();
        this.toucherThread.join();
        this.toucherThread = null;
        if (bl) {
            Maps.removeForValue(map, this, true);
        }
    }

    static {
        Assert.a(true);
        map = new HashMap<String, FileMonitor>();
    }
}

