/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import java.nio.ByteOrder;

@Ser
public enum Endianness {
    BIG_ENDIAN("BIG_ENDIAN"),
    LITTLE_ENDIAN("LITTLE_ENDIAN"),
    MIDDLE_ENDIAN("MIDDLE_ENDIAN");

    private final String name;

    private Endianness(String string2) {
        this.name = string2;
    }

    public ByteOrder toByteOrder() {
        if (this == BIG_ENDIAN) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (this == LITTLE_ENDIAN) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        throw new UnsupportedOperationException("Cannot convert " + this + " to Java's ByteOrder");
    }

    public boolean isBig() {
        return this == BIG_ENDIAN;
    }

    public boolean isLittle() {
        return this == LITTLE_ENDIAN;
    }

    public boolean isMiddle() {
        return this == MIDDLE_ENDIAN;
    }

    public static Endianness fromByteOrder(ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return BIG_ENDIAN;
        }
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return LITTLE_ENDIAN;
        }
        return null;
    }

    public static Endianness nativeOrder() {
        return Endianness.fromByteOrder(ByteOrder.nativeOrder());
    }

    public String toString() {
        return this.name;
    }
}

