/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import java.nio.ByteOrder;

public class EndianUtil {
    public static void swap(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        for (int i = n2 + n3 - 1; n4 < i; ++n4, --i) {
            byte by = byArray[n4];
            byArray[n4] = byArray[i];
            byArray[i] = by;
        }
    }

    public static void swap(byte[] byArray) {
        EndianUtil.swap(byArray, 0, byArray.length);
    }

    public static void swapByGroup(byte[] byArray, int n2) {
        for (int i = 0; i < byArray.length; i += n2) {
            for (int j = 0; j < n2 / 2; ++j) {
                byte by = byArray[i + j];
                byArray[i + j] = byArray[i + (n2 - (j + 1))];
                byArray[i + (n2 - (j + 1))] = by;
            }
        }
    }

    public static short swapShort(short s2) {
        return (short)((s2 & 0xFF) << 8 | s2 >> 8 & 0xFF);
    }

    public static int swapInt(int n2) {
        return (n2 & 0xFF) << 24 | (n2 >> 8 & 0xFF) << 16 | (n2 >> 16 & 0xFF) << 8 | n2 >> 24 & 0xFF;
    }

    public static long swapLong(long l2) {
        return (l2 & 0xFFL) << 56 | (l2 >> 8 & 0xFFL) << 48 | (l2 >> 16 & 0xFFL) << 40 | (l2 >> 24 & 0xFFL) << 32 | (l2 >> 32 & 0xFFL) << 24 | (l2 >> 40 & 0xFFL) << 16 | (l2 >> 48 & 0xFFL) << 8 | l2 >> 56 & 0xFFL;
    }

    public static byte[] shortToLEBytes(short s2) {
        byte[] byArray = new byte[]{(byte)s2, (byte)(s2 >> 8)};
        return byArray;
    }

    public static void shortToLEBytes(short s2, byte[] byArray) {
        EndianUtil.shortToLEBytes(s2, byArray, 0);
    }

    public static void shortToLEBytes(short s2, byte[] byArray, int n2) {
        byArray[n2] = (byte)s2;
        byArray[n2 + 1] = (byte)(s2 >> 8);
    }

    public static byte[] intToLEBytes(int n2) {
        byte[] byArray = new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24)};
        return byArray;
    }

    public static void intToLEBytes(int n2, byte[] byArray) {
        EndianUtil.intToLEBytes(n2, byArray, 0);
    }

    public static void intToLEBytes(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
        byArray[n3 + 1] = (byte)(n2 >> 8);
        byArray[n3 + 2] = (byte)(n2 >> 16);
        byArray[n3 + 3] = (byte)(n2 >> 24);
    }

    public static byte[] longToLEBytes(long l2) {
        byte[] byArray = new byte[8];
        EndianUtil.longToLEBytes(l2, byArray);
        return byArray;
    }

    public static void longToLEBytes(long l2, byte[] byArray) {
        EndianUtil.longToLEBytes(l2, byArray, 0);
    }

    public static void longToLEBytes(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)l2;
        byArray[n2 + 1] = (byte)(l2 >> 8);
        byArray[n2 + 2] = (byte)(l2 >> 16);
        byArray[n2 + 3] = (byte)(l2 >> 24);
        byArray[n2 + 4] = (byte)(l2 >> 32);
        byArray[n2 + 5] = (byte)(l2 >> 40);
        byArray[n2 + 6] = (byte)(l2 >> 48);
        byArray[n2 + 7] = (byte)(l2 >> 56);
    }

    public static byte[] shortToBEBytes(short s2) {
        byte[] byArray = new byte[2];
        byArray[1] = (byte)s2;
        byArray[0] = (byte)(s2 >> 8);
        return byArray;
    }

    public static void shortToBEBytes(short s2, byte[] byArray) {
        EndianUtil.shortToBEBytes(s2, byArray, 0);
    }

    public static void shortToBEBytes(short s2, byte[] byArray, int n2) {
        byArray[n2 + 1] = (byte)s2;
        byArray[n2] = (byte)(s2 >> 8);
    }

    public static byte[] intToBEBytes(int n2) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)n2;
        byArray[2] = (byte)(n2 >> 8);
        byArray[1] = (byte)(n2 >> 16);
        byArray[0] = (byte)(n2 >> 24);
        return byArray;
    }

    public static void intToBEBytes(int n2, byte[] byArray) {
        EndianUtil.intToBEBytes(n2, byArray, 0);
    }

    public static void intToBEBytes(int n2, byte[] byArray, int n3) {
        byArray[n3 + 3] = (byte)n2;
        byArray[n3 + 2] = (byte)(n2 >> 8);
        byArray[n3 + 1] = (byte)(n2 >> 16);
        byArray[n3] = (byte)(n2 >> 24);
    }

    public static byte[] longToBEBytes(long l2) {
        byte[] byArray = new byte[8];
        EndianUtil.longToBEBytes(l2, byArray, 0);
        return byArray;
    }

    public static void longToBEBytes(long l2, byte[] byArray) {
        EndianUtil.longToBEBytes(l2, byArray, 0);
    }

    public static void longToBEBytes(long l2, byte[] byArray, int n2) {
        byArray[n2 + 7] = (byte)l2;
        byArray[n2 + 6] = (byte)(l2 >> 8);
        byArray[n2 + 5] = (byte)(l2 >> 16);
        byArray[n2 + 4] = (byte)(l2 >> 24);
        byArray[n2 + 3] = (byte)(l2 >> 32);
        byArray[n2 + 2] = (byte)(l2 >> 40);
        byArray[n2 + 1] = (byte)(l2 >> 48);
        byArray[n2] = (byte)(l2 >> 56);
    }

    public static short littleEndianBytesToShort(byte[] byArray) {
        return EndianUtil.littleEndianBytesToShort(byArray, 0);
    }

    public static short littleEndianBytesToShort(byte[] byArray, int n2) {
        return (short)(byArray[n2] & 0xFF | byArray[n2 + 1] << 8 & 0xFF00);
    }

    public static int littleEndianBytesToInt(byte[] byArray) {
        return EndianUtil.littleEndianBytesToInt(byArray, 0);
    }

    public static int littleEndianBytesToInt(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | byArray[n2 + 1] << 8 & 0xFF00 | byArray[n2 + 2] << 16 & 0xFF0000 | byArray[n2 + 3] << 24 & 0xFF000000;
    }

    public static long littleEndianBytesToLong(byte[] byArray) {
        long l2 = EndianUtil.littleEndianBytesToLong(byArray, 0);
        return l2;
    }

    public static long littleEndianBytesToLong(byte[] byArray, int n2) {
        return (long)byArray[n2] & 0xFFL | (long)byArray[n2 + 1] << 8 & 0xFF00L | (long)byArray[n2 + 2] << 16 & 0xFF0000L | (long)byArray[n2 + 3] << 24 & 0xFF000000L | (long)byArray[n2 + 4] << 32 & 0xFF00000000L | (long)byArray[n2 + 5] << 40 & 0xFF0000000000L | (long)byArray[n2 + 6] << 48 & 0xFF000000000000L | (long)byArray[n2 + 7] << 56 & 0xFF00000000000000L;
    }

    public static short bigEndianBytesToShort(byte[] byArray) {
        return EndianUtil.bigEndianBytesToShort(byArray, 0);
    }

    public static short bigEndianBytesToShort(byte[] byArray, int n2) {
        return (short)(byArray[n2 + 1] & 0xFF | byArray[n2] << 8 & 0xFF00);
    }

    public static int bigEndianBytesToInt(byte[] byArray) {
        return EndianUtil.bigEndianBytesToInt(byArray, 0);
    }

    public static int bigEndianBytesToInt(byte[] byArray, int n2) {
        return byArray[n2 + 3] & 0xFF | byArray[n2 + 2] << 8 & 0xFF00 | byArray[n2 + 1] << 16 & 0xFF0000 | byArray[n2] << 24 & 0xFF000000;
    }

    public static long bigEndianBytesToLong(byte[] byArray) {
        return EndianUtil.bigEndianBytesToLong(byArray, 0);
    }

    public static long bigEndianBytesToLong(byte[] byArray, int n2) {
        return (long)byArray[n2 + 7] & 0xFFL | (long)byArray[n2 + 6] << 8 & 0xFF00L | (long)byArray[n2 + 5] << 16 & 0xFF0000L | (long)byArray[n2 + 4] << 24 & 0xFF000000L | (long)byArray[n2 + 3] << 32 & 0xFF00000000L | (long)byArray[n2 + 2] << 40 & 0xFF0000000000L | (long)byArray[n2 + 1] << 48 & 0xFF000000000000L | (long)byArray[n2] << 56 & 0xFF00000000000000L;
    }

    public static void numberToBytes(ByteOrder byteOrder, long l2, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        if (byArray.length >= 8) {
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                EndianUtil.longToLEBytes(l2, byArray);
            } else {
                EndianUtil.longToBEBytes(l2, byArray);
            }
        } else if (byArray.length >= 4) {
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                EndianUtil.intToLEBytes((int)l2, byArray);
            } else {
                EndianUtil.intToBEBytes((int)l2, byArray);
            }
        } else if (byArray.length >= 2) {
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                EndianUtil.shortToLEBytes((short)l2, byArray);
            } else {
                EndianUtil.shortToBEBytes((short)l2, byArray);
            }
        } else {
            byArray[0] = (byte)l2;
        }
    }

    public static long bytesToNumberSigned(ByteOrder byteOrder, byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("bytesToNumber with invalid parameters: byte[] is null or empty");
        }
        if (byArray.length >= 8) {
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                return EndianUtil.littleEndianBytesToLong(byArray, 0);
            }
            return EndianUtil.bigEndianBytesToLong(byArray, 0);
        }
        if (byArray.length >= 4) {
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                return EndianUtil.littleEndianBytesToInt(byArray, 0);
            }
            return EndianUtil.bigEndianBytesToInt(byArray, 0);
        }
        if (byArray.length >= 2) {
            if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                return EndianUtil.littleEndianBytesToShort(byArray, 0);
            }
            return EndianUtil.bigEndianBytesToShort(byArray, 0);
        }
        return byArray[0];
    }

    public static long bytesToNumberUnsigned(ByteOrder byteOrder, byte[] byArray) {
        long l2 = EndianUtil.bytesToNumberSigned(byteOrder, byArray);
        if (byArray.length >= 8) {
            return l2;
        }
        if (byArray.length >= 4) {
            return l2 & 0xFFFFFFFFFFFFFFFFL;
        }
        if (byArray.length >= 2) {
            return l2 & 0xFFFFL;
        }
        return l2 & 0xFFL;
    }

    public static short bytesToShort(byte[] byArray, int n2, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return EndianUtil.littleEndianBytesToShort(byArray, n2);
        }
        return EndianUtil.bigEndianBytesToShort(byArray, n2);
    }

    public static int bytesToInt(byte[] byArray, int n2, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return EndianUtil.littleEndianBytesToInt(byArray, n2);
        }
        return EndianUtil.bigEndianBytesToInt(byArray, n2);
    }

    public static long bytesToLong(byte[] byArray, int n2, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return EndianUtil.littleEndianBytesToLong(byArray, n2);
        }
        return EndianUtil.bigEndianBytesToLong(byArray, n2);
    }
}

