/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import com.pnfsoftware.jeb.util.logging.GlobalLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DirectoryEnumerator
implements Iterable<File> {
    private File base;
    private Pattern pattern;
    private boolean recurse;
    private Set<String> blacklistedDirnames = new HashSet<String>();

    public DirectoryEnumerator(File file, String string, boolean bl) {
        this(file);
        if (string != null) {
            this.setFilterString(string, false, false);
        }
        this.setRecurse(bl);
    }

    public DirectoryEnumerator(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("The base is not a directory: " + file);
        }
        this.base = file;
    }

    public void setFilterString(String object, boolean bl, boolean bl2) {
        try {
            int n2 = 0;
            if (bl) {
                n2 |= 2;
            }
            if (bl2) {
                n2 |= 0x100;
            }
            if (!((String)object).startsWith("*")) {
                object = "^" + (String)object;
            }
            if (!((String)object).endsWith("*")) {
                object = (String)object + "$";
            }
            object = ((String)object).replace(".", "\\.").replace("*", ".*").replace("?", ".");
            this.pattern = Pattern.compile((String)object, n2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("The filter string could not be converted to a regex pattern", patternSyntaxException);
        }
    }

    public void setFilter(Pattern pattern) {
        this.pattern = pattern;
    }

    public Pattern getFilter() {
        return this.pattern;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public void addBlackListedDirectory(String string) {
        this.blacklistedDirnames.add(string);
    }

    public Collection<String> getBlacklistedDirnames() {
        return Collections.unmodifiableCollection(this.blacklistedDirnames);
    }

    public List<File> list() {
        ArrayList<File> arrayList;
        long l2 = System.currentTimeMillis();
        try {
            ArrayList<File> arrayList2 = new ArrayList<File>();
            this.listFilesRecurse(this.base, arrayList2, !this.recurse ? 1 : Integer.MAX_VALUE);
            arrayList = arrayList2;
        }
        catch (Throwable throwable) {
            long l3 = System.currentTimeMillis() - l2;
            if (l3 > 200L && this.recurse) {
                GlobalLog.getLogger().debug("*** Lengthy recursive directory listing: %s: %dms", this.base, l3);
            }
            throw throwable;
        }
        long l4 = System.currentTimeMillis() - l2;
        if (l4 > 200L && this.recurse) {
            GlobalLog.getLogger().debug("*** Lengthy recursive directory listing: %s: %dms", this.base, l4);
        }
        return arrayList;
    }

    private void listFilesRecurse(File file, List<File> list, int n2) {
        if (file.isDirectory()) {
            if (n2 == 0) {
                return;
            }
            if (this.blacklistedDirnames.contains(file.getName())) {
                return;
            }
            for (String string : file.list()) {
                this.listFilesRecurse(new File(file, string), list, n2 - 1);
            }
        } else if (file.isFile() && (this.pattern == null || this.pattern.matcher(file.getName()).matches())) {
            list.add(file);
        }
    }

    @Override
    public Iterator<File> iterator() {
        return new DirIter();
    }

    class DirIter
    implements Iterator<File> {
        List<File> tba = new ArrayList<File>();
        File curdir;
        String[] curnames = new String[0];
        int index;
        File curfile;

        DirIter() {
            this.tba.add(DirectoryEnumerator.this.base);
            this.curfile = this.prepareNext();
        }

        @Override
        public boolean hasNext() {
            return this.curfile != null;
        }

        @Override
        public File next() {
            if (this.curfile == null) {
                throw new NoSuchElementException();
            }
            File file = this.curfile;
            this.curfile = this.prepareNext();
            return file;
        }

        private File prepareNext() {
            block5: {
                File file;
                block0: while (true) {
                    if (this.index >= this.curnames.length) {
                        if (this.tba.isEmpty()) break block5;
                        this.curdir = this.tba.remove(0);
                        this.curnames = this.curdir.list();
                        if (this.curnames == null) {
                            this.curnames = new String[0];
                        }
                        this.index = 0;
                    }
                    while (true) {
                        String string;
                        if (this.index >= this.curnames.length) continue block0;
                        if ((file = new File(this.curdir, string = this.curnames[this.index++])).isDirectory()) {
                            if (DirectoryEnumerator.this.blacklistedDirnames.contains(string)) continue;
                            this.tba.add(file);
                            continue;
                        }
                        if (file.isFile() && (DirectoryEnumerator.this.pattern == null || DirectoryEnumerator.this.pattern.matcher(string).matches())) break block0;
                    }
                    break;
                }
                return file;
            }
            return null;
        }
    }
}

