/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import com.pnfsoftware.jeb.util.format.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;

public class ChannelUtil {
    public static ByteBuffer read(SeekableByteChannel seekableByteChannel, long l2, int n2, boolean bl) throws IOException {
        return ChannelUtil.read(seekableByteChannel, l2, n2, bl, null);
    }

    public static ByteBuffer read(SeekableByteChannel seekableByteChannel, long l2, int n2, boolean bl, ByteBuffer byteBuffer) throws IOException {
        return ChannelUtil.readInternal(seekableByteChannel, l2, n2, bl, byteBuffer, false);
    }

    public static ByteBuffer readBestEffort(SeekableByteChannel seekableByteChannel, long l2, int n2, boolean bl, ByteBuffer byteBuffer) throws IOException {
        return ChannelUtil.readInternal(seekableByteChannel, l2, n2, bl, byteBuffer, true);
    }

    private static ByteBuffer readInternal(SeekableByteChannel seekableByteChannel, long l2, int n2, boolean bl, ByteBuffer byteBuffer, boolean bl2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative size");
        }
        if (n2 == 0) {
            return ChannelUtil.prepareBuffer(byteBuffer, 0, bl);
        }
        long l3 = seekableByteChannel.size();
        if (Long.compareUnsigned(l2, l3) >= 0) {
            if (bl2) {
                return ChannelUtil.prepareBuffer(byteBuffer, 0, bl);
            }
            throw new IOException(Strings.ff("Read 0 bytes at offset %Xh, expected %d", l2, n2));
        }
        long l4 = l3 - l2;
        int n3 = n2;
        if (Long.compareUnsigned(n2, l4) > 0) {
            n3 = (int)l4;
        }
        byteBuffer = ChannelUtil.prepareBuffer(byteBuffer, n3, bl);
        seekableByteChannel.position(l2);
        int n4 = seekableByteChannel.read(byteBuffer);
        if (n4 != n2) {
            if (bl2) {
                byteBuffer.limit(Math.max(0, n4));
            } else {
                throw new IOException(Strings.ff("Read %d bytes at offset %Xh, expected %d", n4, l2, n2));
            }
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    private static ByteBuffer prepareBuffer(ByteBuffer byteBuffer, int n2, boolean bl) {
        if (byteBuffer == null || byteBuffer.capacity() < n2) {
            byteBuffer = ByteBuffer.allocate(n2);
        } else {
            byteBuffer.clear();
            byteBuffer.limit(n2);
        }
        byteBuffer.order(bl ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        return byteBuffer;
    }

    public static byte[] getAllFrom(SeekableByteChannel seekableByteChannel, long l2) throws IOException {
        seekableByteChannel.position(l2);
        long l3 = seekableByteChannel.size() - l2;
        if (l3 > Integer.MAX_VALUE) {
            throw new IOException("Cannot alocate that many bytes: " + l3);
        }
        byte[] byArray = new byte[(int)l3];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n2 = seekableByteChannel.read(byteBuffer);
        if (n2 != byArray.length) {
            throw new IOException(Strings.ff("Wanted to read %d bytes, got %d only", byArray.length, n2));
        }
        return byArray;
    }

    public static byte get(SeekableByteChannel seekableByteChannel, long l2) throws IOException {
        seekableByteChannel.position(l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        if (seekableByteChannel.read(byteBuffer) != 1) {
            throw new IOException(Strings.ff("Expected a byte at offset %Xh", l2));
        }
        return byteBuffer.get(0);
    }

    public static byte get(SeekableByteChannel seekableByteChannel) throws IOException {
        return ChannelUtil.get(seekableByteChannel, seekableByteChannel.position());
    }

    public static byte[] getBytes(SeekableByteChannel seekableByteChannel, long l2, int n2) throws IOException {
        seekableByteChannel.position(l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        if (seekableByteChannel.read(byteBuffer) != n2) {
            throw new IOException(Strings.ff("Expected %d bytes at offset %Xh", n2, l2));
        }
        return byteBuffer.array();
    }

    public static byte[] getBytes(SeekableByteChannel seekableByteChannel, int n2) throws IOException {
        return ChannelUtil.getBytes(seekableByteChannel, seekableByteChannel.position(), n2);
    }

    public static short getShort(SeekableByteChannel seekableByteChannel, long l2, ByteOrder byteOrder) throws IOException {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return ChannelUtil.getBEShort(seekableByteChannel, l2);
        }
        return ChannelUtil.getLEShort(seekableByteChannel, l2);
    }

    public static int getInt(SeekableByteChannel seekableByteChannel, long l2, ByteOrder byteOrder) throws IOException {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return ChannelUtil.getBEInt(seekableByteChannel, l2);
        }
        return ChannelUtil.getLEInt(seekableByteChannel, l2);
    }

    public static long getLong(SeekableByteChannel seekableByteChannel, long l2, ByteOrder byteOrder) throws IOException {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return ChannelUtil.getBELong(seekableByteChannel, l2);
        }
        return ChannelUtil.getLELong(seekableByteChannel, l2);
    }

    public static short getShort(SeekableByteChannel seekableByteChannel, ByteOrder byteOrder) throws IOException {
        return ChannelUtil.getShort(seekableByteChannel, seekableByteChannel.position(), byteOrder);
    }

    public static int getInt(SeekableByteChannel seekableByteChannel, ByteOrder byteOrder) throws IOException {
        return ChannelUtil.getInt(seekableByteChannel, seekableByteChannel.position(), byteOrder);
    }

    public static long getLong(SeekableByteChannel seekableByteChannel, ByteOrder byteOrder) throws IOException {
        return ChannelUtil.getLong(seekableByteChannel, seekableByteChannel.position(), byteOrder);
    }

    public static short getLEShort(SeekableByteChannel seekableByteChannel, long l2) throws IOException {
        seekableByteChannel.position(l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
        if (seekableByteChannel.read(byteBuffer) != 2) {
            throw new IOException(Strings.ff("Expected a short at offset %Xh", l2));
        }
        return byteBuffer.getShort(0);
    }

    public static int getLEInt(SeekableByteChannel seekableByteChannel, long l2) throws IOException {
        seekableByteChannel.position(l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        if (seekableByteChannel.read(byteBuffer) != 4) {
            throw new IOException(Strings.ff("Expected an int at offset %Xh", l2));
        }
        return byteBuffer.getInt(0);
    }

    public static long getLELong(SeekableByteChannel seekableByteChannel, long l2) throws IOException {
        seekableByteChannel.position(l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        if (seekableByteChannel.read(byteBuffer) != 8) {
            throw new IOException(Strings.ff("Expected a long at offset %Xh", l2));
        }
        return byteBuffer.getLong(0);
    }

    public static short getBEShort(SeekableByteChannel seekableByteChannel, long l2) throws IOException {
        seekableByteChannel.position(l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2).order(ByteOrder.BIG_ENDIAN);
        if (seekableByteChannel.read(byteBuffer) != 2) {
            throw new IOException(Strings.ff("Expected a short at offset %Xh", l2));
        }
        return byteBuffer.getShort(0);
    }

    public static int getBEInt(SeekableByteChannel seekableByteChannel, long l2) throws IOException {
        seekableByteChannel.position(l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
        if (seekableByteChannel.read(byteBuffer) != 4) {
            throw new IOException(Strings.ff("Expected an int at offset %Xh", l2));
        }
        return byteBuffer.getInt(0);
    }

    public static long getBELong(SeekableByteChannel seekableByteChannel, long l2) throws IOException {
        seekableByteChannel.position(l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        if (seekableByteChannel.read(byteBuffer) != 8) {
            throw new IOException(Strings.ff("Expected a long at offset %Xh", l2));
        }
        return byteBuffer.getLong(0);
    }

    public static short getLEShort(SeekableByteChannel seekableByteChannel) throws IOException {
        return ChannelUtil.getLEShort(seekableByteChannel, seekableByteChannel.position());
    }

    public static int getLEInt(SeekableByteChannel seekableByteChannel) throws IOException {
        return ChannelUtil.getLEInt(seekableByteChannel, seekableByteChannel.position());
    }

    public static long getLELong(SeekableByteChannel seekableByteChannel) throws IOException {
        return ChannelUtil.getLELong(seekableByteChannel, seekableByteChannel.position());
    }

    public static short getBEShort(SeekableByteChannel seekableByteChannel) throws IOException {
        return ChannelUtil.getBEShort(seekableByteChannel, seekableByteChannel.position());
    }

    public static int getBEInt(SeekableByteChannel seekableByteChannel) throws IOException {
        return ChannelUtil.getBEInt(seekableByteChannel, seekableByteChannel.position());
    }

    public static long getBELong(SeekableByteChannel seekableByteChannel) throws IOException {
        return ChannelUtil.getBELong(seekableByteChannel, seekableByteChannel.position());
    }

    public static byte[] getBytesUntil(SeekableByteChannel seekableByteChannel, int n2, int n3, boolean bl) throws IOException {
        int n4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[256];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        boolean bl2 = false;
        for (int i = n3; i > 0 && !bl2; i -= n4) {
            int n5;
            byteBuffer.position(0);
            if (i < byteBuffer.limit()) {
                byteBuffer.limit(i);
                bl2 = true;
            }
            if ((n5 = seekableByteChannel.read(byteBuffer)) <= 0) {
                if (!bl) break;
                throw new IOException("Not enough data");
            }
            for (n4 = 0; n4 < n5; ++n4) {
                if (byArray[n4] != n2) continue;
                bl2 = true;
                break;
            }
            byteArrayOutputStream.write(byArray, 0, n4);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

