/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import com.pnfsoftware.jeb.util.io.Endianness;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class ChannelHelper {
    SeekableByteChannel channel;
    Endianness endianness;
    byte[] array;
    ByteBuffer b;

    public ChannelHelper(SeekableByteChannel seekableByteChannel, Endianness endianness) {
        this.channel = seekableByteChannel;
        this.endianness = endianness;
        this.array = new byte[8];
        this.b = ByteBuffer.wrap(this.array);
        this.b.order(endianness.toByteOrder());
    }

    private void prep(int n2, long l2) throws IOException {
        this.channel.position(l2);
        this.prep(n2);
    }

    private void prep(int n2) throws IOException {
        this.b.position(0);
        this.b.limit(n2);
    }

    public byte get() throws IOException {
        this.prep(1);
        if (this.channel.read(this.b) != 1) {
            throw new IOException("Cannot read 1 byte");
        }
        return this.array[0];
    }

    public byte get(long l2) throws IOException {
        this.prep(1, l2);
        if (this.channel.read(this.b) != 1) {
            throw new IOException("Cannot read 1 byte");
        }
        return this.array[0];
    }

    public short getShort() throws IOException {
        this.prep(2);
        if (this.channel.read(this.b) != 2) {
            throw new IOException("Cannot read 2 bytes");
        }
        return this.b.getShort(0);
    }

    public short getShort(long l2) throws IOException {
        this.prep(2, l2);
        if (this.channel.read(this.b) != 2) {
            throw new IOException("Cannot read 2 bytes");
        }
        return this.b.getShort(0);
    }

    public int getInt() throws IOException {
        this.prep(4);
        if (this.channel.read(this.b) != 4) {
            throw new IOException("Cannot read 4 bytes");
        }
        return this.b.getInt(0);
    }

    public int getInt(long l2) throws IOException {
        this.prep(4, l2);
        if (this.channel.read(this.b) != 4) {
            throw new IOException("Cannot read 4 bytes");
        }
        return this.b.getInt(0);
    }

    public long getLong() throws IOException {
        this.prep(8);
        if (this.channel.read(this.b) != 8) {
            throw new IOException("Cannot read 8 bytes");
        }
        return this.b.getLong(0);
    }

    public long getLong(long l2) throws IOException {
        this.prep(8, l2);
        if (this.channel.read(this.b) != 8) {
            throw new IOException("Cannot read 8 bytes");
        }
        return this.b.getLong(0);
    }
}

