/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferUtil {
    public static boolean equalsByteArray(ByteBuffer byteBuffer, int n2, byte[] byArray, int n3, int n4) {
        for (int i = 0; i < n4; ++i) {
            if (byteBuffer.get(n2 + i) == byArray[n3 + i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] getBytes(ByteBuffer byteBuffer, int n2, int n3) {
        byte[] byArray = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            byArray[i] = byteBuffer.get(n2 + i);
        }
        return byArray;
    }

    public static byte[] getBytes(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static void skip(ByteBuffer byteBuffer, int n2) {
        byteBuffer.position(byteBuffer.position() + n2);
    }

    public static int skipAttempt(ByteBuffer byteBuffer, int n2) {
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.remaining();
        if (n2 > n4) {
            n2 = n4;
        } else if (n2 < 0 && n2 + n3 < 0) {
            n2 = -n3;
        }
        byteBuffer.position(n3 + n2);
        return n2;
    }

    public static void skipToEnd(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        if (n2 > 0) {
            byteBuffer.position(byteBuffer.position() + n2);
        }
    }

    public static long getUnsignedInt(ByteBuffer byteBuffer) {
        return byteBuffer.getInt() & 0xFFFFFFFF;
    }

    public static long getUnsignedInt(ByteBuffer byteBuffer, int n2) {
        return byteBuffer.getInt(n2) & 0xFFFFFFFF;
    }

    public static ByteBuffer wrapLE(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer;
    }

    public static ByteBuffer wrapBE(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return byteBuffer;
    }

    public static ByteBuffer wrapLE(byte[] byArray, int n2, int n3) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer;
    }

    public static ByteBuffer wrapBE(byte[] byArray, int n2, int n3) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return byteBuffer;
    }

    public static int align(ByteBuffer byteBuffer, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Invalid alignment: " + n2);
        }
        int n3 = byteBuffer.position();
        int n4 = n2 - n3 % n2;
        if (n4 != n2) {
            byteBuffer.position(n3 += n4);
        }
        return n3;
    }
}

