/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import com.pnfsoftware.jeb.util.encoding.BadEncodingException;
import com.pnfsoftware.jeb.util.encoding.LEB128;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import java.util.Arrays;

public class ByteArray {
    byte[] bytes;
    int index;
    int maxindex;

    public ByteArray(byte[] byArray) {
        this(byArray, 0);
    }

    public ByteArray(byte[] byArray, int n2) {
        this(byArray, n2, byArray.length);
    }

    public ByteArray(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new IllegalArgumentException("Null byte array");
        }
        this.bytes = byArray;
        this.position(n2);
        this.maxPosition(n3);
    }

    public ByteArray copy() {
        return this.copy(this.index);
    }

    public ByteArray copy(int n2) {
        return this.copy(n2, this.maxindex);
    }

    public ByteArray copy(int n2, int n3) {
        return new ByteArray(this.bytes, n2, n3);
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public int position(int n2) {
        if (n2 < 0 || n2 > this.bytes.length) {
            throw new IllegalArgumentException("Illegal position: " + n2);
        }
        int n3 = this.index;
        this.index = n2;
        return n3;
    }

    public int position() {
        return this.index;
    }

    public int maxPosition(int n2) {
        if (n2 < 0 || n2 > this.bytes.length) {
            throw new IllegalArgumentException("Illegal max position: " + n2);
        }
        int n3 = this.maxindex;
        this.maxindex = n2;
        return n3;
    }

    public int maxPosition() {
        return this.maxindex;
    }

    public int available() {
        return this.maxindex - this.index;
    }

    private void updateIndex(int n2) {
        this.index += n2;
        if (this.index > this.maxindex) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public void skip(int n2) {
        this.updateIndex(n2);
    }

    public byte get() {
        byte by = this.bytes[this.index];
        this.updateIndex(1);
        return by;
    }

    public byte[] get(int n2) {
        byte[] byArray = Arrays.copyOfRange(this.bytes, this.index, this.index + n2);
        this.updateIndex(n2);
        return byArray;
    }

    public int i8() {
        byte by = this.bytes[this.index];
        this.updateIndex(1);
        return by;
    }

    public int u8() {
        int n2 = this.bytes[this.index] & 0xFF;
        this.updateIndex(1);
        return n2;
    }

    public int i16() {
        short s2 = EndianUtil.littleEndianBytesToShort(this.bytes, this.index);
        this.updateIndex(2);
        return s2;
    }

    public int u16() {
        int n2 = EndianUtil.littleEndianBytesToShort(this.bytes, this.index) & 0xFFFF;
        this.updateIndex(2);
        return n2;
    }

    public int u31() {
        int n2 = EndianUtil.littleEndianBytesToInt(this.bytes, this.index);
        if (n2 < 0) {
            throw new BadEncodingException(Strings.ff("Expected a positive 4-byte signed integer, got 0x%X", n2), this.index);
        }
        this.updateIndex(4);
        return n2;
    }

    public int i32() {
        int n2 = EndianUtil.littleEndianBytesToInt(this.bytes, this.index);
        this.updateIndex(4);
        return n2;
    }

    public long u32() {
        int n2 = EndianUtil.littleEndianBytesToInt(this.bytes, this.index);
        this.updateIndex(4);
        return (long)n2 & 0xFFFFFFFFL;
    }

    public long u63() {
        long l2 = EndianUtil.littleEndianBytesToLong(this.bytes, this.index);
        if (l2 < 0L) {
            throw new BadEncodingException(Strings.ff("Expected a positive 8-byte signed integer, got 0x%X", l2), this.index);
        }
        this.updateIndex(8);
        return l2;
    }

    public long i64() {
        long l2 = EndianUtil.littleEndianBytesToLong(this.bytes, this.index);
        this.updateIndex(8);
        return l2;
    }

    public int varu16() {
        LEB128.Value value = LEB128.read_uint16(this.bytes, this.index);
        this.updateIndex(value.getEncodingLength());
        return (int)value.get();
    }

    public int vari32() {
        LEB128.Value value = LEB128.read_int32(this.bytes, this.index);
        this.updateIndex(value.getEncodingLength());
        return (int)value.get();
    }

    public long varu32() {
        LEB128.Value value = LEB128.read_uint32(this.bytes, this.index);
        this.updateIndex(value.getEncodingLength());
        return value.get();
    }

    public long vari64() {
        LEB128.Value value = LEB128.read_int64(this.bytes, this.index);
        this.updateIndex(value.getEncodingLength());
        return value.get();
    }

    public String toString() {
        return Strings.ff("pos:0x%X (max:0x%X)", this.index, this.maxindex);
    }
}

