/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.io;

import com.pnfsoftware.jeb.util.format.Strings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class ArraySeekableByteChannel
implements SeekableByteChannel {
    private byte[] data;
    private int arrayBaseOffset;
    private int length;
    private int position;

    public ArraySeekableByteChannel(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ArraySeekableByteChannel(byte[] byArray, int n2, int n3) {
        this.data = byArray;
        this.arrayBaseOffset = n2;
        this.length = n3;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n2 = this.length - this.position;
        if (n2 <= 0) {
            return -1;
        }
        int n3 = byteBuffer.remaining();
        int n4 = n3 <= n2 ? n3 : n2;
        byteBuffer.put(this.data, this.arrayBaseOffset + this.position, n4);
        this.position += n4;
        return n4;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        throw new IOException("Buffer is not writeable");
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IOException(Strings.ff("Negative position: %d", l2));
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException(Strings.ff("Position is too large: %d", l2));
        }
        this.position = (int)l2;
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.length;
    }

    @Override
    public SeekableByteChannel truncate(long l2) throws IOException {
        throw new IOException("Buffer cannot be truncated");
    }
}

