/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.interpreter;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.interpreter.CommandParameter;
import com.pnfsoftware.jeb.util.interpreter.ExecutionResult;
import com.pnfsoftware.jeb.util.interpreter.ICommandHandler;
import com.pnfsoftware.jeb.util.interpreter.ICommandManager;
import com.pnfsoftware.jeb.util.interpreter.ICommandNode;
import com.pnfsoftware.jeb.util.interpreter.InputToken;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SimpleCommandManager
implements ICommandManager {
    private ICommandManager parent;
    private String name;
    private Map<String, ICommandNode> children = new LinkedHashMap<String, ICommandNode>();
    private Map<String, String> alts = new LinkedHashMap<String, String>();
    private int options;
    private static final int NEW_TOKEN = 0;
    private static final int CURR_TOKEN = 1;
    private static final int QUOTES = 2;

    public SimpleCommandManager() {
        this(null, "");
    }

    public SimpleCommandManager(ICommandManager iCommandManager, String string) {
        if (iCommandManager == null && !string.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.parent = iCommandManager;
        this.name = string;
    }

    @Override
    public ICommandManager getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ICommandNode addChild(ICommandNode iCommandNode) {
        String[] stringArray;
        if (iCommandNode.getParent() == null) {
            throw new IllegalArgumentException();
        }
        String string = iCommandNode.getName();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Command name cannot be null or empty");
        }
        String[] object = stringArray = string.split("\\|");
        int n2 = object.length;
        for (int i = 0; i < n2; ++i) {
            String string2 = object[i];
            if (Strings.hasBlank(string2)) {
                throw new IllegalArgumentException("Invalid command name: " + string2);
            }
            if (Strings.isContainedIn(string2, "help", "use", "list", "exit")) {
                throw new IllegalArgumentException(Strings.ff("'%s' is a reserved command name", string2));
            }
            if (!this.children.containsKey(string2) && !this.alts.containsKey(string2)) continue;
            throw new IllegalArgumentException("Duplicate command name: " + string2);
        }
        String string3 = stringArray[0];
        this.children.put(string3, iCommandNode);
        for (n2 = 1; n2 < stringArray.length; ++n2) {
            this.alts.put(stringArray[n2], string3);
        }
        return iCommandNode;
    }

    @Override
    public List<ICommandNode> getChildren() {
        return new ArrayList<ICommandNode>(this.children.values());
    }

    @Override
    public String getHelp() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.children.keySet()) {
            ICommandNode iCommandNode = this.children.get(string);
            this.appendHelp(stringBuilder, iCommandNode);
        }
        return stringBuilder.toString();
    }

    private void appendParam(StringBuilder stringBuilder, CommandParameter commandParameter) {
        if (commandParameter.isOptional()) {
            stringBuilder.append('[');
        }
        if (commandParameter.hasPrefix()) {
            stringBuilder.append('-').append(commandParameter.getPrefix());
            if (!commandParameter.getName().isEmpty()) {
                stringBuilder.append(" ");
            }
        }
        stringBuilder.append(commandParameter.getName());
        if (commandParameter.isOptional()) {
            stringBuilder.append(']');
        }
    }

    private void appendHelp(StringBuilder stringBuilder, ICommandNode iCommandNode) {
        StringBuilder stringBuilder2 = new StringBuilder(SimpleCommandManager.getFullName(iCommandNode));
        if (iCommandNode instanceof ICommandHandler) {
            for (CommandParameter commandParameter : ((ICommandHandler)iCommandNode).getParameters()) {
                stringBuilder2.append(' ');
                this.appendParam(stringBuilder2, commandParameter);
            }
        }
        if (stringBuilder2.length() > 30 && this.hasOptionalParameters((ICommandHandler)iCommandNode)) {
            stringBuilder2 = new StringBuilder(SimpleCommandManager.getFullName(iCommandNode));
            stringBuilder2.append(" [OPTION]...");
            if (iCommandNode instanceof ICommandHandler) {
                for (CommandParameter commandParameter : ((ICommandHandler)iCommandNode).getParameters()) {
                    if (commandParameter.isOptional()) continue;
                    stringBuilder2.append(' ');
                    this.appendParam(stringBuilder2, commandParameter);
                }
            }
        }
        Strings.ff(stringBuilder, "%-30s : %s\n", stringBuilder2, iCommandNode.getHelp());
    }

    private boolean hasOptionalParameters(ICommandHandler iCommandHandler) {
        for (CommandParameter commandParameter : iCommandHandler.getParameters()) {
            if (!commandParameter.isOptional()) continue;
            return true;
        }
        return false;
    }

    private String getHelp(String string) {
        CharSequence charSequence;
        ICommandNode iCommandNode = this.children.get(string);
        if (iCommandNode == null) {
            charSequence = this.alts.get(string);
            if (charSequence == null) {
                return null;
            }
            iCommandNode = this.children.get(charSequence);
        }
        if (iCommandNode == null) {
            return null;
        }
        charSequence = new StringBuilder();
        this.appendHelp((StringBuilder)charSequence, iCommandNode);
        if (iCommandNode instanceof ICommandHandler) {
            for (CommandParameter commandParameter : ((ICommandHandler)iCommandNode).getParameters()) {
                this.appendParam((StringBuilder)charSequence, commandParameter);
                if (!Strings.isBlank(commandParameter.getHelp())) {
                    ((StringBuilder)charSequence).append(": ").append(commandParameter.getHelp());
                }
                ((StringBuilder)charSequence).append('\n');
            }
            ((StringBuilder)charSequence).append(((ICommandHandler)iCommandNode).getHelpDetails()).append('\n');
        }
        return ((StringBuilder)charSequence).toString();
    }

    private static String getFullName(ICommandNode iCommandNode) {
        Object object = iCommandNode.getName();
        for (ICommandManager iCommandManager = iCommandNode.getParent(); iCommandManager != null && iCommandManager.getParent() != null; iCommandManager = iCommandManager.getParent()) {
            object = iCommandManager.getName() + " " + (String)object;
        }
        return ((String)object).trim();
    }

    public ExecutionResult execute(String string) {
        List<InputToken> list;
        try {
            list = this.parseTokenString(string);
        }
        catch (ParseException parseException) {
            return ExecutionResult.error(parseException.toString());
        }
        return this.execute(list);
    }

    @Override
    public ExecutionResult execute(List<InputToken> list) {
        Object object;
        if (list == null || list.isEmpty()) {
            return null;
        }
        String string = list.get(0).getValue();
        if (string.equals("help")) {
            if (list.size() == 1) {
                return ExecutionResult.success(this.getHelp());
            }
            String string2 = list.get(1).getValue();
            String string3 = this.getHelp(string2);
            if (string3 == null) {
                return ExecutionResult.error(Strings.ff("No section with name %s", string2));
            }
            return ExecutionResult.success(string3);
        }
        ICommandNode iCommandNode = this.children.get(string);
        if (iCommandNode == null) {
            object = this.alts.get(string);
            if (object == null) {
                return null;
            }
            iCommandNode = this.children.get(object);
        }
        if ((object = this.preCheck()) != null && ((ExecutionResult)object).isError()) {
            return object;
        }
        object = iCommandNode.execute(list.subList(1, list.size()));
        if (object != null && ((ExecutionResult)object).isError()) {
            return object;
        }
        ExecutionResult executionResult = this.postCheck();
        if (executionResult != null && executionResult.isError()) {
            return executionResult;
        }
        return object != null ? object : ExecutionResult.GENERIC_SUCCESS;
    }

    protected ExecutionResult preCheck() {
        return null;
    }

    protected ExecutionResult postCheck() {
        return null;
    }

    public List<InputToken> parseTokenString(String string) throws ParseException {
        ArrayList<InputToken> arrayList = new ArrayList<InputToken>();
        int n2 = 0;
        StringBuilder stringBuilder = null;
        boolean bl = false;
        int n3 = this.options;
        for (int i = 0; i < string.length(); ++i) {
            if (arrayList.size() == 1 && !bl) {
                bl = true;
                ICommandNode iCommandNode = this.children.get(((InputToken)arrayList.get(0)).getValue());
                if (iCommandNode != null) {
                    n3 = iCommandNode.getOptions();
                }
            }
            char c2 = string.charAt(i);
            if (n2 == 0) {
                stringBuilder = new StringBuilder();
            }
            if (Character.isWhitespace(c2)) {
                if (n2 == 0) continue;
                if (n2 == 1) {
                    arrayList.add(new InputToken(stringBuilder.toString()));
                    n2 = 0;
                    continue;
                }
                if (n2 != 2) continue;
                stringBuilder.append(c2);
                continue;
            }
            if (c2 == '\"' && (n3 & 1) == 0) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                if (n2 == 1) {
                    throw new ParseException("Unexpected double-quote", i);
                }
                if (n2 != 2) continue;
                arrayList.add(new InputToken(stringBuilder.toString(), true));
                n2 = 0;
                continue;
            }
            if (c2 == '\\') {
                if (i + 1 >= string.length()) {
                    throw new ParseException("Unexpected EOL after backslash", i);
                }
                stringBuilder.append('\\');
                c2 = string.charAt(i + 1);
                ++i;
            }
            if (n2 == 0) {
                n2 = 1;
            }
            stringBuilder.append(c2);
        }
        if (stringBuilder != null && stringBuilder.length() != 0) {
            if (n2 == 1) {
                arrayList.add(new InputToken(stringBuilder.toString()));
            } else if (n2 == 2) {
                throw new ParseException("Token is incomplete, missing closing double-quote", string.length());
            }
        }
        return arrayList;
    }

    @Override
    public int getOptions() {
        return this.options;
    }
}

