/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.interpreter;

import com.pnfsoftware.jeb.util.collect.BytePipe;
import com.pnfsoftware.jeb.util.format.Strings;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class InputToken {
    private String value;
    private boolean needsUnescaping;

    public InputToken(String string, boolean bl) {
        this.value = string;
        this.needsUnescaping = bl;
    }

    public InputToken(String string) {
        this(string, false);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        if (this.needsUnespaping()) {
            return Strings.ff("\"%s\"", this.getValue());
        }
        return this.getValue();
    }

    public boolean needsUnespaping() {
        return this.needsUnescaping;
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        if (!this.needsUnescaping) {
            return this.value.getBytes(Charset.defaultCharset());
        }
        BytePipe bytePipe = new BytePipe(this.value.length());
        for (int i = 0; i < this.value.length(); ++i) {
            char c2 = this.value.charAt(i);
            if (c2 > '\u007f') {
                throw new UnsupportedEncodingException("Only characters in the ASCII range are allowed in escaped strings");
            }
            int n2 = c2;
            if (n2 == 92) {
                if (i + 1 > this.value.length()) {
                    throw new UnsupportedEncodingException("Illegal escape character:");
                }
                c2 = this.value.charAt(i + 1);
                ++i;
                switch (c2) {
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        n2 = (byte)c2;
                        break;
                    }
                    case 't': {
                        n2 = 9;
                        break;
                    }
                    case 'r': {
                        n2 = 13;
                        break;
                    }
                    case 'n': {
                        n2 = 10;
                        break;
                    }
                    case 'b': {
                        n2 = 8;
                        break;
                    }
                    case 'f': {
                        n2 = 12;
                        break;
                    }
                    case 'x': {
                        if (i + 2 > this.value.length()) {
                            throw new UnsupportedEncodingException("Missing characters after \\x");
                        }
                        try {
                            n2 = (byte)Integer.parseInt(this.value.substring(i + 1, i + 3), 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new UnsupportedEncodingException("Illegal escaped byte");
                        }
                        i += 2;
                        break;
                    }
                    default: {
                        throw new UnsupportedEncodingException("Illegal escape character");
                    }
                }
            }
            bytePipe.append((byte)n2);
        }
        return bytePipe.getAll();
    }
}

