/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.interpreter;

import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.interpreter.CommandParameter;
import com.pnfsoftware.jeb.util.interpreter.ICommandHandler;
import com.pnfsoftware.jeb.util.interpreter.ICommandManager;
import com.pnfsoftware.jeb.util.interpreter.ICommandNode;
import com.pnfsoftware.jeb.util.interpreter.InputToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractCommandHandler
implements ICommandHandler {
    protected ICommandManager parent;
    protected String name;
    protected List<CommandParameter> params = new ArrayList<CommandParameter>();
    protected String help = "";
    protected String helpDetails = "";
    private int options = 0;

    public AbstractCommandHandler(ICommandManager iCommandManager, String string) {
        this(iCommandManager, string, "");
    }

    public AbstractCommandHandler(ICommandManager iCommandManager, String string, String string2) {
        this.parent = iCommandManager;
        this.name = string;
        this.help = string2;
        this.helpDetails = "";
    }

    public AbstractCommandHandler(ICommandManager iCommandManager, String string, String[] stringArray, String string2, String string3) {
        this(iCommandManager, string, string2);
        this.helpDetails = string3;
        for (String string4 : stringArray) {
            this.addParameter(new CommandParameter(string4, "", false));
        }
    }

    public AbstractCommandHandler(ICommandManager iCommandManager, String string, CommandParameter[] commandParameterArray, String string2, String string3) {
        this(iCommandManager, string, string2);
        this.helpDetails = string3;
        for (CommandParameter commandParameter : commandParameterArray) {
            this.params.add(commandParameter);
        }
    }

    public InputToken[] parseInputToken(List<InputToken> list) {
        return this.parseInputToken(list, true);
    }

    public InputToken[] parseInputToken(List<InputToken> list, boolean bl) {
        Object object;
        int n2;
        InputToken[] inputTokenArray = new InputToken[this.params.size()];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl2 = true;
        boolean bl3 = this.params.get(this.params.size() - 1).allowMultipleTokens();
        int n3 = -1;
        block0: for (n2 = 0; n2 < list.size(); ++n2) {
            object = list.get(n2);
            boolean bl4 = !((InputToken)object).needsUnespaping() && ((InputToken)object).getValue().startsWith("-");
            String string = ((InputToken)object).getValue();
            if (bl4) {
                if (!bl2) {
                    throw new IllegalArgumentException(Strings.ff("Unexpected prefixed parameter %s", ((InputToken)object).getValue()));
                }
                string = string.substring(1);
            } else {
                bl2 = false;
            }
            for (int i = 0; i < this.params.size(); ++i) {
                CommandParameter commandParameter = this.params.get(i);
                if (bl4) {
                    if (commandParameter.hasPrefix()) {
                        if (!string.contains(commandParameter.getPrefix())) continue;
                        if (inputTokenArray[i] != null) {
                            throw new IllegalArgumentException(Strings.ff("Duplicated parameter -%s", commandParameter.getPrefix()));
                        }
                        if (Strings.isBlank(commandParameter.getName())) {
                            inputTokenArray[i] = object;
                            string = string.replace(commandParameter.getPrefix(), "");
                        } else {
                            if (!string.endsWith(commandParameter.getPrefix())) {
                                throw new IllegalArgumentException(Strings.ff("Expected token after %s ", commandParameter.getPrefix()));
                            }
                            string = string.substring(0, string.length() - commandParameter.getPrefix().length());
                            if (++n2 < list.size()) {
                                inputTokenArray[i] = list.get(n2);
                            } else {
                                throw new IllegalArgumentException(Strings.ff("Expected token after -%s", commandParameter.getPrefix()));
                            }
                        }
                        if (!string.isEmpty()) continue;
                        continue block0;
                    }
                    throw new IllegalArgumentException(Strings.ff("Unexpected parameter %s", string));
                }
                if (n3 == -1 && commandParameter.hasPrefix()) continue;
                if (n3 == -1) {
                    n3 = i;
                }
                if (n3 < this.params.size()) {
                    inputTokenArray[n3] = object;
                    ++n3;
                    continue block0;
                }
                if (bl3) {
                    arrayList.add(object);
                    continue block0;
                }
                throw new IllegalArgumentException(Strings.ff("Extra parameter %s", string));
            }
        }
        if (bl) {
            for (n2 = 0; n2 < this.params.size(); ++n2) {
                object = this.params.get(n2);
                if (((CommandParameter)object).isOptional() || inputTokenArray[n2] != null) continue;
                throw new IllegalArgumentException(Strings.ff("Missing parameter %s", ((CommandParameter)object).getName()));
            }
        }
        if (bl3 && !arrayList.isEmpty()) {
            for (n2 = 0; n2 < this.params.size(); ++n2) {
                arrayList.add(n2, inputTokenArray[n2]);
            }
            inputTokenArray = arrayList.toArray(new InputToken[arrayList.size()]);
        }
        return inputTokenArray;
    }

    @Override
    public ICommandManager getParent() {
        return this.parent;
    }

    @Override
    public List<ICommandNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    @Override
    public String getHelp() {
        return this.help;
    }

    protected void setHelp(String string) {
        this.help = string;
    }

    @Override
    public String getHelpDetails() {
        return this.helpDetails;
    }

    @Override
    public List<CommandParameter> getParameters() {
        return this.params;
    }

    public int getParameterIndex(String string, String string2) {
        for (int i = 0; i < this.params.size(); ++i) {
            CommandParameter commandParameter = this.params.get(i);
            if (!Strings.equals(string2, commandParameter.getPrefix()) || !Strings.equals(string, commandParameter.getName())) continue;
            return i;
        }
        return -1;
    }

    public AbstractCommandHandler addParameter(String string) {
        return this.addParameter(new CommandParameter(string, false));
    }

    public AbstractCommandHandler addParameter(CommandParameter commandParameter) {
        if (commandParameter.getName() == null || commandParameter.getName().isEmpty()) {
            throw new IllegalArgumentException("Parameter name is empty or null");
        }
        for (CommandParameter commandParameter2 : this.params) {
            if (commandParameter.getName().equalsIgnoreCase(commandParameter2.getName())) {
                throw new IllegalArgumentException("Duplicate parameter");
            }
            if (!commandParameter.isOptional() && !commandParameter.hasPrefix() && commandParameter2.isOptional()) {
                throw new IllegalArgumentException("Mandatory parameters must come first");
            }
            if (!commandParameter.hasPrefix() || commandParameter2.hasPrefix()) continue;
            throw new IllegalArgumentException("Prefixed parameters must comme first");
        }
        this.params.add(commandParameter);
        return this;
    }

    public String toString() {
        return Strings.ff("%s", this.getName());
    }

    public static InputToken getToken(List<InputToken> list, int n2) {
        if (list == null || n2 < 0 || n2 >= list.size()) {
            return null;
        }
        return list.get(n2);
    }

    public static String getParameter(List<InputToken> list, int n2) {
        InputToken inputToken = AbstractCommandHandler.getToken(list, n2);
        if (inputToken == null) {
            return null;
        }
        return inputToken.getValue();
    }

    public static String getParameterSafe(List<InputToken> list, int n2) {
        return Strings.safe(AbstractCommandHandler.getParameter(list, n2));
    }

    @Override
    public int getOptions() {
        return this.options;
    }

    public AbstractCommandHandler setOptions(int n2) {
        this.options = n2;
        return this;
    }
}

