/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.util.graph;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.exceptions.InterruptionException;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.collect.MultiList;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class Digraph {
    private static final ILogger logger = GlobalLog.getLogger(Digraph.class);
    private boolean done;
    private List<V> vertices = new ArrayList<V>();
    private TreeMap<Integer, V> vertexmap = new TreeMap();
    private List<E> edges = new ArrayList<E>();
    private MultiList<E> edgefrommap = new MultiList();
    private MultiList<E> edgetomap = new MultiList();
    private List<Set<Integer>> reachabilityIndices;

    public static Digraph create() {
        return new Digraph();
    }

    public List<V> copyOfVertices() {
        ArrayList<V> arrayList = new ArrayList<V>(this.getVertexCount());
        for (V v2 : this.vertices) {
            arrayList.add(v2.clone());
        }
        return arrayList;
    }

    public List<E> copyOfEdges() {
        ArrayList<E> arrayList = new ArrayList<E>(this.getEdgeCount());
        for (E e : this.edges) {
            arrayList.add(e.clone());
        }
        return arrayList;
    }

    public int getVertexCount() {
        return this.vertices.size();
    }

    public List<V> getVertices() {
        return this.vertices;
    }

    public V getVertex(int n2) {
        return this.vertexmap.get(n2);
    }

    public V getVertexByIndex(int n2) {
        return this.vertices.get(n2);
    }

    public String getVertexLabel(int n2) {
        return this.vertexmap.get(n2).getLabel();
    }

    public void setVertexLabel(int n2, String string) {
        this.vertexmap.get(n2).setLabel(string);
    }

    public void setVertexLabels(Object ... objectArray) {
        for (int i = 0; i < objectArray.length - 1; i += 2) {
            Object object = objectArray[i];
            Object object2 = objectArray[i + 1];
            if (!(object instanceof Integer) || !(object2 instanceof String)) continue;
            this.setVertexLabel((Integer)object, (String)object2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeVertex(V v2, boolean bl) {
        void var5_12;
        Assert.a(this.vertices.indexOf(v2) == v2.index);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (E iterator : this.edgefrommap.get(v2.index)) {
            arrayList.add(iterator.getDst().id);
        }
        ArrayList arrayList2 = new ArrayList();
        for (E e2 : this.edgetomap.get(v2.index)) {
            arrayList2.add(e2.getSrc().id);
        }
        for (E e2 : this.edgetomap.get(v2.index)) {
            this.edgefrommap.removeMultipleElements(e2.src.index, e -> e.dst == v2);
        }
        for (E e2 : this.edgefrommap.get(v2.index)) {
            this.edgetomap.removeMultipleElements(e2.dst.index, e -> e.src == v2);
        }
        for (E e2 : this.edgefrommap.remove(v2.index)) {
            Assert.a(this.edges.remove(e2), "Edge " + e2 + " is not present");
        }
        for (E e2 : this.edgetomap.remove(v2.index)) {
            Assert.a(this.edges.remove(e2), "Edge " + e2 + " is not present");
        }
        Assert.a(this.vertexmap.remove(v2.id) == v2);
        Assert.a(this.vertices.remove(v2.index) == v2);
        int n2 = v2.index;
        while (var5_12 < this.vertices.size()) {
            --this.vertices.get((int)var5_12).index;
            ++var5_12;
        }
        if (bl) {
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    int n4 = (Integer)iterator2.next();
                    if (this.getEdge(n3, n4) != null) continue;
                    this.addEdge(n3, n4, null);
                }
            }
        }
        this.verify();
    }

    private void verify() {
        Assert.a(this.vertices.size() == this.vertexmap.size());
        Assert.a(this.edgefrommap.values().size() == this.edges.size(), this.edgefrommap.values().size() + " != " + this.edges.size());
        Assert.a(this.edgetomap.values().size() == this.edges.size(), this.edgetomap.values().size() + " != " + this.edges.size());
        if (Licensing.isReleaseBuild()) {
            return;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n2 = 0;
        for (V object : this.vertices) {
            Assert.a(object.index == n2, "Unexpected index");
            ++n2;
            Assert.a(this.vertexmap.get(object.id) == object, "Vertex is missing");
            Assert.a(hashSet.add(object.id), "Duplicate id: " + object.id);
        }
        for (E e : this.edges) {
            Assert.a(this.vertices.contains(e.src));
            Assert.a(this.vertices.contains(e.dst), "Vertex id=" + e.dst.id + " was not found");
        }
    }

    public int getEdgeCount() {
        return this.edges.size();
    }

    public List<E> getEdges() {
        return this.edges;
    }

    public E getEdge(int n2) {
        return this.edges.get(n2);
    }

    public void removeEdge(E e) {
        Assert.a(this.edges.remove(e));
        Assert.a(this.edgefrommap.removeElement(e.src.index, e));
        Assert.a(this.edgetomap.removeElement(e.dst.index, e));
    }

    public void removeEdge(int n2) {
        E e = this.edges.remove(n2);
        Assert.a(this.edgefrommap.removeElement(e.src.index, e));
        Assert.a(this.edgetomap.removeElement(e.dst.index, e));
    }

    public E getEdge(int n2, int n3) {
        V v2 = this.vertexmap.get(n2);
        Assert.a(v2 != null, "Source vertex " + n2 + " does not exist");
        int n4 = v2.index;
        for (E e : this.getEdgesFrom(n4)) {
            if (e.dst.id != n3) continue;
            return e;
        }
        return null;
    }

    List<E> getEdgesFrom(int n2) {
        return this.edgefrommap.get(n2);
    }

    List<E> getEdgesTo(int n2) {
        return this.edgetomap.get(n2);
    }

    public Digraph v(int n2, Double d, String string) {
        this.addVertex(n2, d, string, true);
        return this;
    }

    public Digraph v(int n2, Double d) {
        return this.v(n2, d, null);
    }

    public Digraph v(int n2) {
        return this.v(n2, null, null);
    }

    private V addVertex(int n2, Double d, String string, boolean bl) {
        this.verifyNotDone();
        V v2 = this.vertexmap.get(n2);
        if (v2 != null) {
            if (bl) {
                throw new IllegalArgumentException("Vertex id " + n2 + " is already in use");
            }
        } else {
            v2 = new V(this.vertices.size(), n2, d, string);
            this.vertices.add(v2);
            this.vertexmap.put(n2, v2);
        }
        return v2;
    }

    private E addEdge(int n2, int n3, Double d) {
        this.verifyNotDone();
        boolean bl = true;
        V v2 = this.vertexmap.get(n2);
        if (v2 == null) {
            v2 = this.addVertex(n2, null, null, true);
            bl = false;
        }
        V v3 = v2;
        if (n3 != n2 && (v3 = this.vertexmap.get(n3)) == null) {
            v3 = this.addVertex(n3, null, null, true);
            bl = false;
        }
        V v4 = v3;
        if (bl) {
            Assert.a(this.edgefrommap.findFirstElement(v2.index, e -> e.dst == v4) == null, Strings.ff("Edge %d->%d already exists", n2, n3));
        }
        E e2 = new E(v2, v4, d);
        this.edges.add(e2);
        this.edgefrommap.put(v2.index, e2);
        this.edgetomap.put(v4.index, e2);
        return e2;
    }

    public Digraph e(int n2, int n3, Double d) {
        this.addEdge(n2, n3, d);
        return this;
    }

    public Digraph e(int n2, int n3) {
        return this.e(n2, n3, null);
    }

    public Digraph done() {
        this.verify();
        return this;
    }

    private void verifyNotDone() {
        if (this.done) {
            throw new IllegalStateException();
        }
    }

    public void resetEdgeBetweennessScores() {
        for (E object : this.edges) {
            object.ebscore = 0.0;
        }
        for (V v2 : this.vertices) {
            v2.vcscore = 0.0;
        }
    }

    public List<Integer> computeEdgeBetweenness() {
        this.resetEdgeBetweennessScores();
        for (int i = 0; i < this.getVertexCount(); ++i) {
            this.computeEdgeBetweennessFromSingleNode(i);
            for (E e3 : this.edges) {
                if (e3.score == null) continue;
                E e4 = e3;
                e4.ebscore = e4.ebscore + e3.score;
            }
            for (V v4 : this.vertices) {
                if (v4.score == null) continue;
                V v5 = v4;
                v5.vcscore = v5.vcscore + v4.score;
            }
            if (!Thread.interrupted()) continue;
            throw new InterruptionException();
        }
        List<E> list3 = this.copyOfEdges();
        Collections.sort(list3, (e, e2) -> -Double.compare(e.ebscore, e2.ebscore));
        Object object = new StringBuilder();
        for (E e5 : list3) {
            Strings.ff(object, "%s>%s:%.1f,", new Object[]{e5.src, e5.dst, e5.ebscore});
        }
        (new Object[1])[0] = ((StringBuilder)object).toString();
        List<V> list = this.copyOfVertices();
        Collections.sort(list, (v2, v3) -> -Double.compare(v2.vcscore, v3.vcscore));
        object = new StringBuilder();
        for (V v6 : list) {
            Strings.ff((Appendable)object, "%s:%.1f,", v6, v6.vcscore);
        }
        (new Object[1])[0] = ((StringBuilder)object).toString();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.getEdgeCount());
        for (int i = 0; i < this.getEdgeCount(); ++i) {
            arrayList.add(i);
        }
        Collections.sort(arrayList, new Comparator<Integer>(){

            @Override
            public int compare(Integer n2, Integer n3) {
                return -Double.compare(Digraph.this.edges.get((int)n2.intValue()).ebscore, Digraph.this.edges.get((int)n3.intValue()).ebscore);
            }
        });
        return arrayList;
    }

    public List<Integer> getEdgeIndexesByDescendingBetweenness() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.getEdgeCount());
        for (int i = 0; i < this.getEdgeCount(); ++i) {
            arrayList.add(i);
        }
        arrayList.sort((n2, n3) -> -Double.compare(this.edges.get((int)n2.intValue()).ebscore, this.edges.get((int)n3.intValue()).ebscore));
        return arrayList;
    }

    public List<Integer> getVertexIndexesByDescendingCentrality() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.getVertexCount());
        for (int i = 0; i < this.getVertexCount(); ++i) {
            arrayList.add(i);
        }
        arrayList.sort((n2, n3) -> -Double.compare(this.vertices.get((int)n2.intValue()).vcscore, this.vertices.get((int)n3.intValue()).vcscore));
        return arrayList;
    }

    private void computeEdgeBetweennessFromSingleNode(int n2) {
        int n3;
        Iterator<E> iterator;
        for (E arrayList2 : this.edges) {
            arrayList2.score = null;
        }
        for (V v2 : this.vertices) {
            v2.score = 0.0;
        }
        Object object = new int[this.getVertexCount()];
        object[n2] = true;
        ArrayList arrayList = new ArrayList();
        HashSet hashSet = new HashSet();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        arrayList2.add(n2);
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        while (!arrayList2.isEmpty()) {
            ArrayList<E> arrayList3 = new ArrayList<E>();
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                n3 = (Integer)iterator.next();
                for (E e : this.getEdgesFrom(n3)) {
                    int n4 = e.dst.index;
                    if (hashSet.contains(n4)) continue;
                    arrayList3.add(e);
                    hashSet2.add(n4);
                    Object object2 = object;
                    int n5 = n4;
                    object2[n5] = object2[n5] + object[n3];
                }
            }
            if (!arrayList3.isEmpty()) {
                arrayList.add(arrayList3);
            }
            hashSet.addAll(hashSet2);
            arrayList2 = new ArrayList(hashSet2);
            hashSet2.clear();
            if (!Thread.interrupted()) continue;
            throw new InterruptionException();
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            iterator = (List)arrayList.get(i);
            for (n3 = 0; n3 < iterator.size(); ++n3) {
                E e = (E)iterator.get(n3);
                if (e.score != null) continue;
                ArrayList<Object> arrayList4 = new ArrayList<Object>();
                arrayList4.add(e);
                V v3 = e.dst;
                for (int j = n3 + 1; j < iterator.size(); ++j) {
                    E e2 = (E)iterator.get(j);
                    if (e2.dst != v3) continue;
                    arrayList4.add(e2);
                }
                double d = 0.0;
                for (E e3 : arrayList4) {
                    d += (double)object[e3.src.index];
                }
                double d2 = 1.0 + this.vertices.get((int)v3.index).score;
                for (E e4 : arrayList4) {
                    double d3 = d2 * ((double)object[e4.src.index] / d);
                    e4.score = d3;
                    V v4 = this.vertices.get(e4.src.index);
                    v4.score = v4.score + d3;
                }
            }
            if (!Thread.interrupted()) continue;
            throw new InterruptionException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (E e : this.edges) {
            if (e.score == null) continue;
            Strings.ff(stringBuilder, "%s>%s:%.1f,", e.src, e.dst, e.score);
        }
    }

    public boolean isWeaklyConnected() {
        int n2 = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(n2);
        HashSet<Integer> hashSet2 = new HashSet<Integer>(hashSet);
        while (!hashSet.isEmpty()) {
            HashSet<Integer> hashSet3 = new HashSet<Integer>();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                int n3;
                int n4 = (Integer)iterator.next();
                for (E e : this.getEdgesFrom(n4)) {
                    n3 = e.dst.index;
                    if (hashSet2.contains(n3)) continue;
                    hashSet3.add(n3);
                    hashSet2.add(n3);
                }
                for (E e : this.getEdgesTo(n4)) {
                    n3 = e.src.index;
                    if (hashSet2.contains(n3)) continue;
                    hashSet3.add(n3);
                    hashSet2.add(n3);
                }
            }
            hashSet = hashSet3;
        }
        return hashSet2.size() == this.getVertexCount();
    }

    public List<Digraph> getWeaklyConnectedComponents() {
        int n2;
        ArrayList<Digraph> arrayList = new ArrayList<Digraph>();
        HashSet<Integer> hashSet = new HashSet<Integer>(this.getVertexCount());
        for (n2 = 0; n2 < this.getVertexCount(); ++n2) {
            hashSet.add(n2);
        }
        n2 = 0;
        while (!hashSet.isEmpty()) {
            int n3;
            Iterator iterator;
            Object object;
            Object object2 = new HashSet<Integer>();
            object2.add((Integer)hashSet.iterator().next());
            HashSet<Integer> hashSet2 = new HashSet<Integer>((Collection<Integer>)object2);
            while (!object2.isEmpty()) {
                object = new HashSet();
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    int n4;
                    n3 = (Integer)iterator.next();
                    for (E e : this.getEdgesFrom(n3)) {
                        n4 = e.dst.index;
                        if (hashSet2.contains(n4)) continue;
                        object.add(n4);
                        hashSet2.add(n4);
                    }
                    for (E e : this.getEdgesTo(n3)) {
                        n4 = e.src.index;
                        if (hashSet2.contains(n4)) continue;
                        object.add(n4);
                        hashSet2.add(n4);
                    }
                }
                object2 = object;
            }
            if (n2 == 0 && hashSet.equals(hashSet2)) {
                arrayList.add(this);
                break;
            }
            object = Digraph.create();
            iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                n3 = (Integer)iterator.next();
                Iterator<E> iterator2 = this.vertices.get(n3);
                ((Digraph)object).addVertex(((V)((Object)iterator2)).id, ((V)((Object)iterator2)).weight, ((V)((Object)iterator2)).label, false);
                for (E e : this.getEdgesFrom(n3)) {
                    ((Digraph)object).e(e.src.id, e.dst.id, e.weight);
                }
            }
            arrayList.add(((Digraph)object).done());
            hashSet.removeAll(hashSet2);
            ++n2;
        }
        return arrayList;
    }

    public String toString() {
        return Strings.ff("V=%s:E=%s", this.vertices, this.edges);
    }

    private void computeTransitiveClosure() {
        int n2 = this.getVertexCount();
        this.reachabilityIndices = new ArrayList<Set<Integer>>(n2);
        for (int i = 0; i < n2; ++i) {
            HashSet hashSet = new HashSet();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            arrayList.add(i);
            while (!arrayList.isEmpty()) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    int n3 = (Integer)iterator.next();
                    for (E e : this.getEdgesFrom(n3)) {
                        int n4 = e.dst.index;
                        if (hashSet.contains(n4)) continue;
                        hashSet2.add(n4);
                    }
                }
                hashSet.addAll(hashSet2);
                arrayList = new ArrayList(hashSet2);
                hashSet2.clear();
            }
            this.reachabilityIndices.add(hashSet);
        }
    }

    public boolean isAdjacent(V v2, V v3) {
        for (E e : this.getEdgesFrom(v2.index)) {
            if (e.dst != v3) continue;
            return true;
        }
        return false;
    }

    public boolean canReach(V v2, V v3) {
        Set<Integer> set;
        if (this.isAdjacent(v2, v3)) {
            return true;
        }
        if (this.reachabilityIndices == null) {
            this.computeTransitiveClosure();
        }
        if ((set = this.reachabilityIndices.get(v2.index)) == null) {
            return false;
        }
        return this.reachabilityIndices.get(v2.index).contains(v3.index);
    }

    public Set<Integer> getReachableVertices(int n2) {
        V v2 = this.vertexmap.get(n2);
        Assert.a(v2 != null, "Vertex id does not exist: " + n2);
        if (this.reachabilityIndices == null) {
            this.computeTransitiveClosure();
        }
        Set<Integer> set = this.reachabilityIndices.get(v2.index);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n3 : set) {
            hashSet.add(this.vertices.get((int)n3).id);
        }
        return hashSet;
    }

    public static Digraph load(File file) throws IOException {
        return Digraph.load(file, null);
    }

    private static Digraph load(File file, Boolean bl) throws IOException {
        Digraph digraph = Digraph.create();
        for (String string : IO.readLines(file)) {
            int n2;
            int n3;
            Object object;
            int n4;
            int n5;
            if ((string = string.trim()).isEmpty() || string.startsWith("#")) continue;
            if (string.startsWith(":")) {
                String string2 = string.substring(1);
                if (bl == null && string2.equals("directed")) {
                    bl = true;
                    continue;
                }
                if (bl == null && string2.equals("undirected")) {
                    bl = false;
                    continue;
                }
                throw new RuntimeException("Unknown command: " + string2);
            }
            if (string.startsWith("[")) {
                int n6 = 0;
                while (n6 >= 0) {
                    n5 = 0;
                    n4 = string.indexOf("]", n6 + 1);
                    String string3 = string.substring(n6 + 1, n4);
                    object = Strings.splitall(string3, " ");
                    if (((String[])object).length != 2) {
                        object = Strings.splitall(string3, ">");
                        if (((String[])object).length != 2) {
                            throw new RuntimeException("Illegal edge definition: " + string3);
                        }
                        n5 = 1;
                    }
                    if (bl != null) {
                        n5 = bl.booleanValue() ? 1 : 0;
                    }
                    int n7 = Integer.parseInt(object[0]);
                    int n8 = Integer.parseInt(object[1]);
                    digraph.e(n7, n8);
                    if (n5 == 0) {
                        digraph.e(n8, n7);
                    }
                    n6 = string.indexOf("[", n4 + 1);
                }
                continue;
            }
            for (n3 = 0; n3 < string.length() && Character.isDigit(string.charAt(n3)); ++n3) {
            }
            n5 = Integer.parseInt(string.substring(0, n3));
            int n9 = n4 = n3 < string.length() ? (int)string.charAt(n3) : 0;
            if (n4 == 62) {
                n2 = Integer.parseInt(string.substring(n3 + 1));
                digraph.e(n5, n2);
                if (bl == null || bl.booleanValue()) continue;
                digraph.e(n2, n5);
                continue;
            }
            if (n4 == 32) {
                n2 = Integer.parseInt(string.substring(n3 + 1));
                digraph.e(n5, n2);
                if (bl != null && bl.booleanValue()) continue;
                digraph.e(n2, n5);
                continue;
            }
            if (n4 == 58) {
                n2 = n5;
                object = null;
                String string4 = null;
                block11: for (String string5 : string.substring(n3 + 1).split(";")) {
                    String[] stringArray = string5.split("=");
                    if (stringArray.length != 2) continue;
                    switch (stringArray[0]) {
                        case "w": {
                            object = Double.parseDouble(stringArray[1]);
                            continue block11;
                        }
                        case "l": {
                            string4 = stringArray[1];
                            continue block11;
                        }
                        default: {
                            throw new RuntimeException("Unknown vertex attribute: " + string5);
                        }
                    }
                }
                digraph.v(n2, (Double)object, string4);
                continue;
            }
            throw new RuntimeException("Cannot parse line: " + string);
        }
        digraph.done();
        return digraph;
    }

    public class V {
        private int index;
        private final int id;
        private Double weight;
        private String label;
        private Double score;
        private Double vcscore;

        V(int n2, int n3, Double d, String string) {
            this.index = n2;
            this.id = n3;
            this.weight = d;
            this.label = string;
        }

        V(int n2, int n3) {
            this(n2, n3, null, null);
        }

        V(int n2) {
            this(n2, n2, null, null);
        }

        public int getId() {
            return this.id;
        }

        public Double getWeight() {
            return this.weight;
        }

        public void setWeight(Double d) {
            this.weight = d;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String string) {
            this.label = string;
        }

        public Double getVertexCentralityScore() {
            return this.vcscore;
        }

        public void setVertexCentralityScore(Double d) {
            this.vcscore = d;
        }

        public void normalizeVertexCentralityScore(double d) {
            if (this.vcscore != null && (d > 0.0 || d < 0.0)) {
                this.vcscore = this.vcscore / d;
            }
        }

        public V clone() {
            V v2 = new V(this.index, this.id, this.weight, this.label);
            v2.score = this.score;
            v2.vcscore = this.vcscore;
            return v2;
        }

        public String toString() {
            Object object = Strings.isBlank(this.label) ? Integer.toString(this.id) : this.label;
            if (this.weight != null) {
                object = (String)object + Strings.ff("(w=%.3f)", this.weight);
            }
            if (this.vcscore != null) {
                object = (String)object + Strings.ff("(c=%.3f)", this.vcscore);
            }
            return object;
        }
    }

    public static class E {
        private V src;
        private V dst;
        private Double weight;
        private Double score;
        private Double ebscore;

        E(V v2, V v3, Double d) {
            this.src = v2;
            this.dst = v3;
            this.weight = d;
        }

        E(V v2, V v3) {
            this(v2, v3, null);
        }

        public V getSrc() {
            return this.src;
        }

        public int getSrcId() {
            return this.src.id;
        }

        public int getSrcIndex() {
            return this.src.index;
        }

        public V getDst() {
            return this.dst;
        }

        public int getDstId() {
            return this.dst.id;
        }

        public int getDstIndex() {
            return this.dst.index;
        }

        public Double getWeight() {
            return this.weight;
        }

        public Double getScore() {
            return this.score;
        }

        public Double getEdgeBetweennessScore() {
            return this.ebscore;
        }

        public E clone() {
            E e = new E(this.src, this.dst, this.weight);
            e.score = this.score;
            e.ebscore = this.ebscore;
            return e;
        }

        public String toString() {
            if (this.weight == null) {
                return Strings.ff("%d>%d", this.src.id, this.dst.id);
            }
            return Strings.ff("%d>%d(%f)", this.src.id, this.dst.id, this.weight);
        }
    }
}

